/*
 * Decompiled with CFR 0.152.
 */
package com.telenordigital.nbiot;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.telenordigital.nbiot.Device;
import com.telenordigital.nbiot.OutputDataMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;

@ParametersAreNonnullByDefault
@Immutable
public final class ImmutableOutputDataMessage
implements OutputDataMessage {
    private final boolean keepAlive;
    @Nullable
    private final Device device;
    @Nullable
    private final byte[] payload;
    private final int received;

    private ImmutableOutputDataMessage(boolean keepAlive, @Nullable Device device, @Nullable byte[] payload, int received) {
        this.keepAlive = keepAlive;
        this.device = device;
        this.payload = payload;
        this.received = received;
    }

    @Override
    @JsonProperty(value="keepAlive")
    public boolean keepAlive() {
        return this.keepAlive;
    }

    @Override
    @JsonProperty(value="device")
    @Nullable
    public Device device() {
        return this.device;
    }

    @Override
    @JsonProperty(value="payload")
    @Nullable
    public byte[] payload() {
        return this.payload;
    }

    @Override
    @JsonProperty(value="received")
    public int received() {
        return this.received;
    }

    public final ImmutableOutputDataMessage withKeepAlive(boolean value) {
        if (this.keepAlive == value) {
            return this;
        }
        return new ImmutableOutputDataMessage(value, this.device, this.payload, this.received);
    }

    public final ImmutableOutputDataMessage withDevice(@Nullable Device value) {
        if (this.device == value) {
            return this;
        }
        return new ImmutableOutputDataMessage(this.keepAlive, value, this.payload, this.received);
    }

    public final ImmutableOutputDataMessage withPayload(byte ... elements) {
        byte[] newValue = elements == null ? null : (byte[])elements.clone();
        return new ImmutableOutputDataMessage(this.keepAlive, this.device, newValue, this.received);
    }

    public final ImmutableOutputDataMessage withReceived(int value) {
        if (this.received == value) {
            return this;
        }
        return new ImmutableOutputDataMessage(this.keepAlive, this.device, this.payload, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableOutputDataMessage && this.equalTo((ImmutableOutputDataMessage)another);
    }

    private boolean equalTo(ImmutableOutputDataMessage another) {
        return this.keepAlive == another.keepAlive && Objects.equals(this.device, another.device) && Arrays.equals(this.payload, another.payload) && this.received == another.received;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Boolean.hashCode(this.keepAlive);
        h += (h << 5) + Objects.hashCode(this.device);
        h += (h << 5) + Arrays.hashCode(this.payload);
        h += (h << 5) + this.received;
        return h;
    }

    public String toString() {
        return "OutputDataMessage{keepAlive=" + this.keepAlive + ", device=" + this.device + ", payload=" + Arrays.toString(this.payload) + ", received=" + this.received + "}";
    }

    public static ImmutableOutputDataMessage copyOf(OutputDataMessage instance) {
        if (instance instanceof ImmutableOutputDataMessage) {
            return (ImmutableOutputDataMessage)instance;
        }
        return new Builder().from(instance).build();
    }

    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEEP_ALIVE = 1L;
        private static final long INIT_BIT_RECEIVED = 2L;
        private long initBits = 3L;
        private boolean keepAlive;
        @Nullable
        private Device device;
        @Nullable
        private byte[] payload;
        private int received;

        public final Builder from(OutputDataMessage instance) {
            byte[] payloadValue;
            Objects.requireNonNull(instance, "instance");
            this.keepAlive(instance.keepAlive());
            Device deviceValue = instance.device();
            if (deviceValue != null) {
                this.device(deviceValue);
            }
            if ((payloadValue = instance.payload()) != null) {
                this.payload(payloadValue);
            }
            this.received(instance.received());
            return this;
        }

        @JsonProperty(value="keepAlive")
        public final Builder keepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="device")
        public final Builder device(@Nullable Device device) {
            this.device = device;
            return this;
        }

        @JsonProperty(value="payload")
        public final Builder payload(byte ... payload) {
            this.payload = payload;
            return this;
        }

        @JsonProperty(value="received")
        public final Builder received(int received) {
            this.received = received;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableOutputDataMessage build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableOutputDataMessage(this.keepAlive, this.device, this.payload, this.received);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("keepAlive");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("received");
            }
            return "Cannot build OutputDataMessage, some of required attributes are not set " + attributes;
        }
    }
}

