/*
 * Decompiled with CFR 0.152.
 */
package eu.aschuetz.nativeutils.api.structs;

import java.util.Arrays;
import java.util.Objects;

public class RegData {
    private final RegType type;
    private final Object value;

    public RegData(int value) {
        this.type = RegType.REG_DWORD;
        this.value = value;
    }

    public RegData(long value) {
        this.type = RegType.REG_QWORD;
        this.value = value;
    }

    public RegData(Object data, Object type) {
        this.type = (RegType)((Object)type);
        this.value = data;
    }

    public RegType type() {
        return this.type;
    }

    public Object value() {
        return this.value;
    }

    public Number number() {
        return (Number)this.value;
    }

    public int asInt() {
        return this.number().intValue();
    }

    public long asLong() {
        return this.number().longValue();
    }

    public byte[] binary() {
        return (byte[])this.value;
    }

    public String string() {
        return (String)this.value;
    }

    public String[] strings() {
        return (String[])this.value;
    }

    public String toString() {
        String vString;
        if (this.value instanceof byte[]) {
            vString = Arrays.toString((byte[])this.value);
        } else if (this.value instanceof String[]) {
            StringBuilder sb = new StringBuilder();
            boolean f = false;
            for (String s : (String[])this.value) {
                if (f) {
                    sb.append(",");
                }
                f = true;
                sb.append(s);
            }
            vString = sb.toString();
        } else {
            vString = Objects.toString(this.value);
        }
        return (Object)((Object)this.type) + " | " + vString;
    }

    public static enum RegType {
        REG_BINARY,
        REG_DWORD,
        REG_EXPAND_SZ,
        REG_LINK,
        REG_MULTI_SZ,
        REG_NONE,
        REG_QWORD,
        REG_SZ;

    }
}

