/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql;

import eu.clarussecure.proxy.protocol.plugins.pgsql.PgsqlConstants;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.AuthenticationResponseHandler;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.QueryResponseHandler;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.SessionInitializationResponseHandler;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.codec.PgsqlRawPartAggregator;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.codec.PgsqlRawPartCodec;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.forwarder.PgsqlResponseForwarder;
import eu.clarussecure.proxy.spi.protocol.Configuration;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;

public class BackendSidePipelineInitializer
extends ChannelInitializer<Channel> {
    private static boolean MESSAGE_PROCESSING_ACTIVATED;
    private static boolean QUERY_PROCESSING_ACTIVATED;
    private EventExecutorGroup parserGroup = null;

    protected void initChannel(Channel ch) throws Exception {
        Configuration configuration = (Configuration)ch.attr(PgsqlConstants.CONFIGURATION_KEY).get();
        ChannelPipeline pipeline = ch.pipeline();
        pipeline.addLast("PgsqlPartCodec", (ChannelHandler)new PgsqlRawPartCodec(false, configuration.getFramePartMaxLength()));
        if (this.parserGroup == null) {
            this.parserGroup = new DefaultEventExecutorGroup(configuration.getNbParserThreads());
        }
        if (MESSAGE_PROCESSING_ACTIVATED) {
            pipeline.addLast("PgsqlPartAggregator", (ChannelHandler)new PgsqlRawPartAggregator(49, 50, 116, 83, 75, 84, 68, 110, 67, 73, 115, 69, 51, 90, 78));
            pipeline.addLast(this.parserGroup, "PgsqlAuthenticationResponseHandler", (ChannelHandler)new AuthenticationResponseHandler());
        }
        pipeline.addLast(this.parserGroup, "SessionInitializationResponseHandler", (ChannelHandler)new SessionInitializationResponseHandler());
        if (MESSAGE_PROCESSING_ACTIVATED && QUERY_PROCESSING_ACTIVATED) {
            pipeline.addLast(this.parserGroup, "QueryResultHandler", (ChannelHandler)new QueryResponseHandler());
        }
        pipeline.addLast(this.parserGroup, "PgsqlPartResponseForwarder", (ChannelHandler)new PgsqlResponseForwarder());
    }

    static {
        String messageProcessing = System.getProperty("pgsql.message.processing", "true");
        MESSAGE_PROCESSING_ACTIVATED = Boolean.TRUE.toString().equalsIgnoreCase(messageProcessing) || "1".equalsIgnoreCase(messageProcessing) || "yes".equalsIgnoreCase(messageProcessing) || "on".equalsIgnoreCase(messageProcessing);
        String queryProcessing = System.getProperty("pgsql.query.processing", "true");
        QUERY_PROCESSING_ACTIVATED = Boolean.TRUE.toString().equalsIgnoreCase(queryProcessing) || "1".equalsIgnoreCase(queryProcessing) || "yes".equalsIgnoreCase(queryProcessing) || "on".equalsIgnoreCase(queryProcessing);
    }
}

