/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql;

import eu.clarussecure.proxy.spi.Capabilities;
import eu.clarussecure.proxy.spi.Mode;
import eu.clarussecure.proxy.spi.Operation;
import eu.clarussecure.proxy.spi.protocol.ProtocolCapabilities;
import java.util.Map;
import java.util.Set;

public class PgsqlCapabilities
implements ProtocolCapabilities {
    private final Map<Operation, Set<Mode>> datasetCRUDOperations = Capabilities.toMap((Enum[][])new Enum[][]{{Operation.CREATE, Mode.AS_IT_IS, Mode.BUFFERING, Mode.STREAMING}, {Operation.READ, Mode.AS_IT_IS, Mode.BUFFERING, Mode.STREAMING}, {Operation.UPDATE, Mode.AS_IT_IS, Mode.BUFFERING, Mode.STREAMING}, {Operation.DELETE, Mode.AS_IT_IS, Mode.BUFFERING, Mode.STREAMING}});
    private final Map<Operation, Set<Mode>> recordCRUDOperations = Capabilities.toMap((Enum[][])new Enum[][]{{Operation.CREATE, Mode.AS_IT_IS, Mode.BUFFERING, Mode.STREAMING}, {Operation.READ, Mode.AS_IT_IS, Mode.BUFFERING, Mode.STREAMING, Mode.ORCHESTRATION}, {Operation.UPDATE, Mode.AS_IT_IS, Mode.BUFFERING, Mode.STREAMING}, {Operation.DELETE, Mode.AS_IT_IS, Mode.BUFFERING, Mode.STREAMING}});

    public Set<Operation> getSupportedCRUDOperations(boolean wholeDataset) {
        return wholeDataset ? this.datasetCRUDOperations.keySet() : this.recordCRUDOperations.keySet();
    }

    public Set<Mode> getSupportedProcessingModes(boolean wholeDataset, Operation operation) {
        return wholeDataset ? this.datasetCRUDOperations.get(operation) : this.recordCRUDOperations.get(operation);
    }

    public boolean isUserIdentificationRequired() {
        return true;
    }

    public boolean isUserAuthenticationSupported() {
        return true;
    }

    public boolean isUserSessionSupported() {
        return true;
    }

    public boolean isUserSessionSameAsTCPSession() {
        return true;
    }
}

