/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql;

import eu.clarussecure.proxy.protocol.plugins.pgsql.GeometryType;
import eu.clarussecure.proxy.spi.protocol.Configuration;
import eu.clarussecure.proxy.spi.protocol.ProtocolCapabilities;
import eu.clarussecure.proxy.spi.security.policy.SecurityPolicy;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PgsqlConfiguration
extends Configuration {
    public static final String PROTOCOL_NAME = "PostgreSQL";
    public static final int DEFAULT_PROTOCOL_PORT = 5432;
    public static final int DEFAULT_NB_OF_PARSER_THREADS = Runtime.getRuntime().availableProcessors();
    public static final String GEOMETRIC_DATA_ID = "dataId";
    public static final String GEOMETRIC_OBJECT_CLEAR_TYPE = "clearType";
    public static final String GEOMETRIC_OBJECT_PROTECTED_TYPE = "protectedType";
    private static final Pattern PUBLIC_DATA_ID_PATTERN = Pattern.compile("([^/]*/)(public\\.)?([^/\\.]*/[^/]*)");
    private static final String CSP_PATTERN = "csp\\d+";
    private static final String DATA_TECHNICAL_ID = "data_technical_id";
    private static final String GEOMETRIC_OBJECT_DEFINITION = "geometric_object_definition";
    private List<String> backendDatabaseNames;
    private String dataTechnicalId;
    private Map<String, String> geometryObjectDefinition;

    public PgsqlConfiguration(ProtocolCapabilities capabilities) {
        super(capabilities);
        this.nbParserThreads = DEFAULT_NB_OF_PARSER_THREADS;
    }

    public String getProtocolName() {
        return PROTOCOL_NAME;
    }

    public int getDefaultProtocolPort() {
        return 5432;
    }

    public void setParameters(SecurityPolicy securityPolicy) {
        HashMap<String, String> parameters;
        Node protectionNode;
        Node attributeTypesNode;
        super.setParameters(securityPolicy);
        String dataTechnicalId = null;
        String geometricDataId = null;
        String geometricObjectClearType = null;
        String geometricObjectProtectedType = null;
        Node rootNode = securityPolicy.getDocument().getFirstChild();
        Node dataNode = securityPolicy.findSubNode("data", rootNode);
        List attributeNodes = securityPolicy.findSubNodes("attribute", dataNode);
        if (attributeNodes != null) {
            for (Node attributeNode : attributeNodes) {
                Node nameAttr = attributeNode.getAttributes().getNamedItem("name");
                Node attributeTypeAttr = attributeNode.getAttributes().getNamedItem("attribute_type");
                if (nameAttr != null && attributeTypeAttr != null) {
                    String name = nameAttr.getNodeValue();
                    String attributeType = attributeTypeAttr.getNodeValue();
                    if ("technical_identifier".equals(attributeType)) {
                        dataTechnicalId = this.adaptDataId(name);
                    }
                }
                Node dataTypeAttr = attributeNode.getAttributes().getNamedItem("data_type");
                if (nameAttr == null || dataTypeAttr == null) continue;
                String name = nameAttr.getNodeValue();
                String dataType = dataTypeAttr.getNodeValue();
                if (!"geometric_object".equals(dataType)) continue;
                geometricDataId = this.adaptDataId(name);
            }
        }
        if ((attributeTypesNode = securityPolicy.findSubNode("attribute_types", protectionNode = securityPolicy.findSubNode("protection", rootNode))).hasChildNodes()) {
            NodeList subnodes = attributeTypesNode.getChildNodes();
            for (int i = 0; i < subnodes.getLength(); ++i) {
                Node protectionAttr;
                Node subnode = subnodes.item(i);
                if (subnode.getNodeType() != 1 || !subnode.getNodeName().equals("attribute_type") || (protectionAttr = subnode.getAttributes().getNamedItem("protection")) == null) continue;
                String protection = protectionAttr.getNodeValue();
                if ("splitting".equals(protection)) {
                    Node splittingTypeAttr = subnode.getAttributes().getNamedItem("splitting_type");
                    if (splittingTypeAttr == null) continue;
                    String splittingType = splittingTypeAttr.getNodeValue();
                    if ("points".equals(splittingType)) {
                        geometricObjectClearType = GeometryType.POINT.toString();
                        geometricObjectProtectedType = GeometryType.POINT.toString();
                        break;
                    }
                    if (!"lines".equals(splittingType)) continue;
                    geometricObjectClearType = GeometryType.POINT.toString();
                    geometricObjectProtectedType = GeometryType.LINESTRING.toString();
                    break;
                }
                if (!"coarsening".equals(protection)) continue;
                geometricObjectClearType = GeometryType.POLYGON.toString();
                geometricObjectProtectedType = GeometryType.POLYGON.toString();
            }
        }
        if ((parameters = this.getParameters()) == null) {
            parameters = new HashMap<String, String>();
            this.setParameters(parameters);
        }
        if (dataTechnicalId != null) {
            parameters.put(DATA_TECHNICAL_ID, dataTechnicalId);
        }
        StringBuilder sb = new StringBuilder();
        if (geometricDataId != null) {
            sb.append(GEOMETRIC_DATA_ID).append('=').append(geometricDataId).append(';');
        }
        if (geometricObjectClearType != null) {
            sb.append(GEOMETRIC_OBJECT_CLEAR_TYPE).append('=').append(geometricObjectClearType).append(';');
        }
        if (geometricObjectProtectedType != null) {
            sb.append(GEOMETRIC_OBJECT_PROTECTED_TYPE).append('=').append(geometricObjectProtectedType).append(';');
        }
        if (sb.length() > 0) {
            parameters.put(GEOMETRIC_OBJECT_DEFINITION, sb.toString());
        }
    }

    public String adaptDataId(String dataId) {
        Matcher m = PUBLIC_DATA_ID_PATTERN.matcher(dataId = dataId.indexOf(47) == -1 ? "*/*/" + dataId : (dataId.indexOf(47) == dataId.lastIndexOf(47) ? "*/" + dataId : dataId));
        if (m.matches()) {
            dataId = m.replaceAll("$1public.$3");
        }
        return dataId;
    }

    public List<String> getBackendDatabaseNames() {
        if (this.backendDatabaseNames == null) {
            Map parameters = this.getParameters();
            if (parameters != null) {
                Pattern cspPattern = Pattern.compile(CSP_PATTERN);
                this.backendDatabaseNames = parameters.entrySet().stream().filter(e -> cspPattern.matcher((CharSequence)e.getKey()).matches()).collect(Collectors.toMap(Map.Entry::getKey, e -> Arrays.stream(((String)e.getValue()).split(";")).map(p -> p.split("=")).filter(p -> "database".equals(p[0])).map(p -> p[1]).findFirst().orElse(null))).entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
            } else {
                this.backendDatabaseNames = Collections.emptyList();
            }
        }
        return this.backendDatabaseNames;
    }

    public String getDataTechnicalId() {
        Map parameters;
        if (this.dataTechnicalId == null && (parameters = this.getParameters()) != null) {
            this.dataTechnicalId = (String)parameters.get(DATA_TECHNICAL_ID);
        }
        return this.dataTechnicalId;
    }

    public Map<String, String> getGeometryObjectDefinition() {
        if (this.geometryObjectDefinition == null) {
            Map parameters = this.getParameters();
            if (parameters != null) {
                String parameterValue = (String)parameters.get(GEOMETRIC_OBJECT_DEFINITION);
                this.geometryObjectDefinition = Arrays.stream(parameterValue.split(";")).map(p -> p.split("=")).collect(Collectors.toMap(tk -> tk[0], tk -> tk[1], (v1, v2) -> v2));
            } else {
                this.geometryObjectDefinition = Collections.emptyMap();
            }
        }
        return this.geometryObjectDefinition;
    }
}

