/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message;

import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.AllComparisonExpression;
import net.sf.jsqlparser.expression.AnalyticExpression;
import net.sf.jsqlparser.expression.AnyComparisonExpression;
import net.sf.jsqlparser.expression.Assignment;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.DateTimeLiteralExpression;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.ExtractExpression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.IntervalExpression;
import net.sf.jsqlparser.expression.JdbcNamedParameter;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.JsonExpression;
import net.sf.jsqlparser.expression.KeepExpression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.MySQLGroupConcat;
import net.sf.jsqlparser.expression.Not;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.NumericBind;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.OracleHint;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.RawStringValue;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeKeyExpression;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.expression.UserVariable;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.WithinGroupExpression;
import net.sf.jsqlparser.expression.operators.arithmetic.Addition;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseAnd;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseOr;
import net.sf.jsqlparser.expression.operators.arithmetic.BitwiseXor;
import net.sf.jsqlparser.expression.operators.arithmetic.Concat;
import net.sf.jsqlparser.expression.operators.arithmetic.Division;
import net.sf.jsqlparser.expression.operators.arithmetic.Modulo;
import net.sf.jsqlparser.expression.operators.arithmetic.Multiplication;
import net.sf.jsqlparser.expression.operators.arithmetic.Subtraction;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.conditional.OrExpression;
import net.sf.jsqlparser.expression.operators.relational.Array;
import net.sf.jsqlparser.expression.operators.relational.ArrayElement;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.FromExpression;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.JsonOperator;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.Matches;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.expression.operators.relational.RegExpMatchOperator;
import net.sf.jsqlparser.expression.operators.relational.RegExpMySQLOperator;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.select.SubSelect;

public class PgsqlColumnsFinder
implements ExpressionVisitor {
    private List<Map.Entry<Expression, List<Column>>> expressionsWithColumns;
    private Map<Expression, Expression> expressionsToParents;
    private Deque<Expression> currentExpressions;

    public void parse(Expression expression) {
        this.expressionsWithColumns = new ArrayList<Map.Entry<Expression, List<Column>>>();
        this.expressionsToParents = new HashMap<Expression, Expression>();
        this.currentExpressions = new ArrayDeque<Expression>();
        if (expression != null) {
            expression.accept((ExpressionVisitor)this);
        }
    }

    public List<Column> getColumns() {
        return this.expressionsWithColumns.stream().map(Map.Entry::getValue).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public List<Expression> getExpressionsWithColumns() {
        return this.expressionsWithColumns.stream().map(Map.Entry::getKey).collect(Collectors.toList());
    }

    public List<Map.Entry<Expression, List<Column>>> getExpressionsWithColumnsToColumns() {
        return this.expressionsWithColumns;
    }

    public Map<Expression, Expression> getExpressionsToParents() {
        return this.expressionsToParents;
    }

    public void visit(SubSelect subSelect) {
    }

    public void visit(Assignment assignement) {
        this.visitBinaryExpression((BinaryExpression)assignement);
    }

    public void visit(Addition addition) {
        this.visitBinaryExpression((BinaryExpression)addition);
    }

    public void visit(AndExpression andExpression) {
        this.visitBinaryExpression((BinaryExpression)andExpression);
    }

    public void visit(ArrayElement arrayElement) {
        this.expressionsToParents.put((Expression)arrayElement, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)arrayElement);
        if (arrayElement.getLeftExpression() != null) {
            arrayElement.getLeftExpression().accept((ExpressionVisitor)this);
        }
        if (arrayElement.getIndex() != null) {
            arrayElement.getIndex().accept((ExpressionVisitor)this);
        }
        this.currentExpressions.pop();
    }

    public void visit(Array array) {
        this.expressionsToParents.put((Expression)array, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)array);
        for (Expression element : array.getElements()) {
            element.accept((ExpressionVisitor)this);
        }
        this.currentExpressions.pop();
    }

    public void visit(Between between) {
        this.expressionsToParents.put((Expression)between, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)between);
        if (between.getLeftExpression() != null) {
            between.getLeftExpression().accept((ExpressionVisitor)this);
        }
        if (between.getBetweenExpressionStart() != null) {
            between.getBetweenExpressionStart().accept((ExpressionVisitor)this);
        }
        if (between.getBetweenExpressionEnd() != null) {
            between.getBetweenExpressionEnd().accept((ExpressionVisitor)this);
        }
        this.currentExpressions.pop();
    }

    public void visit(Column column) {
        if (column.getColumnName().charAt(0) == '$' && column.getColumnName().substring(1).chars().allMatch(c -> Character.isDigit(c))) {
            return;
        }
        Map.Entry<Expression, List<Column>> entry = this.expressionsWithColumns.isEmpty() ? null : this.expressionsWithColumns.get(this.expressionsWithColumns.size() - 1);
        Expression currentExpression = this.currentExpressions.peek();
        if (entry == null || entry.getKey() != currentExpression) {
            entry = new AbstractMap.SimpleEntry(currentExpression, new ArrayList());
            this.expressionsWithColumns.add(entry);
        }
        entry.getValue().add(column);
    }

    public void visit(Division division) {
        this.visitBinaryExpression((BinaryExpression)division);
    }

    public void visit(DoubleValue doubleValue) {
    }

    public void visit(EqualsTo equalsTo) {
        this.visitBinaryExpression((BinaryExpression)equalsTo);
    }

    public void visit(IsExpression is) {
        this.visitBinaryExpression((BinaryExpression)is);
    }

    public void visit(Function function) {
        this.expressionsToParents.put((Expression)function, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)function);
        if (function.getParameters() != null) {
            for (Expression expression : function.getParameters().getExpressions()) {
                expression.accept((ExpressionVisitor)this);
            }
        }
        this.currentExpressions.pop();
    }

    public void visit(GreaterThan greaterThan) {
        this.visitBinaryExpression((BinaryExpression)greaterThan);
    }

    public void visit(GreaterThanEquals greaterThanEquals) {
        this.visitBinaryExpression((BinaryExpression)greaterThanEquals);
    }

    public void visit(InExpression inExpression) {
        this.expressionsToParents.put((Expression)inExpression, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)inExpression);
        if (inExpression.getLeftExpression() != null) {
            inExpression.getLeftExpression().accept((ExpressionVisitor)this);
        } else if (inExpression.getLeftItemsList() != null) {
            // empty if block
        }
        this.currentExpressions.pop();
    }

    public void visit(SignedExpression signedExpression) {
        this.expressionsToParents.put((Expression)signedExpression, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)signedExpression);
        if (signedExpression.getExpression() != null) {
            signedExpression.getExpression().accept((ExpressionVisitor)this);
        }
        this.currentExpressions.pop();
    }

    public void visit(IsNullExpression isNullExpression) {
        this.expressionsToParents.put((Expression)isNullExpression, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)isNullExpression);
        if (isNullExpression.getLeftExpression() != null) {
            isNullExpression.getLeftExpression().accept((ExpressionVisitor)this);
        }
        this.currentExpressions.pop();
    }

    public void visit(JdbcParameter jdbcParameter) {
    }

    public void visit(LikeExpression likeExpression) {
        this.visitBinaryExpression((BinaryExpression)likeExpression);
    }

    public void visit(FromExpression fromExpression) {
        this.visitBinaryExpression((BinaryExpression)fromExpression);
    }

    public void visit(ExistsExpression existsExpression) {
        this.expressionsToParents.put((Expression)existsExpression, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)existsExpression);
        if (existsExpression.getRightExpression() != null) {
            existsExpression.getRightExpression().accept((ExpressionVisitor)this);
        }
        this.currentExpressions.pop();
    }

    public void visit(LongValue longValue) {
    }

    public void visit(MinorThan minorThan) {
        this.visitBinaryExpression((BinaryExpression)minorThan);
    }

    public void visit(MinorThanEquals minorThanEquals) {
        this.visitBinaryExpression((BinaryExpression)minorThanEquals);
    }

    public void visit(Multiplication multiplication) {
        this.visitBinaryExpression((BinaryExpression)multiplication);
    }

    public void visit(Not not) {
        this.expressionsToParents.put((Expression)not, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)not);
        if (not.getExpression() != null) {
            not.getExpression().accept((ExpressionVisitor)this);
        }
        this.currentExpressions.pop();
    }

    public void visit(NotEqualsTo notEqualsTo) {
        this.visitBinaryExpression((BinaryExpression)notEqualsTo);
    }

    public void visit(NullValue nullValue) {
    }

    public void visit(OrExpression orExpression) {
        this.visitBinaryExpression((BinaryExpression)orExpression);
    }

    public void visit(Parenthesis parenthesis) {
        this.expressionsToParents.put((Expression)parenthesis, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)parenthesis);
        if (parenthesis.getExpression() != null) {
            parenthesis.getExpression().accept((ExpressionVisitor)this);
        }
        this.currentExpressions.pop();
    }

    public void visit(StringValue stringValue) {
    }

    public void visit(RawStringValue stringValue) {
    }

    public void visit(Subtraction subtraction) {
        this.visitBinaryExpression((BinaryExpression)subtraction);
    }

    public void visitBinaryExpression(BinaryExpression binaryExpression) {
        this.expressionsToParents.put((Expression)binaryExpression, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)binaryExpression);
        if (binaryExpression.getLeftExpression() != null) {
            binaryExpression.getLeftExpression().accept((ExpressionVisitor)this);
        }
        if (binaryExpression.getLeftExpression() != null) {
            binaryExpression.getRightExpression().accept((ExpressionVisitor)this);
        }
        this.currentExpressions.pop();
    }

    public void visit(DateValue dateValue) {
    }

    public void visit(TimestampValue timestampValue) {
    }

    public void visit(TimeValue timeValue) {
    }

    public void visit(CaseExpression caseExpression) {
        this.expressionsToParents.put((Expression)caseExpression, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)caseExpression);
        if (caseExpression.getSwitchExpression() != null) {
            caseExpression.getSwitchExpression().accept((ExpressionVisitor)this);
        }
        if (caseExpression.getWhenClauses() != null) {
            for (Expression expression : caseExpression.getWhenClauses()) {
                expression.accept((ExpressionVisitor)this);
            }
        }
        if (caseExpression.getElseExpression() != null) {
            caseExpression.getElseExpression().accept((ExpressionVisitor)this);
        }
        this.currentExpressions.pop();
    }

    public void visit(WhenClause whenClause) {
        this.expressionsToParents.put((Expression)whenClause, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)whenClause);
        if (whenClause.getWhenExpression() != null) {
            whenClause.getWhenExpression().accept((ExpressionVisitor)this);
        }
        if (whenClause.getThenExpression() != null) {
            whenClause.getThenExpression().accept((ExpressionVisitor)this);
        }
        this.currentExpressions.pop();
    }

    public void visit(AllComparisonExpression allComparisonExpression) {
    }

    public void visit(AnyComparisonExpression anyComparisonExpression) {
    }

    public void visit(Concat concat) {
        this.visitBinaryExpression((BinaryExpression)concat);
    }

    public void visit(Matches matches) {
        this.visitBinaryExpression((BinaryExpression)matches);
    }

    public void visit(BitwiseAnd bitwiseAnd) {
        this.visitBinaryExpression((BinaryExpression)bitwiseAnd);
    }

    public void visit(BitwiseOr bitwiseOr) {
        this.visitBinaryExpression((BinaryExpression)bitwiseOr);
    }

    public void visit(BitwiseXor bitwiseXor) {
        this.visitBinaryExpression((BinaryExpression)bitwiseXor);
    }

    public void visit(CastExpression cast) {
        this.expressionsToParents.put((Expression)cast, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)cast);
        cast.getLeftExpression().accept((ExpressionVisitor)this);
        this.currentExpressions.pop();
    }

    public void visit(Modulo modulo) {
        this.visitBinaryExpression((BinaryExpression)modulo);
    }

    public void visit(AnalyticExpression analytic) {
    }

    public void visit(ExtractExpression eexpr) {
    }

    public void visit(IntervalExpression iexpr) {
    }

    public void visit(JdbcNamedParameter jdbcNamedParameter) {
    }

    public void visit(OracleHierarchicalExpression oexpr) {
        this.expressionsToParents.put((Expression)oexpr, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)oexpr);
        if (oexpr.getStartExpression() != null) {
            oexpr.getStartExpression().accept((ExpressionVisitor)this);
        }
        if (oexpr.getConnectExpression() != null) {
            oexpr.getConnectExpression().accept((ExpressionVisitor)this);
        }
        this.currentExpressions.pop();
    }

    public void visit(RegExpMatchOperator rexpr) {
        this.visitBinaryExpression((BinaryExpression)rexpr);
    }

    public void visit(RegExpMySQLOperator rexpr) {
        this.visitBinaryExpression((BinaryExpression)rexpr);
    }

    public void visit(JsonExpression jsonExpr) {
        this.expressionsToParents.put((Expression)jsonExpr, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)jsonExpr);
        if (jsonExpr.getColumn() != null) {
            jsonExpr.getColumn().accept((ExpressionVisitor)this);
        }
        this.currentExpressions.pop();
    }

    public void visit(JsonOperator jsonExpr) {
    }

    public void visit(WithinGroupExpression wgexpr) {
        this.expressionsToParents.put((Expression)wgexpr, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)wgexpr);
        if (wgexpr.getExprList() != null) {
            for (Expression expression : wgexpr.getExprList().getExpressions()) {
                expression.accept((ExpressionVisitor)this);
            }
        }
        this.currentExpressions.pop();
    }

    public void visit(UserVariable var) {
    }

    public void visit(NumericBind bind) {
    }

    public void visit(KeepExpression aexpr) {
    }

    public void visit(MySQLGroupConcat groupConcat) {
    }

    public void visit(RowConstructor rowConstructor) {
        this.expressionsToParents.put((Expression)rowConstructor, this.currentExpressions.peek());
        this.currentExpressions.push((Expression)rowConstructor);
        if (rowConstructor.getExprList() != null) {
            for (Expression expr : rowConstructor.getExprList().getExpressions()) {
                expr.accept((ExpressionVisitor)this);
            }
        }
        this.currentExpressions.pop();
    }

    public void visit(HexValue hexValue) {
    }

    public void visit(OracleHint hint) {
    }

    public void visit(TimeKeyExpression timeKeyExpression) {
    }

    public void visit(DateTimeLiteralExpression literal) {
    }
}

