/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlDetailedQueryResponseMessage;
import eu.clarussecure.proxy.spi.CString;
import io.netty.util.ReferenceCounted;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Objects;

public class PgsqlRowDescriptionMessage
extends PgsqlDetailedQueryResponseMessage<List<Field>> {
    public static final byte TYPE = 84;
    private List<Field> fields;

    public PgsqlRowDescriptionMessage(List<Field> fields) {
        this.fields = Objects.requireNonNull(fields, "fields must not be null");
    }

    public List<Field> getFields() {
        return this.fields;
    }

    public void setFields(List<Field> fields) {
        this.fields = Objects.requireNonNull(fields, "fields must not be null");
    }

    @Override
    public byte getType() {
        return 84;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(StringUtil.simpleClassName((Object)this));
        builder.append(" [");
        builder.append("fields=");
        int i = 0;
        for (Field field : this.fields) {
            builder.append(field);
            if (++i >= this.fields.size()) continue;
            builder.append('\n');
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public List<Field> getDetails() {
        return this.getFields();
    }

    public static class Field
    implements ReferenceCounted {
        private CString name;
        private int tableOID;
        private short columnNumber;
        private long typeOID;
        private short typeSize;
        private int typeModifier;
        private short format;

        public Field(CString name) {
            this(name, 0, 0, 0L, 0, 0, 0);
        }

        public Field(CString name, int tableOID, short columnNumber, long typeOID, short typeSize, int typeModifier, short format) {
            this.name = Objects.requireNonNull(name, "field name is required");
            this.tableOID = tableOID;
            this.columnNumber = columnNumber;
            this.typeOID = typeOID;
            this.typeSize = typeSize;
            this.typeModifier = typeModifier;
            this.format = format;
        }

        public CString getName() {
            return this.name;
        }

        public void setName(CString name) {
            this.name = name;
        }

        public int getTableOID() {
            return this.tableOID;
        }

        public void setTableOID(int tableOID) {
            this.tableOID = tableOID;
        }

        public short getColumnNumber() {
            return this.columnNumber;
        }

        public void setColumnNumber(short columnNumber) {
            this.columnNumber = columnNumber;
        }

        public long getTypeOID() {
            return this.typeOID;
        }

        public void setTypeOID(int typeOID) {
            this.typeOID = typeOID;
        }

        public short getTypeSize() {
            return this.typeSize;
        }

        public void setTypeSize(short typeSize) {
            this.typeSize = typeSize;
        }

        public int getTypeModifier() {
            return this.typeModifier;
        }

        public void setTypeModifier(int typeModifier) {
            this.typeModifier = typeModifier;
        }

        public short getFormat() {
            return this.format;
        }

        public boolean isFormatText() {
            return this.format == 0;
        }

        public boolean isFormatBinary() {
            return this.format == 1;
        }

        public void setFormat(short format) {
            this.format = format;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(StringUtil.simpleClassName((Object)this));
            builder.append(" [");
            builder.append("name=").append((CharSequence)this.name);
            builder.append(", tableOID=").append(this.tableOID);
            builder.append(", columnNumber=").append(this.columnNumber);
            builder.append(", typeOID=").append(this.typeOID);
            builder.append(", typeSize=").append(this.typeSize);
            builder.append(", typeModifier=").append(this.typeModifier);
            builder.append(", format=").append(this.format);
            builder.append("]");
            return builder.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Field other = (Field)obj;
            return !(this.name == null ? other.name != null : !this.name.equals((Object)other.name));
        }

        public int refCnt() {
            return this.name != null ? this.name.refCnt() : 0;
        }

        public ReferenceCounted retain() {
            if (this.name != null) {
                if (!this.name.isBuffered()) {
                    this.name.getByteBuf();
                }
                this.name.retain();
            }
            return this;
        }

        public ReferenceCounted retain(int increment) {
            if (this.name != null) {
                if (!this.name.isBuffered()) {
                    this.name.getByteBuf();
                }
                return this.retain(increment);
            }
            return this;
        }

        public ReferenceCounted touch() {
            if (this.name != null) {
                this.name.touch();
            }
            return this;
        }

        public ReferenceCounted touch(Object hint) {
            if (this.name != null) {
                this.name.touch(hint);
            }
            return this;
        }

        public boolean release() {
            boolean released;
            boolean bl = released = this.name == null || this.name.release();
            if (released) {
                this.name = null;
            }
            return released;
        }

        public boolean release(int decrement) {
            boolean released;
            boolean bl = released = this.name == null || this.name.release(decrement);
            if (released) {
                this.name = null;
            }
            return released;
        }
    }
}

