/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlAuthenticationRequest;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlSessionInitializationRequestMessage;
import eu.clarussecure.proxy.spi.CString;
import io.netty.util.internal.StringUtil;
import java.util.Map;
import java.util.Objects;

public class PgsqlStartupMessage
implements PgsqlSessionInitializationRequestMessage,
PgsqlAuthenticationRequest {
    public static final byte TYPE = 0;
    public static final int HEADER_SIZE = 4;
    private int protocolVersion;
    private Map<CString, CString> parameters;

    public PgsqlStartupMessage(int protocolVersion, Map<CString, CString> parameters) {
        this.protocolVersion = protocolVersion;
        this.parameters = Objects.requireNonNull(parameters, "parameters must not be null");
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public String getProtocolVersionAsString() {
        return String.format("%d.%d", this.getProtocolMajorVersion(), this.getProtocolMinorVersion());
    }

    public int getProtocolMajorVersion() {
        return this.protocolVersion >> 16 & 0xFFFF;
    }

    public int getProtocolMinorVersion() {
        return this.protocolVersion & 0xFFFF;
    }

    public void setProtocolVersion(int protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public Map<CString, CString> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<CString, CString> parameters) {
        this.parameters = parameters;
    }

    @Override
    public byte getType() {
        return 0;
    }

    @Override
    public int getHeaderSize() {
        return 4;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(StringUtil.simpleClassName((Object)this));
        builder.append(" [");
        builder.append("protocolVersion=").append(this.getProtocolVersionAsString());
        builder.append(", parameters=").append(this.parameters);
        builder.append("]");
        return builder.toString();
    }
}

