/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlBindCompleteMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlBindMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlCloseCompleteMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlCloseMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlCommandCompleteMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlDataRowMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlDescribeMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlExecuteMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlFlushMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlMessageHandler;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlNoDataMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlParameterDescriptionMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlParseCompleteMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlParseMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlQueryRequestMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlReadyForQueryMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlRowDescriptionMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlSimpleQueryMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlSyncMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.converter.PgsqlMessageToQueryConverter;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.BindStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.CloseStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.CommandResults;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.DescribeStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.ExecuteStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.FlushStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.QueriesTransferMode;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.Query;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLSession;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLStatement;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SimpleSQLStatement;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SynchronizeStep;
import eu.clarussecure.proxy.protocol.plugins.tcp.handler.forwarder.DirectedMessage;
import eu.clarussecure.proxy.spi.CString;
import eu.clarussecure.proxy.spi.buffer.MutableByteBufInputStream;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryRequestHandler
extends PgsqlMessageHandler<PgsqlQueryRequestMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryRequestHandler.class);

    public QueryRequestHandler() {
        super(PgsqlSimpleQueryMessage.class, PgsqlParseMessage.class, PgsqlBindMessage.class, PgsqlDescribeMessage.class, PgsqlExecuteMessage.class, PgsqlCloseMessage.class, PgsqlSyncMessage.class, PgsqlFlushMessage.class);
    }

    @Override
    protected boolean isStreamingSupported(byte type) {
        return type == 81;
    }

    @Override
    protected void decodeStream(ChannelHandlerContext ctx, byte type, MutableByteBufInputStream in) throws IOException {
        assert (type == 81);
        in.skip(5L);
        this.simpleQueryDecodeStream(ctx, in);
    }

    private void simpleQueryDecodeStream(ChannelHandlerContext ctx, MutableByteBufInputStream in) throws IOException {
        Deque<List<CString>> newGroupOfDirectedSQLCommands = null;
        while (in.readableBytes() > 0 || newGroupOfDirectedSQLCommands != null && !newGroupOfDirectedSQLCommands.isEmpty()) {
            List newDirectedSQLCommands;
            if (in.readableBytes() > 0) {
                int len = this.nextSQLCommandLength((InputStream)in, false, () -> in.readableBytes() > 0);
                do {
                    boolean last;
                    int strlen;
                    ByteBuf buffer;
                    CString sqlCommand;
                    if ((newGroupOfDirectedSQLCommands = this.process(ctx, newGroupOfDirectedSQLCommands, sqlCommand = CString.valueOf((ByteBuf)(buffer = in.readFully(len)), (int)(strlen = (last = in.readableBytes() == 0) ? buffer.capacity() - 1 : buffer.capacity())), last)) != null && newGroupOfDirectedSQLCommands.size() > 1) {
                        len = 0;
                        continue;
                    }
                    len = this.nextSQLCommandLength((InputStream)in, true, () -> in.available() > 0);
                    if (len != -1 || in.available() <= 0 || in.available() != in.readableBytes()) continue;
                    len = in.available();
                } while (len > 0);
            }
            if (newGroupOfDirectedSQLCommands == null || newGroupOfDirectedSQLCommands.isEmpty() || (newDirectedSQLCommands = (List)newGroupOfDirectedSQLCommands.poll()) == null || newDirectedSQLCommands.isEmpty()) continue;
            if (in.readableBytes() > 0 || !newGroupOfDirectedSQLCommands.isEmpty()) {
                this.getSqlSession(ctx).addFirstQueryResponseToIgnore(SQLSession.QueryResponseType.READY_FOR_QUERY);
            }
            for (int i = 0; i < newDirectedSQLCommands.size(); ++i) {
                CString newSQLCommands = (CString)newDirectedSQLCommands.get(i);
                if (newSQLCommands == null) continue;
                PgsqlSimpleQueryMessage newMsg = new PgsqlSimpleQueryMessage(newSQLCommands);
                this.sendRequest(ctx, newMsg, i);
            }
            this.waitForResponses(ctx);
        }
    }

    private Deque<List<CString>> process(ChannelHandlerContext ctx, Deque<List<CString>> newGroupOfSQLCommands, CString sqlCommand, boolean last) throws IOException {
        List<CString> newDirectedSQLCommands = this.process(ctx, sqlCommand, last);
        if (newDirectedSQLCommands != null) {
            int i;
            List<CString> newSQLCommands;
            if (newGroupOfSQLCommands == null) {
                newGroupOfSQLCommands = new LinkedList<List<CString>>();
            }
            if ((newSQLCommands = newGroupOfSQLCommands.peekLast()) == null || newSQLCommands.size() != newDirectedSQLCommands.size()) {
                newSQLCommands = new ArrayList<CString>(newDirectedSQLCommands.size());
                for (i = 0; i < newDirectedSQLCommands.size(); ++i) {
                    CString newSQLCommand = null;
                    CString newDirectedSQLCommand = newDirectedSQLCommands.get(i);
                    if (newDirectedSQLCommand != null) {
                        newSQLCommand = CString.valueOf((ByteBuf)ctx.alloc().compositeBuffer(Integer.MAX_VALUE));
                    }
                    newSQLCommands.add(newSQLCommand);
                }
                newGroupOfSQLCommands.add(newSQLCommands);
            }
            if (newDirectedSQLCommands.size() == 1 && newDirectedSQLCommands.get(0) == sqlCommand) {
                sqlCommand.retain();
            }
            for (i = 0; i < newDirectedSQLCommands.size(); ++i) {
                CString newDirectedSQLCommand = newDirectedSQLCommands.get(i);
                if (newDirectedSQLCommand == null) continue;
                CString newSQLCommand = newSQLCommands.get(i);
                newSQLCommand.append((CharSequence)newDirectedSQLCommand);
            }
        }
        return newGroupOfSQLCommands;
    }

    @Override
    protected List<DirectedMessage<PgsqlQueryRequestMessage>> directedProcess(ChannelHandlerContext ctx, PgsqlQueryRequestMessage msg) throws IOException {
        switch (msg.getType()) {
            case 81: {
                return this.process((PgsqlSimpleQueryMessage)msg, "Simple query", PgsqlMessageToQueryConverter::from, sqlStatement -> this.process(ctx, (SimpleSQLStatement)sqlStatement), PgsqlMessageToQueryConverter::to);
            }
            case 80: {
                return this.process(ctx, (PgsqlParseMessage)msg, "Parse", PgsqlMessageToQueryConverter::from, sqlStatement -> this.getEventProcessor(ctx).processStatement(ctx, (SQLStatement)sqlStatement), responses -> this.sendCommandResults(ctx, (CommandResults)responses), PgsqlMessageToQueryConverter::to);
            }
            case 66: {
                return this.process(ctx, (PgsqlBindMessage)msg, "Bind", PgsqlMessageToQueryConverter::from, bindStep -> this.getEventProcessor(ctx).processBindStep(ctx, (BindStep)bindStep), responses -> this.sendCommandResults(ctx, (CommandResults)responses), PgsqlMessageToQueryConverter::to);
            }
            case 68: {
                return this.process(ctx, (PgsqlDescribeMessage)msg, "Describe", PgsqlMessageToQueryConverter::from, describeStep -> this.getEventProcessor(ctx).processDescribeStep(ctx, (DescribeStep)describeStep), responses -> this.sendCommandResults(ctx, (CommandResults)responses), PgsqlMessageToQueryConverter::to);
            }
            case 69: {
                return this.process(ctx, (PgsqlExecuteMessage)msg, "Execute", PgsqlMessageToQueryConverter::from, executeStep -> this.getEventProcessor(ctx).processExecuteStep(ctx, (ExecuteStep)executeStep), responses -> this.sendCommandResults(ctx, (CommandResults)responses), PgsqlMessageToQueryConverter::to);
            }
            case 67: {
                return this.process(ctx, (PgsqlCloseMessage)msg, "Close", PgsqlMessageToQueryConverter::from, closeStep -> this.getEventProcessor(ctx).processCloseStep(ctx, (CloseStep)closeStep), responses -> this.sendCommandResults(ctx, (CommandResults)responses), PgsqlMessageToQueryConverter::to);
            }
            case 83: {
                return this.process(ctx, (PgsqlSyncMessage)msg, "Sync", PgsqlMessageToQueryConverter::from, synchronizeStep -> this.getEventProcessor(ctx).processSynchronizeStep(ctx, (SynchronizeStep)synchronizeStep), trxStatus -> this.sendReadyForQueryResponse(ctx, (byte)trxStatus), PgsqlMessageToQueryConverter::to);
            }
            case 72: {
                return this.process(ctx, (PgsqlFlushMessage)msg, "Flush", PgsqlMessageToQueryConverter::from, flushStep -> this.getEventProcessor(ctx).processFlushStep(ctx, (FlushStep)flushStep), nil -> {}, PgsqlMessageToQueryConverter::to);
            }
        }
        throw new IllegalArgumentException("msg");
    }

    @Override
    private List<SimpleSQLStatement> process(ChannelHandlerContext ctx, SimpleSQLStatement sqlStatement) throws IOException {
        List newDirectedSQLCommands;
        CString sqlCommands = sqlStatement.getSQL();
        Deque<List<CString>> newGroupOfDirectedSQLCommands = null;
        int from = 0;
        try (MutableByteBufInputStream in = new MutableByteBufInputStream(sqlCommands.getByteBuf());){
            while (in.readableBytes() > 0) {
                int len = this.nextSQLCommandLength((InputStream)in, false, () -> in.readableBytes() > 0);
                ByteBuf buffer = in.readFully(len);
                boolean last = in.readableBytes() == 0;
                int strlen = last ? buffer.capacity() - 1 : buffer.capacity();
                CString sqlCommand = CString.valueOf((ByteBuf)buffer, (int)strlen);
                newGroupOfDirectedSQLCommands = this.process(ctx, sqlCommands, newGroupOfDirectedSQLCommands, from, sqlCommand, last);
                from += len;
            }
        }
        if (newGroupOfDirectedSQLCommands != null) {
            while (newGroupOfDirectedSQLCommands.size() > 1) {
                newDirectedSQLCommands = (List)newGroupOfDirectedSQLCommands.poll();
                if (newDirectedSQLCommands == null || newDirectedSQLCommands.isEmpty()) continue;
                this.getSqlSession(ctx).addFirstQueryResponseToIgnore(SQLSession.QueryResponseType.READY_FOR_QUERY);
                for (int i = 0; i < newDirectedSQLCommands.size(); ++i) {
                    CString newSQLCommands = (CString)newDirectedSQLCommands.get(i);
                    if (newSQLCommands == null) continue;
                    PgsqlSimpleQueryMessage newMsg = new PgsqlSimpleQueryMessage(newSQLCommands);
                    this.sendRequest(ctx, newMsg, i);
                }
                this.waitForResponses(ctx);
            }
        }
        List list = newDirectedSQLCommands = newGroupOfDirectedSQLCommands != null ? (List)newGroupOfDirectedSQLCommands.poll() : null;
        if (newDirectedSQLCommands != null && newDirectedSQLCommands.size() == 1 && newDirectedSQLCommands.get(0) == sqlCommands) {
            return Collections.singletonList(sqlStatement);
        }
        if (newDirectedSQLCommands != null) {
            return newDirectedSQLCommands.stream().map(nds -> nds == null ? null : new SimpleSQLStatement((CString)nds)).collect(Collectors.toList());
        }
        return null;
    }

    private int nextSQLCommandLength(InputStream in, boolean separatorCharRequired, StreamEvaluator stream) throws IOException {
        boolean inQuote = false;
        boolean inSingleQuote = false;
        int len = -1;
        int index = 0;
        char cp = '\u0000';
        Character ci = null;
        in.mark(0);
        if (stream.available()) {
            ci = Character.valueOf((char)in.read());
            ++index;
        }
        while (ci != null) {
            char cn;
            if (ci.charValue() == '\"' && !inSingleQuote) {
                if (inQuote) {
                    if (index <= 0 || !stream.available()) continue;
                    cn = (char)in.read();
                    ++index;
                    if (cp != '\\' && cp != '\"' && cn != '\"') {
                        inQuote = false;
                    }
                    cp = ci.charValue();
                    ci = Character.valueOf(cn);
                    continue;
                }
                inQuote = true;
                cp = ci.charValue();
                if (stream.available()) {
                    ci = Character.valueOf((char)in.read());
                    ++index;
                    continue;
                }
                ci = null;
                continue;
            }
            if (ci.charValue() == '\'' && !inQuote) {
                if (inSingleQuote) {
                    if (index <= 0 || !stream.available()) continue;
                    cn = (char)in.read();
                    ++index;
                    if (cp != '\\' && cp != '\'' && cn != '\'') {
                        inSingleQuote = false;
                    }
                    cp = ci.charValue();
                    ci = Character.valueOf(cn);
                    continue;
                }
                inSingleQuote = true;
                cp = ci.charValue();
                if (stream.available()) {
                    ci = Character.valueOf((char)in.read());
                    ++index;
                    continue;
                }
                ci = null;
                continue;
            }
            if (ci.charValue() == ';' && !inQuote && !inSingleQuote) {
                int rewind = 0;
                while (stream.available()) {
                    ci = Character.valueOf((char)in.read());
                    ++index;
                    if (ci.charValue() == '\r' || ci.charValue() == '\n') continue;
                    if (ci.charValue() == '\u0000') break;
                    rewind = 1;
                    break;
                }
                len = index - rewind;
                break;
            }
            cp = ci.charValue();
            if (stream.available()) {
                ci = Character.valueOf((char)in.read());
                ++index;
                continue;
            }
            ci = null;
        }
        if (len == -1 && !separatorCharRequired) {
            len = index;
        }
        in.reset();
        return len;
    }

    private Deque<List<CString>> process(ChannelHandlerContext ctx, CString sqlCommands, Deque<List<CString>> newGroupOfSQLCommands, int from, CString sqlCommand, boolean last) throws IOException {
        List<CString> newDirectedSQLCommands = this.process(ctx, sqlCommand, last);
        if (newDirectedSQLCommands != null) {
            int i;
            if (newGroupOfSQLCommands == null) {
                newGroupOfSQLCommands = new LinkedList<List<CString>>();
            }
            List<CString> newSQLCommands = newGroupOfSQLCommands.peekLast();
            if (!(!newDirectedSQLCommands.isEmpty() && newDirectedSQLCommands.size() <= 1 && newDirectedSQLCommands.get(0) == sqlCommand && newSQLCommands != null && newSQLCommands.get(0) == sqlCommands || newSQLCommands != null && newSQLCommands.size() == newDirectedSQLCommands.size())) {
                newSQLCommands = new ArrayList<CString>(newDirectedSQLCommands.size());
                for (i = 0; i < newDirectedSQLCommands.size(); ++i) {
                    CString newSQLCommand = null;
                    CString newDirectedSQLCommand = newDirectedSQLCommands.get(i);
                    if (newDirectedSQLCommand != null) {
                        newSQLCommand = CString.valueOf((ByteBuf)ctx.alloc().compositeBuffer(Integer.MAX_VALUE));
                        if (newGroupOfSQLCommands.isEmpty() && from > 0) {
                            CString cs = sqlCommands.subSequence(0, from);
                            cs.retain();
                            newSQLCommand.append((CharSequence)cs);
                        }
                    }
                    newSQLCommands.add(newSQLCommand);
                }
                newGroupOfSQLCommands.add(newSQLCommands);
            }
            if (newDirectedSQLCommands.size() == 1 && newDirectedSQLCommands.get(0) == sqlCommand) {
                sqlCommand.retain();
            }
            for (i = 0; i < newDirectedSQLCommands.size(); ++i) {
                CString newDirectedSQLCommand = newDirectedSQLCommands.get(i);
                if (newDirectedSQLCommand == null) continue;
                CString newSQLCommand = newSQLCommands.get(i);
                newSQLCommand.append((CharSequence)newDirectedSQLCommand);
            }
        }
        return newGroupOfSQLCommands;
    }

    private List<CString> process(ChannelHandlerContext ctx, CString sqlCommand, boolean last) throws IOException {
        SimpleSQLStatement sqlStatement = new SimpleSQLStatement(sqlCommand);
        QueriesTransferMode<SQLStatement, CommandResults> transferMode = this.getEventProcessor(ctx).processStatement(ctx, sqlStatement);
        List<SQLStatement> newDirectedSQLStatements = this.process(ctx, transferMode, (R responses) -> {
            if (responses != null) {
                this.sendCommandResults(ctx, (CommandResults)responses);
                if (last) {
                    this.sendReadyForQueryResponse(ctx, (byte)84);
                }
            }
        }, errorDetails -> {
            this.sendErrorResponse(ctx, (Map<Byte, CString>)errorDetails);
            if (last) {
                this.sendReadyForQueryResponse(ctx, (byte)69);
            }
        });
        return newDirectedSQLStatements != null ? newDirectedSQLStatements.stream().map(s -> s != null ? s.getSQL() : null).collect(Collectors.toList()) : null;
    }

    private <M extends PgsqlQueryRequestMessage, Q extends Query, R> List<DirectedMessage<PgsqlQueryRequestMessage>> process(ChannelHandlerContext ctx, M msg, String prefix, Function<M, Q> queryBuilder, CheckedFunction<Q, QueriesTransferMode<Q, R>> processor, CheckedConsumer<R> responseConsumer, Function<Q, PgsqlQueryRequestMessage> msgBuilder) throws IOException {
        return this.process(msg, prefix, queryBuilder, query -> {
            QueriesTransferMode transferMode = (QueriesTransferMode)processor.apply(query);
            List newQueries = this.process(ctx, transferMode, responseConsumer, errorDetails -> this.sendErrorResponse(ctx, (Map<Byte, CString>)errorDetails));
            return newQueries;
        }, msgBuilder);
    }

    private <M extends PgsqlQueryRequestMessage, Q extends Query> List<DirectedMessage<PgsqlQueryRequestMessage>> process(M msg, String prefix, Function<M, Q> queryBuilder, CheckedFunction<Q, List<Q>> processor, Function<Q, PgsqlQueryRequestMessage> msgBuilder) throws IOException {
        List<DirectedMessage<PgsqlQueryRequestMessage>> directedMsgs = Collections.singletonList(new DirectedMessage(0, msg));
        Query query = (Query)queryBuilder.apply(msg);
        LOGGER.debug("{}: {}", (Object)prefix, (Object)query);
        List<Q> newQueries = processor.apply(query);
        if (newQueries == null || newQueries.size() != 1 || newQueries.get(0) != query) {
            if (newQueries == null || newQueries.isEmpty()) {
                directedMsgs = null;
                LOGGER.trace("{} dropped", (Object)prefix);
            } else {
                directedMsgs = new ArrayList<DirectedMessage<PgsqlQueryRequestMessage>>(newQueries.size());
                for (int i = 0; i < newQueries.size(); ++i) {
                    Query newQuery = (Query)newQueries.get(i);
                    if (newQuery == null) continue;
                    PgsqlQueryRequestMessage newMsg = msgBuilder.apply(newQuery);
                    LOGGER.trace("{} modified: original was: {}", (Object)prefix, (Object)query);
                    LOGGER.trace("{} modified: new is : {}", (Object)prefix, (Object)newQuery);
                    directedMsgs.add((DirectedMessage<PgsqlQueryRequestMessage>)new DirectedMessage(i, (Object)newMsg));
                }
            }
        }
        return directedMsgs;
    }

    private <Q extends Query, R> List<Q> process(ChannelHandlerContext ctx, QueriesTransferMode<Q, R> transferMode, CheckedConsumer<R> responseConsumer, CheckedConsumer<Map<Byte, CString>> errorConsumer) throws IOException {
        ArrayList<Query> newDirectedLastQueries;
        switch (transferMode.getTransferMode()) {
            case FORWARD: {
                int maxBackend = (Integer)transferMode.getNewDirectedQueries().keySet().stream().max(Comparator.naturalOrder()).get();
                List newDirectedQueries = IntStream.range(0, maxBackend + 1).mapToObj(backend -> transferMode.getNewDirectedQueries().get(backend)).map(l -> l == null ? Collections.emptyList() : l).collect(Collectors.toList());
                newDirectedLastQueries = new ArrayList<Query>(newDirectedQueries.size());
                for (int i = 0; i < newDirectedQueries.size(); ++i) {
                    List newQueries = (List)newDirectedQueries.get(i);
                    if (!newQueries.isEmpty()) {
                        for (Query query : newQueries.subList(0, newQueries.size() - 1)) {
                            PgsqlQueryRequestMessage msg = PgsqlMessageToQueryConverter.to(query);
                            this.sendRequest(ctx, msg, i);
                            if (!(msg instanceof PgsqlSimpleQueryMessage) && !(msg instanceof PgsqlSyncMessage)) continue;
                            this.waitForResponses(ctx);
                        }
                    }
                    Query lastNewQuery = newQueries.size() > 0 ? (Query)newQueries.get(newQueries.size() - 1) : null;
                    newDirectedLastQueries.add(lastNewQuery);
                }
                break;
            }
            case FORGET: {
                responseConsumer.accept(transferMode.getResponse());
                newDirectedLastQueries = null;
                break;
            }
            case ERROR: {
                errorConsumer.accept(transferMode.getErrorDetails());
                newDirectedLastQueries = null;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for enum " + ((Object)((Object)transferMode.getTransferMode())).getClass().getSimpleName() + ": " + (Object)((Object)transferMode.getTransferMode()));
            }
        }
        return newDirectedLastQueries;
    }

    private void waitForResponses(ChannelHandlerContext ctx) throws IOException {
        SQLSession psqlSession = this.getSqlSession(ctx);
        try {
            psqlSession.waitForResponses();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    private void sendCommandResults(ChannelHandlerContext ctx, CommandResults commandResults) throws IOException {
        if (commandResults.isParseCompleteRequired()) {
            this.sendParseCompleteResponse(ctx);
        }
        if (commandResults.isBindCompleteRequired()) {
            this.sendBindCompleteResponse(ctx);
        }
        if (commandResults.getParameterDescription() != null) {
            this.sendParameterDescriptionResponse(ctx, commandResults.getParameterDescription());
        }
        if (commandResults.getRowDescription() != null) {
            if (commandResults.getRowDescription().isEmpty()) {
                this.sendNoDataResponse(ctx);
            } else {
                this.sendRowDescriptionResponse(ctx, commandResults.getRowDescription());
            }
        }
        if (commandResults.getRows() != null) {
            for (List<ByteBuf> row : commandResults.getRows()) {
                this.sendDataRowResponse(ctx, row);
            }
        }
        if (commandResults.getCompleteTag() != null) {
            this.sendCommandCompleteResponse(ctx, commandResults.getCompleteTag());
        }
        if (commandResults.isCloseCompleteRequired()) {
            this.sendCloseCompleteResponse(ctx);
        }
    }

    private void sendParseCompleteResponse(ChannelHandlerContext ctx) throws IOException {
        PgsqlParseCompleteMessage msg = new PgsqlParseCompleteMessage();
        this.sendResponse(ctx, msg);
    }

    private void sendBindCompleteResponse(ChannelHandlerContext ctx) throws IOException {
        PgsqlBindCompleteMessage msg = new PgsqlBindCompleteMessage();
        this.sendResponse(ctx, msg);
    }

    private void sendParameterDescriptionResponse(ChannelHandlerContext ctx, List<Long> parameterTypes) throws IOException {
        PgsqlParameterDescriptionMessage msg = new PgsqlParameterDescriptionMessage(parameterTypes);
        this.sendResponse(ctx, msg);
    }

    private void sendRowDescriptionResponse(ChannelHandlerContext ctx, List<PgsqlRowDescriptionMessage.Field> rowDescription) throws IOException {
        PgsqlRowDescriptionMessage msg = new PgsqlRowDescriptionMessage(rowDescription);
        this.sendResponse(ctx, msg);
    }

    private void sendDataRowResponse(ChannelHandlerContext ctx, List<ByteBuf> row) throws IOException {
        PgsqlDataRowMessage msg = new PgsqlDataRowMessage(row);
        this.sendResponse(ctx, msg);
    }

    private void sendNoDataResponse(ChannelHandlerContext ctx) throws IOException {
        PgsqlNoDataMessage msg = new PgsqlNoDataMessage();
        this.sendResponse(ctx, msg);
    }

    private void sendCommandCompleteResponse(ChannelHandlerContext ctx, CString response) throws IOException {
        PgsqlCommandCompleteMessage msg = new PgsqlCommandCompleteMessage(response);
        this.sendResponse(ctx, msg);
    }

    private void sendCloseCompleteResponse(ChannelHandlerContext ctx) throws IOException {
        PgsqlCloseCompleteMessage msg = new PgsqlCloseCompleteMessage();
        this.sendResponse(ctx, msg);
    }

    private void sendReadyForQueryResponse(ChannelHandlerContext ctx, byte trxStatus) throws IOException {
        PgsqlReadyForQueryMessage msg = new PgsqlReadyForQueryMessage(trxStatus);
        this.sendResponse(ctx, msg);
    }

    @FunctionalInterface
    private static interface CheckedConsumer<T> {
        public void accept(T var1) throws IOException;
    }

    @FunctionalInterface
    private static interface CheckedFunction<T, R> {
        public R apply(T var1) throws IOException;
    }

    private static interface StreamEvaluator {
        public boolean available() throws IOException;
    }
}

