/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlCancelRequestMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlMessageHandler;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlSSLRequestMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlSSLResponseMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlSessionInitializationRequestMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlStartupMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.ssl.SessionInitializer;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.ssl.SessionMessageTransferMode;
import eu.clarussecure.proxy.protocol.plugins.tcp.handler.forwarder.DirectedMessage;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionInitializationRequestHandler
extends PgsqlMessageHandler<PgsqlSessionInitializationRequestMessage> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionInitializationRequestHandler.class);

    public SessionInitializationRequestHandler() {
        super(PgsqlSSLRequestMessage.class, PgsqlStartupMessage.class, PgsqlCancelRequestMessage.class);
    }

    @Override
    protected List<DirectedMessage<PgsqlSessionInitializationRequestMessage>> directedProcess(ChannelHandlerContext ctx, PgsqlSessionInitializationRequestMessage msg) throws IOException {
        PgsqlSessionInitializationRequestMessage newMsg = this.process(ctx, msg);
        if (newMsg == null) {
            return null;
        }
        DirectedMessage directedMsg = new DirectedMessage(-1, (Object)newMsg);
        List<DirectedMessage<PgsqlSessionInitializationRequestMessage>> directedMsgs = Collections.singletonList(directedMsg);
        return directedMsgs;
    }

    @Override
    protected PgsqlSessionInitializationRequestMessage process(ChannelHandlerContext ctx, PgsqlSessionInitializationRequestMessage msg) throws IOException {
        PgsqlSessionInitializationRequestMessage newMsg = msg;
        if (msg instanceof PgsqlSSLRequestMessage) {
            int code = ((PgsqlSSLRequestMessage)msg).getCode();
            LOGGER.debug("SSL request: {}", (Object)code);
            SessionMessageTransferMode<Void, Byte> transferMode = this.getSessionInitializer(ctx).processSSLRequest(ctx, code);
            switch (transferMode.getTransferMode()) {
                case FORWARD: {
                    LOGGER.trace("Forward the SSL request");
                    break;
                }
                case FORGET: {
                    if (transferMode.getResponse() != null) {
                        LOGGER.trace("Send the SSL response");
                        this.sendSSLResponse(ctx, transferMode.getResponse());
                    }
                    LOGGER.trace("Ignore the SSL request");
                    newMsg = null;
                    break;
                }
                case ERROR: {
                    LOGGER.trace("Send an error response");
                    this.sendErrorResponse(ctx, transferMode.getErrorDetails());
                    newMsg = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid value for enum " + ((Object)((Object)transferMode.getTransferMode())).getClass().getSimpleName() + ": " + (Object)((Object)transferMode.getTransferMode()));
                }
            }
        } else if (msg instanceof PgsqlStartupMessage) {
            SessionMessageTransferMode<Void, Void> transferMode = this.getSessionInitializer(ctx).processStartupMessage(ctx);
            switch (transferMode.getTransferMode()) {
                case FORWARD: {
                    LOGGER.trace("Forward the start-up message");
                    break;
                }
                case ORCHESTRATE: {
                    LOGGER.trace("Send the SSL request");
                    this.sendSSLRequest(ctx, 80877103);
                    LOGGER.trace("Wait for the SSL response");
                    this.waitForResponses(ctx);
                    LOGGER.trace("Forward the start-up message");
                    break;
                }
                case ERROR: {
                    LOGGER.trace("Send an error response");
                    this.sendErrorResponse(ctx, transferMode.getErrorDetails());
                    newMsg = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid value for enum " + ((Object)((Object)transferMode.getTransferMode())).getClass().getSimpleName() + ": " + (Object)((Object)transferMode.getTransferMode()));
                }
            }
        } else if (msg instanceof PgsqlCancelRequestMessage) {
            int code = ((PgsqlCancelRequestMessage)msg).getCode();
            int processId = ((PgsqlCancelRequestMessage)msg).getProcessId();
            int secretKey = ((PgsqlCancelRequestMessage)msg).getSecretKey();
            LOGGER.debug("Cancel request: code={}, process ID={}, secret key={}", new Object[]{code, processId, secretKey});
            SessionMessageTransferMode<Void, Void> transferMode = this.getSessionInitializer(ctx).processCancelRequest(ctx, code, processId, secretKey);
            switch (transferMode.getTransferMode()) {
                case FORWARD: {
                    LOGGER.trace("Forward the cancel request");
                    break;
                }
                case FORGET: {
                    LOGGER.trace("Ignore the cancel request");
                    newMsg = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid value for enum " + ((Object)((Object)transferMode.getTransferMode())).getClass().getSimpleName() + ": " + (Object)((Object)transferMode.getTransferMode()));
                }
            }
        }
        return newMsg;
    }

    private void sendSSLRequest(ChannelHandlerContext ctx, int code) throws IOException {
        PgsqlSSLRequestMessage msg = new PgsqlSSLRequestMessage(code);
        this.sendRequest(ctx, msg, -1);
    }

    private void sendSSLResponse(ChannelHandlerContext ctx, byte code) throws IOException {
        PgsqlSSLResponseMessage msg = new PgsqlSSLResponseMessage(code);
        this.sendResponse(ctx, msg);
    }

    private void waitForResponses(ChannelHandlerContext ctx) throws IOException {
        SessionInitializer sessionInitializer = this.getSessionInitializer(ctx);
        sessionInitializer.waitForResponses(ctx);
    }

    private SessionInitializer getSessionInitializer(ChannelHandlerContext ctx) {
        return this.getPgsqlSession(ctx).getSessionInitializer();
    }
}

