/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.converter;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlBindMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlCloseMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlDescribeMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlExecuteMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlFlushMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlParseMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlQueryMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlQueryRequestMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlSimpleQueryMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlSyncMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.BindStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.CloseStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.DescribeStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.ExecuteStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.ExtendedQuery;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.FlushStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.ParseStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.Query;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLStatement;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SimpleQuery;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SimpleSQLStatement;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SynchronizeStep;
import io.netty.util.internal.StringUtil;

public class PgsqlMessageToQueryConverter {
    public static Query from(PgsqlQueryRequestMessage msg) {
        if (msg instanceof PgsqlQueryMessage) {
            return PgsqlMessageToQueryConverter.from((PgsqlQueryMessage)msg);
        }
        if (msg instanceof PgsqlBindMessage) {
            return PgsqlMessageToQueryConverter.from((PgsqlBindMessage)msg);
        }
        if (msg instanceof PgsqlDescribeMessage) {
            return PgsqlMessageToQueryConverter.from((PgsqlDescribeMessage)msg);
        }
        if (msg instanceof PgsqlExecuteMessage) {
            return PgsqlMessageToQueryConverter.from((PgsqlExecuteMessage)msg);
        }
        if (msg instanceof PgsqlCloseMessage) {
            return PgsqlMessageToQueryConverter.from((PgsqlCloseMessage)msg);
        }
        if (msg instanceof PgsqlSyncMessage) {
            return PgsqlMessageToQueryConverter.from((PgsqlSyncMessage)msg);
        }
        if (msg instanceof PgsqlFlushMessage) {
            return PgsqlMessageToQueryConverter.from((PgsqlFlushMessage)msg);
        }
        throw new IllegalArgumentException(StringUtil.simpleClassName((Object)msg) + " not supported");
    }

    public static PgsqlQueryRequestMessage to(Query query) {
        if (query instanceof SimpleQuery) {
            return PgsqlMessageToQueryConverter.to((SimpleQuery)query);
        }
        return PgsqlMessageToQueryConverter.to((ExtendedQuery)query);
    }

    public static PgsqlQueryRequestMessage to(SimpleQuery query) {
        return PgsqlMessageToQueryConverter.to((SimpleSQLStatement)query);
    }

    public static PgsqlQueryRequestMessage to(ExtendedQuery query) {
        if (query instanceof ParseStep) {
            return PgsqlMessageToQueryConverter.to((ParseStep)query);
        }
        if (query instanceof BindStep) {
            return PgsqlMessageToQueryConverter.to((BindStep)query);
        }
        if (query instanceof DescribeStep) {
            return PgsqlMessageToQueryConverter.to((DescribeStep)query);
        }
        if (query instanceof ExecuteStep) {
            return PgsqlMessageToQueryConverter.to((ExecuteStep)query);
        }
        if (query instanceof CloseStep) {
            return PgsqlMessageToQueryConverter.to((CloseStep)query);
        }
        if (query instanceof SynchronizeStep) {
            return PgsqlMessageToQueryConverter.to((SynchronizeStep)query);
        }
        if (query instanceof FlushStep) {
            return PgsqlMessageToQueryConverter.to((FlushStep)query);
        }
        throw new IllegalArgumentException(StringUtil.simpleClassName((Object)query) + " not supported");
    }

    public static SQLStatement from(PgsqlQueryMessage msg) {
        if (msg instanceof PgsqlSimpleQueryMessage) {
            return PgsqlMessageToQueryConverter.from((PgsqlSimpleQueryMessage)msg);
        }
        return PgsqlMessageToQueryConverter.from((PgsqlParseMessage)msg);
    }

    public static PgsqlQueryMessage to(SQLStatement sqlStatement) {
        if (sqlStatement instanceof SimpleSQLStatement) {
            return PgsqlMessageToQueryConverter.to((SimpleSQLStatement)sqlStatement);
        }
        return PgsqlMessageToQueryConverter.to((ParseStep)sqlStatement);
    }

    public static SimpleSQLStatement from(PgsqlSimpleQueryMessage msg) {
        return new SimpleSQLStatement(msg.getQuery());
    }

    public static PgsqlSimpleQueryMessage to(SimpleSQLStatement sqlStatement) {
        return new PgsqlSimpleQueryMessage(sqlStatement.getSQL());
    }

    public static ParseStep from(PgsqlParseMessage msg) {
        return new ParseStep(msg.getPreparedStatement(), msg.getQuery(), false, null, msg.getParameterTypes());
    }

    public static PgsqlParseMessage to(ParseStep query) {
        return new PgsqlParseMessage(query.getName(), query.getSQL(), query.getParameterTypes());
    }

    public static BindStep from(PgsqlBindMessage msg) {
        return new BindStep(msg.getPortal(), msg.getPreparedStatement(), msg.getParameterFormats(), msg.getParameterValues(), msg.getResultColumnFormats());
    }

    public static PgsqlBindMessage to(BindStep query) {
        return new PgsqlBindMessage(query.getName(), query.getPreparedStatement(), query.getParameterFormats(), query.getParameterValues(), query.getResultColumnFormats());
    }

    public static DescribeStep from(PgsqlDescribeMessage msg) {
        return new DescribeStep(msg.getCode(), msg.getName());
    }

    public static PgsqlDescribeMessage to(DescribeStep query) {
        return new PgsqlDescribeMessage(query.getCode(), query.getName());
    }

    public static ExecuteStep from(PgsqlExecuteMessage msg) {
        return new ExecuteStep(msg.getPortal(), msg.getMaxRows());
    }

    public static PgsqlExecuteMessage to(ExecuteStep query) {
        return new PgsqlExecuteMessage(query.getPortal(), query.getMaxRows());
    }

    public static CloseStep from(PgsqlCloseMessage msg) {
        return new CloseStep(msg.getCode(), msg.getName());
    }

    public static PgsqlCloseMessage to(CloseStep query) {
        return new PgsqlCloseMessage(query.getCode(), query.getName());
    }

    public static SynchronizeStep from(PgsqlSyncMessage msg) {
        return new SynchronizeStep();
    }

    public static PgsqlSyncMessage to(SynchronizeStep query) {
        return new PgsqlSyncMessage();
    }

    public static FlushStep from(PgsqlFlushMessage msg) {
        return new FlushStep();
    }

    public static PgsqlFlushMessage to(FlushStep query) {
        return new PgsqlFlushMessage();
    }
}

