/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.ExtendedQuery;
import eu.clarussecure.proxy.spi.CString;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Objects;

public class BindStep
implements ExtendedQuery {
    private CString name;
    private CString preparedStatement;
    private List<Short> parameterFormats;
    private List<ByteBuf> parameterValues;
    private List<Short> resultColumnFormats;

    public BindStep(CString portal, CString preparedStatement, List<Short> parameterFormats, List<ByteBuf> parameterValues, List<Short> resultColumnFormats) {
        this.name = Objects.requireNonNull(portal, "portal must not be null");
        this.preparedStatement = Objects.requireNonNull(preparedStatement, "preparedStatement must not be null");
        this.parameterFormats = Objects.requireNonNull(parameterFormats, "parameterFormats must not be null");
        this.parameterValues = Objects.requireNonNull(parameterValues, "parameterValues must not be null");
        this.resultColumnFormats = Objects.requireNonNull(resultColumnFormats, "resultColumnFormats must not be null");
    }

    public CString getName() {
        return this.name;
    }

    public void setName(CString name) {
        this.name = Objects.requireNonNull(name, "name must not be null");
    }

    public CString getPreparedStatement() {
        return this.preparedStatement;
    }

    public void setPreparedStatement(CString preparedStatement) {
        this.preparedStatement = Objects.requireNonNull(preparedStatement, "preparedStatement must not be null");
    }

    public List<Short> getParameterFormats() {
        return this.parameterFormats;
    }

    public void setParameterFormats(List<Short> parameterFormats) {
        this.parameterFormats = Objects.requireNonNull(parameterFormats, "parameterFormats must not be null");
    }

    public List<ByteBuf> getParameterValues() {
        return this.parameterValues;
    }

    public void setParameterValues(List<ByteBuf> parameterValues) {
        this.parameterValues = Objects.requireNonNull(parameterValues, "parameterValues must not be null");
    }

    public List<Short> getResultColumnFormats() {
        return this.resultColumnFormats;
    }

    public void setResultColumnFormats(List<Short> resultColumnFormats) {
        this.resultColumnFormats = Objects.requireNonNull(resultColumnFormats, "resultColumnFormats must not be null");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(StringUtil.simpleClassName((Object)this));
        builder.append(" [name=").append((CharSequence)this.name);
        builder.append(", preparedStatement=").append((CharSequence)this.preparedStatement);
        builder.append(", parameterFormats=").append(this.parameterFormats);
        builder.append(", parameterValues=").append(this.parameterValues);
        builder.append(", resultColumnFormats=").append(this.resultColumnFormats);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void retain() {
        if (this.name.isBuffered()) {
            this.name.retain();
        }
        if (this.preparedStatement.isBuffered()) {
            this.preparedStatement.retain();
        }
        this.parameterValues.forEach(b -> b.retain());
    }

    @Override
    public boolean release() {
        boolean portalDeallocated = true;
        if (this.name.isBuffered()) {
            portalDeallocated = this.name.release();
        }
        boolean preparedStatementDeallocated = true;
        if (this.preparedStatement.isBuffered()) {
            preparedStatementDeallocated = this.preparedStatement.release();
        }
        Boolean parameterValuesDeallocated = this.parameterValues.stream().reduce(true, (a, b) -> a & b.release(), (a, b) -> a & b);
        return portalDeallocated && preparedStatementDeallocated && parameterValuesDeallocated != false;
    }
}

