/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.ExtendedQuery;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLStatement;
import eu.clarussecure.proxy.spi.CString;
import io.netty.util.internal.StringUtil;
import java.util.List;
import java.util.Objects;

public class ParseStep
implements ExtendedQuery,
SQLStatement {
    private CString name;
    private CString sql;
    private boolean metadata;
    private List<CString> columns;
    private List<Long> parameterTypes;

    public ParseStep(CString name, CString sql, boolean metadata, List<CString> columns, List<Long> parameterTypes) {
        this.name = Objects.requireNonNull(name, "name must not be null");
        this.sql = Objects.requireNonNull(sql, "sql must not be null");
        this.metadata = metadata;
        this.columns = columns;
        this.parameterTypes = Objects.requireNonNull(parameterTypes, "parameterTypes must not be null");
    }

    public CString getName() {
        return this.name;
    }

    public void setName(CString name) {
        this.name = Objects.requireNonNull(name, "name must not be null");
    }

    @Override
    public CString getSQL() {
        return this.sql;
    }

    public void setSQL(CString sql) {
        this.sql = Objects.requireNonNull(sql, "sql must not be null");
    }

    public boolean isMetadata() {
        return this.metadata;
    }

    public void setMetadata(boolean metadata) {
        this.metadata = metadata;
    }

    public List<CString> getColumns() {
        return this.columns;
    }

    public void setColumns(List<CString> columns) {
        this.columns = columns;
    }

    public List<Long> getParameterTypes() {
        return this.parameterTypes;
    }

    public void setParameterTypes(List<Long> parameterTypes) {
        this.parameterTypes = Objects.requireNonNull(parameterTypes, "parameterTypes must not be null");
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(StringUtil.simpleClassName((Object)this));
        builder.append(" [name=").append((CharSequence)this.name);
        builder.append(", SQL=").append((CharSequence)this.sql);
        builder.append(", metadata=").append(this.metadata);
        builder.append(", columns=").append(this.columns);
        builder.append(", parameterTypes=").append(this.parameterTypes);
        builder.append("]");
        return builder.toString();
    }

    @Override
    public void retain() {
        if (this.name.isBuffered()) {
            this.name.retain();
        }
        if (this.sql.isBuffered()) {
            this.sql.retain();
        }
        if (this.columns != null) {
            for (CString column : this.columns) {
                if (!column.isBuffered()) continue;
                column.retain();
            }
        }
    }

    @Override
    public boolean release() {
        boolean nameDeallocated = true;
        if (this.name.isBuffered()) {
            nameDeallocated = this.name.release();
        }
        boolean sqlDeallocated = true;
        if (this.sql.isBuffered()) {
            sqlDeallocated = this.sql.release();
        }
        boolean columnsDeallocated = true;
        if (this.columns != null) {
            for (CString column : this.columns) {
                if (!column.isBuffered()) continue;
                columnsDeallocated &= column.release();
            }
        }
        return nameDeallocated && sqlDeallocated && columnsDeallocated;
    }
}

