/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql;

import eu.clarussecure.dataoperations.DataOperationCommand;
import eu.clarussecure.proxy.protocol.plugins.pgsql.GeometryType;
import eu.clarussecure.proxy.protocol.plugins.pgsql.PgsqlConfiguration;
import eu.clarussecure.proxy.protocol.plugins.pgsql.PgsqlConstants;
import eu.clarussecure.proxy.protocol.plugins.pgsql.PgsqlSession;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlColumnsFinder;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlRowDescriptionMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.AuthenticationResponse;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.BindStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.CloseStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.CommandResults;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.DescribeStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.EventProcessor;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.ExecuteStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.ExtendedQuery;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.FlushStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.MessageTransferMode;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.ParameterValue;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.ParseStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.QueriesTransferMode;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.Query;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLCommandType;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLDatabaseSchema;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLSession;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLStatement;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SimpleQuery;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SimpleSQLParserUtil;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SimpleSQLStatement;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SynchronizeStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.TransferMode;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data.Type;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data.TypeParser;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data.TypeWriter;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data.Types;
import eu.clarussecure.proxy.protocol.plugins.tcp.TCPConstants;
import eu.clarussecure.proxy.spi.CString;
import eu.clarussecure.proxy.spi.DataOperation;
import eu.clarussecure.proxy.spi.InboundDataOperation;
import eu.clarussecure.proxy.spi.MetadataOperation;
import eu.clarussecure.proxy.spi.Mode;
import eu.clarussecure.proxy.spi.ModuleOperation;
import eu.clarussecure.proxy.spi.Operation;
import eu.clarussecure.proxy.spi.OutboundDataOperation;
import eu.clarussecure.proxy.spi.StringUtilities;
import eu.clarussecure.proxy.spi.protocol.Configuration;
import eu.clarussecure.proxy.spi.protocol.ProtocolService;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.channel.ChannelHandlerContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.invoke.LambdaMetafactory;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.xml.bind.DatatypeConverter;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.BinaryExpression;
import net.sf.jsqlparser.expression.CaseExpression;
import net.sf.jsqlparser.expression.CastExpression;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.Not;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.OracleHierarchicalExpression;
import net.sf.jsqlparser.expression.Parenthesis;
import net.sf.jsqlparser.expression.RawStringValue;
import net.sf.jsqlparser.expression.RowConstructor;
import net.sf.jsqlparser.expression.SignedExpression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.WhenClause;
import net.sf.jsqlparser.expression.WithinGroupExpression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.ArrayElement;
import net.sf.jsqlparser.expression.operators.relational.Between;
import net.sf.jsqlparser.expression.operators.relational.ExistsExpression;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.expression.operators.relational.MultiExpressionList;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.jsqlparser.parser.Token;
import net.sf.jsqlparser.parser.TokenMgrError;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Database;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.SetStatement;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.alter.Alter;
import net.sf.jsqlparser.statement.alter.AlterExpression;
import net.sf.jsqlparser.statement.alter.AlterOperation;
import net.sf.jsqlparser.statement.close.CursorClose;
import net.sf.jsqlparser.statement.commit.Commit;
import net.sf.jsqlparser.statement.create.index.CreateIndex;
import net.sf.jsqlparser.statement.create.table.ColDataType;
import net.sf.jsqlparser.statement.create.table.ColumnDefinition;
import net.sf.jsqlparser.statement.create.table.CreateTable;
import net.sf.jsqlparser.statement.create.table.Index;
import net.sf.jsqlparser.statement.declare.cursor.DeclareCursor;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.drop.Drop;
import net.sf.jsqlparser.statement.fetch.CursorFetch;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.OrderByElement;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SubSelect;
import net.sf.jsqlparser.statement.start.StartTransaction;
import net.sf.jsqlparser.statement.update.Update;
import org.postgis.Geometry;
import org.postgis.PGboxbase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgsqlEventProcessor
implements EventProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EventProcessor.class);
    private static boolean FORCE_SQL_PROCESSING;
    private static final boolean CHECK_BUFFER_REFERENCE_COUNT;
    public static final String USER_KEY = "user";
    public static final String DATABASE_KEY = "database";
    private static final int AUTHENTICATION_OK = 0;
    private static final int AUTHENTICATION_CLEARTEXT_PASSWORD = 3;
    private static final int AUTHENTICATION_MD5_PASSWORD = 5;
    public static final String FUNCTION_METADATA = "CLARUS_METADATA";
    public static final String FUNCTION_PROTECTED = "CLARUS_PROTECTED";
    public static final String FUNCTION_HAS_COLUMN_PRIVILEGE = "has_column_privilege";
    public static final String FUNCTION_ADD_GEOMETRY_COLUMN = "AddGeometryColumn";
    public static final String FUNCTION_ST_AS_BINARY = "ST_AsBinary";
    public static final String FUNCTION_ST_AS_TEXT = "ST_AsText";
    public static final String FUNCTION_ST_EXTENT = "ST_Extent";
    public static final String FUNCTION_ST_ESTIMATED_EXTENT = "ST_EstimatedExtent";
    public static final String FUNCTION_UPPER = "upper";
    public String[] FUNCTIONS_WITH_SUPPORTED_RETURN_TYPE = new String[]{"ST_AsBinary", "ST_AsText", "ST_Extent", "ST_EstimatedExtent", "upper"};
    private static final Pattern FQ_DATA_ID_PATTERN;
    private static final String SQL_DATABASE_SCHEMA = "SQL_DATABASE_SCHEMA";

    @Override
    public MessageTransferMode<Map<CString, CString>, Void> processUserIdentification(ChannelHandlerContext ctx, Map<CString, CString> parameters) throws IOException {
        TransferMode transferMode;
        boolean sameDatabaseNames;
        LOGGER.debug("User identification parameters: {}", parameters);
        Map<CString, CString> newParameters = parameters;
        List<Map<CString, CString>> allNewParameters = Collections.singletonList(newParameters);
        LinkedHashMap<Byte, CString> errorDetails = null;
        SQLSession session = this.getSession(ctx);
        CString databaseName = parameters.get(CString.valueOf((CharSequence)DATABASE_KEY));
        session.setDatabaseName(databaseName.toString());
        List<CString> databaseNames = Collections.singletonList(databaseName);
        List<Object> newDatabaseNames = databaseNames;
        List<String> backendDatabaseNames = this.getBackendDatabaseNames(ctx);
        boolean bl = sameDatabaseNames = backendDatabaseNames.stream().distinct().count() <= 1L;
        if (!sameDatabaseNames) {
            newDatabaseNames = backendDatabaseNames.stream().map(CString::valueOf).collect(Collectors.toList());
        }
        CString newDatabaseName = newDatabaseNames.get(0);
        CString userName = parameters.get(CString.valueOf((CharSequence)USER_KEY));
        CString newUserName = this.getProtocolService(ctx).newUserIdentification(userName);
        if (newUserName != null) {
            int numberOfBackends = this.getNumberOfBackends(ctx);
            if (!newUserName.equals((Object)userName) || !newDatabaseNames.equals(databaseNames)) {
                if (sameDatabaseNames) {
                    newParameters = new HashMap<CString, CString>(parameters);
                    newParameters.forEach((k, v) -> {
                        k.retain();
                        if (!(k.equals((Object)CString.valueOf((CharSequence)USER_KEY)) && !newUserName.equals((Object)userName) || k.equals((Object)CString.valueOf((CharSequence)DATABASE_KEY)) && !newDatabaseName.equals((Object)databaseName))) {
                            v.retain();
                        }
                    });
                    if (!newUserName.equals((Object)userName)) {
                        newParameters.put(CString.valueOf((CharSequence)USER_KEY), newUserName);
                    }
                    if (!newDatabaseName.equals((Object)databaseName)) {
                        newParameters.put(CString.valueOf((CharSequence)DATABASE_KEY), newDatabaseName);
                    }
                } else {
                    allNewParameters = new ArrayList<Map<CString, CString>>(numberOfBackends);
                    for (int i = 0; i < numberOfBackends; ++i) {
                        CString backendNewDatabaseName = (CString)newDatabaseNames.get(i);
                        newParameters = new HashMap<CString, CString>(parameters);
                        newParameters.forEach((k, v) -> {
                            k.retain();
                            if (!(k.equals((Object)CString.valueOf((CharSequence)USER_KEY)) && !newUserName.equals((Object)userName) || k.equals((Object)CString.valueOf((CharSequence)DATABASE_KEY)) && !backendNewDatabaseName.equals((Object)databaseName))) {
                                v.retain();
                            }
                        });
                        if (!newUserName.equals((Object)userName)) {
                            newParameters.put(CString.valueOf((CharSequence)USER_KEY), newUserName);
                        }
                        if (!backendNewDatabaseName.equals((Object)databaseName)) {
                            newParameters.put(CString.valueOf((CharSequence)DATABASE_KEY), backendNewDatabaseName);
                        }
                        allNewParameters.add(newParameters);
                    }
                }
            }
            transferMode = TransferMode.FORWARD;
            session.setUser(userName.toString());
            SQLSession.AuthenticationPhase authenticationPhase = new SQLSession.AuthenticationPhase(numberOfBackends);
            session.setAuthenticationPhase(authenticationPhase);
            session.setQueryInvolvedBackends(IntStream.range(0, numberOfBackends).boxed().collect(Collectors.toList()));
        } else {
            transferMode = TransferMode.ERROR;
            errorDetails = new LinkedHashMap<Byte, CString>();
            errorDetails.put((byte)83, CString.valueOf((CharSequence)"FATAL"));
            errorDetails.put((byte)67, CString.valueOf((CharSequence)"28000"));
            errorDetails.put((byte)77, CString.valueOf((CharSequence)"Access denied"));
        }
        MessageTransferMode<Map<CString, CString>, Object> mode = sameDatabaseNames ? new MessageTransferMode<Map<CString, CString>, Object>(transferMode, newParameters, null, errorDetails) : new MessageTransferMode<Map<CString, CString>, Object>(transferMode, allNewParameters, null, errorDetails);
        LOGGER.debug("User identification processed: transfer mode={}, new parameters={}, error={}", new Object[]{mode.getTransferMode(), mode.getNewContent(), mode.getErrorDetails()});
        return mode;
    }

    @Override
    public MessageTransferMode<AuthenticationResponse, Void> processAuthenticationResponse(ChannelHandlerContext ctx, AuthenticationResponse response) throws IOException {
        TransferMode transferMode;
        LOGGER.debug("Authentication response type: {}", (Object)response.getType());
        AuthenticationResponse newResponse = response;
        SQLSession session = this.getSession(ctx);
        int backend = this.getBackend(ctx);
        int preferredBackend = this.getPreferredBackend(ctx);
        if (backend != preferredBackend) {
            transferMode = TransferMode.FORGET;
            newResponse = null;
        } else {
            int newType;
            transferMode = TransferMode.FORWARD;
            int type = response.getType();
            int n = newType = 5 == type ? 3 : type;
            if (newType != type) {
                newResponse = new AuthenticationResponse(newType, null);
            }
        }
        SQLSession.AuthenticationPhase authenticationPhase = session.getAuthenticationPhase();
        boolean allResponsesReceived = authenticationPhase.setAndCountAuthenticationResponse(backend, response);
        if (allResponsesReceived) {
            if (0 == response.getType()) {
                session.setAuthenticationPhase(null);
            } else {
                authenticationPhase.allResponsesReceived();
            }
        }
        MessageTransferMode<AuthenticationResponse, Void> mode = new MessageTransferMode<AuthenticationResponse, Void>(transferMode, newResponse);
        LOGGER.debug("Authentication response processed: transfer mode={}, new type={}", (Object)mode.getTransferMode(), (Object)mode.getNewContent());
        return mode;
    }

    @Override
    public MessageTransferMode<CString, Void> processUserAuthentication(ChannelHandlerContext ctx, CString password) throws IOException {
        TransferMode transferMode;
        LOGGER.debug("User authentication pawword: {}", (Object)password);
        List<CString> newPasswords = Collections.singletonList(password);
        LinkedHashMap<Byte, CString> errorDetails = null;
        SQLSession session = this.getSession(ctx);
        String userName = session.getUser();
        CString[] userCredentials = this.getProtocolService(ctx).userAuthentication(CString.valueOf((CharSequence)userName), password);
        if (userCredentials != null) {
            transferMode = TransferMode.FORWARD;
            CString newPassword = userCredentials[1];
            SQLSession.AuthenticationPhase authenticationPhase = session.getAuthenticationPhase();
            authenticationPhase.waitForAllResponses();
            int nbBackends = authenticationPhase.getNbAuthenticationResponses();
            newPasswords = new ArrayList<CString>(nbBackends);
            for (int i = 0; i < nbBackends; ++i) {
                AuthenticationResponse authenticationResponse = authenticationPhase.getAuthenticationResponse(i);
                if (5 == authenticationResponse.getType()) {
                    MessageDigest digest;
                    ByteBuf parameters = authenticationResponse.getParameters();
                    byte[] salt = new byte[parameters.readableBytes()];
                    parameters.readBytes(salt);
                    try {
                        digest = MessageDigest.getInstance("MD5");
                    }
                    catch (NoSuchAlgorithmException e) {
                        throw new IOException(e);
                    }
                    digest.update((newPassword.toString() + userName).getBytes());
                    String pwdUsrEnc = DatatypeConverter.printHexBinary((byte[])digest.digest()).toLowerCase();
                    digest.update(pwdUsrEnc.getBytes());
                    digest.update(salt);
                    String passwordEncrypted = "md5" + DatatypeConverter.printHexBinary((byte[])digest.digest()).toLowerCase();
                    newPasswords.add(CString.valueOf((CharSequence)passwordEncrypted));
                } else {
                    newPasswords.add(newPassword);
                }
                authenticationPhase.setAuthenticationResponse(i, null);
            }
        } else {
            transferMode = TransferMode.ERROR;
            newPasswords = null;
            errorDetails = new LinkedHashMap<Byte, CString>();
            errorDetails.put((byte)83, CString.valueOf((CharSequence)"FATAL"));
            errorDetails.put((byte)67, CString.valueOf((CharSequence)"28P01"));
            errorDetails.put((byte)77, CString.valueOf((CharSequence)String.format("password authentication failed for user \"%s\"", userName)));
        }
        MessageTransferMode<CString, Object> mode = new MessageTransferMode<CString, Object>(transferMode, newPasswords, null, errorDetails);
        LOGGER.debug("User authentication processed: transfer mode={}, new password(s)=<XXX>, error={}", (Object)mode.getTransferMode(), mode.getErrorDetails());
        return mode;
    }

    @Override
    public QueriesTransferMode<SQLStatement, CommandResults> processStatement(ChannelHandlerContext ctx, SQLStatement sqlStatement) throws IOException {
        LOGGER.debug("SQL statement: {}", (Object)sqlStatement);
        TransferMode transferMode = TransferMode.FORWARD;
        Map<Integer, List<Query>> newQueries = Collections.singletonMap(0, Collections.singletonList(sqlStatement));
        CommandResults response = null;
        Map<Byte, CString> errorDetails = null;
        boolean toProcess = false;
        Operation operation = null;
        SQLSession session = this.getSession(ctx);
        session.setCurrentCommandOperation(operation);
        SQLCommandType type = SimpleSQLParserUtil.parse(sqlStatement.getSQL());
        if (type != null) {
            CString completeTag = null;
            CString error = null;
            block0 : switch (type) {
                case CLARUS_METADATA: 
                case CLARUS_PROTECTED: {
                    if (session.isProcessingQuery()) {
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)String.format("%s is not supported while processing one or several queries", type.getPattern()));
                        break;
                    }
                    toProcess = true;
                    operation = Operation.READ;
                    session.setCurrentCommandOperation(operation);
                    break;
                }
                case SET: 
                case FETCH_CURSOR: 
                case CLOSE_CURSOR: {
                    toProcess = this.isSQLStatementToProcess(null);
                    break;
                }
                case START_TRANSACTION: {
                    toProcess = this.isSQLStatementToProcess(null);
                    if (!(sqlStatement instanceof SimpleQuery) || session.getTransactionStatus() == 69) break;
                    session.setTransactionStatus((byte)84);
                    break;
                }
                case COMMIT: 
                case ROLLBACK: {
                    toProcess = this.isSQLStatementToProcess(null);
                    if (sqlStatement instanceof SimpleQuery && session.getTransactionStatus() != 69) {
                        session.setTransactionStatus((byte)73);
                    }
                    if (!session.isInDatasetCreation()) break;
                    session.setInDatasetCreation(false);
                    break;
                }
                case SELECT: 
                case DECLARE_CURSOR: {
                    operation = Operation.READ;
                    boolean retrieveWholeDataset = false;
                    Mode processingMode = this.getProcessingMode(ctx, retrieveWholeDataset, operation);
                    toProcess = this.isSQLStatementToProcess(processingMode);
                    if (!toProcess) break;
                    if (processingMode == null) {
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)String.format("%s read not supported by this CLARUS proxy", retrieveWholeDataset ? "Dataset" : "Record"));
                        break;
                    }
                    if (processingMode == Mode.ORCHESTRATION) {
                        session.setCurrentCommandOperation(operation);
                        break;
                    }
                    if (processingMode != Mode.AS_IT_IS && processingMode != Mode.BUFFERING && processingMode != Mode.STREAMING) break;
                    session.setCurrentCommandOperation(operation);
                    break;
                }
                case INSERT: {
                    operation = Operation.CREATE;
                    boolean inDatasetCreation = session.isInDatasetCreation();
                    Mode processingMode = this.getProcessingMode(ctx, inDatasetCreation, operation);
                    toProcess = this.isSQLStatementToProcess(processingMode);
                    if (!toProcess) break;
                    if (processingMode == null) {
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)String.format("%s creation not supported by this CLARUS proxy", inDatasetCreation ? "Dataset" : "Record"));
                        break;
                    }
                    if (processingMode == Mode.BUFFERING) {
                        if (inDatasetCreation) {
                            transferMode = TransferMode.FORGET;
                            if (!(sqlStatement instanceof SimpleQuery)) break;
                            completeTag = CString.valueOf((CharSequence)"INSERT 0 1");
                            break;
                        }
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)"Buffering processing mode not supported for record creation by this CLARUS proxy");
                        break;
                    }
                    if (processingMode == Mode.ORCHESTRATION) {
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)"Orchestration processing mode not supported for dataset or record creation by this CLARUS proxy");
                        break;
                    }
                    if (processingMode != Mode.AS_IT_IS && processingMode != Mode.STREAMING) break;
                    session.setCurrentCommandOperation(operation);
                    break;
                }
                case CREATE_TABLE: {
                    operation = Operation.CREATE;
                    Mode processingMode = this.getProcessingMode(ctx, true, operation);
                    toProcess = this.isSQLStatementToProcess(processingMode);
                    if (!toProcess) break;
                    if (processingMode == null) {
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)"Dataset creation not supported by this CLARUS proxy");
                        break;
                    }
                    if (processingMode == Mode.BUFFERING) {
                        if (session.getTransactionStatus() == 84) {
                            session.setInDatasetCreation(true);
                        }
                        transferMode = TransferMode.FORGET;
                        if (!(sqlStatement instanceof SimpleQuery)) break;
                        completeTag = CString.valueOf((CharSequence)"CREATE TABLE");
                        break;
                    }
                    if (processingMode == Mode.ORCHESTRATION) {
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)"Orchestration processing mode not supported for dataset creation by this CLARUS proxy");
                        break;
                    }
                    if (processingMode != Mode.AS_IT_IS && processingMode != Mode.STREAMING) break;
                    if (session.getTransactionStatus() == 84) {
                        session.setInDatasetCreation(true);
                    }
                    session.setCurrentCommandOperation(operation);
                    break;
                }
                case ADD_GEOMETRY_COLUMN: 
                case ALTER_TABLE: 
                case CREATE_INDEX: {
                    boolean inDatasetCreation = session.isInDatasetCreation();
                    operation = inDatasetCreation ? Operation.CREATE : Operation.UPDATE;
                    Mode processingMode = this.getProcessingMode(ctx, session.getTransactionStatus() == 84, operation);
                    toProcess = this.isSQLStatementToProcess(processingMode);
                    if (!toProcess) break;
                    if (processingMode == null) {
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)String.format("Dataset %s not supported by this CLARUS proxy", inDatasetCreation ? "creation" : "structure modification"));
                        break;
                    }
                    if (processingMode == Mode.BUFFERING) {
                        if (inDatasetCreation) {
                            transferMode = TransferMode.FORGET;
                            if (!(sqlStatement instanceof SimpleQuery)) break;
                            switch (type) {
                                case ADD_GEOMETRY_COLUMN: {
                                    completeTag = CString.valueOf((CharSequence)"SELECT 1");
                                    break block0;
                                }
                            }
                            completeTag = CString.valueOf((CharSequence)type.getPattern());
                            break;
                        }
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)"Buffering processing mode not supported for dataset structure modification by this CLARUS proxy");
                        break;
                    }
                    if (processingMode == Mode.ORCHESTRATION) {
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)"Orchestration processing mode not supported for dataset or record creation by this CLARUS proxy");
                        break;
                    }
                    if (processingMode != Mode.AS_IT_IS && processingMode != Mode.STREAMING) break;
                    session.setCurrentCommandOperation(operation);
                    break;
                }
                case DROP_TABLE: {
                    operation = Operation.DELETE;
                    Mode processingMode = this.getProcessingMode(ctx, true, operation);
                    toProcess = this.isSQLStatementToProcess(processingMode);
                    if (!toProcess) break;
                    if (processingMode == null) {
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)"Dataset delete not supported by this CLARUS proxy");
                        break;
                    }
                    if (processingMode == Mode.BUFFERING) {
                        transferMode = TransferMode.FORGET;
                        if (!(sqlStatement instanceof SimpleQuery)) break;
                        completeTag = CString.valueOf((CharSequence)"DROP TABLE");
                        break;
                    }
                    if (processingMode == Mode.ORCHESTRATION) {
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)"Orchestration processing mode not supported for dataset delete by this CLARUS proxy");
                        break;
                    }
                    if (processingMode != Mode.AS_IT_IS && processingMode != Mode.STREAMING) break;
                    session.setCurrentCommandOperation(operation);
                    break;
                }
                case UPDATE: {
                    operation = Operation.UPDATE;
                    boolean inDatasetModification = false;
                    Mode processingMode = this.getProcessingMode(ctx, inDatasetModification, operation);
                    toProcess = this.isSQLStatementToProcess(processingMode);
                    if (!toProcess) break;
                    if (processingMode == null) {
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)String.format("%s update not supported by this CLARUS proxy", inDatasetModification ? "Dataset" : "Record"));
                        break;
                    }
                    if (processingMode == Mode.BUFFERING) {
                        if (inDatasetModification) {
                            transferMode = TransferMode.FORGET;
                            if (!(sqlStatement instanceof SimpleQuery)) break;
                            completeTag = CString.valueOf((CharSequence)"UPDATE 0 1");
                            break;
                        }
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)"Buffering processing mode not supported for record modification by this CLARUS proxy");
                        break;
                    }
                    if (processingMode == Mode.ORCHESTRATION) {
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)"Orchestration processing mode not supported for dataset or record modification by this CLARUS proxy");
                        break;
                    }
                    if (processingMode != Mode.AS_IT_IS && processingMode != Mode.STREAMING) break;
                    session.setCurrentCommandOperation(operation);
                    break;
                }
                case DELETE: {
                    operation = Operation.DELETE;
                    boolean deleteWholeDataset = false;
                    Mode processingMode = this.getProcessingMode(ctx, deleteWholeDataset, operation);
                    toProcess = this.isSQLStatementToProcess(processingMode);
                    if (!toProcess) break;
                    if (processingMode == null) {
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)String.format("%s delete not supported by this CLARUS proxy", deleteWholeDataset ? "Dataset" : "Record"));
                        break;
                    }
                    if (processingMode == Mode.BUFFERING) {
                        if (deleteWholeDataset) {
                            transferMode = TransferMode.FORGET;
                            if (!(sqlStatement instanceof SimpleQuery)) break;
                            completeTag = CString.valueOf((CharSequence)"DELETE 0 1");
                            break;
                        }
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)"Buffering processing mode not supported for record delete by this CLARUS proxy");
                        break;
                    }
                    if (processingMode == Mode.ORCHESTRATION) {
                        transferMode = TransferMode.ERROR;
                        error = CString.valueOf((CharSequence)"Orchestration processing mode not supported for dataset or record delete by this CLARUS proxy");
                        break;
                    }
                    session.setCurrentCommandOperation(operation);
                    break;
                }
            }
            if (completeTag != null) {
                response = new CommandResults(completeTag);
            }
            if (error != null) {
                errorDetails = new LinkedHashMap<Byte, CString>();
                errorDetails.put((byte)83, CString.valueOf((CharSequence)"FATAL"));
                errorDetails.put((byte)77, error);
            }
        }
        if (transferMode == TransferMode.FORWARD) {
            if (sqlStatement instanceof SimpleQuery) {
                session.setCommandInvolvedBackends(Collections.singletonList(this.getPreferredBackend(ctx)), false);
                Result<List<Query>, CommandResults, CString> result = this.buildNewQueries(ctx, (SimpleSQLStatement)sqlStatement, operation, toProcess);
                if (result.isQuery()) {
                    newQueries = result.queriesAsMap();
                } else if (result.isResponse()) {
                    transferMode = TransferMode.FORGET;
                    newQueries = null;
                    response = result.response();
                } else if (result.isError()) {
                    transferMode = TransferMode.ERROR;
                    errorDetails = new LinkedHashMap();
                    errorDetails.put((byte)83, CString.valueOf((CharSequence)"FATAL"));
                    errorDetails.put((byte)77, result.error());
                    if (session.getTransactionStatus() == 84) {
                        session.setTransactionStatus((byte)69);
                        session.setTransactionErrorDetails(errorDetails);
                    }
                    session.resetCurrentCommand();
                    newQueries = null;
                }
            } else {
                session.addParseStep((ParseStep)sqlStatement, operation, type, toProcess, Collections.singletonList(this.getPreferredBackend(ctx)));
                transferMode = TransferMode.FORGET;
                newQueries = null;
                response = new CommandResults();
                response.setParseCompleteRequired(true);
            }
        } else if (transferMode == TransferMode.FORGET) {
            if (sqlStatement instanceof SimpleQuery) {
                session.setCommandInvolvedBackends(Collections.singletonList(this.getPreferredBackend(ctx)), false);
                errorDetails = this.bufferQuery(ctx, sqlStatement);
                if (errorDetails != null) {
                    transferMode = TransferMode.ERROR;
                    session.resetCurrentCommand();
                }
            } else {
                session.addParseStep((ParseStep)sqlStatement, operation, type, toProcess, Collections.singletonList(this.getPreferredBackend(ctx)));
                response = new CommandResults();
                response.setParseCompleteRequired(true);
            }
            newQueries = null;
        } else if (transferMode == TransferMode.ERROR) {
            if (session.getTransactionStatus() == 84) {
                session.setTransactionStatus((byte)69);
                session.setTransactionErrorDetails(errorDetails);
            }
            session.resetCurrentCommand();
            newQueries = null;
        }
        session.setTransferMode(transferMode);
        QueriesTransferMode<SQLStatement, CommandResults> mode = new QueriesTransferMode<SQLStatement, CommandResults>(transferMode, newQueries, response, errorDetails);
        LOGGER.debug("SQL statement processed: new queries={}, transfer mode={}", mode.getNewQueries(), (Object)mode.getTransferMode());
        return mode;
    }

    private boolean isSQLStatementToProcess(Mode processingMode) {
        return FORCE_SQL_PROCESSING || processingMode != Mode.AS_IT_IS;
    }

    private Result<List<Query>, CommandResults, CString> buildNewQueries(ChannelHandlerContext ctx, SimpleSQLStatement sqlStatement, Operation operation, boolean toProcess) throws IOException {
        List<List<Query>> bufferedQueries = this.processBufferedQueries(ctx);
        SQLSession session = this.getSession(ctx);
        List<SimpleSQLStatement> newSQLStatements = null;
        if (toProcess) {
            Result<SimpleSQLStatement, CommandResults, CString> result = this.processSimpleSQLStatement(ctx, sqlStatement, operation);
            if (result.isQuery()) {
                newSQLStatements = result.queries();
            } else {
                if (result.isResponse()) {
                    return Result.response(result.response());
                }
                if (result.isError()) {
                    return Result.error(result.error());
                }
            }
        } else {
            newSQLStatements = Collections.singletonList(sqlStatement);
        }
        List newQueries = null;
        if (bufferedQueries.isEmpty() || bufferedQueries.stream().allMatch(List::isEmpty)) {
            if (newSQLStatements != null) {
                newQueries = newSQLStatements.stream().map(ns -> ns != null ? Collections.singletonList(ns) : null).collect(Collectors.toList());
            }
        } else {
            List<Query> directedBufferedQueries;
            int i;
            int nbDirected = bufferedQueries.size() > newSQLStatements.size() ? bufferedQueries.size() : newSQLStatements.size();
            boolean allSimple = true;
            int newSize = 0;
            block0: for (i = 0; i < nbDirected; ++i) {
                directedBufferedQueries = i < bufferedQueries.size() ? bufferedQueries.get(i) : null;
                for (Query bufferedQuery : directedBufferedQueries) {
                    if (bufferedQuery instanceof SimpleQuery) {
                        newSize += ((SQLStatement)bufferedQuery).getSQL().length();
                        continue;
                    }
                    allSimple = false;
                    continue block0;
                }
            }
            newQueries = new ArrayList(nbDirected);
            for (i = 0; i < nbDirected; ++i) {
                List<Object> directedQueries;
                SimpleSQLStatement directedSQLStatement;
                directedBufferedQueries = i < bufferedQueries.size() ? bufferedQueries.get(i) : null;
                SimpleSQLStatement simpleSQLStatement = directedSQLStatement = i < newSQLStatements.size() ? newSQLStatements.get(i) : null;
                if (directedBufferedQueries == null || directedBufferedQueries.isEmpty()) {
                    directedQueries = directedSQLStatement != null ? Collections.singletonList(directedSQLStatement) : Collections.emptyList();
                } else if (allSimple) {
                    if (directedSQLStatement != null) {
                        newSize += directedSQLStatement.getSQL().length();
                    }
                    CString newSQL = CString.valueOf((CharSequence)new StringBuilder(newSize));
                    for (Query bufferedQuery : directedBufferedQueries) {
                        newSQL.append((CharSequence)((SQLStatement)bufferedQuery).getSQL());
                    }
                    if (directedSQLStatement != null) {
                        newSQL.append((CharSequence)directedSQLStatement.getSQL());
                    }
                    SimpleSQLStatement newDirectedSQLStatement = new SimpleSQLStatement(newSQL);
                    directedQueries = Collections.singletonList(newDirectedSQLStatement);
                } else {
                    directedQueries = new ArrayList<Query>(directedBufferedQueries);
                    if (directedSQLStatement != null) {
                        directedQueries.add(directedSQLStatement);
                    }
                }
                newQueries.add(directedQueries);
            }
            if (allSimple) {
                SQLSession.QueryResponseType nextQueryResponseToIgnore = session.firstQueryResponseToIgnore();
                while (nextQueryResponseToIgnore == SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR) {
                    session.removeFirstQueryResponseToIgnore();
                    nextQueryResponseToIgnore = session.firstQueryResponseToIgnore();
                }
            }
        }
        return Result.queries(newQueries);
    }

    private List<List<Query>> processBufferedQueries(ChannelHandlerContext ctx) throws IOException {
        SQLSession session = this.getSession(ctx);
        ArrayList<Statement> referencedStatements = new ArrayList<Statement>(session.getBufferedQueries().size());
        ArrayList<List<ParameterValue>> referencedParameterValues = new ArrayList<List<ParameterValue>>(session.getBufferedQueries().size());
        ArrayList<OutboundDataOperation> referencedOutboundDataOperations = new ArrayList<OutboundDataOperation>(session.getBufferedQueries().size());
        ArrayList<Integer> referencedRows = new ArrayList<Integer>(session.getBufferedQueries().size());
        HashMap<CString, Integer> lastParseStepIndexes = new HashMap<CString, Integer>();
        HashMap<CString, Integer> lastBindStepIndexes = new HashMap<CString, Integer>();
        Map parseStepCounters = session.getParseStepStatuses().keySet().stream().collect(Collectors.toMap(java.util.function.Function.identity(), i -> 1));
        Map bindStepCounters = session.getBindStepStatuses().keySet().stream().collect(Collectors.toMap(java.util.function.Function.identity(), i -> 1));
        OutboundDataOperation lastOutboundDataOperation = null;
        int queryIndex = 0;
        int row = 0;
        for (Query bufferedQuery : session.getBufferedQueries()) {
            int refIndex = -1;
            Statement refStmt = null;
            List<ParameterValue> refParamVals = null;
            Integer refRow = null;
            boolean extract = false;
            if (bufferedQuery instanceof SimpleQuery) {
                refStmt = this.parseSQL(ctx, ((SimpleSQLStatement)bufferedQuery).getSQL());
                if (refStmt instanceof Insert) {
                    refRow = row;
                    ItemsList values = ((Insert)refStmt).getItemsList();
                    row += values instanceof ExpressionList ? 1 : (values instanceof MultiExpressionList ? ((MultiExpressionList)values).getExprList().size() : 1);
                }
                extract = true;
            } else {
                Short format;
                ParameterValue parameterValue;
                int i2;
                List<Short> formats;
                List<Long> parameterTypes;
                SQLSession.ExtendedQueryStatus<ParseStep> parseStepStatus;
                SQLSession.ExtendedQueryStatus<BindStep> bindStepStatus;
                BindStep bindStep;
                ParseStep parseStep;
                SQLSession.ExtendedQueryStatus<ParseStep> parseStepStatus2;
                Object counter2;
                Integer counter3;
                ExtendedQuery query = (ExtendedQuery)bufferedQuery;
                if (query instanceof ParseStep) {
                    ParseStep parseStep2 = (ParseStep)query;
                    refStmt = this.parseSQL(ctx, parseStep2.getSQL());
                    if (refStmt instanceof Insert) {
                        refRow = row;
                    }
                    lastParseStepIndexes.put(parseStep2.getName(), queryIndex);
                    counter3 = parseStepCounters.get(parseStep2.getName());
                    parseStepCounters.put(parseStep2.getName(), counter3 + 1);
                } else if (query instanceof BindStep) {
                    BindStep bindStep2 = (BindStep)query;
                    ParseStep parseStep3 = null;
                    if (lastParseStepIndexes.containsKey(bindStep2.getPreparedStatement())) {
                        refIndex = (Integer)lastParseStepIndexes.get(bindStep2.getPreparedStatement());
                        parseStep3 = (ParseStep)session.getBufferedQueries().get(refIndex);
                        refStmt = (Statement)referencedStatements.get(refIndex);
                    } else {
                        SQLSession.ExtendedQueryStatus<ParseStep> parseStepStatus3 = session.getParseStepStatus(bindStep2.getPreparedStatement());
                        if (parseStepStatus3 != null) {
                            parseStep3 = parseStepStatus3.getQuery();
                            refStmt = this.parseSQL(ctx, parseStep3.getSQL());
                        }
                    }
                    if (parseStep3 != null) {
                        refParamVals = bindStep2.getParameterValues().stream().map(ParameterValue::new).collect(Collectors.toList());
                        List<Long> parameterTypes2 = parseStep3.getParameterTypes();
                        for (int idx = 0; idx < parameterTypes2.size(); ++idx) {
                            ((ParameterValue)refParamVals.get(idx)).setType(parameterTypes2.get(idx));
                        }
                        List<Short> formats2 = bindStep2.getParameterFormats();
                        for (int i3 = 0; i3 < refParamVals.size(); ++i3) {
                            ParameterValue parameterValue2 = (ParameterValue)refParamVals.get(i3);
                            Short format2 = formats2.get(formats2.size() == 1 ? 0 : i3);
                            parameterValue2.setFormat(format2);
                        }
                        if (refStmt instanceof Insert) {
                            refRow = row;
                            ItemsList values = ((Insert)refStmt).getItemsList();
                            row += values instanceof ExpressionList ? 1 : (values instanceof MultiExpressionList ? ((MultiExpressionList)values).getExprList().size() : 1);
                        }
                        extract = true;
                    }
                    lastBindStepIndexes.put(bindStep2.getName(), queryIndex);
                    counter2 = bindStepCounters.get(bindStep2.getName());
                    bindStepCounters.put(bindStep2.getName(), (Integer)counter2 + 1);
                } else if (query instanceof DescribeStep) {
                    DescribeStep describeStep = (DescribeStep)query;
                    if (describeStep.getCode() == 83) {
                        if (lastParseStepIndexes.containsKey(describeStep.getName())) {
                            refIndex = (Integer)lastParseStepIndexes.get(describeStep.getName());
                            lastOutboundDataOperation = (OutboundDataOperation)referencedOutboundDataOperations.get(refIndex);
                        } else {
                            parseStepStatus2 = session.getParseStepStatus(describeStep.getName());
                            if (parseStepStatus2 != null) {
                                parseStep = parseStepStatus2.getQuery();
                                refStmt = this.parseSQL(ctx, parseStep.getSQL());
                                extract = true;
                            }
                        }
                    } else {
                        bindStep = null;
                        if (lastBindStepIndexes.containsKey(describeStep.getName())) {
                            refIndex = (Integer)lastBindStepIndexes.get(describeStep.getName());
                            lastOutboundDataOperation = (OutboundDataOperation)referencedOutboundDataOperations.get(refIndex);
                        } else {
                            bindStepStatus = session.getBindStepStatus(describeStep.getName());
                            if (bindStepStatus != null && (parseStepStatus = session.getParseStepStatus((bindStep = bindStepStatus.getQuery()).getName())) != null) {
                                ParseStep parseStep4 = parseStepStatus.getQuery();
                                refStmt = this.parseSQL(ctx, parseStep4.getSQL());
                                refParamVals = bindStep.getParameterValues().stream().map(ParameterValue::new).collect(Collectors.toList());
                                parameterTypes = parseStep4.getParameterTypes();
                                for (int idx = 0; idx < parameterTypes.size(); ++idx) {
                                    refParamVals.get(idx).setType(parameterTypes.get(idx));
                                }
                                formats = bindStep.getParameterFormats();
                                for (i2 = 0; i2 < refParamVals.size(); ++i2) {
                                    parameterValue = refParamVals.get(i2);
                                    format = formats.get(formats.size() == 1 ? 0 : i2);
                                    parameterValue.setFormat(format);
                                }
                                extract = true;
                            }
                        }
                    }
                } else if (query instanceof ExecuteStep) {
                    ExecuteStep executeStep = (ExecuteStep)query;
                    bindStep = null;
                    if (lastBindStepIndexes.containsKey(executeStep.getPortal())) {
                        refIndex = (Integer)lastBindStepIndexes.get(executeStep.getPortal());
                        lastOutboundDataOperation = (OutboundDataOperation)referencedOutboundDataOperations.get(refIndex);
                    } else {
                        bindStepStatus = session.getBindStepStatus(executeStep.getPortal());
                        if (bindStepStatus != null && (parseStepStatus = session.getParseStepStatus((bindStep = bindStepStatus.getQuery()).getName())) != null) {
                            ParseStep parseStep5 = parseStepStatus.getQuery();
                            refStmt = this.parseSQL(ctx, parseStep5.getSQL());
                            refParamVals = bindStep.getParameterValues().stream().map(ParameterValue::new).collect(Collectors.toList());
                            parameterTypes = parseStep5.getParameterTypes();
                            for (int idx = 0; idx < parameterTypes.size(); ++idx) {
                                refParamVals.get(idx).setType(parameterTypes.get(idx));
                            }
                            formats = bindStep.getParameterFormats();
                            for (i2 = 0; i2 < refParamVals.size(); ++i2) {
                                parameterValue = refParamVals.get(i2);
                                format = formats.get(formats.size() == 1 ? 0 : i2);
                                parameterValue.setFormat(format);
                            }
                            extract = true;
                        }
                    }
                } else if (query instanceof CloseStep) {
                    CloseStep closeStep = (CloseStep)query;
                    if (closeStep.getCode() == 83) {
                        if (lastParseStepIndexes.containsKey(closeStep.getName())) {
                            refIndex = (Integer)lastParseStepIndexes.get(closeStep.getName());
                            lastOutboundDataOperation = (OutboundDataOperation)referencedOutboundDataOperations.get(refIndex);
                        } else {
                            parseStepStatus2 = session.getParseStepStatus(closeStep.getName());
                            if (parseStepStatus2 != null) {
                                parseStep = parseStepStatus2.getQuery();
                                refStmt = this.parseSQL(ctx, parseStep.getSQL());
                                extract = true;
                            }
                        }
                        counter3 = parseStepCounters.get(closeStep.getName());
                        parseStepCounters.put(closeStep.getName(), counter3 - 1);
                    } else {
                        bindStep = null;
                        if (lastBindStepIndexes.containsKey(closeStep.getName())) {
                            refIndex = (Integer)lastBindStepIndexes.get(closeStep.getName());
                            lastOutboundDataOperation = (OutboundDataOperation)referencedOutboundDataOperations.get(refIndex);
                        } else {
                            bindStepStatus = session.getBindStepStatus(closeStep.getName());
                            if (bindStepStatus != null && (parseStepStatus = session.getParseStepStatus((bindStep = bindStepStatus.getQuery()).getName())) != null) {
                                ParseStep parseStep6 = parseStepStatus.getQuery();
                                refStmt = this.parseSQL(ctx, parseStep6.getSQL());
                                refParamVals = bindStep.getParameterValues().stream().map(ParameterValue::new).collect(Collectors.toList());
                                parameterTypes = parseStep6.getParameterTypes();
                                for (int idx = 0; idx < parameterTypes.size(); ++idx) {
                                    refParamVals.get(idx).setType(parameterTypes.get(idx));
                                }
                                formats = bindStep.getParameterFormats();
                                for (i2 = 0; i2 < refParamVals.size(); ++i2) {
                                    parameterValue = refParamVals.get(i2);
                                    format = formats.get(formats.size() == 1 ? 0 : i2);
                                    parameterValue.setFormat(format);
                                }
                                extract = true;
                            }
                        }
                        counter2 = bindStepCounters.get(closeStep.getName());
                        bindStepCounters.put(closeStep.getName(), (Integer)counter2 - 1);
                    }
                } else if (query instanceof SynchronizeStep) {
                    if (queryIndex > 0) {
                        refIndex = queryIndex - 1;
                        lastOutboundDataOperation = (OutboundDataOperation)referencedOutboundDataOperations.get(refIndex);
                    }
                } else if (query instanceof FlushStep && queryIndex > 0) {
                    refIndex = queryIndex - 1;
                    lastOutboundDataOperation = (OutboundDataOperation)referencedOutboundDataOperations.get(refIndex);
                }
            }
            referencedStatements.add(refStmt);
            referencedParameterValues.add(refParamVals);
            referencedRows.add(refRow);
            if (extract) {
                OutboundDataOperation moduleOperation;
                block145: {
                    moduleOperation = null;
                    try {
                        OutboundDataOperation refOutboundDataOperation;
                        if (refStmt instanceof SetStatement) {
                            moduleOperation = this.extractSetOperation(ctx, (SetStatement)refStmt);
                        } else if (refStmt instanceof StartTransaction) {
                            moduleOperation = this.extractStartTransactionOperation(ctx, (StartTransaction)refStmt);
                        } else if (refStmt instanceof Commit) {
                            moduleOperation = this.extractCommitOperation(ctx, (Commit)refStmt);
                        } else if (refStmt instanceof CreateTable) {
                            moduleOperation = this.extractCreateTableOperation(ctx, (CreateTable)refStmt);
                        } else if (refStmt instanceof Alter) {
                            refOutboundDataOperation = null;
                            if (lastOutboundDataOperation != null && (lastOutboundDataOperation.getOperation() == Operation.CREATE || lastOutboundDataOperation.getOperation() == Operation.UPDATE) && lastOutboundDataOperation.isUsingHeadOperation()) {
                                refOutboundDataOperation = lastOutboundDataOperation;
                            }
                            moduleOperation = this.extractAlterTableOperation(ctx, (Alter)refStmt, refOutboundDataOperation, null);
                        } else if (refStmt instanceof CreateIndex) {
                            refOutboundDataOperation = null;
                            if (lastOutboundDataOperation != null && (lastOutboundDataOperation.getOperation() == Operation.CREATE || lastOutboundDataOperation.getOperation() == Operation.UPDATE) && lastOutboundDataOperation.isUsingHeadOperation()) {
                                refOutboundDataOperation = lastOutboundDataOperation;
                            }
                            moduleOperation = this.extractCreateIndexOperation(ctx, (CreateIndex)refStmt, refOutboundDataOperation, null);
                        } else if (refStmt instanceof Drop) {
                            moduleOperation = this.extractDropTableOperation(ctx, (Drop)refStmt);
                        } else if (refStmt instanceof Insert) {
                            refOutboundDataOperation = null;
                            if (lastOutboundDataOperation != null && lastOutboundDataOperation.getOperation() == Operation.CREATE && !lastOutboundDataOperation.isUsingHeadOperation()) {
                                refOutboundDataOperation = lastOutboundDataOperation;
                            }
                            moduleOperation = this.extractInsertOperation(ctx, (Insert)refStmt, refParamVals, refOutboundDataOperation);
                        } else if (refStmt instanceof Select) {
                            refOutboundDataOperation = null;
                            if (lastOutboundDataOperation != null && (lastOutboundDataOperation.getOperation() == Operation.CREATE || lastOutboundDataOperation.getOperation() == Operation.UPDATE) && lastOutboundDataOperation.isUsingHeadOperation()) {
                                refOutboundDataOperation = lastOutboundDataOperation;
                            }
                            moduleOperation = this.extractSelectOperation(ctx, (Select)refStmt, refParamVals, refOutboundDataOperation, null);
                        } else if (refStmt instanceof DeclareCursor) {
                            moduleOperation = this.extractDeclareCursorOperation(ctx, (DeclareCursor)refStmt, refParamVals);
                        } else if (refStmt instanceof CursorFetch) {
                            moduleOperation = this.extractCursorFetchOperation(ctx, (CursorFetch)refStmt);
                        } else if (refStmt instanceof CursorClose) {
                            moduleOperation = this.extractCursorCloseOperation(ctx, (CursorClose)refStmt);
                        }
                    }
                    catch (ParseException e) {
                        LOGGER.error("Parsing error for {} : ", (Object)refStmt);
                        if (!LOGGER.isTraceEnabled()) break block145;
                        LOGGER.trace("Parsing error details:", (Throwable)e);
                    }
                }
                if (moduleOperation instanceof OutboundDataOperation) {
                    lastOutboundDataOperation = moduleOperation;
                } else {
                    if (moduleOperation instanceof InboundDataOperation) {
                        throw new IOException("Inbound operation is unsupported in buffered queries");
                    }
                    if (moduleOperation instanceof MetadataOperation) {
                        throw new IOException("Metadata operation is unsupported in buffered queries");
                    }
                    if (moduleOperation != null) {
                        throw new IOException(String.format("unsupported module operation type (%s) in buffered queries", moduleOperation.getClass().getName()));
                    }
                }
            }
            referencedOutboundDataOperations.add(lastOutboundDataOperation);
            if (refIndex != -1) {
                referencedOutboundDataOperations.set(refIndex, lastOutboundDataOperation);
            }
            ++queryIndex;
        }
        bindStepCounters.forEach((name, counter) -> {
            if (counter <= 0) {
                session.removeBindStep((CString)name);
            }
        });
        parseStepCounters.forEach((name, counter) -> {
            if (counter <= 0) {
                session.removeParseStep((CString)name);
            }
        });
        boolean modifyRequests = false;
        HashMap<OutboundDataOperation, List<OutboundDataOperation>> dataOperation2newDataOperations = new HashMap<OutboundDataOperation, List<OutboundDataOperation>>();
        for (OutboundDataOperation outboundDataOperation2 : referencedOutboundDataOperations) {
            List<OutboundDataOperation> newOutboundDataOperations2;
            if (outboundDataOperation2 == null || (newOutboundDataOperations2 = (List)dataOperation2newDataOperations.get(outboundDataOperation2)) != null) continue;
            newOutboundDataOperations2 = this.newOutboundDataOperation(ctx, outboundDataOperation2);
            dataOperation2newDataOperations.put(outboundDataOperation2, newOutboundDataOperations2);
            modifyRequests |= newOutboundDataOperations2.stream().anyMatch(ModuleOperation::isModified);
        }
        ArrayList<List<Query>> newQueries = new ArrayList<List<Query>>();
        if (modifyRequests) {
            queryIndex = 0;
            boolean simpleQueries = false;
            for (Query bufferedQuery : session.getBufferedQueries()) {
                boolean modifyRequest;
                simpleQueries = bufferedQuery instanceof SimpleQuery;
                List newOutboundDataOperations3 = null;
                OutboundDataOperation outboundDataOperation3 = (OutboundDataOperation)referencedOutboundDataOperations.get(queryIndex);
                if (outboundDataOperation3 != null) {
                    newOutboundDataOperations3 = (List)dataOperation2newDataOperations.get(outboundDataOperation3);
                }
                boolean bl = modifyRequest = newOutboundDataOperations3 != null && (FORCE_SQL_PROCESSING || newOutboundDataOperations3.size() != 1 || ((OutboundDataOperation)newOutboundDataOperations3.get(0)).isModified());
                if (modifyRequest) {
                    Statement refStmt = (Statement)referencedStatements.get(queryIndex);
                    for (OutboundDataOperation newOutboundDataOperation : newOutboundDataOperations3) {
                        ArrayList<Query> newBackendQueries;
                        int involvedBackend;
                        Query newQuery = bufferedQuery;
                        if (refStmt != null) {
                            PgsqlStatement<SetStatement> newStatement;
                            PgsqlStatement<SetStatement> statement;
                            List refParamVals = (List)referencedParameterValues.get(queryIndex);
                            Integer refRow = (Integer)referencedRows.get(queryIndex);
                            Statement newStmt = refStmt;
                            if (refStmt instanceof SetStatement) {
                                statement = new PgsqlStatement<SetStatement>((SetStatement)refStmt, null, null, refParamVals, null, null);
                                newStatement = this.modifySetStatement(ctx, statement, newOutboundDataOperation, true);
                                newStmt = newStatement.getStatement();
                            } else if (refStmt instanceof StartTransaction) {
                                statement = new PgsqlStatement<StartTransaction>((StartTransaction)refStmt, null, null, refParamVals, null, null);
                                newStatement = this.modifyStartTransactionStatement(ctx, statement, newOutboundDataOperation, true);
                                newStmt = newStatement.getStatement();
                            } else if (refStmt instanceof Commit) {
                                statement = new PgsqlStatement<Commit>((Commit)refStmt, null, null, refParamVals, null, null);
                                newStatement = this.modifyCommitStatement(ctx, statement, newOutboundDataOperation, true);
                                newStmt = newStatement.getStatement();
                            } else if (refStmt instanceof CreateTable) {
                                statement = new PgsqlStatement<CreateTable>((CreateTable)refStmt, null, null, refParamVals, null, null);
                                newStatement = this.modifyCreateTableStatement(ctx, statement, newOutboundDataOperation, true);
                                newStmt = newStatement.getStatement();
                            } else if (refStmt instanceof Alter) {
                                statement = new PgsqlStatement<Alter>((Alter)refStmt, null, null, refParamVals, null, null);
                                newStatement = this.modifyAlterTableStatement(ctx, statement, newOutboundDataOperation, true);
                                newStmt = newStatement.getStatement();
                            } else if (refStmt instanceof CreateIndex) {
                                statement = new PgsqlStatement<CreateIndex>((CreateIndex)refStmt, null, null, refParamVals, null, null);
                                newStatement = this.modifyCreateIndexStatement(ctx, statement, newOutboundDataOperation, true);
                                newStmt = newStatement.getStatement();
                            } else if (refStmt instanceof Drop) {
                                statement = new PgsqlStatement<Drop>((Drop)refStmt, null, null, refParamVals, null, null);
                                newStatement = this.modifyDropTableStatement(ctx, statement, newOutboundDataOperation, true);
                                newStmt = newStatement.getStatement();
                            } else if (refStmt instanceof Insert) {
                                statement = new PgsqlStatement<Insert>((Insert)refStmt, null, null, refParamVals, null, null);
                                newStatement = this.modifyInsertStatement(ctx, statement, newOutboundDataOperation, true, refRow);
                                newStmt = newStatement.getStatement();
                            } else if (refStmt instanceof Select) {
                                statement = new PgsqlStatement<Select>((Select)refStmt, null, null, refParamVals, null, null);
                                newStatement = this.modifySelectStatement(ctx, statement, newOutboundDataOperation, true, null);
                                newStmt = newStatement.getStatement();
                            } else if (refStmt instanceof DeclareCursor) {
                                statement = new PgsqlStatement<DeclareCursor>((DeclareCursor)refStmt, null, null, refParamVals, null, null);
                                newStatement = this.modifyDeclareCursorStatement(ctx, statement, newOutboundDataOperation, true, null);
                                newStmt = newStatement.getStatement();
                            } else if (refStmt instanceof CursorFetch) {
                                statement = new PgsqlStatement<CursorFetch>((CursorFetch)refStmt, null, null, refParamVals, null, null);
                                newStatement = this.modifyCursorFetchStatement(ctx, statement, newOutboundDataOperation, true);
                                newStmt = newStatement.getStatement();
                            } else if (refStmt instanceof CursorClose) {
                                statement = new PgsqlStatement<CursorClose>((CursorClose)refStmt, null, null, refParamVals, null, null);
                                newStatement = this.modifyCursorCloseStatement(ctx, statement, newOutboundDataOperation, true);
                                newStmt = newStatement.getStatement();
                            }
                            if (bufferedQuery instanceof SimpleQuery) {
                                SimpleSQLStatement simpleSQLStatement = (SimpleSQLStatement)bufferedQuery;
                                String newSQL = newStmt.toString();
                                newSQL = StringUtilities.addIrrelevantCharacters((String)newSQL, (CharSequence)simpleSQLStatement.getSQL(), (String)" \t\r\n;");
                                newQuery = new SimpleSQLStatement(CString.valueOf((CharSequence)newSQL));
                            } else {
                                ExtendedQuery query = (ExtendedQuery)bufferedQuery;
                                if (query instanceof ParseStep) {
                                    ParseStep parseStep = (ParseStep)query;
                                    String newSQL = newStmt.toString();
                                    newSQL = StringUtilities.addIrrelevantCharacters((String)newSQL, (CharSequence)parseStep.getSQL(), (String)" \t\r\n;");
                                    newQuery = new ParseStep(parseStep.getName(), CString.valueOf((CharSequence)newSQL), parseStep.isMetadata(), parseStep.getColumns(), parseStep.getParameterTypes());
                                } else if (query instanceof BindStep) {
                                    BindStep bindStep = (BindStep)query;
                                    List<ByteBuf> parameterBinaryValues = refParamVals.stream().map(ParameterValue::getValue).collect(Collectors.toList());
                                    if (!parameterBinaryValues.equals(bindStep.getParameterValues())) {
                                        newQuery = new BindStep(bindStep.getName(), bindStep.getPreparedStatement(), bindStep.getParameterFormats(), parameterBinaryValues, bindStep.getResultColumnFormats());
                                    }
                                }
                            }
                        }
                        if ((involvedBackend = newOutboundDataOperation.getInvolvedCSP()) == -1) {
                            involvedBackend = this.getPreferredBackend(ctx);
                        }
                        if (newQueries.size() <= involvedBackend) {
                            for (int i4 = newQueries.size(); i4 <= involvedBackend; ++i4) {
                                newQueries.add(null);
                            }
                        }
                        if ((newBackendQueries = (ArrayList<Query>)newQueries.get(involvedBackend)) == null) {
                            newBackendQueries = new ArrayList<Query>();
                            newQueries.set(involvedBackend, newBackendQueries);
                        }
                        newQuery.retain();
                        newBackendQueries.add(newQuery);
                    }
                } else {
                    ArrayList<Query> newBackendQueries;
                    int involvedBackend;
                    int n = involvedBackend = newOutboundDataOperations3 != null && newOutboundDataOperations3.size() == 1 ? ((OutboundDataOperation)newOutboundDataOperations3.get(0)).getInvolvedCSP() : -1;
                    if (involvedBackend == -1) {
                        involvedBackend = this.getPreferredBackend(ctx);
                    }
                    if (newQueries.size() <= involvedBackend) {
                        for (int i5 = newQueries.size(); i5 <= involvedBackend; ++i5) {
                            newQueries.add(null);
                        }
                    }
                    if ((newBackendQueries = (ArrayList<Query>)newQueries.get(involvedBackend)) == null) {
                        newBackendQueries = new ArrayList<Query>();
                        newQueries.set(involvedBackend, newBackendQueries);
                    }
                    bufferedQuery.retain();
                    newBackendQueries.add(bufferedQuery);
                }
                ++queryIndex;
            }
            List newOutboundDataOperationsWithExtraData = referencedOutboundDataOperations.stream().distinct().map(outboundDataOperation -> (List)dataOperation2newDataOperations.get(outboundDataOperation)).filter(newOutboundDataOperations -> newOutboundDataOperations.stream().anyMatch(newOutboundDataOperation -> newOutboundDataOperation.getExtraDataIds() != null && !newOutboundDataOperation.getExtraDataIds().isEmpty())).collect(Collectors.toList());
            for (List newOutboundDataOperations4 : newOutboundDataOperationsWithExtraData) {
                int nbNewCommands = 0;
                for (OutboundDataOperation newOutboundDataOperation : newOutboundDataOperations4) {
                    List<String> extraDataValues;
                    Query newQuery;
                    String newSQL;
                    CreateTable newCreateStatement;
                    List<String> extraTypeIds;
                    List<String> extraDataIds;
                    ArrayList<SimpleSQLStatement> newBackendQueries;
                    int involvedBackend = newOutboundDataOperation.getInvolvedCSP();
                    if (involvedBackend == -1) {
                        involvedBackend = this.getPreferredBackend(ctx);
                    }
                    if (newQueries.size() <= involvedBackend) {
                        for (int i6 = newQueries.size(); i6 <= involvedBackend; ++i6) {
                            newQueries.add(null);
                        }
                    }
                    if ((newBackendQueries = (ArrayList<SimpleSQLStatement>)newQueries.get(involvedBackend)) == null) {
                        newBackendQueries = new ArrayList<SimpleSQLStatement>();
                        newQueries.set(involvedBackend, newBackendQueries);
                    }
                    if (simpleQueries) {
                        extraDataIds = newOutboundDataOperation.getExtraDataIds().stream().map(CString::toString).collect(Collectors.toList());
                        extraTypeIds = Stream.generate(() -> "BYTEA").limit(extraDataIds.size()).collect(Collectors.toList());
                        newCreateStatement = this.buildCreateTableStatement(ctx, extraDataIds, extraTypeIds, true);
                        newSQL = newCreateStatement.toString() + ";";
                        newQuery = new SimpleSQLStatement(CString.valueOf((CharSequence)newSQL));
                        newBackendQueries.add((SimpleSQLStatement)newQuery);
                        ++nbNewCommands;
                        extraDataValues = newOutboundDataOperation.getExtraDataContents().stream().map(this::readBinaryAsHexString).collect(Collectors.toList());
                        Insert newInsertStatement = this.buildInsertStatement(ctx, extraDataIds, extraDataValues);
                        newSQL = newInsertStatement.toString() + ";";
                        newQuery = new SimpleSQLStatement(CString.valueOf((CharSequence)newSQL));
                        newBackendQueries.add((SimpleSQLStatement)newQuery);
                        ++nbNewCommands;
                        continue;
                    }
                    extraDataIds = newOutboundDataOperation.getExtraDataIds().stream().map(CString::toString).collect(Collectors.toList());
                    extraTypeIds = Stream.generate(() -> "BYTEA").limit(extraDataIds.size()).collect(Collectors.toList());
                    newCreateStatement = this.buildCreateTableStatement(ctx, extraDataIds, extraTypeIds, true);
                    newSQL = newCreateStatement.toString() + ";";
                    newQuery = new ParseStep(CString.valueOf((CharSequence)""), CString.valueOf((CharSequence)newSQL), false, null, Collections.emptyList());
                    newBackendQueries.add((SimpleSQLStatement)newQuery);
                    newQuery = new BindStep(CString.valueOf((CharSequence)""), CString.valueOf((CharSequence)""), Collections.emptyList(), Collections.emptyList(), Collections.emptyList());
                    newBackendQueries.add((SimpleSQLStatement)newQuery);
                    newQuery = new DescribeStep(80, CString.valueOf((CharSequence)""));
                    newBackendQueries.add((SimpleSQLStatement)newQuery);
                    newQuery = new ExecuteStep(CString.valueOf((CharSequence)""), 0);
                    newBackendQueries.add((SimpleSQLStatement)newQuery);
                    newQuery = new SynchronizeStep();
                    newBackendQueries.add((SimpleSQLStatement)newQuery);
                    ++nbNewCommands;
                    extraDataValues = IntStream.range(0, newOutboundDataOperation.getExtraDataContents().size()).mapToObj(i -> "$" + (i + 1)).collect(Collectors.toList());
                    List<ByteBuf> extraParameterValues = newOutboundDataOperation.getExtraDataContents().stream().map(in -> this.readBinary(ctx, (InputStream)in)).collect(Collectors.toList());
                    Insert newInsertStatement = this.buildInsertStatement(ctx, extraDataIds, extraDataValues);
                    newSQL = newInsertStatement.toString() + ";";
                    newQuery = new ParseStep(CString.valueOf((CharSequence)""), CString.valueOf((CharSequence)newSQL), false, null, Collections.emptyList());
                    newBackendQueries.add((SimpleSQLStatement)newQuery);
                    newQuery = new BindStep(CString.valueOf((CharSequence)""), CString.valueOf((CharSequence)""), Collections.singletonList((short)1), extraParameterValues, Collections.emptyList());
                    newBackendQueries.add((SimpleSQLStatement)newQuery);
                    newQuery = new DescribeStep(80, CString.valueOf((CharSequence)""));
                    newBackendQueries.add((SimpleSQLStatement)newQuery);
                    newQuery = new ExecuteStep(CString.valueOf((CharSequence)""), 0);
                    newBackendQueries.add((SimpleSQLStatement)newQuery);
                    newQuery = new SynchronizeStep();
                    newBackendQueries.add((SimpleSQLStatement)newQuery);
                    ++nbNewCommands;
                }
                for (int i7 = 0; i7 < nbNewCommands; ++i7) {
                    if (simpleQueries) {
                        session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR);
                        session.setCommandInvolvedBackends(newOutboundDataOperations4.stream().map(ModuleOperation::getInvolvedCSP).collect(Collectors.toList()), false);
                        continue;
                    }
                    session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARSE_COMPLETE);
                    session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.BIND_COMPLETE);
                    session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.ROW_DESCRIPTION_AND_DATA_ROW_OR_NO_DATA);
                    session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR);
                    session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.READY_FOR_QUERY);
                }
            }
        } else if (!session.getBufferedQueries().isEmpty()) {
            int involvedBackend = this.getPreferredBackend(ctx);
            if (newQueries.size() <= involvedBackend) {
                for (int i8 = newQueries.size(); i8 <= involvedBackend; ++i8) {
                    newQueries.add(null);
                }
            }
            session.getBufferedQueries().forEach(q -> q.retain());
            newQueries.set(involvedBackend, session.getBufferedQueries());
        }
        session.resetBufferedQueries();
        return newQueries;
    }

    private ByteBuf readBinary(ChannelHandlerContext ctx, InputStream in) {
        ByteBuf buffer;
        try {
            buffer = ctx.alloc().buffer(in.available());
            in.mark(Integer.MAX_VALUE);
            buffer.writeBytes(in, in.available());
        }
        catch (IOException e) {
            buffer = null;
        }
        return buffer;
    }

    private String readBinaryAsHexString(InputStream in) {
        String res;
        try {
            StringBuilder sb = new StringBuilder(in.available());
            sb.append("E'\\\\x");
            in.mark(Integer.MAX_VALUE);
            int b = in.read();
            while (b != -1) {
                sb.append(String.format("%02X", b));
                b = in.read();
            }
            in.reset();
            sb.append("'");
            res = sb.toString();
        }
        catch (IOException e) {
            res = null;
        }
        return res;
    }

    private Result<SimpleSQLStatement, CommandResults, CString> processSimpleSQLStatement(ChannelHandlerContext ctx, SimpleSQLStatement sqlStatement, Operation operation) {
        Statement stmt = this.parseSQL(ctx, sqlStatement.getSQL());
        LOGGER.debug("statement type: {}", stmt != null ? stmt.getClass().getSimpleName() : null);
        if (stmt == null) {
            return Result.query(sqlStatement);
        }
        OutboundDataOperation moduleOperation = null;
        try {
            if (stmt instanceof SetStatement) {
                moduleOperation = this.extractSetOperation(ctx, (SetStatement)stmt);
            } else if (stmt instanceof StartTransaction) {
                moduleOperation = this.extractStartTransactionOperation(ctx, (StartTransaction)stmt);
            } else if (stmt instanceof Commit) {
                moduleOperation = this.extractCommitOperation(ctx, (Commit)stmt);
            } else if (stmt instanceof CreateTable) {
                moduleOperation = this.extractCreateTableOperation(ctx, (CreateTable)stmt);
            } else if (stmt instanceof Alter) {
                moduleOperation = this.extractAlterTableOperation(ctx, (Alter)stmt, null, operation);
            } else if (stmt instanceof CreateIndex) {
                moduleOperation = this.extractCreateIndexOperation(ctx, (CreateIndex)stmt, null, operation);
            } else if (stmt instanceof Drop) {
                moduleOperation = this.extractDropTableOperation(ctx, (Drop)stmt);
            } else if (stmt instanceof Insert) {
                moduleOperation = this.extractInsertOperation(ctx, (Insert)stmt, null, null);
            } else if (!(stmt instanceof Update) && !(stmt instanceof Delete)) {
                if (stmt instanceof Select) {
                    moduleOperation = this.extractSelectOperation(ctx, (Select)stmt, null, null, operation);
                } else if (stmt instanceof DeclareCursor) {
                    moduleOperation = this.extractDeclareCursorOperation(ctx, (DeclareCursor)stmt, null);
                } else if (stmt instanceof CursorFetch) {
                    moduleOperation = this.extractCursorFetchOperation(ctx, (CursorFetch)stmt);
                } else if (stmt instanceof CursorClose) {
                    moduleOperation = this.extractCursorCloseOperation(ctx, (CursorClose)stmt);
                }
            }
        }
        catch (ParseException e2) {
            return Result.error(CString.valueOf((CharSequence)e2.getMessage()));
        }
        SQLSession session = this.getSession(ctx);
        Result<SimpleSQLStatement, CommandResults, Object> result = null;
        if (moduleOperation instanceof MetadataOperation) {
            MetadataOperation metadataOperation = (MetadataOperation)moduleOperation;
            List<Integer> involvedBackends = metadataOperation.getInvolvedCSPs();
            if (involvedBackends == null) {
                involvedBackends = Collections.emptyList();
            }
            session.setCommandInvolvedBackends(involvedBackends);
            metadataOperation = this.newMetaDataOperation(ctx, metadataOperation);
            CommandResults commandResults = new CommandResults();
            List<PgsqlRowDescriptionMessage.Field> description = Stream.of("column_name", "protected_column_name").map(CString::valueOf).map(PgsqlRowDescriptionMessage.Field::new).collect(Collectors.toList());
            commandResults.setRowDescription(description);
            if (metadataOperation.isModified()) {
                boolean multipleDatasets;
                List metadata = metadataOperation.getMetadata();
                Set prefixes = metadata.stream().map(Map.Entry::getKey).map(id -> id.substring(0, id.lastIndexOf(47))).collect(Collectors.toSet());
                boolean bl = multipleDatasets = prefixes.size() > 1 || ((CString)prefixes.stream().findFirst().get()).equals((Object)"*");
                if (!multipleDatasets) {
                    metadata = metadata.stream().map(e -> new AbstractMap.SimpleEntry(((CString)e.getKey()).substring(((CString)e.getKey()).lastIndexOf(47) + 1), e.getValue())).collect(Collectors.toList());
                }
                List<List<ByteBuf>> rows = this.buildRows(metadata, involvedBackends, -1);
                commandResults.setRows(rows);
                commandResults.setCompleteTag(CString.valueOf((CharSequence)("SELECT " + rows.size())));
            } else {
                commandResults.setCompleteTag(CString.valueOf((CharSequence)"SELECT 0"));
            }
            result = Result.response(commandResults);
            session.resetCurrentCommand();
        } else if (moduleOperation instanceof OutboundDataOperation) {
            OutboundDataOperation outboundDataOperation = moduleOperation;
            List<OutboundDataOperation> newOutboundDataOperations = this.newOutboundDataOperation(ctx, outboundDataOperation);
            if (stmt instanceof SetStatement || stmt instanceof StartTransaction || stmt instanceof Commit || stmt instanceof CreateTable || stmt instanceof Alter || stmt instanceof CreateIndex || stmt instanceof Drop || stmt instanceof Insert || stmt instanceof Select || stmt instanceof DeclareCursor || stmt instanceof CursorFetch || stmt instanceof CursorClose) {
                if (newOutboundDataOperations.isEmpty()) {
                    CommandResults commandResults = new CommandResults();
                    if (stmt instanceof SetStatement) {
                        commandResults.setCompleteTag(CString.valueOf((CharSequence)"SET"));
                    } else if (stmt instanceof StartTransaction) {
                        commandResults.setCompleteTag(CString.valueOf((CharSequence)"BEGIN"));
                    } else if (stmt instanceof Commit) {
                        commandResults.setCompleteTag(CString.valueOf((CharSequence)"COMMIT"));
                    } else if (stmt instanceof CreateTable) {
                        commandResults.setCompleteTag(CString.valueOf((CharSequence)"CREATE TABLE"));
                    } else if (stmt instanceof Alter) {
                        commandResults.setCompleteTag(CString.valueOf((CharSequence)"ALTER TABLE"));
                    } else if (stmt instanceof CreateIndex) {
                        commandResults.setCompleteTag(CString.valueOf((CharSequence)"CREATE INDEX"));
                    } else if (stmt instanceof Drop) {
                        commandResults.setCompleteTag(CString.valueOf((CharSequence)"DROP TABLE"));
                    } else if (stmt instanceof Insert) {
                        commandResults.setCompleteTag(CString.valueOf((CharSequence)"INSERT 0 1"));
                    } else if (stmt instanceof Update) {
                        commandResults.setCompleteTag(CString.valueOf((CharSequence)"UPDATE 0 1"));
                    } else if (stmt instanceof Delete) {
                        commandResults.setCompleteTag(CString.valueOf((CharSequence)"DELETE 0 1"));
                    } else if (stmt instanceof Select) {
                        commandResults.setCompleteTag(CString.valueOf((CharSequence)"SELECT 0"));
                    } else if (stmt instanceof DeclareCursor) {
                        commandResults.setCompleteTag(CString.valueOf((CharSequence)"DECLARE CURSOR"));
                    } else if (stmt instanceof CursorFetch) {
                        commandResults.setCompleteTag(CString.valueOf((CharSequence)"FETCH 0"));
                    } else if (stmt instanceof CursorClose) {
                        commandResults.setCompleteTag(CString.valueOf((CharSequence)"CLOSE CURSOR"));
                    }
                    result = Result.response(commandResults);
                    session.setCommandInvolvedBackends(Collections.emptyList());
                    session.resetCurrentCommand();
                } else {
                    List<Object> involvedBackends;
                    boolean requestModified;
                    ArrayList<SQLSession.ExpectedField> expectedFields = null;
                    boolean bl = requestModified = newOutboundDataOperations.size() > 1 || newOutboundDataOperations.get(0).isModified();
                    if (FORCE_SQL_PROCESSING || requestModified) {
                        ArrayList<SimpleSQLStatement> sqlStatements = new ArrayList<SimpleSQLStatement>(newOutboundDataOperations.size());
                        involvedBackends = new ArrayList(newOutboundDataOperations.size());
                        if (session.getCurrentCommandOperation() == Operation.READ) {
                            expectedFields = new ArrayList();
                        }
                        for (OutboundDataOperation newOutboundDataOperation : newOutboundDataOperations) {
                            String newSQL;
                            if (stmt instanceof SetStatement) {
                                PgsqlStatement<SetStatement> statement = new PgsqlStatement<SetStatement>((SetStatement)stmt);
                                PgsqlStatement<SetStatement> newStatement = this.modifySetStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                SetStatement newSetStatement = newStatement.getStatement();
                                newSQL = newSetStatement.toString();
                            } else if (stmt instanceof StartTransaction) {
                                PgsqlStatement<StartTransaction> statement = new PgsqlStatement<StartTransaction>((StartTransaction)stmt);
                                PgsqlStatement<StartTransaction> newStatement = this.modifyStartTransactionStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                StartTransaction newStartTransaction = newStatement.getStatement();
                                newSQL = newStartTransaction.toString();
                            } else if (stmt instanceof Commit) {
                                PgsqlStatement<Commit> statement = new PgsqlStatement<Commit>((Commit)stmt);
                                PgsqlStatement<Commit> newStatement = this.modifyCommitStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                Commit newCommit = newStatement.getStatement();
                                newSQL = newCommit.toString();
                            } else if (stmt instanceof CreateTable) {
                                PgsqlStatement<CreateTable> statement = new PgsqlStatement<CreateTable>((CreateTable)stmt);
                                PgsqlStatement<CreateTable> newStatement = this.modifyCreateTableStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                CreateTable newCreateTable = newStatement.getStatement();
                                newSQL = newCreateTable.toString();
                            } else if (stmt instanceof Alter) {
                                PgsqlStatement<Alter> statement = new PgsqlStatement<Alter>((Alter)stmt);
                                PgsqlStatement<Alter> newStatement = this.modifyAlterTableStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                Alter newAlter = newStatement.getStatement();
                                newSQL = newAlter.toString();
                            } else if (stmt instanceof CreateIndex) {
                                PgsqlStatement<CreateIndex> statement = new PgsqlStatement<CreateIndex>((CreateIndex)stmt);
                                PgsqlStatement<CreateIndex> newStatement = this.modifyCreateIndexStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                CreateIndex newCreateIndex = newStatement.getStatement();
                                newSQL = newCreateIndex.toString();
                            } else if (stmt instanceof Drop) {
                                PgsqlStatement<Drop> statement = new PgsqlStatement<Drop>((Drop)stmt);
                                PgsqlStatement<Drop> newStatement = this.modifyDropTableStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                Drop newDropTable = newStatement.getStatement();
                                newSQL = newDropTable.toString();
                            } else if (stmt instanceof Insert) {
                                PgsqlStatement<Insert> statement = new PgsqlStatement<Insert>((Insert)stmt);
                                PgsqlStatement<Insert> newStatement = this.modifyInsertStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1, 0);
                                Insert newInsert = newStatement.getStatement();
                                newSQL = newInsert.toString();
                            } else if (stmt instanceof Select) {
                                PgsqlStatement<Select> statement = new PgsqlStatement<Select>((Select)stmt);
                                PgsqlStatement<Select> newStatement = this.modifySelectStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1, expectedFields);
                                Select newSelect = newStatement.getStatement();
                                newSQL = newSelect.toString();
                            } else if (stmt instanceof DeclareCursor) {
                                PgsqlStatement<DeclareCursor> statement = new PgsqlStatement<DeclareCursor>((DeclareCursor)stmt);
                                PgsqlStatement<DeclareCursor> newStatement = this.modifyDeclareCursorStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1, expectedFields);
                                DeclareCursor newDeclareCursor = newStatement.getStatement();
                                newSQL = newDeclareCursor.toString();
                            } else if (stmt instanceof CursorFetch) {
                                PgsqlStatement<CursorFetch> statement = new PgsqlStatement<CursorFetch>((CursorFetch)stmt);
                                PgsqlStatement<CursorFetch> newStatement = this.modifyCursorFetchStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                CursorFetch newCursorFetch = newStatement.getStatement();
                                newSQL = newCursorFetch.toString();
                            } else if (stmt instanceof CursorClose) {
                                PgsqlStatement<CursorClose> statement = new PgsqlStatement<CursorClose>((CursorClose)stmt);
                                PgsqlStatement<CursorClose> newStatement = this.modifyCursorCloseStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                CursorClose newCursorClose = newStatement.getStatement();
                                newSQL = newCursorClose.toString();
                            } else {
                                newSQL = stmt.toString();
                            }
                            newSQL = StringUtilities.addIrrelevantCharacters((String)newSQL, (CharSequence)sqlStatement.getSQL(), (String)" \t\r\n;");
                            sqlStatement = new SimpleSQLStatement(CString.valueOf((CharSequence)newSQL));
                            int involvedBackend = newOutboundDataOperation.getInvolvedCSP();
                            if (involvedBackend == -1) {
                                involvedBackend = this.getPreferredBackend(ctx);
                            }
                            involvedBackends.add(involvedBackend);
                            if (sqlStatements.size() <= involvedBackend) {
                                for (int i = sqlStatements.size(); i <= involvedBackend; ++i) {
                                    sqlStatements.add(null);
                                }
                            }
                            sqlStatements.set(involvedBackend, sqlStatement);
                        }
                        result = Result.queries(sqlStatements);
                    } else {
                        involvedBackends = newOutboundDataOperations.get(0).getInvolvedCSPs();
                        if (involvedBackends == null) {
                            involvedBackends = Collections.singletonList(this.getPreferredBackend(ctx));
                        }
                        result = Result.query(sqlStatement);
                        if (session.getCurrentCommandOperation() == Operation.READ) {
                            List selectItemIds = (List)outboundDataOperation.getAttribute("selectItemIds");
                            expectedFields = selectItemIds.stream().map(e -> {
                                SelectItem item = (SelectItem)e.getKey();
                                String fqOutputName = this.toOutputName(item.toString());
                                List attributeNames = (List)e.getValue();
                                List<Map.Entry<String, Integer>> attributeMapping = IntStream.range(0, attributeNames.size()).mapToObj(i -> new AbstractMap.SimpleEntry(attributeNames.get(i), i)).collect(Collectors.toList());
                                Map<Integer, List<SQLSession.ExpectedProtectedField>> protectedFields = Stream.of(new SQLSession.ExpectedProtectedField(0, fqOutputName, attributeNames, attributeMapping)).collect(Collectors.groupingBy(SQLSession.ExpectedProtectedField::getBackend));
                                return new SQLSession.ExpectedField(fqOutputName, attributeNames, protectedFields);
                            }).collect(Collectors.toList());
                        }
                    }
                    session.setCommandInvolvedBackends(involvedBackends);
                    if (session.getCurrentCommandOperation() == Operation.READ) {
                        session.setResultProcessingEnabled(requestModified || !outboundDataOperation.isUnprotectingDataEnabled());
                        session.setPromise(newOutboundDataOperations.get(0).getPromise());
                        session.setUnprotectingDataEnabled(outboundDataOperation.isUnprotectingDataEnabled());
                        session.setExpectedFields(expectedFields);
                        if (stmt instanceof DeclareCursor) {
                            session.saveCursorContext(((DeclareCursor)stmt).getName());
                        }
                    } else if (stmt instanceof CursorFetch) {
                        session.restoreCursorContext(((CursorFetch)stmt).getName());
                    } else if (stmt instanceof CursorClose) {
                        session.removeCursorContext(((CursorClose)stmt).getName());
                    }
                }
            } else {
                result = stmt instanceof Update ? Result.query(sqlStatement) : (stmt instanceof Delete ? Result.query(sqlStatement) : Result.query(sqlStatement));
            }
        } else {
            result = Result.query(sqlStatement);
        }
        return result;
    }

    private MetadataOperation newMetaDataOperation(ChannelHandlerContext ctx, MetadataOperation metadataOperation) {
        MetadataOperation newMetaDataOperation = this.getProtocolService(ctx).newMetadataOperation(metadataOperation);
        int maxBackend = newMetaDataOperation.getInvolvedCSPs().stream().max(Comparator.naturalOrder()).orElse(-1);
        String[] geometryColumnsDataids = (String[])Stream.of("f_table_catalog", "f_table_schema", "f_table_name", "f_geometry_column", "type").map(cn -> "geometry_columns/" + cn).toArray(String[]::new);
        String[] pgStatsDataids = (String[])Stream.of("schemaname", "tablename", "attname").map(cn -> "pg_stats/" + cn).toArray(String[]::new);
        newMetaDataOperation.getMetadata().stream().filter(e -> Stream.concat(Stream.of(geometryColumnsDataids), Stream.of(pgStatsDataids)).anyMatch(cid -> ((CString)e.getKey()).endsWith((CharSequence)cid))).filter(e -> ((List)e.getValue()).isEmpty()).forEach(e -> e.setValue(IntStream.range(0, maxBackend + 1).mapToObj(backend -> newMetaDataOperation.getInvolvedCSPs().contains(backend) ? (CString)e.getKey() : null).collect(Collectors.toList())));
        List<String> backendDatabaseNames = this.getBackendDatabaseNames(ctx);
        if (!backendDatabaseNames.isEmpty()) {
            newMetaDataOperation.getMetadata().forEach(e -> IntStream.range(0, ((List)e.getValue()).size()).filter(csp -> ((List)e.getValue()).get(csp) != null).forEach(csp -> ((List)e.getValue()).set(csp, this.modifyDatabaseName((CString)((List)e.getValue()).get(csp), (String)backendDatabaseNames.get(csp)))));
        }
        return newMetaDataOperation;
    }

    private List<OutboundDataOperation> newOutboundDataOperation(ChannelHandlerContext ctx, OutboundDataOperation outboundDataOperation) {
        Map<String, String> geometryObjectDefinition;
        List selectItemIds;
        if (outboundDataOperation.getOperation() == Operation.READ && outboundDataOperation.getCriterions().stream().filter(c -> c != null).map(OutboundDataOperation.Criterion::getDataId).anyMatch(id -> id.endsWith((CharSequence)"pg_type/oid"))) {
            SQLDatabaseSchema databaseSchema = this.getDatabaseSchema(ctx);
            List criterions = outboundDataOperation.getCriterions();
            List involvedBackends = criterions.stream().filter(c -> c != null).filter(c -> c.getDataId().endsWith((CharSequence)"pg_type/oid")).map(OutboundDataOperation.Criterion::getValue).map(CString::toString).mapToLong(Long::valueOf).mapToObj(oid -> databaseSchema.getTypeOIDBackends(oid)).filter(backends -> backends != null).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            if (!involvedBackends.isEmpty()) {
                if (outboundDataOperation.getInvolvedCSPs() != null) {
                    involvedBackends.removeAll(outboundDataOperation.getInvolvedCSPs());
                }
                outboundDataOperation.setInvolvedCSPs(involvedBackends);
                outboundDataOperation.setModified(true);
            }
        }
        List newOutboundDataOperations = this.getProtocolService(ctx).newOutboundDataOperation(outboundDataOperation);
        List<String> backendDatabaseNames = this.getBackendDatabaseNames(ctx);
        if (!backendDatabaseNames.isEmpty()) {
            newOutboundDataOperations.forEach(newOutboundDataOperation -> {
                int backend = newOutboundDataOperation.getInvolvedCSP() == -1 ? this.getPreferredBackend(ctx) : newOutboundDataOperation.getInvolvedCSP();
                List dataIds = newOutboundDataOperation.getDataIds();
                IntStream.range(0, dataIds.size()).forEach(i -> dataIds.set(i, this.modifyDatabaseName((CString)dataIds.get(i), (String)backendDatabaseNames.get(backend))));
                newOutboundDataOperation.getCriterions().stream().filter(c -> c != null).forEach(c -> c.setDataId(this.modifyDatabaseName(c.getDataId(), (String)backendDatabaseNames.get(backend))));
            });
        }
        if ((selectItemIds = (List)outboundDataOperation.getAttribute("selectItemIds")) != null) {
            selectItemIds.forEach(entry -> {
                Function function;
                SelectItem selectItem = (SelectItem)entry.getKey();
                if (selectItem instanceof SelectExpressionItem && ((SelectExpressionItem)selectItem).getExpression() instanceof Function && (function = (Function)((SelectExpressionItem)selectItem).getExpression()).getParameters() != null && function.getParameters().getExpressions() != null) {
                    List dataIds = (List)entry.getValue();
                    List dataIdPatterns = dataIds.stream().map(dataId -> this.isFullyQualifiedDataId((String)dataId) ? Pattern.compile(String.format("(%s\\.?)?(%s\\.?)?(%s\\.?)?(%s)?", this.getDatabaseName((String)dataId), this.getSchemaName((String)dataId), this.getTableName((String)dataId), this.getColumnName((String)dataId))) : null).collect(Collectors.toList());
                    List parameterMatchers = function.getParameters().getExpressions().stream().map(parameter -> parameter instanceof StringValue ? ((StringValue)parameter).getValue() : parameter.toString()).map(StringUtilities::unquote).map(value -> value.replace("\".\"", ".")).map(value -> dataIdPatterns.stream().map(pattern -> pattern != null ? pattern.matcher((CharSequence)value) : null).collect(Collectors.toList())).collect(Collectors.toList());
                    if (parameterMatchers.stream().flatMap(Collection::stream).filter(matcher -> matcher != null).anyMatch(Matcher::matches)) {
                        List fctGetDataIdParts = Stream.of(this::getDatabaseName, this::getSchemaName, this::getTableName, this::getColumnName).collect(Collectors.toList());
                        for (int backend = 0; backend < newOutboundDataOperations.size(); ++backend) {
                            OutboundDataOperation newOutboundDataOperation = (OutboundDataOperation)newOutboundDataOperations.get(backend);
                            Map dataIdMapping = newOutboundDataOperation.getDataIdMapping();
                            Map<String, String> mapping = dataIdMapping.entrySet().stream().collect(Collectors.toMap(e -> ((CString)e.getKey()).toString(), e -> ((CString)e.getValue()).toString()));
                            List newDataValues = (List)newOutboundDataOperation.getDataValues().get(0);
                            for (int c = 0; c < newDataValues.size(); ++c) {
                                CString newDataValue = (CString)newDataValues.get(c);
                                if (newDataValue == null || !newDataValue.equals((Object)function.toString())) continue;
                                String dataValue = newDataValue.toString();
                                Function newFunction = null;
                                CCJSqlParser parser = new CCJSqlParser((Reader)new StringReader(dataValue));
                                try {
                                    newFunction = parser.Function();
                                }
                                catch (Exception e2) {
                                    LOGGER.error("Parsing error for {} : ", (Object)dataValue, (Object)e2);
                                }
                                if (newFunction == null || newFunction.getParameters() == null || newFunction.getParameters().getExpressions() == null) continue;
                                for (int p = 0; p < newFunction.getParameters().getExpressions().size(); ++p) {
                                    for (int i = 0; i < ((List)parameterMatchers.get(p)).size(); ++i) {
                                        String protectedDataId;
                                        String dataId2;
                                        Matcher parameterMatcher = (Matcher)((List)parameterMatchers.get(p)).get(i);
                                        if (parameterMatcher == null || !parameterMatcher.matches() || !this.isFullyQualifiedDataId(dataId2 = (String)dataIds.get(i)) || !this.isFullyQualifiedDataId(protectedDataId = mapping.get(dataId2))) continue;
                                        StringBuilder target = new StringBuilder();
                                        StringBuilder replacement = new StringBuilder();
                                        for (int g = 0; g < fctGetDataIdParts.size(); ++g) {
                                            String group = parameterMatcher.group(g + 1);
                                            if (group == null || group.isEmpty()) continue;
                                            java.util.function.Function fctGetDataIdPart = (java.util.function.Function)fctGetDataIdParts.get(g);
                                            if (target.length() > 0) {
                                                target.append('.');
                                            }
                                            target.append((String)fctGetDataIdPart.apply(dataId2));
                                            if (protectedDataId == null) continue;
                                            if (replacement.length() > 0) {
                                                replacement.append('.');
                                            }
                                            replacement.append((String)fctGetDataIdPart.apply(protectedDataId));
                                        }
                                        Expression parameter2 = (Expression)newFunction.getParameters().getExpressions().get(p);
                                        String value2 = parameter2 instanceof StringValue ? ((StringValue)parameter2).getValue() : parameter2.toString();
                                        boolean withQuotes = StringUtilities.hasQuote((String)value2);
                                        if (withQuotes) {
                                            value2 = StringUtilities.unquote((String)value2).replace("\".\"", ".");
                                        }
                                        String newValue = value2.replace(target.toString(), replacement.toString());
                                        if (withQuotes) {
                                            newValue = StringUtilities.quote((String)newValue.replace(".", "\".\""));
                                        }
                                        Expression newParameter = this.buildExpression(parameter2, value2, newValue);
                                        newFunction.getParameters().getExpressions().set(p, newParameter);
                                    }
                                }
                                String modifiedDataValue = newFunction.toString();
                                newDataValues.set(c, CString.valueOf((CharSequence)modifiedDataValue));
                                newOutboundDataOperation.setModified(true);
                            }
                        }
                    }
                }
            });
            if (outboundDataOperation.getOperation() == Operation.CREATE || outboundDataOperation.getOperation() == Operation.UPDATE) {
                selectItemIds.forEach(entry -> {
                    Function function;
                    SelectItem selectItem = (SelectItem)entry.getKey();
                    if (selectItem instanceof SelectExpressionItem && ((SelectExpressionItem)selectItem).getExpression() instanceof Function && FUNCTION_ADD_GEOMETRY_COLUMN.equalsIgnoreCase((function = (Function)((SelectExpressionItem)selectItem).getExpression()).getName())) {
                        String protectedType = null;
                        Map<String, String> geometryObjectDefinition = this.getGeometryObjectDefinition(ctx);
                        if (!geometryObjectDefinition.isEmpty()) {
                            protectedType = geometryObjectDefinition.get("protectedType");
                        }
                        if (protectedType != null) {
                            for (DataOperation newOutboundDataOperation : newOutboundDataOperations) {
                                List newDataValues = (List)newOutboundDataOperation.getDataValues().get(0);
                                for (int c = 0; c < newDataValues.size(); ++c) {
                                    String dataValue;
                                    CString newDataValue = (CString)newDataValues.get(c);
                                    if (newDataValue == null || !newDataValue.startsWith((CharSequence)function.getName())) continue;
                                    String modifiedDataValue = dataValue = newDataValue.toString();
                                    for (GeometryType geometryType : GeometryType.values()) {
                                        String clearType = geometryType.toString();
                                        if (clearType.equals(protectedType)) continue;
                                        modifiedDataValue = modifiedDataValue.replaceAll("(?i)\\b" + clearType + "\\b", protectedType);
                                    }
                                    if (modifiedDataValue.equals(dataValue)) continue;
                                    newDataValues.set(c, CString.valueOf((CharSequence)modifiedDataValue));
                                    newOutboundDataOperation.setModified(true);
                                }
                            }
                        }
                    }
                });
            }
        }
        String[] geometryColumnsDataids = (String[])Stream.of("f_table_catalog", "f_table_schema", "f_table_name", "f_geometry_column", "type").map(cn -> "geometry_columns/" + cn).toArray(String[]::new);
        if (outboundDataOperation.getOperation() == Operation.READ && (outboundDataOperation.getDataIds().stream().anyMatch(id -> Stream.of(geometryColumnsDataids).anyMatch(cid -> id.endsWith((CharSequence)cid))) || outboundDataOperation.getCriterions().stream().filter(c -> c != null).map(OutboundDataOperation.Criterion::getDataId).anyMatch(id -> Stream.of(geometryColumnsDataids).anyMatch(cid -> id.endsWith((CharSequence)cid)))) && !(geometryObjectDefinition = this.getGeometryObjectDefinition(ctx)).isEmpty()) {
            boolean typeProtected;
            boolean catalogProtected = backendDatabaseNames.stream().anyMatch(dbn -> !dbn.equals(this.getDatabaseName(ctx)));
            String geometricDataId = geometryObjectDefinition.get("dataId");
            List protectedGeometricDataIds = null;
            if (geometricDataId != null) {
                MetadataOperation metadataOperation = new MetadataOperation();
                metadataOperation.addDataId(CString.valueOf((CharSequence)geometricDataId));
                List metadata = this.newMetaDataOperation(ctx, metadataOperation).getMetadata();
                protectedGeometricDataIds = !metadata.isEmpty() ? (List)((Map.Entry)metadata.get(0)).getValue() : null;
            }
            String protectedGeometricDataId = protectedGeometricDataIds != null && !protectedGeometricDataIds.isEmpty() ? ((CString)protectedGeometricDataIds.get(0)).toString() : null;
            boolean dataIdProtected = geometricDataId != null && protectedGeometricDataId != null && !geometricDataId.equals(protectedGeometricDataId);
            String clearType = geometryObjectDefinition.get("clearType");
            String protectedType = geometryObjectDefinition.get("protectedType");
            boolean bl = typeProtected = !Objects.equals(clearType, protectedType);
            if (catalogProtected || dataIdProtected || typeProtected) {
                String columnName;
                String catalogName = dataIdProtected && !this.getDatabaseName(geometricDataId).equals("*") ? this.getDatabaseName(geometricDataId) : (catalogProtected ? this.getDatabaseName(ctx) : "*");
                String schemaName = dataIdProtected ? this.getSchemaName(geometricDataId) : "*";
                String tableName = dataIdProtected ? this.getTableName(geometricDataId) : "*";
                String string = columnName = dataIdProtected ? this.getColumnName(geometricDataId) : "*";
                String protectedCatalogName = dataIdProtected ? this.getDatabaseName(protectedGeometricDataId) : (catalogProtected ? backendDatabaseNames.get(0) : "*");
                String protectedSchemaName = dataIdProtected ? this.getSchemaName(protectedGeometricDataId) : "*";
                String protectedTableName = dataIdProtected ? this.getTableName(protectedGeometricDataId) : "*";
                String protectedColumnName = dataIdProtected ? this.getColumnName(protectedGeometricDataId) : "*";
                boolean protectCatalogName = !protectedCatalogName.equals("*") && !catalogName.equals("*") && !catalogName.equals(protectedCatalogName);
                boolean protectSchemaName = !protectedSchemaName.equals("*") && !schemaName.equals("*") && !schemaName.equals(protectedSchemaName);
                boolean protectTableName = !protectedTableName.equals("*") && !tableName.equals("*") && !tableName.equals(protectedTableName);
                boolean protectColumnName = !protectedColumnName.equals("*") && !columnName.equals("*") && !columnName.equals(protectedColumnName);
                newOutboundDataOperations.stream().forEach(newOutboundDataOperation -> {
                    int[] typeIndexes;
                    int[] typeIndexes2;
                    List dataIds = newOutboundDataOperation.getDataIds();
                    int[] catalogIndexes = catalogProtected ? IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"geometry_columns/f_table_catalog")).toArray() : new int[]{};
                    int[] dataIdIndexes = dataIdProtected ? IntStream.range(0, dataIds.size()).filter(i -> Stream.of("f_table_catalog", "f_table_schema", "f_table_name", "f_geometry_column").anyMatch(cn -> ((CString)dataIds.get(i)).endsWith((CharSequence)("geometry_columns/" + cn)))).toArray() : new int[]{};
                    int[] nArray = typeIndexes2 = typeProtected ? IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"geometry_columns/type")).toArray() : new int[]{};
                    if (Stream.of(catalogIndexes, dataIdIndexes, typeIndexes2).anyMatch(arr -> ((int[])arr).length > 0)) {
                        newOutboundDataOperation.setModified(true);
                    }
                    List criterions = newOutboundDataOperation.getCriterions();
                    catalogIndexes = protectCatalogName ? IntStream.range(0, criterions.size()).filter(i -> criterions.get(i) != null).filter(i -> ((OutboundDataOperation.Criterion)criterions.get(i)).getDataId().endsWith((CharSequence)"geometry_columns/f_table_catalog")).toArray() : new int[]{};
                    int[] schemaIndexes = protectSchemaName ? IntStream.range(0, criterions.size()).filter(i -> criterions.get(i) != null).filter(i -> ((OutboundDataOperation.Criterion)criterions.get(i)).getDataId().endsWith((CharSequence)"geometry_columns/f_table_schema")).toArray() : new int[]{};
                    int[] tableIndexes = protectTableName ? IntStream.range(0, criterions.size()).filter(i -> criterions.get(i) != null).filter(i -> ((OutboundDataOperation.Criterion)criterions.get(i)).getDataId().endsWith((CharSequence)"geometry_columns/f_table_name")).toArray() : new int[]{};
                    int[] columnIndexes = protectColumnName ? IntStream.range(0, criterions.size()).filter(i -> criterions.get(i) != null).filter(i -> ((OutboundDataOperation.Criterion)criterions.get(i)).getDataId().endsWith((CharSequence)"geometry_columns/f_geometry_column")).toArray() : new int[]{};
                    int[] nArray2 = typeIndexes = typeProtected ? IntStream.range(0, criterions.size()).filter(i -> criterions.get(i) != null).filter(i -> ((OutboundDataOperation.Criterion)criterions.get(i)).getDataId().endsWith((CharSequence)"geometry_columns/type")).toArray() : new int[]{};
                    if (Stream.of(catalogIndexes, schemaIndexes, tableIndexes, columnIndexes, typeIndexes).anyMatch(arr -> ((int[])arr).length > 0) && (Arrays.stream(catalogIndexes).anyMatch(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)catalogName)) || Arrays.stream(schemaIndexes).anyMatch(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)schemaName)) || Arrays.stream(tableIndexes).anyMatch(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)tableName)) || Arrays.stream(columnIndexes).anyMatch(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)columnName)) || Arrays.stream(typeIndexes).anyMatch(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)clearType)))) {
                        Arrays.stream(catalogIndexes).filter(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)catalogName)).forEach(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).setValue(CString.valueOf((CharSequence)protectedCatalogName)));
                        Arrays.stream(schemaIndexes).filter(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)schemaName)).forEach(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).setValue(CString.valueOf((CharSequence)protectedSchemaName)));
                        Arrays.stream(tableIndexes).filter(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)tableName)).forEach(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).setValue(CString.valueOf((CharSequence)protectedTableName)));
                        Arrays.stream(columnIndexes).filter(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)columnName)).forEach(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).setValue(CString.valueOf((CharSequence)protectedColumnName)));
                        Arrays.stream(typeIndexes).filter(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)clearType)).forEach(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).setValue(CString.valueOf((CharSequence)protectedType)));
                        newOutboundDataOperation.setModified(true);
                    }
                });
            }
        }
        String[] pgStatsDataids = (String[])Stream.of("schemaname", "tablename", "attname").map(cn -> "pg_stats/" + cn).toArray(String[]::new);
        if (outboundDataOperation.getOperation() == Operation.READ && outboundDataOperation.getCriterions().stream().filter(c -> c != null).map(OutboundDataOperation.Criterion::getDataId).anyMatch(id -> Stream.of(pgStatsDataids).anyMatch(cid -> id.endsWith((CharSequence)cid)))) {
            newOutboundDataOperations.stream().forEach(newOutboundDataOperation -> {
                boolean dataIdProtected;
                List criterions = newOutboundDataOperation.getCriterions();
                String clearDataId = "*/" + Stream.of(pgStatsDataids).map(cid -> criterions.stream().filter(c -> c.getDataId().endsWith((CharSequence)cid)).map(OutboundDataOperation.Criterion::getValue).map(CString::toString).findFirst().orElse("*")).collect(Collectors.joining("/")).replaceFirst("/", ".");
                MetadataOperation metadataOperation = new MetadataOperation();
                metadataOperation.addDataId(CString.valueOf((CharSequence)clearDataId));
                List metadata = this.newMetaDataOperation(ctx, metadataOperation).getMetadata();
                List protectedDataIds = !metadata.isEmpty() ? (List)((Map.Entry)metadata.get(0)).getValue() : null;
                String protectedDataId = protectedDataIds != null && !protectedDataIds.isEmpty() ? ((CString)protectedDataIds.get(0)).toString() : null;
                boolean bl = dataIdProtected = protectedDataId != null && !clearDataId.equals(protectedDataId);
                if (dataIdProtected) {
                    int[] columnIndexes;
                    String schemaName = dataIdProtected ? this.getSchemaName(clearDataId) : "*";
                    String tableName = dataIdProtected ? this.getTableName(clearDataId) : "*";
                    String columnName = dataIdProtected ? this.getColumnName(clearDataId) : "*";
                    String protectedSchemaName = dataIdProtected ? this.getSchemaName(protectedDataId) : "*";
                    String protectedTableName = dataIdProtected ? this.getTableName(protectedDataId) : "*";
                    String protectedColumnName = dataIdProtected ? this.getColumnName(protectedDataId) : "*";
                    boolean protectSchemaName = !protectedSchemaName.equals("*") && !schemaName.equals("*") && !schemaName.equals(protectedSchemaName);
                    boolean protectTableName = !protectedTableName.equals("*") && !tableName.equals("*") && !tableName.equals(protectedTableName);
                    boolean protectColumnName = !protectedColumnName.equals("*") && !columnName.equals("*") && !columnName.equals(protectedColumnName);
                    int[] schemaIndexes = protectSchemaName ? IntStream.range(0, criterions.size()).filter(i -> criterions.get(i) != null).filter(i -> ((OutboundDataOperation.Criterion)criterions.get(i)).getDataId().endsWith((CharSequence)"pg_stats/schemaname")).toArray() : new int[]{};
                    int[] tableIndexes = protectTableName ? IntStream.range(0, criterions.size()).filter(i -> criterions.get(i) != null).filter(i -> ((OutboundDataOperation.Criterion)criterions.get(i)).getDataId().endsWith((CharSequence)"pg_stats/tablename")).toArray() : new int[]{};
                    int[] nArray = columnIndexes = protectColumnName ? IntStream.range(0, criterions.size()).filter(i -> criterions.get(i) != null).filter(i -> ((OutboundDataOperation.Criterion)criterions.get(i)).getDataId().endsWith((CharSequence)"pg_stats/attname")).toArray() : new int[]{};
                    if (Stream.of(schemaIndexes, tableIndexes, columnIndexes).anyMatch(arr -> ((int[])arr).length > 0) && (Arrays.stream(schemaIndexes).anyMatch(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)schemaName)) || Arrays.stream(tableIndexes).anyMatch(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)tableName)) || Arrays.stream(columnIndexes).anyMatch(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)columnName)))) {
                        Arrays.stream(schemaIndexes).filter(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)schemaName)).forEach(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).setValue(CString.valueOf((CharSequence)protectedSchemaName)));
                        Arrays.stream(tableIndexes).filter(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)tableName)).forEach(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).setValue(CString.valueOf((CharSequence)protectedTableName)));
                        Arrays.stream(columnIndexes).filter(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).getValue().equals((Object)columnName)).forEach(idx -> ((OutboundDataOperation.Criterion)criterions.get(idx)).setValue(CString.valueOf((CharSequence)protectedColumnName)));
                        newOutboundDataOperation.setModified(true);
                    }
                }
            });
        }
        return newOutboundDataOperations;
    }

    private boolean isFullyQualifiedDataId(String dataId) {
        Matcher matcher = FQ_DATA_ID_PATTERN.matcher(dataId);
        return matcher.matches();
    }

    private String getDatabaseName(String dataId) {
        Matcher matcher = FQ_DATA_ID_PATTERN.matcher(dataId);
        if (matcher.matches()) {
            return matcher.group(1);
        }
        return null;
    }

    private String getSchemaName(String dataId) {
        Matcher matcher = FQ_DATA_ID_PATTERN.matcher(dataId);
        if (matcher.matches()) {
            return matcher.group(2);
        }
        return null;
    }

    private String getTableName(String dataId) {
        Matcher matcher = FQ_DATA_ID_PATTERN.matcher(dataId);
        if (matcher.matches()) {
            return matcher.group(3);
        }
        return null;
    }

    private String getColumnName(String dataId) {
        Matcher matcher = FQ_DATA_ID_PATTERN.matcher(dataId);
        if (matcher.matches()) {
            return matcher.group(4);
        }
        return null;
    }

    private InboundDataOperation newInboundDataOperation(ChannelHandlerContext ctx, List<InboundDataOperation> inboundDataOperations) {
        Map<String, String> geometryObjectDefinition;
        List<String> backendDatabaseNames = this.getBackendDatabaseNames(ctx);
        if (!backendDatabaseNames.isEmpty()) {
            inboundDataOperations.stream().forEach(inboundDataOperation -> {
                List dataIds = inboundDataOperation.getDataIds();
                String databaseName = this.getDatabaseName(ctx);
                IntStream.range(0, dataIds.size()).forEach(i -> dataIds.set(i, this.modifyDatabaseName((CString)dataIds.get(i), databaseName)));
            });
        }
        inboundDataOperations.stream().forEach(inboundDataOperation -> {
            if (inboundDataOperation.getOperation() == Operation.READ && inboundDataOperation.getDataIds().stream().anyMatch(id -> Stream.of("typname", "typelem").anyMatch(cn -> id.endsWith((CharSequence)("pg_types/" + cn))))) {
                List dataIds = inboundDataOperation.getDataIds();
                int typnameIndex = IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"pg_types/typname")).findFirst().orElse(-1);
                int typelemIndex = IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"pg_types/typelem")).findFirst().orElse(-1);
                if (Stream.of(typnameIndex, typelemIndex).allMatch(idx -> idx != -1)) {
                    List dataValues = inboundDataOperation.getDataValues();
                    Types backendTypes = this.getTypes(ctx, inboundDataOperation.getInvolvedCSP());
                    dataValues.forEach(row -> {
                        String typname = ((CString)row.get(typnameIndex)).toString();
                        String typelem = ((CString)row.get(typelemIndex)).toString();
                        backendTypes.setTypeOid(typname, Long.parseLong(typelem));
                    });
                }
            }
        });
        InboundDataOperation newInboundDataOperation = this.getProtocolService(ctx).newInboundDataOperation(inboundDataOperations);
        if (!backendDatabaseNames.isEmpty()) {
            int backend = newInboundDataOperation.getInvolvedCSP() == -1 ? this.getPreferredBackend(ctx) : newInboundDataOperation.getInvolvedCSP();
            List dataIds = newInboundDataOperation.getDataIds();
            IntStream.range(0, dataIds.size()).forEach(i -> dataIds.set(i, this.modifyDatabaseName((CString)dataIds.get(i), (String)backendDatabaseNames.get(backend))));
        }
        if (newInboundDataOperation.getOperation() == Operation.READ && newInboundDataOperation.getDataIds().stream().anyMatch(id -> Stream.of("typname", "typelem").anyMatch(cn -> id.endsWith((CharSequence)("pg_types/" + cn))))) {
            List dataIds = newInboundDataOperation.getDataIds();
            int typnameIndex = IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"pg_types/typname")).findFirst().orElse(-1);
            int typelemIndex = IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"pg_types/typelem")).findFirst().orElse(-1);
            if (Stream.of(typnameIndex, typelemIndex).allMatch(idx -> idx != -1)) {
                List dataValues = newInboundDataOperation.getDataValues();
                Types types = this.getTypes(ctx, -1);
                dataValues.forEach(row -> {
                    String typname = ((CString)row.get(typnameIndex)).toString();
                    String typelem = ((CString)row.get(typelemIndex)).toString();
                    types.setTypeOid(typname, Long.parseLong(typelem));
                });
            }
        }
        if (newInboundDataOperation.getOperation() == Operation.READ && newInboundDataOperation.getDataIds().stream().anyMatch(id -> Stream.of("f_table_catalog", "f_table_schema", "f_table_name", "f_geometry_column", "srid", "type").anyMatch(cn -> id.endsWith((CharSequence)("geometry_columns/" + cn)))) && !(geometryObjectDefinition = this.getGeometryObjectDefinition(ctx)).isEmpty()) {
            boolean typeProtected;
            boolean catalogProtected = backendDatabaseNames.stream().anyMatch(dbn -> !dbn.equals(this.getDatabaseName(ctx)));
            String geometricDataId = geometryObjectDefinition.get("dataId");
            List protectedGeometricDataIds = null;
            if (geometricDataId != null) {
                MetadataOperation metadataOperation = new MetadataOperation();
                metadataOperation.addDataId(CString.valueOf((CharSequence)geometricDataId));
                List metadata = this.newMetaDataOperation(ctx, metadataOperation).getMetadata();
                protectedGeometricDataIds = !metadata.isEmpty() ? (List)((Map.Entry)metadata.get(0)).getValue() : null;
            }
            String protectedGeometricDataId = protectedGeometricDataIds != null && !protectedGeometricDataIds.isEmpty() ? ((CString)protectedGeometricDataIds.get(0)).toString() : null;
            boolean dataIdProtected = geometricDataId != null && protectedGeometricDataId != null && !geometricDataId.equals(protectedGeometricDataId);
            String clearType = geometryObjectDefinition.get("clearType");
            String protectedType = geometryObjectDefinition.get("protectedType");
            boolean bl = typeProtected = !Objects.equals(clearType, protectedType);
            if (catalogProtected || dataIdProtected || typeProtected) {
                int[] typeIndexes;
                String columnName;
                String catalogName = dataIdProtected && !this.getDatabaseName(geometricDataId).equals("*") ? this.getDatabaseName(geometricDataId) : (catalogProtected ? this.getDatabaseName(ctx) : "*");
                String schemaName = dataIdProtected ? this.getSchemaName(geometricDataId) : "*";
                String tableName = dataIdProtected ? this.getTableName(geometricDataId) : "*";
                String string = columnName = dataIdProtected ? this.getColumnName(geometricDataId) : "*";
                String protectedCatalogName = dataIdProtected ? this.getDatabaseName(protectedGeometricDataId) : (catalogProtected ? backendDatabaseNames.get(0) : "*");
                String protectedSchemaName = dataIdProtected ? this.getSchemaName(protectedGeometricDataId) : "*";
                String protectedTableName = dataIdProtected ? this.getTableName(protectedGeometricDataId) : "*";
                String protectedColumnName = dataIdProtected ? this.getColumnName(protectedGeometricDataId) : "*";
                boolean unprotectCatalogName = !protectedCatalogName.equals("*") && !catalogName.equals("*") && !catalogName.equals(protectedCatalogName);
                boolean unprotectSchemaName = !protectedSchemaName.equals("*") && !schemaName.equals("*") && !schemaName.equals(protectedSchemaName);
                boolean unprotectTableName = !protectedTableName.equals("*") && !tableName.equals("*") && !tableName.equals(protectedTableName);
                boolean unprotectColumnName = !protectedColumnName.equals("*") && !columnName.equals("*") && !columnName.equals(protectedColumnName);
                List dataIds = newInboundDataOperation.getDataIds();
                int[] catalogIndexes = unprotectCatalogName ? IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"geometry_columns/f_table_catalog")).toArray() : new int[]{};
                int[] schemaIndexes = unprotectSchemaName ? IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"geometry_columns/f_table_schema")).toArray() : new int[]{};
                int[] tableIndexes = unprotectTableName ? IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"geometry_columns/f_table_name")).toArray() : new int[]{};
                int[] columnIndexes = unprotectColumnName ? IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"geometry_columns/f_geometry_column")).toArray() : new int[]{};
                int[] nArray = typeIndexes = typeProtected ? IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"geometry_columns/type")).toArray() : new int[]{};
                if (Stream.of(catalogIndexes, schemaIndexes, tableIndexes, columnIndexes, typeIndexes).anyMatch(arr -> ((int[])arr).length > 0)) {
                    List dataValues = newInboundDataOperation.getDataValues();
                    long nbRows = dataValues.stream().filter(row -> Arrays.stream(catalogIndexes).anyMatch(idx -> ((CString)row.get(idx)).equals((Object)protectedCatalogName)) || Arrays.stream(schemaIndexes).anyMatch(idx -> ((CString)row.get(idx)).equals((Object)protectedSchemaName)) || Arrays.stream(tableIndexes).anyMatch(idx -> ((CString)row.get(idx)).equals((Object)protectedTableName)) || Arrays.stream(columnIndexes).anyMatch(idx -> ((CString)row.get(idx)).equals((Object)protectedColumnName)) || Arrays.stream(typeIndexes).anyMatch(idx -> ((CString)row.get(idx)).equals((Object)protectedType))).peek(row -> Arrays.stream(catalogIndexes).filter(idx -> ((CString)row.get(idx)).equals((Object)protectedCatalogName)).forEach(idx -> row.set(idx, CString.valueOf((CharSequence)catalogName)))).peek(row -> Arrays.stream(schemaIndexes).filter(idx -> ((CString)row.get(idx)).equals((Object)protectedSchemaName)).forEach(idx -> row.set(idx, CString.valueOf((CharSequence)schemaName)))).peek(row -> Arrays.stream(tableIndexes).filter(idx -> ((CString)row.get(idx)).equals((Object)protectedTableName)).forEach(idx -> row.set(idx, CString.valueOf((CharSequence)tableName)))).peek(row -> Arrays.stream(columnIndexes).filter(idx -> ((CString)row.get(idx)).equals((Object)protectedColumnName)).forEach(idx -> row.set(idx, CString.valueOf((CharSequence)columnName)))).peek(row -> Arrays.stream(typeIndexes).filter(idx -> ((CString)row.get(idx)).equals((Object)protectedType)).forEach(idx -> row.set(idx, CString.valueOf((CharSequence)clearType)))).count();
                    newInboundDataOperation.setModified(nbRows > 0L);
                }
            }
            if (geometricDataId != null) {
                List dataIds = newInboundDataOperation.getDataIds();
                int catalogIndex = IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"geometry_columns/f_table_catalog")).findFirst().orElse(-1);
                int schemaIndex = IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"geometry_columns/f_table_schema")).findFirst().orElse(-1);
                int tableIndex = IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"geometry_columns/f_table_name")).findFirst().orElse(-1);
                int sridIndex = IntStream.range(0, dataIds.size()).filter(i -> ((CString)dataIds.get(i)).endsWith((CharSequence)"geometry_columns/srid")).findFirst().orElse(-1);
                if (Stream.of(tableIndex, sridIndex).allMatch(idx -> idx != -1)) {
                    List dataValues = newInboundDataOperation.getDataValues();
                    dataValues.forEach(row -> {
                        String catalog = catalogIndex != -1 ? ((CString)row.get(catalogIndex)).toString() : this.getDatabaseName(ctx);
                        String schema = schemaIndex != -1 ? ((CString)row.get(schemaIndex)).toString() : "public";
                        String table = ((CString)row.get(tableIndex)).toString();
                        String datasetSrid = String.format("%s/%s.%s", catalog, schema, table);
                        String srid = ((CString)row.get(sridIndex)).toString();
                        SQLDatabaseSchema databaseSchema = this.getDatabaseSchema(ctx);
                        databaseSchema.addDatasetSrid(datasetSrid, srid);
                    });
                }
            }
        }
        return newInboundDataOperation;
    }

    private String escapeRegex(String regex) {
        return regex.replace(".", "\\.").replace("[", "\\[").replace("]", "\\]").replace("(", "\\(").replace(")", "\\)").replace("*", "[^/]*");
    }

    private String modifyDatabaseName(String protectedDataId, String databaseName) {
        return this.modifyDatabaseName(CString.valueOf((CharSequence)protectedDataId), databaseName).toString();
    }

    private CString modifyDatabaseName(CString protectedDataId, String databaseName) {
        int offset = protectedDataId.indexOf(47);
        if (offset != -1) {
            protectedDataId = CString.valueOf((CharSequence)databaseName).append((CharSequence)protectedDataId.substring(offset));
        }
        return protectedDataId;
    }

    private OutboundDataOperation extractSetOperation(ChannelHandlerContext ctx, SetStatement stmt) throws ParseException {
        OutboundDataOperation outboundDataOperation = new OutboundDataOperation();
        outboundDataOperation.setOperation(null);
        int numberOfBackends = this.getNumberOfBackends(ctx);
        outboundDataOperation.setInvolvedCSPs(IntStream.range(0, numberOfBackends).boxed().collect(Collectors.toList()));
        return outboundDataOperation;
    }

    private PgsqlStatement<SetStatement> modifySetStatement(ChannelHandlerContext ctx, PgsqlStatement<SetStatement> statement, OutboundDataOperation outboundDataOperation, boolean newStatement) {
        SetStatement stmt;
        block3: {
            stmt = statement.getStatement();
            if (newStatement) {
                String sql = stmt.toString();
                try {
                    stmt = (SetStatement)CCJSqlParserUtil.parse((String)sql);
                }
                catch (JSQLParserException | TokenMgrError e) {
                    LOGGER.error("Parsing error for {} : ", (Object)sql);
                    if (!LOGGER.isTraceEnabled()) break block3;
                    LOGGER.trace("Parsing error details:", e);
                }
            }
        }
        return new PgsqlStatement<SetStatement>(stmt, statement.getParameterTypes(), statement.getParameterFormats(), statement.getParameterValues(), statement.getResultFormats(), statement.getColumns());
    }

    private OutboundDataOperation extractStartTransactionOperation(ChannelHandlerContext ctx, StartTransaction stmt) throws ParseException {
        OutboundDataOperation outboundDataOperation = new OutboundDataOperation();
        outboundDataOperation.setOperation(null);
        int numberOfBackends = this.getNumberOfBackends(ctx);
        outboundDataOperation.setInvolvedCSPs(IntStream.range(0, numberOfBackends).boxed().collect(Collectors.toList()));
        return outboundDataOperation;
    }

    private PgsqlStatement<StartTransaction> modifyStartTransactionStatement(ChannelHandlerContext ctx, PgsqlStatement<StartTransaction> statement, OutboundDataOperation outboundDataOperation, boolean newStatement) {
        StartTransaction stmt;
        block3: {
            stmt = statement.getStatement();
            if (newStatement) {
                String sql = stmt.toString();
                try {
                    stmt = (StartTransaction)CCJSqlParserUtil.parse((String)sql);
                }
                catch (JSQLParserException | TokenMgrError e) {
                    LOGGER.error("Parsing error for {} : ", (Object)sql);
                    if (!LOGGER.isTraceEnabled()) break block3;
                    LOGGER.trace("Parsing error details:", e);
                }
            }
        }
        return new PgsqlStatement<StartTransaction>(stmt, statement.getParameterTypes(), statement.getParameterFormats(), statement.getParameterValues(), statement.getResultFormats(), statement.getColumns());
    }

    private OutboundDataOperation extractCommitOperation(ChannelHandlerContext ctx, Commit stmt) throws ParseException {
        OutboundDataOperation outboundDataOperation = new OutboundDataOperation();
        outboundDataOperation.setOperation(null);
        int numberOfBackends = this.getNumberOfBackends(ctx);
        outboundDataOperation.setInvolvedCSPs(IntStream.range(0, numberOfBackends).boxed().collect(Collectors.toList()));
        return outboundDataOperation;
    }

    private PgsqlStatement<Commit> modifyCommitStatement(ChannelHandlerContext ctx, PgsqlStatement<Commit> statement, OutboundDataOperation outboundDataOperation, boolean newStatement) {
        Commit stmt;
        block3: {
            stmt = statement.getStatement();
            if (newStatement) {
                String sql = stmt.toString();
                try {
                    stmt = (Commit)CCJSqlParserUtil.parse((String)sql);
                }
                catch (JSQLParserException | TokenMgrError e) {
                    LOGGER.error("Parsing error for {} : ", (Object)sql);
                    if (!LOGGER.isTraceEnabled()) break block3;
                    LOGGER.trace("Parsing error details:", e);
                }
            }
        }
        return new PgsqlStatement<Commit>(stmt, statement.getParameterTypes(), statement.getParameterFormats(), statement.getParameterValues(), statement.getResultFormats(), statement.getColumns());
    }

    private OutboundDataOperation extractCreateTableOperation(ChannelHandlerContext ctx, CreateTable stmt) throws ParseException {
        OutboundDataOperation outboundDataOperation = new OutboundDataOperation();
        outboundDataOperation.setOperation(Operation.CREATE);
        outboundDataOperation.setUsingHeadOperation(true);
        String schemaId = this.getSchemaId(ctx, stmt.getTable());
        String datasetId = this.getTableId(ctx, stmt.getTable(), schemaId);
        AbstractMap.SimpleEntry<Table, String> tableId = new AbstractMap.SimpleEntry<Table, String>(stmt.getTable(), datasetId);
        outboundDataOperation.addAttribute("tableId", tableId);
        List dataIds = stmt.getColumnDefinitions().stream().map(ColumnDefinition::getColumnName).map(StringUtilities::unquote).map(cn -> datasetId + cn).map(CString::valueOf).collect(Collectors.toList());
        outboundDataOperation.setDataIds(dataIds);
        List columnDefinitionIds = IntStream.range(0, stmt.getColumnDefinitions().size()).mapToObj(i -> new AbstractMap.SimpleEntry(stmt.getColumnDefinitions().get(i), ((CString)dataIds.get(i)).toString())).collect(Collectors.toList());
        outboundDataOperation.addAttribute("columnDefinitionIds", columnDefinitionIds);
        SQLDatabaseSchema databaseSchema = this.getDatabaseSchema(ctx);
        databaseSchema.addDatasetDefinition(datasetId, dataIds.stream().map(CString::toString).collect(Collectors.toList()));
        return outboundDataOperation;
    }

    private PgsqlStatement<CreateTable> modifyCreateTableStatement(ChannelHandlerContext ctx, PgsqlStatement<CreateTable> statement, OutboundDataOperation outboundDataOperation, boolean newStatement) {
        CreateTable stmt;
        block12: {
            stmt = statement.getStatement();
            if (newStatement) {
                String sql = stmt.toString();
                try {
                    stmt = (CreateTable)CCJSqlParserUtil.parse((String)sql);
                }
                catch (JSQLParserException | TokenMgrError e2) {
                    LOGGER.error("Parsing error for {} : ", (Object)sql);
                    if (!LOGGER.isTraceEnabled()) break block12;
                    LOGGER.trace("Parsing error details:", e2);
                }
            }
        }
        CreateTable createTable = stmt;
        int involvedBackend = outboundDataOperation.getInvolvedCSP() == -1 ? this.getPreferredBackend(ctx) : outboundDataOperation.getInvolvedCSP();
        List columnDefinitionIds = (List)outboundDataOperation.getAttribute("columnDefinitionIds");
        List dataIdPerColumnDefinition = columnDefinitionIds.stream().map(Map.Entry::getValue).collect(Collectors.toList());
        List newDataIds1 = outboundDataOperation.getDataIds().stream().map(CString::toString).collect(Collectors.toList());
        MetadataOperation metadataOperation1 = new MetadataOperation();
        List allDataIds1 = dataIdPerColumnDefinition.stream().map(CString::valueOf).collect(Collectors.toList());
        metadataOperation1.setDataIds(allDataIds1);
        List metadata1 = this.newMetaDataOperation(ctx, metadataOperation1).getMetadata();
        Map<String, List> rawDataIdsMapping1 = metadata1.stream().collect(Collectors.toMap(e -> ((CString)e.getKey()).toString(), e -> ((List)e.getValue()).isEmpty() ? Collections.emptyList() : Collections.singletonList(StringUtilities.toString((CharSequence)((CharSequence)((List)e.getValue()).get(involvedBackend)))), (l1, l2) -> l1));
        Map dataIdsMapping1 = allDataIds1.stream().distinct().map(CString::toString).collect(Collectors.toMap(java.util.function.Function.identity(), id -> (List)rawDataIdsMapping1.get(id)));
        Map<String, List> fqDataIdsMapping1 = dataIdsMapping1.entrySet().stream().filter(e -> ((String)e.getKey()).lastIndexOf(47) != -1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map.Entry tableIdMapping = fqDataIdsMapping1.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty() && ((List)e.getValue()).get(0) != null).findAny().map(e -> new AbstractMap.SimpleEntry<String, String>(((String)e.getKey()).substring(0, ((String)e.getKey()).lastIndexOf(47)), ((String)((List)e.getValue()).get(0)).substring(0, ((String)((List)e.getValue()).get(0)).lastIndexOf(47)))).orElse(fqDataIdsMapping1.keySet().stream().findAny().map(id -> new AbstractMap.SimpleEntry<String, String>(id.substring(0, id.lastIndexOf(47)), id.substring(0, id.lastIndexOf(47)))).get());
        int nbColumnDefinitions = createTable.getColumnDefinitions().size();
        ArrayList<ColumnDefinition> newColumnDefinitions = new ArrayList<ColumnDefinition>(nbColumnDefinitions);
        ArrayList<String> newDataIds = new ArrayList<String>(nbColumnDefinitions);
        for (int i = 0; i < nbColumnDefinitions; ++i) {
            String newDataId;
            ColumnDefinition newColumnDefinition;
            ColumnDefinition columnDefinition = (ColumnDefinition)createTable.getColumnDefinitions().get(i);
            String dataId = (String)dataIdPerColumnDefinition.get(i);
            if (dataId == null) {
                newColumnDefinition = columnDefinition;
                newDataId = dataId;
            } else {
                List columnDefinitionProtectedDataIds = dataIdsMapping1.entrySet().stream().filter(e -> dataId.contains((CharSequence)e.getKey())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
                if (columnDefinitionProtectedDataIds.isEmpty()) {
                    newColumnDefinition = columnDefinition;
                    newDataId = dataId;
                } else {
                    List newColumnDefinitionDataIds = columnDefinitionProtectedDataIds.stream().filter(newDataIds1::contains).collect(Collectors.toList());
                    if (newColumnDefinitionDataIds.isEmpty()) {
                        newColumnDefinition = null;
                        newDataId = null;
                    } else {
                        String oldDataId = dataId;
                        newDataId = (String)newColumnDefinitionDataIds.get(0);
                        boolean same = newDataId.equals(oldDataId);
                        newColumnDefinition = same ? columnDefinition : this.buildColumnDefinition(columnDefinition, newDataId, null);
                    }
                }
            }
            if (newColumnDefinition != null) {
                newColumnDefinitions.add(newColumnDefinition);
            }
            if (newDataId == null) continue;
            newDataIds.add(newDataId);
        }
        for (int c = 0; c < newDataIds1.size(); ++c) {
            if (newDataIds.contains(newDataIds1.get(c))) continue;
            ColumnDefinition newColumnDefinition = this.buildColumnDefinition(null, (String)newDataIds1.get(c), "varchar(254)");
            newColumnDefinitions.add(newColumnDefinition);
        }
        createTable.setColumnDefinitions(newColumnDefinitions);
        Table table = createTable.getTable();
        Table newTable = null;
        String oldTableId = (String)tableIdMapping.getKey();
        String newTableId = (String)tableIdMapping.getValue();
        boolean same = newTableId.equals(oldTableId);
        newTable = same ? table : this.buildTable(table, newTableId);
        createTable.setTable(newTable);
        return new PgsqlStatement<CreateTable>(stmt, statement.getParameterTypes(), statement.getParameterFormats(), statement.getParameterValues(), statement.getResultFormats(), statement.getColumns());
    }

    private CreateTable buildCreateTableStatement(ChannelHandlerContext ctx, List<String> dataIds, List<String> dataTypes, boolean ifNotExists) {
        List tokens = dataIds.stream().map(dataId -> dataId.split("[/\\.]")).collect(Collectors.toList());
        String newTableName = tokens.stream().map(tk -> ((String[])tk).length > 1 ? tk[((String[])tk).length - 2] : null).filter(s -> s != null).distinct().findFirst().orElseThrow(IllegalArgumentException::new);
        String newSchemaName = tokens.stream().map(tk -> ((String[])tk).length > 2 ? tk[((String[])tk).length - 3] : null).filter(s -> s != null).distinct().findFirst().orElse(this.identifySchema(newTableName));
        String newDatabaseName = tokens.stream().map(tk -> ((String[])tk).length > 3 ? tk[((String[])tk).length - 4] : null).filter(s -> s != null).distinct().findFirst().orElse(this.getDatabaseName(ctx));
        Database newDatabase = new Database(StringUtilities.quote((String)newDatabaseName));
        Table newTable = new Table(newDatabase, StringUtilities.quote((String)newSchemaName), StringUtilities.quote((String)newTableName));
        CreateTable createTable = new CreateTable();
        createTable.setTable(newTable);
        List newColumnDefinitions = IntStream.range(0, dataIds.size()).mapToObj(i -> this.buildColumnDefinition(null, (String)dataIds.get(i), (String)dataTypes.get(i))).collect(Collectors.toList());
        createTable.setColumnDefinitions(newColumnDefinitions);
        createTable.setIfNotExists(ifNotExists);
        return createTable;
    }

    private ColumnDefinition buildColumnDefinition(ColumnDefinition columnDefinition, String newDataId, String newDataType) {
        String[] tokens = newDataId.split("/");
        assert (tokens.length > 0);
        String newColumnName = tokens[tokens.length - 1];
        ColumnDefinition newColumnDefinition = new ColumnDefinition();
        newColumnName = StringUtilities.quote((String)newColumnName);
        newColumnDefinition.setColumnName(newColumnName);
        if (columnDefinition != null) {
            newColumnDefinition.setColDataType(columnDefinition.getColDataType());
            newColumnDefinition.setColumnSpecStrings(columnDefinition.getColumnSpecStrings());
        } else {
            ColDataType dataType = new ColDataType();
            dataType.setDataType(newDataType);
            newColumnDefinition.setColDataType(dataType);
        }
        return newColumnDefinition;
    }

    private Table buildTable(Table table, String newTableId) {
        String[] tokens2;
        String[] tokens = newTableId.split("/");
        assert (tokens.length > 0);
        String newDbName = tokens.length >= 2 ? tokens[tokens.length - 2] : null;
        String newTableName = tokens[tokens.length - 1];
        Database newDatabase = null;
        if (table.getDatabase() != null && !table.getDatabase().getFullyQualifiedName().isEmpty() && newDbName != null) {
            newDbName = StringUtilities.quote((String)newDbName);
            newDatabase = new Database(newDbName);
        }
        if ((tokens2 = newTableName.split("\\.")).length == 2) {
            newTableName = tokens2[1];
        }
        newTableName = StringUtilities.quote((String)newTableName);
        String newSchemaName = null;
        if (table.getSchemaName() != null) {
            newSchemaName = tokens2.length == 2 ? tokens2[0] : "public";
            newSchemaName = StringUtilities.quote((String)newSchemaName);
        }
        Table newTable = new Table(newDatabase, newSchemaName, newTableName);
        newTable.setAlias(table.getAlias());
        return newTable;
    }

    private OutboundDataOperation extractAlterTableOperation(ChannelHandlerContext ctx, Alter stmt, OutboundDataOperation outboundDataOperation, Operation operation) throws ParseException {
        String schemaId = this.getSchemaId(ctx, stmt.getTable());
        String datasetId = this.getTableId(ctx, stmt.getTable(), schemaId);
        if (outboundDataOperation == null || operation != null && outboundDataOperation.getOperation() != operation) {
            outboundDataOperation = new OutboundDataOperation();
            outboundDataOperation.setOperation(operation != null ? operation : Operation.UPDATE);
            outboundDataOperation.setUsingHeadOperation(true);
            AbstractMap.SimpleEntry<Table, String> tableId = new AbstractMap.SimpleEntry<Table, String>(stmt.getTable(), datasetId);
            outboundDataOperation.addAttribute("tableId", tableId);
        }
        List dataIdsPerAlterExpression = stmt.getAlterExpressions().stream().map(this::extractColumnNames).map(l -> l.stream().map(StringUtilities::unquote).map(cn -> datasetId + cn).map(CString::valueOf).collect(Collectors.toList())).collect(Collectors.toList());
        List dataIds = dataIdsPerAlterExpression.stream().flatMap(Collection::stream).collect(Collectors.toList());
        dataIds.removeAll(outboundDataOperation.getDataIds());
        outboundDataOperation.addDataIds(dataIds);
        List alterExpressionIds = (List)outboundDataOperation.getAttribute("alterExpressionIds");
        if (alterExpressionIds == null) {
            alterExpressionIds = IntStream.range(0, stmt.getAlterExpressions().size()).mapToObj(i -> new AbstractMap.SimpleEntry(stmt.getAlterExpressions().get(i), ((List)dataIdsPerAlterExpression.get(i)).stream().map(CString::toString).collect(Collectors.toList()))).collect(Collectors.toList());
            outboundDataOperation.addAttribute("alterExpressionIds", alterExpressionIds);
        } else {
            alterExpressionIds.addAll(IntStream.range(0, stmt.getAlterExpressions().size()).mapToObj(i -> new AbstractMap.SimpleEntry(stmt.getAlterExpressions().get(i), ((List)dataIdsPerAlterExpression.get(i)).stream().map(CString::toString).collect(Collectors.toList()))).collect(Collectors.toList()));
        }
        SQLDatabaseSchema databaseSchema = this.getDatabaseSchema(ctx);
        List<String> datasetDefinition = databaseSchema.getDatasetDefinition(datasetId);
        if (datasetDefinition == null) {
            datasetDefinition = dataIds.stream().map(CString::toString).collect(Collectors.toList());
            databaseSchema.addDatasetDefinition(datasetId, datasetDefinition);
        }
        for (AlterExpression alterExpression : stmt.getAlterExpressions()) {
            String columnName = alterExpression.getColumnName();
            if (columnName == null) continue;
            String dataId = datasetId + columnName;
            if (alterExpression.getOperation() == AlterOperation.ADD) {
                if (datasetDefinition.contains(dataId)) continue;
                datasetDefinition.add(dataId);
                continue;
            }
            if (alterExpression.getOperation() != AlterOperation.DROP || !datasetDefinition.contains(dataId)) continue;
            datasetDefinition.remove(dataId);
        }
        return outboundDataOperation;
    }

    private List<String> extractColumnNames(AlterExpression alterExpression) {
        String columnName = alterExpression.getColumnName();
        if (columnName != null) {
            return Collections.singletonList(columnName);
        }
        List colDataTypes = alterExpression.getColDataTypeList();
        if (colDataTypes != null) {
            return colDataTypes.stream().map(AlterExpression.ColumnDataType::getColumnName).collect(Collectors.toList());
        }
        List pkColumns = alterExpression.getPkColumns();
        if (pkColumns != null) {
            return pkColumns;
        }
        List ukColumns = alterExpression.getUkColumns();
        if (ukColumns != null) {
            return ukColumns;
        }
        List fkColumns = alterExpression.getFkColumns();
        if (fkColumns != null) {
            return fkColumns;
        }
        Index index = alterExpression.getIndex();
        if (index != null) {
            return index.getColumnsNames();
        }
        return Collections.emptyList();
    }

    private PgsqlStatement<Alter> modifyAlterTableStatement(ChannelHandlerContext ctx, PgsqlStatement<Alter> statement, OutboundDataOperation outboundDataOperation, boolean newStatement) {
        Alter stmt;
        block10: {
            stmt = statement.getStatement();
            if (newStatement) {
                String sql = stmt.toString();
                try {
                    stmt = (Alter)CCJSqlParserUtil.parse((String)sql);
                }
                catch (JSQLParserException | TokenMgrError e2) {
                    LOGGER.error("Parsing error for {} : ", (Object)sql);
                    if (!LOGGER.isTraceEnabled()) break block10;
                    LOGGER.trace("Parsing error details:", e2);
                }
            }
        }
        Alter alterTable = stmt;
        int involvedBackend = outboundDataOperation.getInvolvedCSP() == -1 ? this.getPreferredBackend(ctx) : outboundDataOperation.getInvolvedCSP();
        List alterExpressionIds = (List)outboundDataOperation.getAttribute("alterExpressionIds");
        List dataIdsPerAlterExpression = alterExpressionIds.stream().map(Map.Entry::getValue).collect(Collectors.toList());
        List newDataIds1 = outboundDataOperation.getDataIds().stream().map(CString::toString).collect(Collectors.toList());
        MetadataOperation metadataOperation1 = new MetadataOperation();
        List allDataIds1 = dataIdsPerAlterExpression.stream().flatMap(Collection::stream).map(CString::valueOf).collect(Collectors.toList());
        metadataOperation1.setDataIds(allDataIds1);
        List metadata1 = this.newMetaDataOperation(ctx, metadataOperation1).getMetadata();
        Map<String, List> rawDataIdsMapping1 = metadata1.stream().collect(Collectors.toMap(e -> ((CString)e.getKey()).toString(), e -> ((List)e.getValue()).isEmpty() ? Collections.emptyList() : Collections.singletonList(StringUtilities.toString((CharSequence)((CharSequence)((List)e.getValue()).get(involvedBackend)))), (l1, l2) -> l1));
        Map dataIdsMapping1 = allDataIds1.stream().distinct().map(CString::toString).collect(Collectors.toMap(java.util.function.Function.identity(), id -> (List)rawDataIdsMapping1.get(id)));
        Map<String, List> fqDataIdsMapping1 = dataIdsMapping1.entrySet().stream().filter(e -> ((String)e.getKey()).lastIndexOf(47) != -1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map.Entry tableIdMapping = fqDataIdsMapping1.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty() && ((List)e.getValue()).get(0) != null).findAny().map(e -> new AbstractMap.SimpleEntry<String, String>(((String)e.getKey()).substring(0, ((String)e.getKey()).lastIndexOf(47)), ((String)((List)e.getValue()).get(0)).substring(0, ((String)((List)e.getValue()).get(0)).lastIndexOf(47)))).orElse(fqDataIdsMapping1.keySet().stream().findAny().map(id -> new AbstractMap.SimpleEntry<String, String>(id.substring(0, id.lastIndexOf(47)), id.substring(0, id.lastIndexOf(47)))).get());
        int nbAlterExpressions = alterTable.getAlterExpressions().size();
        ArrayList<AlterExpression> newAlterExpressions = new ArrayList<AlterExpression>(nbAlterExpressions);
        for (int i = 0; i < nbAlterExpressions; ++i) {
            AlterExpression newAlterExpression;
            AlterExpression alterExpression = (AlterExpression)alterTable.getAlterExpressions().get(i);
            List dataIds = (List)dataIdsPerAlterExpression.get(i);
            if (dataIds.isEmpty()) {
                newAlterExpression = alterExpression;
            } else {
                List alterExpressionProtectedDataIds = dataIdsMapping1.entrySet().stream().filter(e -> dataIds.contains(e.getKey())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
                if (alterExpressionProtectedDataIds.isEmpty()) {
                    newAlterExpression = alterExpression;
                } else {
                    List newAlterExpressionsDataIds = alterExpressionProtectedDataIds.stream().filter(newDataIds1::contains).collect(Collectors.toList());
                    if (newAlterExpressionsDataIds.isEmpty()) {
                        newAlterExpression = null;
                    } else {
                        List<String> oldDataIds = dataIds.stream().sorted().collect(Collectors.toList());
                        List<String> newDataIds = newAlterExpressionsDataIds.stream().sorted().collect(Collectors.toList());
                        boolean same = newDataIds.equals(oldDataIds);
                        newAlterExpression = same ? alterExpression : this.buildAlterExpression(alterExpression, oldDataIds, newDataIds);
                    }
                }
            }
            if (newAlterExpression == null) continue;
            newAlterExpressions.add(newAlterExpression);
        }
        alterTable.setAlterExpressions(newAlterExpressions);
        Table table = alterTable.getTable();
        Table newTable = null;
        String oldTableId = (String)tableIdMapping.getKey();
        String newTableId = (String)tableIdMapping.getValue();
        boolean same = newTableId.equals(oldTableId);
        newTable = same ? table : this.buildTable(table, newTableId);
        alterTable.setTable(newTable);
        return new PgsqlStatement<Alter>(stmt, statement.getParameterTypes(), statement.getParameterFormats(), statement.getParameterValues(), statement.getResultFormats(), statement.getColumns());
    }

    private AlterExpression buildAlterExpression(AlterExpression alterExpression, List<String> oldDataIds, List<String> newDataIds) {
        List oldColumnNames = oldDataIds.stream().map(id -> id.split("/")).map(tk -> tk[((String[])tk).length - 1]).collect(Collectors.toList());
        List newColumnNames = newDataIds.stream().map(id -> id.split("/")).map(tk -> tk[((String[])tk).length - 1]).collect(Collectors.toList());
        AlterExpression newAlterExpression = new AlterExpression();
        newAlterExpression.setOperation(alterExpression.getOperation());
        if (alterExpression.getColumnName() != null) {
            int idx = oldColumnNames.indexOf(alterExpression.getColumnName());
            if (idx != -1) {
                newAlterExpression.setColumnName((String)newColumnNames.get(idx));
            } else {
                newAlterExpression.setColumnName(alterExpression.getColumnName());
            }
        } else if (alterExpression.getColDataTypeList() != null) {
            alterExpression.getColDataTypeList().forEach(cdt -> {
                int idx = oldColumnNames.indexOf(cdt.getColumnName());
                if (idx != -1) {
                    newAlterExpression.addColDataType((String)newColumnNames.get(idx), cdt.getColDataType());
                } else {
                    newAlterExpression.addColDataType(cdt.getColumnName(), cdt.getColDataType());
                }
            });
        } else if (alterExpression.getConstraintName() != null) {
            alterExpression.setConstraintName(alterExpression.getConstraintName());
        } else if (alterExpression.getPkColumns() != null) {
            newAlterExpression.setPkColumns(alterExpression.getPkColumns().stream().map(pkc -> {
                int idx = oldColumnNames.indexOf(pkc);
                return idx != -1 ? (String)newColumnNames.get(idx) : pkc;
            }).collect(Collectors.toList()));
        } else if (alterExpression.getUkColumns() != null) {
            newAlterExpression.setUkName(alterExpression.getUkName());
            newAlterExpression.setUkColumns(alterExpression.getUkColumns().stream().map(ukc -> {
                int idx = oldColumnNames.indexOf(ukc);
                return idx != -1 ? (String)newColumnNames.get(idx) : ukc;
            }).collect(Collectors.toList()));
        } else if (alterExpression.getFkColumns() != null) {
            newAlterExpression.setFkColumns(alterExpression.getFkColumns().stream().map(fkc -> {
                int idx = oldColumnNames.indexOf(fkc);
                return idx != -1 ? (String)newColumnNames.get(idx) : fkc;
            }).collect(Collectors.toList()));
            newAlterExpression.setFkSourceTable(alterExpression.getFkSourceTable());
            newAlterExpression.setFkSourceColumns(alterExpression.getFkSourceColumns());
            newAlterExpression.setOnDeleteCascade(alterExpression.isOnDeleteCascade());
            newAlterExpression.setOnDeleteRestrict(alterExpression.isOnDeleteRestrict());
            newAlterExpression.setOnDeleteSetNull(alterExpression.isOnDeleteSetNull());
        } else if (alterExpression.getIndex() != null) {
            Index oldIndex = alterExpression.getIndex();
            Index newIndex = new Index();
            newIndex.setType(oldIndex.getType());
            newIndex.setColumnsNames(oldIndex.getColumnsNames().stream().map(cn -> {
                int idx = oldColumnNames.indexOf(cn);
                return idx != -1 ? (String)newColumnNames.get(idx) : cn;
            }).collect(Collectors.toList()));
            newIndex.setName(oldIndex.getName());
            newIndex.setIndexSpec(oldIndex.getIndexSpec());
            newAlterExpression.setIndex(newIndex);
        }
        return newAlterExpression;
    }

    private OutboundDataOperation extractCreateIndexOperation(ChannelHandlerContext ctx, CreateIndex stmt, OutboundDataOperation outboundDataOperation, Operation operation) throws ParseException {
        List columnNames;
        String schemaId = this.getSchemaId(ctx, stmt.getTable());
        String datasetId = this.getTableId(ctx, stmt.getTable(), schemaId);
        if (outboundDataOperation == null || operation != null && outboundDataOperation.getOperation() != operation) {
            outboundDataOperation = new OutboundDataOperation();
            outboundDataOperation.setOperation(operation != null ? operation : Operation.UPDATE);
            outboundDataOperation.setUsingHeadOperation(true);
            AbstractMap.SimpleEntry<Table, String> tableId = new AbstractMap.SimpleEntry<Table, String>(stmt.getTable(), datasetId);
            outboundDataOperation.addAttribute("tableId", tableId);
        }
        if ((columnNames = stmt.getIndex().getColumnsNames()) == null) {
            columnNames = Collections.emptyList();
        }
        List dataIds = columnNames.stream().map(StringUtilities::unquote).map(cn -> datasetId + cn).map(CString::valueOf).collect(Collectors.toList());
        dataIds.removeAll(outboundDataOperation.getDataIds());
        outboundDataOperation.addDataIds(dataIds);
        AbstractMap.SimpleEntry createIndexMethodIds = new AbstractMap.SimpleEntry(stmt.getMethod(), dataIds.stream().map(CString::toString).collect(Collectors.toList()));
        outboundDataOperation.addAttribute("createIndexMethodIds", createIndexMethodIds);
        return outboundDataOperation;
    }

    private PgsqlStatement<CreateIndex> modifyCreateIndexStatement(ChannelHandlerContext ctx, PgsqlStatement<CreateIndex> statement, OutboundDataOperation outboundDataOperation, boolean newStatement) {
        CreateIndex stmt;
        block10: {
            stmt = statement.getStatement();
            if (newStatement) {
                String sql = stmt.toString();
                try {
                    stmt = (CreateIndex)CCJSqlParserUtil.parse((String)sql);
                }
                catch (JSQLParserException | TokenMgrError e2) {
                    LOGGER.error("Parsing error for {} : ", (Object)sql);
                    if (!LOGGER.isTraceEnabled()) break block10;
                    LOGGER.trace("Parsing error details:", e2);
                }
            }
        }
        CreateIndex createIndex = stmt;
        int involvedBackend = outboundDataOperation.getInvolvedCSP() == -1 ? this.getPreferredBackend(ctx) : outboundDataOperation.getInvolvedCSP();
        Map.Entry createIndexMethodIds = (Map.Entry)outboundDataOperation.getAttribute("createIndexMethodIds");
        List dataIds = (List)createIndexMethodIds.getValue();
        List newDataIds1 = outboundDataOperation.getDataIds().stream().map(CString::toString).collect(Collectors.toList());
        MetadataOperation metadataOperation1 = new MetadataOperation();
        List allDataIds1 = dataIds.stream().map(CString::valueOf).collect(Collectors.toList());
        metadataOperation1.setDataIds(allDataIds1);
        List metadata1 = this.newMetaDataOperation(ctx, metadataOperation1).getMetadata();
        Map<String, List> rawDataIdsMapping1 = metadata1.stream().collect(Collectors.toMap(e -> ((CString)e.getKey()).toString(), e -> ((List)e.getValue()).isEmpty() ? Collections.emptyList() : Collections.singletonList(StringUtilities.toString((CharSequence)((CharSequence)((List)e.getValue()).get(involvedBackend)))), (l1, l2) -> l1));
        Map dataIdsMapping1 = allDataIds1.stream().distinct().map(CString::toString).collect(Collectors.toMap(java.util.function.Function.identity(), id -> (List)rawDataIdsMapping1.get(id)));
        Map<String, List> fqDataIdsMapping1 = dataIdsMapping1.entrySet().stream().filter(e -> ((String)e.getKey()).lastIndexOf(47) != -1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        Map.Entry tableIdMapping = fqDataIdsMapping1.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty() && ((List)e.getValue()).get(0) != null).findAny().map(e -> new AbstractMap.SimpleEntry<String, String>(((String)e.getKey()).substring(0, ((String)e.getKey()).lastIndexOf(47)), ((String)((List)e.getValue()).get(0)).substring(0, ((String)((List)e.getValue()).get(0)).lastIndexOf(47)))).orElse(fqDataIdsMapping1.keySet().stream().findAny().map(id -> new AbstractMap.SimpleEntry<String, String>(id.substring(0, id.lastIndexOf(47)), id.substring(0, id.lastIndexOf(47)))).get());
        int nbColumns = createIndex.getIndex().getColumnsNames() != null ? createIndex.getIndex().getColumnsNames().size() : 0;
        ArrayList<String> newColumnNames = new ArrayList<String>(nbColumns);
        for (int i = 0; i < nbColumns; ++i) {
            String newColumnName;
            String columnName = (String)createIndex.getIndex().getColumnsNames().get(i);
            String dataId = (String)dataIds.get(i);
            if (dataId == null) {
                newColumnName = columnName;
            } else {
                List columnProtectedDataIds = dataIdsMapping1.entrySet().stream().filter(e -> dataId.equals(e.getKey())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
                if (columnProtectedDataIds.isEmpty()) {
                    newColumnName = columnName;
                } else {
                    List newColumnDataIds = columnProtectedDataIds.stream().filter(newDataIds1::contains).collect(Collectors.toList());
                    if (newColumnDataIds.isEmpty()) {
                        newColumnName = null;
                    } else {
                        String oldDataId = dataId;
                        String newDataId = (String)newColumnDataIds.get(0);
                        boolean same = newDataId.equals(oldDataId);
                        newColumnName = same ? columnName : this.buildColumnName(columnName, newDataId);
                    }
                }
            }
            if (newColumnName == null) continue;
            newColumnNames.add(newColumnName);
        }
        createIndex.getIndex().setColumnsNames(newColumnNames);
        Table table = createIndex.getTable();
        Table newTable = null;
        String oldTableId = (String)tableIdMapping.getKey();
        String newTableId = (String)tableIdMapping.getValue();
        boolean same = newTableId.equals(oldTableId);
        newTable = same ? table : this.buildTable(table, newTableId);
        createIndex.setTable(newTable);
        return new PgsqlStatement<CreateIndex>(stmt, statement.getParameterTypes(), statement.getParameterFormats(), statement.getParameterValues(), statement.getResultFormats(), statement.getColumns());
    }

    private String buildColumnName(String columnName, String newDataId) {
        String[] tokens = newDataId.split("/");
        assert (tokens.length > 0);
        String newColumnName = tokens[tokens.length - 1];
        return newColumnName;
    }

    private OutboundDataOperation extractDropTableOperation(ChannelHandlerContext ctx, Drop stmt) throws ParseException {
        OutboundDataOperation outboundDataOperation = new OutboundDataOperation();
        outboundDataOperation.setOperation(Operation.DELETE);
        String schemaId = this.getSchemaId(ctx, stmt.getName());
        String datasetId = this.getTableId(ctx, stmt.getName(), schemaId);
        AbstractMap.SimpleEntry<Table, String> tableId = new AbstractMap.SimpleEntry<Table, String>(stmt.getName(), datasetId);
        outboundDataOperation.addAttribute("tableId", tableId);
        List dataIds = Stream.of(CString.valueOf((CharSequence)(datasetId + "*"))).collect(Collectors.toList());
        outboundDataOperation.setDataIds(dataIds);
        return outboundDataOperation;
    }

    private PgsqlStatement<Drop> modifyDropTableStatement(ChannelHandlerContext ctx, PgsqlStatement<Drop> statement, OutboundDataOperation outboundDataOperation, boolean newStatement) {
        Drop stmt;
        block3: {
            stmt = statement.getStatement();
            if (newStatement) {
                String sql = stmt.toString();
                try {
                    stmt = (Drop)CCJSqlParserUtil.parse((String)sql);
                }
                catch (JSQLParserException | TokenMgrError e) {
                    LOGGER.error("Parsing error for {} : ", (Object)sql);
                    if (!LOGGER.isTraceEnabled()) break block3;
                    LOGGER.trace("Parsing error details:", e);
                }
            }
        }
        Drop dropTable = stmt;
        Map.Entry table2tableId = (Map.Entry)outboundDataOperation.getAttribute("tableId");
        String oldTableId = (String)table2tableId.getValue();
        List newDataIds1 = outboundDataOperation.getDataIds().stream().map(CString::toString).collect(Collectors.toList());
        String newTableId = newDataIds1.stream().filter(id -> id.lastIndexOf(47) != -1).findAny().get();
        newTableId = newTableId.substring(0, newTableId.lastIndexOf(47));
        Table table = dropTable.getName();
        Table newTable = null;
        boolean same = newTableId.equals(oldTableId);
        newTable = same ? table : this.buildTable(table, newTableId);
        dropTable.setName(newTable);
        return new PgsqlStatement<Drop>(stmt, statement.getParameterTypes(), statement.getParameterFormats(), statement.getParameterValues(), statement.getResultFormats(), statement.getColumns());
    }

    private OutboundDataOperation extractInsertOperation(ChannelHandlerContext ctx, Insert stmt, List<ParameterValue> parameterValues, OutboundDataOperation outboundDataOperation) throws ParseException {
        String datasetId;
        String schemaId;
        if (outboundDataOperation == null) {
            outboundDataOperation = new OutboundDataOperation();
            outboundDataOperation.setOperation(Operation.CREATE);
            schemaId = this.getSchemaId(ctx, stmt.getTable());
            datasetId = this.getTableId(ctx, stmt.getTable(), schemaId);
            AbstractMap.SimpleEntry<Table, String> tableId = new AbstractMap.SimpleEntry<Table, String>(stmt.getTable(), datasetId);
            outboundDataOperation.addAttribute("tableId", tableId);
            if (stmt.getColumns() == null) {
                List dataIds;
                SQLDatabaseSchema databaseSchema = this.getDatabaseSchema(ctx);
                List<String> datasetDefinition = databaseSchema.getDatasetDefinition(datasetId);
                if (datasetDefinition != null) {
                    dataIds = datasetDefinition.stream().map(CString::valueOf).collect(Collectors.toList());
                } else {
                    MetadataOperation metadataOperation = new MetadataOperation();
                    metadataOperation.addDataId(CString.valueOf((CharSequence)(datasetId + "*")));
                    dataIds = this.newMetaDataOperation(ctx, metadataOperation).getDataIds();
                }
                outboundDataOperation.setDataIds(dataIds);
            } else {
                List dataIds = stmt.getColumns().stream().map(Column::getColumnName).map(StringUtilities::unquote).map(cn -> datasetId + cn).map(CString::valueOf).collect(Collectors.toList());
                List columnIds = IntStream.range(0, stmt.getColumns().size()).mapToObj(i -> new AbstractMap.SimpleEntry(stmt.getColumns().get(i), ((CString)dataIds.get(i)).toString())).collect(Collectors.toList());
                outboundDataOperation.addAttribute("columnIds", columnIds);
                outboundDataOperation.setDataIds(dataIds);
            }
        } else if (outboundDataOperation.getAttribute("columnIds") == null && stmt.getColumns() != null) {
            schemaId = this.getSchemaId(ctx, stmt.getTable());
            datasetId = this.getTableId(ctx, stmt.getTable(), schemaId);
            List dataIds = stmt.getColumns().stream().map(Column::getColumnName).map(StringUtilities::unquote).map(cn -> datasetId + cn).map(CString::valueOf).collect(Collectors.toList());
            List columnIds = IntStream.range(0, stmt.getColumns().size()).mapToObj(i -> new AbstractMap.SimpleEntry(stmt.getColumns().get(i), ((CString)dataIds.get(i)).toString())).collect(Collectors.toList());
            outboundDataOperation.addAttribute("columnIds", columnIds);
        }
        List rows = null;
        if (stmt.getItemsList() instanceof ExpressionList) {
            rows = Collections.singletonList((ExpressionList)stmt.getItemsList());
        } else if (stmt.getItemsList() instanceof MultiExpressionList) {
            rows = ((MultiExpressionList)stmt.getItemsList()).getExprList();
        }
        if (rows != null) {
            for (ExpressionList row : rows) {
                List dataValue = row.getExpressions().stream().map(exp -> exp instanceof NullValue ? null : exp.toString()).map(StringUtilities::unquote).map(CString::valueOf).map(value -> {
                    if (parameterValues != null && value != null && value.charAt(0) == '$') {
                        int idx = Integer.parseInt(value.substring(1).toString()) - 1;
                        ParameterValue parameterValue = (ParameterValue)parameterValues.get(idx);
                        Types types = this.getTypes(ctx, -1);
                        Type parameterType = types.getType(parameterValue.getType());
                        value = this.convertToText(parameterType, -1, parameterValue.getFormat(), parameterValue.getValue());
                    }
                    return value;
                }).collect(Collectors.toList());
                outboundDataOperation.addDataValue(dataValue);
            }
        }
        return outboundDataOperation;
    }

    private PgsqlStatement<Insert> modifyInsertStatement(ChannelHandlerContext ctx, PgsqlStatement<Insert> statement, OutboundDataOperation outboundDataOperation, boolean newStatement, int row) {
        String newTableId;
        String dataId;
        ArrayList<Integer> newDataIdIndexes;
        AbstractMap.SimpleEntry<String, String> tableIdMapping;
        List newDataIds1;
        int involvedBackend;
        Insert stmt;
        block34: {
            stmt = statement.getStatement();
            if (newStatement) {
                String sql = stmt.toString();
                try {
                    stmt = (Insert)CCJSqlParserUtil.parse((String)sql);
                }
                catch (JSQLParserException | TokenMgrError e2) {
                    LOGGER.error("Parsing error for {} : ", (Object)sql);
                    if (!LOGGER.isTraceEnabled()) break block34;
                    LOGGER.trace("Parsing error details:", e2);
                }
            }
        }
        Insert insert = stmt;
        int n = involvedBackend = outboundDataOperation.getInvolvedCSP() == -1 ? this.getPreferredBackend(ctx) : outboundDataOperation.getInvolvedCSP();
        if (insert.getColumns() != null) {
            List columnIds = (List)outboundDataOperation.getAttribute("columnIds");
            List dataIdPerColumn = columnIds.stream().map(Map.Entry::getValue).collect(Collectors.toList());
            newDataIds1 = outboundDataOperation.getDataIds().stream().map(CString::toString).collect(Collectors.toList());
            MetadataOperation metadataOperation1 = new MetadataOperation();
            List allDataIds1 = dataIdPerColumn.stream().map(CString::valueOf).collect(Collectors.toList());
            metadataOperation1.setDataIds(allDataIds1);
            List metadata1 = this.newMetaDataOperation(ctx, metadataOperation1).getMetadata();
            Map<String, List> rawDataIdsMapping1 = metadata1.stream().collect(Collectors.toMap(e -> ((CString)e.getKey()).toString(), e -> ((List)e.getValue()).isEmpty() ? Collections.emptyList() : Collections.singletonList(StringUtilities.toString((CharSequence)((CharSequence)((List)e.getValue()).get(involvedBackend)))), (l1, l2) -> l1));
            Map dataIdsMapping1 = allDataIds1.stream().distinct().map(CString::toString).collect(Collectors.toMap(java.util.function.Function.identity(), id -> (List)rawDataIdsMapping1.get(id)));
            Map<String, List> fqDataIdsMapping1 = dataIdsMapping1.entrySet().stream().filter(e -> ((String)e.getKey()).lastIndexOf(47) != -1).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            tableIdMapping = fqDataIdsMapping1.entrySet().stream().filter(e -> !((List)e.getValue()).isEmpty() && ((List)e.getValue()).get(0) != null).findAny().map(e -> new AbstractMap.SimpleEntry<String, String>(((String)e.getKey()).substring(0, ((String)e.getKey()).lastIndexOf(47)), ((String)((List)e.getValue()).get(0)).substring(0, ((String)((List)e.getValue()).get(0)).lastIndexOf(47)))).orElse(fqDataIdsMapping1.keySet().stream().findAny().map(id -> new AbstractMap.SimpleEntry<String, String>(id.substring(0, id.lastIndexOf(47)), id.substring(0, id.lastIndexOf(47)))).get());
            int nbColumns = insert.getColumns().size();
            newDataIdIndexes = new ArrayList<Integer>(nbColumns);
            ArrayList<Column> newColumns = new ArrayList<Column>(nbColumns);
            ArrayList<String> newDataIds = new ArrayList<String>(nbColumns);
            for (int i = 0; i < nbColumns; ++i) {
                String newDataId;
                Column newColumn;
                Column column = (Column)insert.getColumns().get(i);
                dataId = (String)dataIdPerColumn.get(i);
                if (dataId == null) {
                    newColumn = column;
                    newDataId = dataId;
                } else {
                    List columnProtectedDataIds = dataIdsMapping1.entrySet().stream().filter(e -> dataId.contains((CharSequence)e.getKey())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
                    if (columnProtectedDataIds.isEmpty()) {
                        newColumn = column;
                        newDataId = dataId;
                    } else {
                        List newColumnDataIds = columnProtectedDataIds.stream().filter(newDataIds1::contains).collect(Collectors.toList());
                        if (newColumnDataIds.isEmpty()) {
                            newColumn = null;
                            newDataId = null;
                        } else {
                            String oldDataId = dataId;
                            newDataId = (String)newColumnDataIds.get(0);
                            boolean same = newDataId.equals(oldDataId);
                            newColumn = same ? column : this.buildColumn(column, oldDataId, newDataId);
                        }
                    }
                }
                if (newColumn != null) {
                    newDataIdIndexes.add(newColumns.size());
                    newColumns.add(newColumn);
                } else {
                    newDataIdIndexes.add(-1);
                }
                if (newDataId == null) continue;
                newDataIds.add(newDataId);
            }
            for (int c = 0; c < newDataIds1.size(); ++c) {
                if (newDataIds.contains(newDataIds1.get(c))) continue;
                newDataIdIndexes.add(newColumns.size());
                Column newColumn = this.buildColumn(null, null, (String)newDataIds1.get(c));
                newColumns.add(newColumn);
            }
            insert.setColumns(newColumns);
        } else {
            Map.Entry table2tableId = (Map.Entry)outboundDataOperation.getAttribute("tableId");
            String tableId = (String)table2tableId.getValue();
            newDataIds1 = outboundDataOperation.getDataIds().stream().map(CString::toString).collect(Collectors.toList());
            newTableId = newDataIds1.stream().filter(id -> id.lastIndexOf(47) != -1).findAny().get();
            newTableId = newTableId.substring(0, newTableId.lastIndexOf(47));
            SQLDatabaseSchema databaseSchema = this.getDatabaseSchema(ctx);
            List<String> datasetDefinition = databaseSchema.getDatasetDefinition(tableId);
            List<Object> allDataIds1 = datasetDefinition != null ? datasetDefinition.stream().map(CString::valueOf).collect(Collectors.toList()) : Collections.singletonList(CString.valueOf((CharSequence)(tableId + "*")));
            MetadataOperation metadataOperation1 = new MetadataOperation();
            metadataOperation1.setDataIds(allDataIds1);
            List metadata1 = this.newMetaDataOperation(ctx, metadataOperation1).getMetadata();
            allDataIds1 = metadata1.stream().map(Map.Entry::getKey).collect(Collectors.toList());
            Map<String, List> rawDataIdsMapping1 = metadata1.stream().collect(Collectors.toMap(e -> ((CString)e.getKey()).toString(), e -> ((List)e.getValue()).isEmpty() ? Collections.emptyList() : Collections.singletonList(StringUtilities.toString((CharSequence)((CharSequence)((List)e.getValue()).get(involvedBackend)))), (l1, l2) -> l1));
            Map dataIdsMapping1 = allDataIds1.stream().distinct().map(CString::toString).collect(Collectors.toMap(java.util.function.Function.identity(), id -> (List)rawDataIdsMapping1.get(id)));
            tableIdMapping = new AbstractMap.SimpleEntry<String, String>(tableId, newTableId);
            int nbColumns = -1;
            ItemsList itemsList = insert.getItemsList();
            if (itemsList instanceof ExpressionList) {
                nbColumns = ((ExpressionList)itemsList).getExpressions().size();
            } else if (itemsList instanceof MultiExpressionList) {
                nbColumns = ((ExpressionList)((MultiExpressionList)itemsList).getExprList().get(0)).getExpressions().size();
            } else if (itemsList instanceof SubSelect) {
                // empty if block
            }
            newDataIdIndexes = nbColumns != -1 ? new ArrayList(nbColumns) : new ArrayList();
            for (int i = 0; i < nbColumns; ++i) {
                List newColumnDataIds;
                List columnProtectedDataIds;
                dataId = ((CString)allDataIds1.get(i)).toString();
                int newIndex = dataId == null ? i : ((columnProtectedDataIds = dataIdsMapping1.entrySet().stream().filter(e -> dataId.contains((CharSequence)e.getKey())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList())).isEmpty() ? i : ((newColumnDataIds = columnProtectedDataIds.stream().filter(newDataIds1::contains).collect(Collectors.toList())).isEmpty() ? -1 : i));
                newDataIdIndexes.add(newIndex);
            }
            for (int c = newDataIdIndexes.size(); c < newDataIds1.size(); ++c) {
                newDataIdIndexes.add(c);
            }
        }
        Table table = insert.getTable();
        Table newTable = null;
        String oldTableId = (String)tableIdMapping.getKey();
        newTableId = (String)tableIdMapping.getValue();
        boolean same = newTableId.equals(oldTableId);
        newTable = same ? table : this.buildTable(table, newTableId);
        insert.setTable(newTable);
        ItemsList itemsList = insert.getItemsList();
        List expressionLists = null;
        if (itemsList instanceof ExpressionList) {
            expressionLists = Collections.singletonList((ExpressionList)itemsList);
        } else if (itemsList instanceof MultiExpressionList) {
            expressionLists = ((MultiExpressionList)itemsList).getExprList();
        } else if (itemsList instanceof SubSelect) {
            // empty if block
        }
        if (expressionLists != null) {
            List<ParameterValue> parameterValues = statement.getParameterValues();
            for (ExpressionList expressionList : expressionLists) {
                int newDataIdIndex;
                List expressions = expressionList.getExpressions();
                List dataValues = (List)outboundDataOperation.getDataValues().get(row++);
                ArrayList<Expression> newExpressions = new ArrayList<Expression>(dataValues.size());
                for (int i = 0; i < expressions.size(); ++i) {
                    Expression newExpression;
                    String newValue;
                    newDataIdIndex = (Integer)newDataIdIndexes.get(i);
                    if (newDataIdIndex == -1) continue;
                    Expression expression = (Expression)expressions.get(i);
                    String oldValue = expression instanceof StringValue ? ((StringValue)expression).getValue() : (expression instanceof NullValue ? null : expression.toString());
                    String string = newValue = dataValues.get(newDataIdIndex) != null ? ((CString)dataValues.get(newDataIdIndex)).toString() : null;
                    boolean bl = newValue == null ? oldValue == null : (same = newValue.equals(oldValue));
                    if (same) {
                        newExpression = expression;
                        if (oldValue != null && oldValue.charAt(0) == '$' && parameterValues != null) {
                            int paramIndex = Integer.parseInt(oldValue.substring(1)) - 1;
                            ParameterValue parameterValue = parameterValues.get(paramIndex);
                            Types backendTypes = this.getTypes(ctx, involvedBackend);
                            Type parameterType = backendTypes.getType(parameterValue.getType());
                            ByteBuf value = this.convertToByteBuf(parameterType, -1, parameterValue.getFormat(), (CString)dataValues.get(newDataIdIndex));
                            parameterValue.setValue(value);
                        }
                    } else {
                        newExpression = this.buildExpression(expression, oldValue, newValue);
                    }
                    newExpressions.add(newExpression);
                }
                for (int c = expressions.size(); c < newDataIdIndexes.size(); ++c) {
                    newDataIdIndex = (Integer)newDataIdIndexes.get(c);
                    if (newDataIdIndex == -1) continue;
                    String newValue = dataValues.get(newDataIdIndex) != null ? ((CString)dataValues.get(newDataIdIndex)).toString() : null;
                    Expression newExpression = this.buildExpression(null, null, newValue);
                    newExpressions.add(newExpression);
                }
                expressionList.setExpressions(newExpressions);
            }
        }
        return new PgsqlStatement<Insert>(stmt, statement.getParameterTypes(), statement.getParameterFormats(), statement.getParameterValues(), statement.getResultFormats(), statement.getColumns());
    }

    private Insert buildInsertStatement(ChannelHandlerContext ctx, List<String> dataIds, List<String> dataValues) {
        List tokens = dataIds.stream().map(dataId -> dataId.split("[/\\.]")).collect(Collectors.toList());
        String newTableName = tokens.stream().map(tk -> ((String[])tk).length > 1 ? tk[((String[])tk).length - 2] : null).filter(s -> s != null).distinct().findFirst().orElseThrow(IllegalArgumentException::new);
        String newSchemaName = tokens.stream().map(tk -> ((String[])tk).length > 2 ? tk[((String[])tk).length - 3] : null).filter(s -> s != null).distinct().findFirst().orElse(this.identifySchema(newTableName));
        String newDatabaseName = tokens.stream().map(tk -> ((String[])tk).length > 3 ? tk[((String[])tk).length - 4] : null).filter(s -> s != null).distinct().findFirst().orElse(this.getDatabaseName(ctx));
        Database newDatabase = new Database(StringUtilities.quote((String)newDatabaseName));
        Table newTable = new Table(newDatabase, StringUtilities.quote((String)newSchemaName), StringUtilities.quote((String)newTableName));
        Insert insert = new Insert();
        insert.setTable(newTable);
        List newColumns = dataIds.stream().map(dataId -> this.buildColumn(null, null, (String)dataId)).collect(Collectors.toList());
        insert.setColumns(newColumns);
        insert.setUseValues(true);
        List expressions = dataValues.stream().map(value -> this.buildExpression(null, null, (String)value)).collect(Collectors.toList());
        insert.setItemsList((ItemsList)new ExpressionList(expressions));
        return insert;
    }

    private Column buildColumn(Column column, String oldDataId, String newDataId) {
        String[] tokens;
        String oldTableName = null;
        if (oldDataId != null) {
            tokens = oldDataId.split("/");
            assert (tokens.length > 0);
            oldTableName = tokens.length >= 2 ? tokens[tokens.length - 2] : null;
        }
        tokens = newDataId.split("/");
        assert (tokens.length > 0);
        String newDbName = tokens.length >= 3 ? tokens[tokens.length - 3] : null;
        String newTableName = tokens.length >= 2 ? tokens[tokens.length - 2] : null;
        String newColumnName = tokens[tokens.length - 1];
        newColumnName = StringUtilities.quote((String)newColumnName);
        Table table = column != null ? column.getTable() : null;
        Table newTable = null;
        if (table != null && !table.getFullyQualifiedName().isEmpty() && newTableName != null) {
            boolean alias;
            Database newDatabase = null;
            String newSchemaName = null;
            boolean bl = alias = !table.getFullyQualifiedName().equalsIgnoreCase(oldTableName);
            if (alias) {
                newTableName = table.getFullyQualifiedName();
            } else {
                String[] tokens2;
                if (table.getDatabase() != null && !table.getDatabase().getFullyQualifiedName().isEmpty() && newDbName != null) {
                    newDatabase = new Database(newDbName);
                }
                if ((tokens2 = newTableName.split("\\.")).length == 2) {
                    newTableName = tokens2[1];
                }
                if (table.getSchemaName() != null) {
                    newSchemaName = tokens2.length == 2 ? tokens2[0] : "public";
                }
            }
            newTable = new Table(newDatabase, newSchemaName, newTableName);
            newTable.setAlias(table.getAlias());
        }
        Column newColumn = new Column(newTable, newColumnName, column != null ? column.getIndex() : null);
        return newColumn;
    }

    private Expression buildExpression(Expression expression, String oldValue, String newValue) {
        if (newValue == null) {
            return new NullValue();
        }
        if (expression instanceof Column) {
            return this.buildColumn((Column)expression, oldValue, newValue);
        }
        if (expression instanceof StringValue) {
            if (StringUtilities.hasQuote((String)((StringValue)expression).toString()) && !StringUtilities.hasQuote((String)newValue)) {
                newValue = StringUtilities.quote((String)newValue);
            } else if (StringUtilities.hasSingleQuote((String)((StringValue)expression).toString()) && !StringUtilities.hasSingleQuote((String)newValue)) {
                newValue = StringUtilities.singleQuote((String)newValue);
            } else if (((StringValue)expression).toString().startsWith("E'") && !newValue.startsWith("E'")) {
                newValue = "E'" + newValue + "'";
            }
        }
        if (Pattern.compile("\\$\\d+").matcher(newValue).matches()) {
            return new RawStringValue(newValue);
        }
        return new StringValue(newValue);
    }

    private ModuleOperation extractSelectOperation(ChannelHandlerContext ctx, Select stmt, List<ParameterValue> parameterValues, OutboundDataOperation outboundDataOperation, Operation operation) throws ParseException {
        MetadataOperation moduleOperation;
        MetadataOperation metadataOperation;
        if (!(stmt.getSelectBody() instanceof PlainSelect)) {
            return null;
        }
        PlainSelect select = (PlainSelect)stmt.getSelectBody();
        int capacity = (select.getFromItem() instanceof Table ? 1 : 0) + (select.getJoins() != null ? select.getJoins().size() : 0);
        ArrayList<String> schemaIds = new ArrayList<String>(capacity);
        ArrayList<Map.Entry<Table, String>> tableIds = new ArrayList<Map.Entry<Table, String>>(capacity);
        if (select.getFromItem() instanceof Table) {
            Table table = (Table)select.getFromItem();
            String schemaId = this.getSchemaId(ctx, table);
            schemaIds.add(schemaId);
            String tableId = this.getTableId(ctx, table, schemaId);
            tableIds.add(new AbstractMap.SimpleEntry<Table, String>(table, tableId));
            if (select.getJoins() != null) {
                for (Join join : select.getJoins()) {
                    if (!(join.getRightItem() instanceof Table)) continue;
                    table = (Table)join.getRightItem();
                    schemaId = this.getSchemaId(ctx, table);
                    if (!schemaIds.contains(schemaId)) {
                        schemaIds.add(schemaId);
                    }
                    tableId = this.getTableId(ctx, table, schemaId);
                    tableIds.add(new AbstractMap.SimpleEntry<Table, String>(table, tableId));
                }
            }
        } else {
            String schemaId = this.getSchemaId(ctx, null);
            schemaIds.add(schemaId);
            String tableId = this.getTableId(ctx, null, schemaId);
            tableIds.add(new AbstractMap.SimpleEntry<Object, String>(null, tableId));
        }
        ArrayList<AbstractMap.SimpleEntry<SelectItem, Object>> selectItemIds = new ArrayList<AbstractMap.SimpleEntry<SelectItem, Object>>(select.getSelectItems().size());
        boolean metadata = false;
        boolean retrieveProtectedData = false;
        if (operation == null) {
            operation = Operation.READ;
        }
        boolean usingHeadOperation = false;
        if (outboundDataOperation != null) {
            usingHeadOperation = outboundDataOperation.isUsingHeadOperation();
        }
        List<Object> involvedBackends = null;
        Iterator iter = select.getSelectItems().iterator();
        while (iter.hasNext()) {
            SelectItem selectItem = (SelectItem)iter.next();
            if (selectItem instanceof SelectExpressionItem) {
                Object dataIds;
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                if (selectExpressionItem.getExpression() instanceof Function) {
                    String dataId;
                    Function function = (Function)selectExpressionItem.getExpression();
                    if (FUNCTION_METADATA.equalsIgnoreCase(function.getName())) {
                        metadata = true;
                        if (function.isAllColumns()) {
                            metadataOperation = new MetadataOperation();
                            tableIds.stream().map(Map.Entry::getValue).forEach(id -> metadataOperation.addDataId(CString.valueOf((CharSequence)(id + "*"))));
                            List dataIds2 = this.newMetaDataOperation(ctx, metadataOperation).getDataIds();
                            selectItemIds.add(new AbstractMap.SimpleEntry(selectItem, dataIds2.stream().map(CString::toString).collect(Collectors.toList())));
                        } else if (function.getParameters() != null && function.getParameters().getExpressions() != null && !function.getParameters().getExpressions().isEmpty()) {
                            dataIds = new ArrayList<String>();
                            for (Expression parameter2 : function.getParameters().getExpressions()) {
                                if (!(parameter2 instanceof Column)) continue;
                                Column column = (Column)parameter2;
                                if (column.getTable() != null && column.getTable().getName() != null) {
                                    dataIds.addAll(schemaIds.stream().map(id -> id + column.getTable().getName() + "/" + column.getColumnName()).collect(Collectors.toList()));
                                    continue;
                                }
                                dataIds.addAll(tableIds.stream().map(Map.Entry::getValue).map(id -> id + column.getColumnName()).collect(Collectors.toList()));
                            }
                            selectItemIds.add(new AbstractMap.SimpleEntry<SelectItem, Object>(selectItem, dataIds));
                        } else {
                            throw new ParseException("CLARUS_METADATA function requires at least one parameter (* or column name(s))");
                        }
                        involvedBackends = Collections.emptyList();
                        break;
                    }
                    if (FUNCTION_PROTECTED.equalsIgnoreCase(function.getName())) {
                        retrieveProtectedData = true;
                        if (function.getParameters() != null && function.getParameters().getExpressions() != null && !function.getParameters().getExpressions().isEmpty()) {
                            involvedBackends = new ArrayList(function.getParameters().getExpressions().size());
                            for (Expression parameter3 : function.getParameters().getExpressions()) {
                                if (parameter3 instanceof StringValue && ((StringValue)parameter3).getValue().startsWith("csp")) {
                                    String s = ((StringValue)parameter3).getValue();
                                    s = s.substring("csp".length());
                                    involvedBackends.add(Integer.parseInt(s) - 1);
                                    continue;
                                }
                                throw new ParseException("CLARUS_PROTECTED function requires string parameters (backend names)");
                            }
                        } else {
                            throw new ParseException("CLARUS_PROTECTED function requires at least one parameter (backend names)");
                        }
                        iter.remove();
                        continue;
                    }
                    if (FUNCTION_ADD_GEOMETRY_COLUMN.equalsIgnoreCase(function.getName()) && function.getParameters() != null && function.getParameters().getExpressions() != null) {
                        if (outboundDataOperation != null) {
                            operation = outboundDataOperation.getOperation();
                        }
                        if (operation == Operation.READ) {
                            operation = Operation.UPDATE;
                        }
                        usingHeadOperation = true;
                        dataId = this.buildDataIdFromFunction(ctx, function.getParameters().getExpressions());
                        selectItemIds.add(new AbstractMap.SimpleEntry<SelectItem, List<String>>(selectItem, Collections.singletonList(dataId)));
                        String datasetId = dataId.substring(0, dataId.lastIndexOf(47));
                        String srid = this.getSridFromAddGeometryColumn(ctx, function.getParameters().getExpressions());
                        SQLDatabaseSchema databaseSchema = this.getDatabaseSchema(ctx);
                        databaseSchema.addDatasetSrid(datasetId, srid);
                        continue;
                    }
                    if (FUNCTION_ST_ESTIMATED_EXTENT.equalsIgnoreCase(function.getName()) && function.getParameters() != null && function.getParameters().getExpressions() != null) {
                        if (outboundDataOperation != null) {
                            operation = outboundDataOperation.getOperation();
                        }
                        dataId = this.buildDataIdFromFunction(ctx, function.getParameters().getExpressions());
                        selectItemIds.add(new AbstractMap.SimpleEntry<SelectItem, List<String>>(selectItem, Collections.singletonList(dataId)));
                        continue;
                    }
                    if (FUNCTION_HAS_COLUMN_PRIVILEGE.equalsIgnoreCase(function.getName()) && function.getParameters() != null && function.getParameters().getExpressions() != null) {
                        if (outboundDataOperation != null) {
                            operation = outboundDataOperation.getOperation();
                        }
                        dataId = this.buildDataIdFromHasColumnPrivilege(ctx, function.getParameters().getExpressions());
                        selectItemIds.add(new AbstractMap.SimpleEntry<SelectItem, List<String>>(selectItem, Collections.singletonList(dataId)));
                        continue;
                    }
                    if (function.getParameters() != null && function.getParameters().getExpressions() != null) {
                        List<Object> allDataIds = function.getParameters().getExpressions().stream().flatMap(parameter -> {
                            Stream<Object> dataIds = null;
                            if (parameter instanceof Column) {
                                Column column = (Column)parameter;
                                String columnName = StringUtilities.unquote((String)column.getName(false));
                                if (column.getTable() == null || column.getTable().getName() == null) {
                                    dataIds = tableIds.stream().map(Map.Entry::getValue).map(id -> id + columnName);
                                } else {
                                    String name = column.getTable().getName();
                                    String shortColumnName = columnName.substring(columnName.lastIndexOf(46) + 1);
                                    dataIds = tableIds.stream().sorted(Comparator.comparingInt(e -> ((Table)e.getKey()).getAlias() != null ? 0 : 1)).filter(e -> {
                                        Table table = (Table)e.getKey();
                                        return name.equals(table.getName()) || table.getAlias() != null && name.equals(table.getAlias().getName());
                                    }).map(Map.Entry::getValue).map(id -> id + shortColumnName);
                                }
                            }
                            if (dataIds == null) {
                                dataIds = Stream.empty();
                            }
                            return dataIds;
                        }).collect(Collectors.toList());
                        if (allDataIds.isEmpty()) {
                            allDataIds = Collections.singletonList(this.toFullyQualifiedOutputName(selectItem));
                        }
                        selectItemIds.add(new AbstractMap.SimpleEntry(selectItem, allDataIds));
                        continue;
                    }
                    selectItemIds.add(new AbstractMap.SimpleEntry<SelectItem, List<String>>(selectItem, Collections.singletonList(this.toFullyQualifiedOutputName(selectItem))));
                    continue;
                }
                if (selectExpressionItem.getExpression() instanceof Column) {
                    Column column = (Column)selectExpressionItem.getExpression();
                    dataIds = this.extractDataIds(tableIds, column);
                    selectItemIds.add(new AbstractMap.SimpleEntry<SelectItem, List<String>>(selectItem, (List<String>)dataIds));
                    continue;
                }
                selectItemIds.add(new AbstractMap.SimpleEntry<SelectItem, List<String>>(selectItem, Collections.singletonList(this.toFullyQualifiedOutputName(selectItem))));
                continue;
            }
            if (selectItem instanceof AllColumns) {
                String asterisk = ((AllColumns)selectItem).toString();
                selectItemIds.add(new AbstractMap.SimpleEntry(selectItem, tableIds.stream().map(Map.Entry::getValue).map(id -> id + asterisk).collect(Collectors.toList())));
                continue;
            }
            if (selectItem instanceof AllTableColumns) {
                AllTableColumns allTableColumns = (AllTableColumns)selectItem;
                String name = allTableColumns.getTable().getName();
                selectItemIds.add(new AbstractMap.SimpleEntry<SelectItem, List<String>>(selectItem, Collections.singletonList(tableIds.stream().sorted(Comparator.comparingInt(e -> {
                    Table table = (Table)e.getKey();
                    return table.getAlias() != null ? 0 : 1;
                })).filter(e -> {
                    Table table = (Table)e.getKey();
                    return name.equals(table.getName()) || table.getAlias() != null && name.equals(table.getAlias().getName());
                }).map(e -> (String)e.getValue() + "*").findFirst().orElse(allTableColumns.toString()))));
                continue;
            }
            selectItemIds.add(new AbstractMap.SimpleEntry<SelectItem, List<String>>(selectItem, Collections.singletonList(this.toFullyQualifiedOutputName(selectItem))));
        }
        PgsqlColumnsFinder columnsFinder = new PgsqlColumnsFinder();
        columnsFinder.parse(select.getWhere());
        List<Map.Entry<Expression, List<Column>>> whereClause = columnsFinder.getExpressionsWithColumnsToColumns();
        List<Map.Entry<Expression, List<String>>> criteriaIds = whereClause.stream().map(e -> new AbstractMap.SimpleEntry(e.getKey(), ((List)e.getValue()).stream().map(c -> this.extractDataIds(tableIds, (Column)c)).flatMap(Collection::stream).collect(Collectors.toList()))).collect(Collectors.toList());
        if (metadata) {
            metadataOperation = new MetadataOperation();
            metadataOperation.setDataIds(selectItemIds.stream().map(Map.Entry::getValue).flatMap(ids -> ids.stream()).map(CString::valueOf).collect(Collectors.toList()));
            moduleOperation = metadataOperation;
            moduleOperation.setInvolvedCSPs(involvedBackends);
        } else {
            outboundDataOperation = new OutboundDataOperation();
            outboundDataOperation.setOperation(operation);
            outboundDataOperation.setUsingHeadOperation(usingHeadOperation);
            outboundDataOperation.setDataIds(selectItemIds.stream().map(Map.Entry::getValue).flatMap(Collection::stream).map(CString::valueOf).collect(Collectors.toList()));
            outboundDataOperation.setDataValues(Collections.singletonList(selectItemIds.stream().flatMap(entry -> {
                Function function;
                SelectItem selectItem = (SelectItem)entry.getKey();
                List dataIds = (List)entry.getValue();
                Stream<String> values = selectItem instanceof SelectExpressionItem && ((SelectExpressionItem)selectItem).getExpression() instanceof Function ? ((function = (Function)((SelectExpressionItem)selectItem).getExpression()).getParameters() != null && function.getParameters().getExpressions() != null ? dataIds.stream().map(dataId -> {
                    boolean significant = false;
                    if (this.isFullyQualifiedDataId((String)dataId)) {
                        Pattern dataIdPattern = Pattern.compile(String.format("(%s\\.?)?(%s\\.?)?(%s\\.?)?(%s)?", this.getDatabaseName((String)dataId), this.getSchemaName((String)dataId), this.getTableName((String)dataId), this.getColumnName((String)dataId)));
                        for (Expression parameter : function.getParameters().getExpressions()) {
                            String value = parameter instanceof StringValue ? ((StringValue)parameter).getValue() : parameter.toString();
                            Matcher matcher = dataIdPattern.matcher(StringUtilities.unquote((String)value));
                            if (!matcher.matches()) continue;
                            significant = true;
                            break;
                        }
                    }
                    return significant ? function.toString() : null;
                }) : Stream.generate(() -> null).limit(dataIds.size())) : Stream.generate(() -> null).limit(dataIds.size());
                return values;
            }).map(CString::valueOf).collect(Collectors.toList())));
            List<OutboundDataOperation.Criterion> criterions = this.extractSignificantCriterions(criteriaIds);
            outboundDataOperation.setCriterions(criterions);
            criterions.stream().filter(criterion -> criterion != null).forEach(criterion -> {
                CString value = criterion.getValue();
                if (value != null && value != null && value.charAt(0) == '$') {
                    int idx = Integer.parseInt(value.substring(1).toString()) - 1;
                    ParameterValue parameterValue = (ParameterValue)parameterValues.get(idx);
                    Types types = this.getTypes(ctx, -1);
                    Type parameterType = types.getType(parameterValue.getType());
                    value = this.convertToText(parameterType, -1, parameterValue.getFormat(), parameterValue.getValue());
                    criterion.setValue(value);
                }
            });
            outboundDataOperation.setInvolvedCSPs(involvedBackends);
            if (retrieveProtectedData) {
                outboundDataOperation.setUnprotectingDataEnabled(false);
                outboundDataOperation.setModified(true);
            }
            outboundDataOperation.addAttribute("tableIds", tableIds);
            outboundDataOperation.addAttribute("selectItemIds", selectItemIds);
            outboundDataOperation.addAttribute("criteriaIds", criteriaIds);
            moduleOperation = outboundDataOperation;
        }
        return moduleOperation;
    }

    private String buildDataIdFromFunction(ChannelHandlerContext ctx, List<Expression> parameters) {
        StringBuilder sb = new StringBuilder();
        int nbSep = 0;
        for (Expression parameter : parameters) {
            if (!(parameter instanceof StringValue) || ((StringValue)parameter).getValue().matches("\\d+")) break;
            if (sb.length() > 0) {
                sb.append('/');
                ++nbSep;
            }
            sb.append(((StringValue)parameter).getValue());
        }
        if (nbSep == 3) {
            int i = sb.indexOf("/", sb.indexOf("/") + 1);
            sb.setCharAt(i, '.');
        } else if (nbSep == 2) {
            int i = sb.indexOf("/");
            sb.setCharAt(i, '.');
            sb.insert(0, this.getDatabaseId(ctx));
        } else if (nbSep == 1) {
            int i = sb.indexOf("/");
            String schema = this.identifySchema(sb.substring(0, i));
            sb.insert(0, '.');
            sb.insert(0, schema);
            sb.insert(0, this.getDatabaseId(ctx));
        }
        String dataId = sb.toString();
        return dataId;
    }

    private String getSridFromAddGeometryColumn(ChannelHandlerContext ctx, List<Expression> parameters) {
        for (Expression parameter : parameters) {
            if (!(parameter instanceof StringValue) || !((StringValue)parameter).getValue().matches("\\d+")) continue;
            return ((StringValue)parameter).getValue();
        }
        return null;
    }

    private String buildDataIdFromHasColumnPrivilege(ChannelHandlerContext ctx, List<Expression> parameters) {
        int i;
        StringBuilder sb = new StringBuilder();
        int offset = parameters.size() == 3 ? 0 : 1;
        int nbSep = 0;
        for (i = offset; i < offset + 2; ++i) {
            String value;
            Expression parameter = parameters.get(i);
            if (!(parameter instanceof StringValue)) {
                throw new IllegalArgumentException("Unexepected parameter type (expected a StringValue");
            }
            if (sb.length() > 0) {
                sb.append('/');
                ++nbSep;
            }
            if (StringUtilities.hasQuote((String)(value = ((StringValue)parameter).getValue()))) {
                value = StringUtilities.unquote((String)value).replace("\".\"", ".");
            }
            if (value.indexOf(46) != -1) {
                ++nbSep;
            }
            sb.append(value);
        }
        if (nbSep == 2) {
            sb.insert(0, this.getDatabaseId(ctx));
        } else if (nbSep == 1) {
            i = sb.indexOf("/");
            String schema = this.identifySchema(sb.substring(0, i));
            sb.insert(0, '.');
            sb.insert(0, schema);
            sb.insert(0, this.getDatabaseId(ctx));
        }
        String dataId = sb.toString();
        return dataId;
    }

    private List<String> extractDataIds(List<Map.Entry<Table, String>> tableIds, Column column) {
        List<String> dataIds;
        String columnName = StringUtilities.unquote((String)column.getName(false));
        if (column.getTable() == null || column.getTable().getName() == null) {
            dataIds = tableIds.stream().map(Map.Entry::getValue).map(id -> id + columnName).collect(Collectors.toList());
        } else {
            String name = column.getTable().getName();
            String shortColumnName = columnName.substring(columnName.lastIndexOf(46) + 1);
            dataIds = Collections.singletonList(tableIds.stream().sorted(Comparator.comparingInt(e -> ((Table)e.getKey()).getAlias() != null ? 0 : 1)).filter(e -> {
                Table table = (Table)e.getKey();
                return name.equals(table.getName()) || table.getAlias() != null && name.equals(table.getAlias().getName());
            }).map(Map.Entry::getValue).map(id -> id + shortColumnName).findFirst().orElse(columnName));
        }
        return dataIds;
    }

    private List<OutboundDataOperation.Criterion> extractSignificantCriterions(List<Map.Entry<Expression, List<String>>> criteriaIds) {
        List<OutboundDataOperation.Criterion> basicCriteria = criteriaIds.stream().map(e -> {
            OutboundDataOperation.Criterion criterion = null;
            if (e.getKey() instanceof BinaryExpression) {
                boolean left;
                String dataId;
                if (!((List)e.getValue()).isEmpty()) {
                    dataId = ((List)e.getValue()).stream().filter(id -> id.contains("geometry_columns")).findFirst().orElse((String)((List)e.getValue()).get(0));
                    left = ((List)e.getValue()).indexOf(dataId) == 0;
                } else {
                    dataId = ((Expression)e.getKey()).toString();
                    left = true;
                }
                criterion = this.binaryExpressionToCriterion(dataId, left, (BinaryExpression)e.getKey());
            }
            return criterion;
        }).collect(Collectors.toList());
        return basicCriteria;
    }

    private OutboundDataOperation.Criterion binaryExpressionToCriterion(String dataId, boolean left, BinaryExpression expression) {
        Function function;
        Expression leftExpression = expression.getLeftExpression();
        Expression rightExpression = expression.getRightExpression();
        OutboundDataOperation.Criterion criterion = null;
        if (expression instanceof AndExpression && (leftExpression instanceof Column && rightExpression instanceof Function || rightExpression instanceof Column && leftExpression instanceof Function) && (function = (Function)(leftExpression instanceof Function ? leftExpression : rightExpression)).getName().equalsIgnoreCase("st_makeenvelope") && function.getParameters() != null && function.getParameters().getExpressions() != null) {
            criterion = new OutboundDataOperation.Criterion(CString.valueOf((CharSequence)dataId), CString.valueOf((CharSequence)"area"), CString.valueOf((CharSequence)PlainSelect.getStringList((List)function.getParameters().getExpressions(), (boolean)true, (boolean)false)));
        }
        if (criterion == null) {
            Expression expr = left ? rightExpression : leftExpression;
            String value = expr instanceof StringValue ? ((StringValue)expr).getValue() : expr.toString();
            String operator = expression.getStringExpression();
            criterion = new OutboundDataOperation.Criterion(CString.valueOf((CharSequence)dataId), CString.valueOf((CharSequence)operator), CString.valueOf((CharSequence)value));
        }
        return criterion;
    }

    private void trackTableDefinition(ChannelHandlerContext ctx, Table table) {
        if (table.getName().equalsIgnoreCase("pg_class")) {
            SQLSession session = this.getSession(ctx);
            session.setTableDefinitionEnabled(true);
        }
    }

    private void trackTableDefinition(ChannelHandlerContext ctx, String columnName, String alias) {
        SQLSession session = this.getSession(ctx);
        if (session.isTableDefinitionEnabled() && (columnName.equalsIgnoreCase("oid") || columnName.equalsIgnoreCase("relname"))) {
            session.addRowDescriptionFieldToTrack(alias != null ? alias : columnName, columnName);
        }
    }

    private String getDatabaseId(ChannelHandlerContext ctx) {
        StringBuilder sb = new StringBuilder();
        String databaseName = this.getDatabaseName(ctx);
        if (databaseName != null) {
            sb.append(databaseName);
        } else {
            sb.append('*');
        }
        sb.append('/');
        String databaseId = sb.toString();
        return databaseId;
    }

    private String getSchemaId(ChannelHandlerContext ctx, Table table) {
        String databaseName;
        StringBuilder sb = new StringBuilder();
        if (table != null && table.getDatabase() != null && (databaseName = StringUtilities.unquote((String)table.getDatabase().getDatabaseName())) != null && !databaseName.isEmpty()) {
            sb.append(databaseName.toLowerCase());
        }
        if (sb.length() == 0) {
            sb.append(this.getDatabaseId(ctx));
        }
        if (table != null) {
            String schemaName = StringUtilities.unquote((String)table.getSchemaName());
            if (schemaName == null) {
                String tableName = StringUtilities.unquote((String)table.getName());
                schemaName = this.identifySchema(tableName);
            }
            if (schemaName != null) {
                sb.append(schemaName.toLowerCase()).append('.');
            }
        }
        String schemaId = sb.toString();
        return schemaId;
    }

    private String identifySchema(String tableName) {
        return tableName.startsWith("pg_") ? "pg_catalog" : "public";
    }

    private String getTableId(ChannelHandlerContext ctx, Table table, String schemaId) {
        StringBuilder sb = new StringBuilder();
        if (table != null) {
            String tableName = StringUtilities.unquote((String)table.getName());
            sb.append(schemaId).append(tableName.toLowerCase());
        }
        if (sb.length() == 0) {
            sb.append(schemaId).append('*');
        }
        sb.append('/');
        String datasetId = sb.toString();
        return datasetId;
    }

    private PgsqlStatement<Select> modifySelectStatement(ChannelHandlerContext ctx, PgsqlStatement<Select> statement, OutboundDataOperation outboundDataOperation, boolean newStatement, List<SQLSession.ExpectedField> expectedFields) {
        List newTables;
        List<String> newSelectItemDataIds;
        Select stmt;
        block55: {
            stmt = statement.getStatement();
            if (newStatement) {
                String sql = stmt.toString();
                try {
                    stmt = (Select)CCJSqlParserUtil.parse((String)sql);
                }
                catch (JSQLParserException | TokenMgrError e2) {
                    LOGGER.error("Parsing error for {} : ", (Object)sql);
                    if (!LOGGER.isTraceEnabled()) break block55;
                    LOGGER.trace("Parsing error details:", e2);
                }
            }
        }
        PlainSelect select = (PlainSelect)stmt.getSelectBody();
        int involvedBackend = outboundDataOperation.getInvolvedCSP() == -1 ? this.getPreferredBackend(ctx) : outboundDataOperation.getInvolvedCSP();
        List selectItemIds = (List)outboundDataOperation.getAttribute("selectItemIds");
        List dataIdsPerSelectItem = selectItemIds.stream().map(Map.Entry::getValue).collect(Collectors.toList());
        List tableIds = (List)outboundDataOperation.getAttribute("tableIds");
        List newDataIds1 = outboundDataOperation.getDataIds().stream().map(CString::toString).collect(Collectors.toList());
        List newDataValues1 = ((List)outboundDataOperation.getDataValues().get(0)).stream().map(StringUtilities::toString).collect(Collectors.toList());
        MetadataOperation metadataOperation1 = new MetadataOperation();
        List allDataIds1 = dataIdsPerSelectItem.stream().flatMap(Collection::stream).map(CString::valueOf).collect(Collectors.toList());
        metadataOperation1.setDataIds(allDataIds1);
        List metadata1 = this.newMetaDataOperation(ctx, metadataOperation1).getMetadata();
        Map<String, List> rawDataIdsMapping1 = metadata1.stream().collect(Collectors.toMap(e -> ((CString)e.getKey()).toString(), e -> ((List)e.getValue()).isEmpty() ? Collections.emptyList() : Collections.singletonList(StringUtilities.toString((CharSequence)((CharSequence)((List)e.getValue()).get(involvedBackend)))), (l1, l2) -> l1));
        Map dataIdsMapping1 = allDataIds1.stream().distinct().map(CString::toString).collect(Collectors.toMap(java.util.function.Function.identity(), id -> {
            if (id.endsWith("*")) {
                String prefix = id.substring(0, id.length() - 1);
                return rawDataIdsMapping1.entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(prefix)).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
            }
            return (List)rawDataIdsMapping1.get(id);
        }));
        dataIdsMapping1.entrySet().stream().filter(e -> ((String)e.getKey()).endsWith("*")).forEach(e -> {
            List values = ((List)e.getValue()).stream().map(pid -> pid != null ? pid.substring(0, pid.lastIndexOf(47) + 1) + "*" : null).distinct().collect(Collectors.toList());
            if (values.size() > 1) {
                values = values.stream().filter(pid -> pid != null).collect(Collectors.toList());
            }
            e.setValue(values);
        });
        Map<String, List<Map.Entry>> metadataPerTableId = dataIdsMapping1.entrySet().stream().filter(e -> ((String)e.getKey()).lastIndexOf(47) != -1).collect(Collectors.groupingBy(e -> ((String)e.getKey()).substring(0, ((String)e.getKey()).lastIndexOf(47))));
        Map<String, List> tableIdsMapping = metadataPerTableId.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(Map.Entry::getValue).flatMap(Collection::stream).map(id -> id != null ? id.substring(0, id.lastIndexOf(47)) : null).distinct().collect(Collectors.toList())));
        int nbSelectItems = select.getSelectItems().size();
        ArrayList<SelectItem> newSelectItems = new ArrayList<SelectItem>(nbSelectItems);
        ArrayList<String> newDataIds = new ArrayList<String>(nbSelectItems);
        for (int i = 0; i < nbSelectItems; ++i) {
            ArrayList<Map.Entry<String, Integer>> attributeMapping;
            List<String> protectedAttributeNames;
            SQLSession.ExpectedField expectedField;
            SelectItem newSelectItem;
            SelectItem selectItem = (SelectItem)select.getSelectItems().get(i);
            List<String> dataIds = (List<String>)dataIdsPerSelectItem.get(i);
            newSelectItemDataIds = null;
            if (dataIds.isEmpty()) {
                newSelectItem = selectItem;
            } else {
                List selectItemProtectedDataIds = dataIdsMapping1.entrySet().stream().filter(e -> dataIds.contains(e.getKey())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
                if (selectItemProtectedDataIds.isEmpty()) {
                    newSelectItem = selectItem;
                    List<String> backendDatabaseNames = this.getBackendDatabaseNames(ctx);
                    newSelectItemDataIds = !backendDatabaseNames.isEmpty() ? dataIds.stream().map(id -> this.modifyDatabaseName((String)id, (String)backendDatabaseNames.get(involvedBackend))).collect(Collectors.toList()) : dataIds;
                } else {
                    newSelectItemDataIds = selectItemProtectedDataIds.stream().filter(id -> id != null && id.endsWith("*") ? newDataIds1.stream().anyMatch(ndid -> ndid.startsWith(id.substring(0, id.length() - 1))) : newDataIds1.contains(id)).collect(Collectors.toList());
                    if (newSelectItemDataIds.isEmpty()) {
                        newSelectItem = null;
                    } else {
                        List<String> newSelectItemDataValues = selectItemProtectedDataIds.stream().filter(id -> id != null && id.endsWith("*") ? newDataIds1.stream().anyMatch(ndid -> ndid.startsWith(id.substring(0, id.length() - 1))) : newDataIds1.contains(id)).map(id -> id != null && id.endsWith("*") ? IntStream.range(0, newDataIds1.size()).filter(j -> ((String)newDataIds1.get(j)).startsWith(id.substring(0, id.length() - 1))).findFirst().getAsInt() : newDataIds1.indexOf(id)).map(j -> (String)newDataValues1.get((int)j)).collect(Collectors.toList());
                        boolean same = true;
                        for (int idx = 0; same && idx < dataIds.size(); ++idx) {
                            String newExpression;
                            String oldDataId = dataIds.get(idx);
                            String shortOldDataId = oldDataId.chars().filter(c -> c == 47).count() == 2L ? oldDataId.substring(oldDataId.indexOf(47)) : oldDataId;
                            String newDataId = newSelectItemDataIds.get(idx);
                            String shortNewDataId = newDataId.chars().filter(c -> c == 47).count() == 2L ? newDataId.substring(newDataId.indexOf(47)) : newDataId;
                            same = shortNewDataId.equals(shortOldDataId);
                            if (!same || !(selectItem instanceof SelectExpressionItem) || !(((SelectExpressionItem)selectItem).getExpression() instanceof Function) || (newExpression = newSelectItemDataValues.get(idx)) == null) continue;
                            String oldExpression = selectItem.toString();
                            same = newExpression.equals(oldExpression);
                        }
                        newSelectItem = same ? selectItem : this.buildSelectItem(selectItem, dataIds, newSelectItemDataIds, newSelectItemDataValues);
                    }
                }
            }
            if (newSelectItem != null) {
                newSelectItems.add(newSelectItem);
            }
            if (newSelectItemDataIds != null) {
                newDataIds.addAll(newSelectItemDataIds);
            }
            if (expectedFields == null) continue;
            String clearFieldName = this.toOutputName(selectItem.toString());
            SQLSession.ExpectedField expectedField2 = expectedField = i < expectedFields.size() ? expectedFields.get(i) : null;
            if (expectedField == null) {
                expectedField = new SQLSession.ExpectedField(clearFieldName);
                expectedFields.add(expectedField);
                if (outboundDataOperation.isUnprotectingDataEnabled() && selectItem instanceof SelectExpressionItem && ((SelectExpressionItem)selectItem).getExpression() instanceof Function && Stream.of(this.FUNCTIONS_WITH_SUPPORTED_RETURN_TYPE).noneMatch(fct -> fct.equalsIgnoreCase(((Function)((SelectExpressionItem)selectItem).getExpression()).getName()))) {
                    List<String> attributeNames = Stream.of(this.toFullyQualifiedOutputName(selectItem)).collect(Collectors.toList());
                    expectedField.addAttributeNames(attributeNames);
                } else {
                    expectedField.addAttributeNames(dataIds);
                }
            }
            if (newSelectItem == null) continue;
            if (newSelectItemDataIds == null) {
                throw new IllegalStateException("unexpected");
            }
            if (expectedField.getBackendProtectedFields(involvedBackend) != null) {
                throw new IllegalStateException("unexpected");
            }
            String protectedFieldName = this.toOutputName(newSelectItem.toString());
            if (outboundDataOperation.isUnprotectingDataEnabled() && newSelectItem instanceof SelectExpressionItem && ((SelectExpressionItem)newSelectItem).getExpression() instanceof Function && Stream.of(this.FUNCTIONS_WITH_SUPPORTED_RETURN_TYPE).noneMatch(fct -> fct.equalsIgnoreCase(((Function)((SelectExpressionItem)newSelectItem).getExpression()).getName()))) {
                String protectedAttributeName = this.toFullyQualifiedOutputName(newSelectItem);
                protectedAttributeNames = Stream.of(protectedAttributeName).collect(Collectors.toList());
                attributeMapping = Stream.of(new AbstractMap.SimpleEntry<String, Integer>(protectedAttributeName, 0)).collect(Collectors.toList());
            } else {
                protectedAttributeNames = newSelectItemDataIds;
                Map<String, String> reverseDataIdsMapping1 = dataIdsMapping1.entrySet().stream().filter(e -> dataIds.contains(e.getKey())).flatMap(e -> ((List)e.getValue()).isEmpty() ? Stream.of(new AbstractMap.SimpleEntry(protectedAttributeNames.get(dataIds.indexOf(e.getKey())), e.getKey())) : ((List)e.getValue()).stream().filter(pid -> pid != null && protectedAttributeNames.contains(pid)).map(pid -> new AbstractMap.SimpleEntry((String)pid, e.getKey()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
                int offset = 0;
                attributeMapping = new ArrayList(newSelectItemDataIds.size());
                for (String newDataId : newSelectItemDataIds) {
                    String dataId = reverseDataIdsMapping1.get(newDataId);
                    for (int j2 = offset; j2 < dataIds.size(); ++j2) {
                        if (!dataIds.get(j2).equals(dataId)) continue;
                        attributeMapping.add(new AbstractMap.SimpleEntry<String, Integer>(newDataId, j2));
                        break;
                    }
                    ++offset;
                }
            }
            expectedField.setBackendProtectedFields(involvedBackend, Stream.of(new SQLSession.ExpectedProtectedField(involvedBackend, protectedFieldName, protectedAttributeNames, attributeMapping)).collect(Collectors.toList()));
        }
        int nbNewSelectItems = 0;
        for (int c2 = 0; c2 < newDataIds1.size(); ++c2) {
            SQLSession.ExpectedField expectedField;
            String newDataId = (String)newDataIds1.get(c2);
            boolean found = newDataIds.contains(newDataId);
            if (!found) {
                found = newDataIds.contains(newDataId.substring(0, newDataId.lastIndexOf(47) + 1) + "*");
            }
            if (found) continue;
            newSelectItemDataIds = Stream.of(newDataId).collect(Collectors.toList());
            SelectItem newSelectItem = this.buildSelectItem(null, Collections.singletonList(null), newSelectItemDataIds, null);
            newSelectItems.add(newSelectItem);
            if (expectedFields == null) continue;
            List<String> clearDataIds = rawDataIdsMapping1.entrySet().stream().filter(e -> ((List)e.getValue()).contains(newDataId)).map(Map.Entry::getKey).collect(Collectors.toList());
            String clearFieldName = clearDataIds.stream().findFirst().map(this::toOutputName).orElse(null);
            SQLSession.ExpectedField expectedField3 = expectedField = nbSelectItems + nbNewSelectItems < expectedFields.size() ? expectedFields.get(nbSelectItems + nbNewSelectItems) : null;
            if (expectedField == null) {
                expectedField = new SQLSession.ExpectedField(clearFieldName);
                expectedFields.add(expectedField);
                expectedField.addAttributeNames(clearDataIds);
            }
            if (expectedField.getBackendProtectedFields(involvedBackend) != null) {
                throw new IllegalStateException("unexpected");
            }
            String protectedFieldName = this.toOutputName(newSelectItem.toString());
            List<String> protectedAttributeNames = newSelectItemDataIds;
            List<Map.Entry<String, Integer>> attributeMapping = Stream.of(new AbstractMap.SimpleEntry<String, Integer>(newDataId, 0)).collect(Collectors.toList());
            expectedField.setBackendProtectedFields(involvedBackend, Stream.of(new SQLSession.ExpectedProtectedField(involvedBackend, protectedFieldName, protectedAttributeNames, attributeMapping)).collect(Collectors.toList()));
        }
        select.setSelectItems(newSelectItems);
        List tableIdPerTable = tableIds.stream().map(Map.Entry::getValue).map(v -> v.substring(0, v.length() - 1)).collect(Collectors.toList());
        List newTableIds = newDataIds1.stream().filter(id -> id.lastIndexOf(47) != -1).map(id -> id.substring(0, id.lastIndexOf(47))).distinct().collect(Collectors.toList());
        if (select.getFromItem() != null) {
            ArrayList<Join> froms = new ArrayList<Join>();
            Join join = new Join();
            join.setRightItem(select.getFromItem());
            froms.add(join);
            if (select.getJoins() != null) {
                froms.addAll(select.getJoins());
            }
            int nbFrom = froms.size();
            ArrayList<Join> newFroms = new ArrayList<Join>(nbFrom);
            int j3 = 0;
            for (int i = 0; i < nbFrom; ++i) {
                Join from = (Join)froms.get(i);
                if (!(from.getRightItem() instanceof Table)) {
                    newFroms.add(from);
                    continue;
                }
                String tableId = (String)tableIdPerTable.get(j3++);
                List<String> newJoinTableIds = tableIdsMapping.entrySet().stream().filter(e -> tableId.equals(e.getKey())).flatMap(e -> ((List)e.getValue()).stream().filter(id -> newTableIds.contains(id))).collect(Collectors.toList());
                if (newJoinTableIds.isEmpty()) {
                    newFroms.add(from);
                    continue;
                }
                newJoinTableIds.forEach(id -> newFroms.add(this.buildFrom(from, (String)id)));
            }
            newTables = newFroms.stream().map(Join::getRightItem).filter(item -> item instanceof Table).map(Table.class::cast).collect(Collectors.toList());
            select.setFromItem(((Join)newFroms.remove(0)).getRightItem());
            select.setJoins(newFroms);
        } else {
            newTables = null;
        }
        if (select.getWhere() != null) {
            Expression whereClause;
            Map<String, List> dataIdsMapping2;
            List criterionsIds;
            List dataIdsPerCriteria;
            block56: {
                List criteriaIds = (List)outboundDataOperation.getAttribute("criteriaIds");
                dataIdsPerCriteria = criteriaIds.stream().map(Map.Entry::getValue).collect(Collectors.toList());
                criterionsIds = outboundDataOperation.getCriterions().stream().map(c -> new AbstractMap.SimpleEntry<OutboundDataOperation.Criterion, Boolean>((OutboundDataOperation.Criterion)c, false)).collect(Collectors.toList());
                MetadataOperation metadataOperation2 = new MetadataOperation();
                List allDataIds2 = dataIdsPerCriteria.stream().flatMap(Collection::stream).map(CString::valueOf).collect(Collectors.toList());
                metadataOperation2.setDataIds(allDataIds2);
                List metadata2 = this.newMetaDataOperation(ctx, metadataOperation2).getMetadata();
                dataIdsMapping2 = metadata2.stream().collect(Collectors.toMap(e -> ((CString)e.getKey()).toString(), e -> ((List)e.getValue()).isEmpty() ? Collections.emptyList() : Collections.singletonList(StringUtilities.toString((CharSequence)((CharSequence)((List)e.getValue()).get(involvedBackend)))), (l1, l2) -> l1));
                whereClause = select.getWhere();
                if (!newStatement) {
                    String expression = whereClause.toString();
                    try {
                        whereClause = CCJSqlParserUtil.parseCondExpression((String)expression);
                    }
                    catch (JSQLParserException | TokenMgrError e3) {
                        LOGGER.error("Parsing error for {} : ", (Object)expression);
                        if (!LOGGER.isTraceEnabled()) break block56;
                        LOGGER.trace("Parsing error details:", e3);
                    }
                }
            }
            PgsqlColumnsFinder columnsFinder = new PgsqlColumnsFinder();
            columnsFinder.parse(whereClause);
            List<Expression> expressions = columnsFinder.getExpressionsWithColumns();
            Map<Expression, Expression> expressionsToParents = columnsFinder.getExpressionsToParents();
            Expression newWhereClause = whereClause;
            for (int i = 0; i < expressions.size(); ++i) {
                Expression newExpression;
                Expression expression = expressions.get(i);
                Expression parentExpression = expressionsToParents.get(expression);
                List criteriaDataIds = (List)dataIdsPerCriteria.get(i);
                if (criteriaDataIds.isEmpty()) {
                    newExpression = expression;
                } else {
                    List criteriaProtectedDataIds = dataIdsMapping2.entrySet().stream().filter(e -> {
                        if (criteriaDataIds.contains(e.getKey())) {
                            return true;
                        }
                        String shortAttributeName = this.toOutputName((String)e.getKey());
                        return shortAttributeName.charAt(0) == '?' && shortAttributeName.charAt(shortAttributeName.length() - 1) == '?';
                    }).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
                    if (criteriaProtectedDataIds.isEmpty()) {
                        newExpression = expression;
                    } else {
                        List newCriterions = criteriaProtectedDataIds.stream().filter(id -> criterionsIds.stream().anyMatch(e -> (Boolean)e.getValue() == false && e.getKey() != null && ((OutboundDataOperation.Criterion)e.getKey()).getDataId().equals(id))).map(id -> criterionsIds.stream().filter(e -> (Boolean)e.getValue() == false && e.getKey() != null && ((OutboundDataOperation.Criterion)e.getKey()).getDataId().equals(id)).findFirst().orElse(null)).filter(e -> e != null).peek(e -> e.setValue(true)).map(Map.Entry::getKey).map(c -> new AbstractMap.SimpleEntry<String, OutboundDataOperation.Criterion>(c.getDataId().toString(), (OutboundDataOperation.Criterion)c)).collect(Collectors.toList());
                        if (newCriterions.isEmpty()) {
                            newExpression = null;
                        } else {
                            List shortOldDataIds = criteriaDataIds.stream().map(cdid -> cdid.chars().filter(c -> c == 47).count() == 2L ? cdid.substring(cdid.indexOf(47)) : cdid).collect(Collectors.toList());
                            boolean same = true;
                            for (Map.Entry entry : newCriterions) {
                                String newDataId = (String)entry.getKey();
                                String shortNewDataId = newDataId.chars().filter(c -> c == 47).count() == 2L ? newDataId.substring(newDataId.indexOf(47)) : newDataId;
                                int idx = shortOldDataIds.indexOf(shortNewDataId);
                                boolean bl = same = idx != -1;
                                if (same && expression instanceof BinaryExpression) {
                                    OutboundDataOperation.Criterion criterion = (OutboundDataOperation.Criterion)entry.getValue();
                                    OutboundDataOperation.Criterion oldCriterion = this.binaryExpressionToCriterion((String)criteriaDataIds.get(idx), idx == 0, (BinaryExpression)expression);
                                    same = criterion.getValue().equals((Object)oldCriterion.getValue());
                                }
                                if (same) continue;
                                break;
                            }
                            newExpression = same || !(expression instanceof BinaryExpression) ? expression : this.buildExpression((BinaryExpression)expression, newCriterions.stream().map(Map.Entry::getValue).collect(Collectors.toList()));
                        }
                    }
                }
                while (newExpression != expression) {
                    Expression newParentExpression = this.modifyParentExpression(parentExpression, expression, newExpression);
                    if (newParentExpression != parentExpression) {
                        expression = parentExpression;
                        newExpression = newParentExpression;
                        parentExpression = expressionsToParents.get(expression);
                        continue;
                    }
                    if (newWhereClause == expression) {
                        newWhereClause = newExpression;
                    }
                    expression = newExpression;
                }
            }
            select.setWhere(newWhereClause);
        }
        if (select.getOrderByElements() != null) {
            LinkedHashMap<OrderByElement, List<Object>> orderByElementIds = new LinkedHashMap<OrderByElement, List<Object>>(select.getOrderByElements().size());
            for (OrderByElement orderByElement : select.getOrderByElements()) {
                if (orderByElement.getExpression() instanceof Column) {
                    Column column = (Column)orderByElement.getExpression();
                    if (column.getTable() == null || column.getTable().getName() == null) {
                        orderByElementIds.put(orderByElement, tableIds.stream().map(Map.Entry::getValue).map(id -> id + column.getColumnName()).collect(Collectors.toList()));
                        continue;
                    }
                    String name = column.getTable().getName();
                    orderByElementIds.put(orderByElement, Collections.singletonList(tableIds.stream().filter(e -> {
                        Table table = (Table)e.getKey();
                        return name.equals(table.getName()) || table.getAlias() != null && name.equals(table.getAlias().getName());
                    }).map(e -> (String)e.getValue() + column.getColumnName()).findFirst().orElse(column.getName(false))));
                    continue;
                }
                orderByElementIds.put(orderByElement, Collections.emptyList());
            }
            List dataIdsPerOrderByElement = orderByElementIds.values().stream().collect(Collectors.toList());
            MetadataOperation metadataOperation3 = new MetadataOperation();
            dataIdsPerOrderByElement.stream().flatMap(Collection::stream).forEach(id -> metadataOperation3.addDataId(CString.valueOf((CharSequence)id)));
            List metadata3 = this.newMetaDataOperation(ctx, metadataOperation3).getMetadata();
            Map<String, List> dataIdsMapping3 = metadata3.stream().collect(Collectors.toMap(e -> ((CString)e.getKey()).toString(), e -> ((List)e.getValue()).isEmpty() ? Collections.emptyList() : Collections.singletonList(StringUtilities.toString((CharSequence)((CharSequence)((List)e.getValue()).get(involvedBackend)))), (l1, l2) -> l1));
            List newDataIds3 = dataIdsMapping3.values().stream().flatMap(Collection::stream).filter(id -> id != null).collect(Collectors.toList());
            int nbOrderByElement = select.getOrderByElements().size();
            ArrayList<OrderByElement> newOrderByElements = new ArrayList<OrderByElement>(nbOrderByElement);
            for (int i = 0; i < nbOrderByElement; ++i) {
                OrderByElement orderByElement = (OrderByElement)select.getOrderByElements().get(i);
                List dataIds = (List)dataIdsPerOrderByElement.get(i);
                if (dataIds.isEmpty()) {
                    newOrderByElements.add(orderByElement);
                    continue;
                }
                List orderByElementProtectedDataIds = dataIdsMapping3.entrySet().stream().filter(e -> dataIds.contains(e.getKey())).flatMap(e -> ((List)e.getValue()).stream()).collect(Collectors.toList());
                if (orderByElementProtectedDataIds.isEmpty()) {
                    newOrderByElements.add(orderByElement);
                    continue;
                }
                List<String> newOrderByElementDataIds = orderByElementProtectedDataIds.stream().filter(id -> newDataIds3.contains(id)).collect(Collectors.toList());
                if (newOrderByElementDataIds.isEmpty()) continue;
                newOrderByElementDataIds.forEach(id -> newOrderByElements.add(this.buildOrderByElement(orderByElement, (String)id, newTables)));
            }
            select.setOrderByElements(newOrderByElements.isEmpty() ? null : newOrderByElements);
        }
        return new PgsqlStatement<Select>(stmt, statement.getParameterTypes(), statement.getParameterFormats(), statement.getParameterValues(), statement.getResultFormats(), statement.getColumns());
    }

    private SelectItem buildSelectItem(SelectItem selectItem, List<String> oldDataIds, List<String> newDataIds, List<String> newExpressions) {
        SelectItem newSelectItem = selectItem;
        newSelectItem = selectItem instanceof SelectExpressionItem && ((SelectExpressionItem)selectItem).getExpression() instanceof Function ? this.buildFunctionItem(selectItem, newExpressions.get(0)) : this.buildColumnItem(selectItem, oldDataIds.get(0), newDataIds.get(0));
        return newSelectItem;
    }

    private SelectItem buildFunctionItem(SelectItem functionItem, String newExpression) {
        Function function;
        Function newFunction = function = (Function)((SelectExpressionItem)functionItem).getExpression();
        CCJSqlParser parser = new CCJSqlParser((Reader)new StringReader(newExpression));
        try {
            newFunction = parser.Function();
        }
        catch (Exception e) {
            LOGGER.error("Parsing error for {} : ", (Object)newExpression, (Object)e);
        }
        SelectExpressionItem newSelectExpressionItem = new SelectExpressionItem((Expression)newFunction);
        SelectExpressionItem selectExpressionItem = (SelectExpressionItem)functionItem;
        newSelectExpressionItem.setAlias(selectExpressionItem.getAlias());
        SelectExpressionItem newFunctionItem = newSelectExpressionItem;
        return newFunctionItem;
    }

    private SelectItem buildColumnItem(SelectItem columnItem, String oldDataId, String newDataId) {
        Object newColumnItem;
        String[] tokens;
        String oldTableName = null;
        if (oldDataId != null) {
            tokens = oldDataId.split("/");
            assert (tokens.length > 0);
            oldTableName = tokens.length >= 2 ? tokens[tokens.length - 2] : null;
        }
        tokens = newDataId.split("/");
        assert (tokens.length > 0);
        String newDbName = tokens.length >= 3 ? tokens[tokens.length - 3] : null;
        String newTableName = tokens.length >= 2 ? tokens[tokens.length - 2] : null;
        String newColumnName = tokens[tokens.length - 1];
        Table table = null;
        if (columnItem instanceof SelectExpressionItem && ((SelectExpressionItem)columnItem).getExpression() instanceof Column) {
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)columnItem;
            Column column = (Column)selectExpressionItem.getExpression();
            table = column.getTable();
            newColumnName = StringUtilities.quote((String)newColumnName);
        } else if (columnItem instanceof AllTableColumns) {
            table = ((AllTableColumns)columnItem).getTable();
        } else if (columnItem == null) {
            newColumnName = StringUtilities.quote((String)newColumnName);
        }
        Table newTable = null;
        if (table != null && !table.getFullyQualifiedName().isEmpty() && newTableName != null) {
            boolean alias;
            Database newDatabase = null;
            String newSchemaName = null;
            boolean bl = alias = !table.getFullyQualifiedName().equalsIgnoreCase(oldTableName);
            if (alias) {
                newTableName = table.getFullyQualifiedName();
            } else {
                String[] tokens2;
                if (table.getDatabase() != null && !table.getDatabase().getFullyQualifiedName().isEmpty() && newDbName != null) {
                    newDatabase = new Database(newDbName);
                }
                if ((tokens2 = newTableName.split("\\.")).length == 2) {
                    newTableName = tokens2[1];
                }
                if (table.getSchemaName() != null) {
                    newSchemaName = tokens2.length == 2 ? tokens2[0] : "public";
                }
            }
            newTable = new Table(newDatabase, newSchemaName, newTableName);
            newTable.setAlias(table.getAlias());
        }
        if (newColumnName.equals("*")) {
            newColumnItem = newTable != null ? new AllTableColumns(newTable) : new AllColumns();
        } else {
            Column newColumn = new Column(newTable, newColumnName);
            SelectExpressionItem newSelectExpressionItem = new SelectExpressionItem((Expression)newColumn);
            if (columnItem instanceof SelectExpressionItem) {
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)columnItem;
                newSelectExpressionItem.setAlias(selectExpressionItem.getAlias());
                Column column = (Column)selectExpressionItem.getExpression();
                newColumn.setIndex(column.getIndex());
            }
            newColumnItem = newSelectExpressionItem;
        }
        return newColumnItem;
    }

    private String toFullyQualifiedOutputName(SelectItem selectItem) {
        String fqOutputName = null;
        if (selectItem instanceof SelectExpressionItem) {
            SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
            if (selectExpressionItem.getExpression() instanceof Function) {
                Function function = (Function)selectExpressionItem.getExpression();
                fqOutputName = function.getName() + "()";
                if (function.getAlias() != null) {
                    fqOutputName = fqOutputName + " " + function.getAlias();
                }
            } else if (selectExpressionItem.getExpression() instanceof Column) {
                Column column = (Column)selectExpressionItem.getExpression();
                fqOutputName = column.getName(false);
            }
            if (selectExpressionItem.getAlias() != null && fqOutputName != null) {
                fqOutputName = fqOutputName + " " + selectExpressionItem.getAlias();
            }
        }
        if (fqOutputName == null) {
            fqOutputName = selectItem.toString();
        }
        return fqOutputName;
    }

    private Join buildFrom(Join from, String tableId) {
        String[] tokens2;
        String[] tokens = tableId.split("/");
        assert (tokens.length > 0);
        String newDbName = tokens.length >= 2 ? tokens[tokens.length - 2] : null;
        String newTableName = tokens[tokens.length - 1];
        Table table = (Table)from.getRightItem();
        Database newDatabase = null;
        if (table.getDatabase() != null && !table.getDatabase().getFullyQualifiedName().isEmpty() && newDbName != null) {
            newDatabase = new Database(newDbName);
        }
        if ((tokens2 = newTableName.split("\\.")).length == 2) {
            newTableName = tokens2[1];
        }
        String newSchemaName = null;
        if (table.getSchemaName() != null) {
            newSchemaName = tokens2.length == 2 ? tokens2[0] : "public";
        }
        Table newTable = new Table(newDatabase, newSchemaName, newTableName);
        newTable.setAlias(table.getAlias());
        Join newFrom = new Join();
        newFrom.setRightItem((FromItem)newTable);
        newFrom.setOuter(from.isOuter());
        newFrom.setRight(from.isRight());
        newFrom.setLeft(from.isLeft());
        newFrom.setNatural(from.isNatural());
        newFrom.setFull(from.isFull());
        newFrom.setInner(from.isInner());
        newFrom.setSimple(from.isSimple());
        newFrom.setCross(from.isCross());
        newFrom.setSemi(from.isSemi());
        newFrom.setOnExpression(from.getOnExpression());
        newFrom.setUsingColumns(from.getUsingColumns());
        return newFrom;
    }

    private Expression buildExpression(BinaryExpression oldExpression, List<OutboundDataOperation.Criterion> newCriterions) {
        BinaryExpression newBinaryExpression;
        BinaryExpression newExpression;
        block14: {
            newExpression = null;
            newBinaryExpression = null;
            try {
                newExpression = newBinaryExpression = (BinaryExpression)CCJSqlParserUtil.parseCondExpression((String)oldExpression.toString());
            }
            catch (JSQLParserException | TokenMgrError e) {
                LOGGER.error("Parsing error for {} : ", (Object)oldExpression);
                if (!LOGGER.isTraceEnabled()) break block14;
                LOGGER.trace("Parsing error details:", e);
            }
        }
        Expression leftExpression = newBinaryExpression.getLeftExpression();
        Expression rightExpression = newBinaryExpression.getRightExpression();
        Column column = (Column)(leftExpression instanceof Column ? leftExpression : rightExpression);
        for (OutboundDataOperation.Criterion newCriterion : newCriterions) {
            String value;
            String columnName = newCriterion.getDataId().substring(newCriterion.getDataId().lastIndexOf(47) + 1).toString();
            columnName = StringUtilities.quote((String)columnName);
            column.setColumnName(columnName);
            if (newCriterion.getOperator().equals((Object)newBinaryExpression.getStringExpression())) {
                Expression newExpr;
                block15: {
                    value = newCriterion.getValue().toString();
                    if (leftExpression instanceof Column ? newBinaryExpression.getRightExpression() instanceof StringValue : newBinaryExpression.getLeftExpression() instanceof StringValue) {
                        value = StringUtilities.singleQuote((String)value);
                    }
                    newExpr = null;
                    try {
                        newExpr = CCJSqlParserUtil.parseCondExpression((String)value);
                    }
                    catch (JSQLParserException | TokenMgrError e) {
                        try {
                            newExpr = CCJSqlParserUtil.parseExpression((String)value);
                        }
                        catch (JSQLParserException | TokenMgrError e2) {
                            LOGGER.error("Parsing error for {} : ", (Object)value);
                            if (!LOGGER.isTraceEnabled()) break block15;
                            LOGGER.trace("Parsing error details:", e2);
                        }
                    }
                }
                if (leftExpression instanceof Column) {
                    newBinaryExpression.setRightExpression(newExpr);
                    continue;
                }
                newBinaryExpression.setLeftExpression(newExpr);
                continue;
            }
            if (newBinaryExpression instanceof AndExpression && (leftExpression instanceof Column && rightExpression instanceof Function || rightExpression instanceof Column && leftExpression instanceof Function)) {
                Function function = (Function)(leftExpression instanceof Function ? leftExpression : rightExpression);
                if (!function.getName().equalsIgnoreCase("st_makeenvelope") || !newCriterion.getOperator().equals((Object)"area")) continue;
                String value2 = newCriterion.getValue().toString();
                CCJSqlParser parser = new CCJSqlParser((Reader)new StringReader(value2));
                try {
                    ExpressionList parameters = parser.SimpleExpressionList();
                    function.setParameters(parameters);
                }
                catch (Exception e) {
                    LOGGER.error("Parsing error for {} : ", (Object)value2, (Object)e);
                }
                continue;
            }
            if (!newCriterion.getOperator().equalsIgnoreCase((CharSequence)"IN")) continue;
            value = newCriterion.getValue().toString();
            if (value.charAt(0) == '(' && value.charAt(value.length() - 1) == ')') {
                value = value.substring(1, value.length() - 1);
            }
            newExpression = new InExpression((Expression)column, (ItemsList)new ExpressionList(Collections.singletonList(new RawStringValue(value))));
        }
        return newExpression;
    }

    private Expression modifyParentExpression(Expression parentExpression, Expression oldExpression, Expression newExpression) {
        block15: {
            block46: {
                OracleHierarchicalExpression oracleHierarchicalExpression;
                block47: {
                    block44: {
                        block45: {
                            block41: {
                                WhenClause whenClause;
                                block43: {
                                    block42: {
                                        block38: {
                                            CaseExpression caseExpression;
                                            block40: {
                                                block39: {
                                                    block35: {
                                                        BinaryExpression binaryExpression;
                                                        block37: {
                                                            block36: {
                                                                block33: {
                                                                    block34: {
                                                                        block31: {
                                                                            block32: {
                                                                                block29: {
                                                                                    block30: {
                                                                                        block27: {
                                                                                            block28: {
                                                                                                block25: {
                                                                                                    block26: {
                                                                                                        block24: {
                                                                                                            block23: {
                                                                                                                block19: {
                                                                                                                    Between between;
                                                                                                                    block22: {
                                                                                                                        block21: {
                                                                                                                            block20: {
                                                                                                                                block16: {
                                                                                                                                    ArrayElement arrayElement;
                                                                                                                                    block18: {
                                                                                                                                        block17: {
                                                                                                                                            if (!(parentExpression instanceof ArrayElement)) break block16;
                                                                                                                                            if (newExpression != null) break block17;
                                                                                                                                            parentExpression = null;
                                                                                                                                            break block15;
                                                                                                                                        }
                                                                                                                                        arrayElement = (ArrayElement)parentExpression;
                                                                                                                                        if (arrayElement.getLeftExpression() != oldExpression) break block18;
                                                                                                                                        arrayElement.setLeftExpression(newExpression);
                                                                                                                                        break block15;
                                                                                                                                    }
                                                                                                                                    if (arrayElement.getIndex() != oldExpression) break block15;
                                                                                                                                    arrayElement.setIndex(newExpression);
                                                                                                                                    break block15;
                                                                                                                                }
                                                                                                                                if (!(parentExpression instanceof Between)) break block19;
                                                                                                                                if (newExpression != null) break block20;
                                                                                                                                parentExpression = null;
                                                                                                                                break block15;
                                                                                                                            }
                                                                                                                            between = (Between)parentExpression;
                                                                                                                            if (between.getLeftExpression() != oldExpression) break block21;
                                                                                                                            between.setLeftExpression(newExpression);
                                                                                                                            break block15;
                                                                                                                        }
                                                                                                                        if (between.getBetweenExpressionStart() != oldExpression) break block22;
                                                                                                                        between.setBetweenExpressionStart(newExpression);
                                                                                                                        break block15;
                                                                                                                    }
                                                                                                                    if (between.getBetweenExpressionEnd() != oldExpression) break block15;
                                                                                                                    between.setBetweenExpressionEnd(newExpression);
                                                                                                                    break block15;
                                                                                                                }
                                                                                                                if (!(parentExpression instanceof Function)) break block23;
                                                                                                                Function function = (Function)parentExpression;
                                                                                                                if (function.getParameters() == null || function.getParameters().getExpressions() == null) break block15;
                                                                                                                for (int i = 0; i < function.getParameters().getExpressions().size(); ++i) {
                                                                                                                    if (function.getParameters().getExpressions().get(i) != oldExpression) continue;
                                                                                                                    function.getParameters().getExpressions().set(i, newExpression == null ? new NullValue() : newExpression);
                                                                                                                    break block15;
                                                                                                                }
                                                                                                                break block15;
                                                                                                            }
                                                                                                            if (!(parentExpression instanceof InExpression)) break block24;
                                                                                                            InExpression inExpression = (InExpression)parentExpression;
                                                                                                            if (inExpression.getLeftExpression() != oldExpression) break block15;
                                                                                                            inExpression.setLeftExpression(newExpression);
                                                                                                            break block15;
                                                                                                        }
                                                                                                        if (!(parentExpression instanceof SignedExpression)) break block25;
                                                                                                        if (newExpression != null) break block26;
                                                                                                        parentExpression = null;
                                                                                                        break block15;
                                                                                                    }
                                                                                                    SignedExpression signedExpression = (SignedExpression)parentExpression;
                                                                                                    if (signedExpression.getExpression() != oldExpression) break block15;
                                                                                                    signedExpression.setExpression(newExpression);
                                                                                                    break block15;
                                                                                                }
                                                                                                if (!(parentExpression instanceof IsNullExpression)) break block27;
                                                                                                if (newExpression != null) break block28;
                                                                                                parentExpression = null;
                                                                                                break block15;
                                                                                            }
                                                                                            IsNullExpression isNullExpression = (IsNullExpression)parentExpression;
                                                                                            if (isNullExpression.getLeftExpression() != oldExpression) break block15;
                                                                                            isNullExpression.setLeftExpression(newExpression);
                                                                                            break block15;
                                                                                        }
                                                                                        if (!(parentExpression instanceof ExistsExpression)) break block29;
                                                                                        if (newExpression != null) break block30;
                                                                                        parentExpression = null;
                                                                                        break block15;
                                                                                    }
                                                                                    ExistsExpression existsExpression = (ExistsExpression)parentExpression;
                                                                                    if (existsExpression.getRightExpression() != oldExpression) break block15;
                                                                                    existsExpression.setRightExpression(newExpression);
                                                                                    break block15;
                                                                                }
                                                                                if (!(parentExpression instanceof Not)) break block31;
                                                                                if (newExpression != null) break block32;
                                                                                parentExpression = null;
                                                                                break block15;
                                                                            }
                                                                            Not not = (Not)parentExpression;
                                                                            if (not.getExpression() != oldExpression) break block15;
                                                                            not.setExpression(newExpression);
                                                                            break block15;
                                                                        }
                                                                        if (!(parentExpression instanceof Parenthesis)) break block33;
                                                                        if (newExpression != null) break block34;
                                                                        parentExpression = null;
                                                                        break block15;
                                                                    }
                                                                    Parenthesis parenthesis = (Parenthesis)parentExpression;
                                                                    if (parenthesis.getExpression() != oldExpression) break block15;
                                                                    parenthesis.setExpression(newExpression);
                                                                    break block15;
                                                                }
                                                                if (!(parentExpression instanceof BinaryExpression)) break block35;
                                                                if (newExpression != null) break block36;
                                                                parentExpression = null;
                                                                break block15;
                                                            }
                                                            binaryExpression = (BinaryExpression)parentExpression;
                                                            if (binaryExpression.getLeftExpression() != oldExpression) break block37;
                                                            binaryExpression.setLeftExpression(newExpression);
                                                            break block15;
                                                        }
                                                        if (binaryExpression.getRightExpression() != oldExpression) break block15;
                                                        binaryExpression.setRightExpression(newExpression);
                                                        break block15;
                                                    }
                                                    if (!(parentExpression instanceof CaseExpression)) break block38;
                                                    caseExpression = (CaseExpression)parentExpression;
                                                    if (caseExpression.getSwitchExpression() != oldExpression) break block39;
                                                    caseExpression.setSwitchExpression(newExpression);
                                                    break block15;
                                                }
                                                if (caseExpression.getElseExpression() != oldExpression) break block40;
                                                caseExpression.setElseExpression(newExpression);
                                                break block15;
                                            }
                                            if (caseExpression.getWhenClauses() == null) break block15;
                                            for (int i = 0; i < caseExpression.getWhenClauses().size(); ++i) {
                                                if (caseExpression.getWhenClauses().get(i) != oldExpression) continue;
                                                if (newExpression == null) {
                                                    caseExpression.getWhenClauses().remove(i);
                                                } else {
                                                    caseExpression.getWhenClauses().set(i, newExpression);
                                                }
                                                break block15;
                                            }
                                            break block15;
                                        }
                                        if (!(parentExpression instanceof WhenClause)) break block41;
                                        if (newExpression != null) break block42;
                                        parentExpression = null;
                                        break block15;
                                    }
                                    whenClause = (WhenClause)parentExpression;
                                    if (whenClause.getWhenExpression() != oldExpression) break block43;
                                    whenClause.setWhenExpression(newExpression);
                                    break block15;
                                }
                                if (whenClause.getThenExpression() != oldExpression) break block15;
                                whenClause.setThenExpression(newExpression);
                                break block15;
                            }
                            if (!(parentExpression instanceof CastExpression)) break block44;
                            if (newExpression != null) break block45;
                            parentExpression = null;
                            break block15;
                        }
                        CastExpression castExpression = (CastExpression)parentExpression;
                        if (castExpression.getLeftExpression() != oldExpression) break block15;
                        castExpression.setLeftExpression(newExpression);
                        break block15;
                    }
                    if (!(parentExpression instanceof OracleHierarchicalExpression)) break block46;
                    oracleHierarchicalExpression = (OracleHierarchicalExpression)parentExpression;
                    if (oracleHierarchicalExpression.getStartExpression() != oldExpression) break block47;
                    oracleHierarchicalExpression.setStartExpression(newExpression);
                    break block15;
                }
                if (oracleHierarchicalExpression.getConnectExpression() != oldExpression) break block15;
                if (newExpression == null) {
                    parentExpression = null;
                } else {
                    oracleHierarchicalExpression.setConnectExpression(newExpression);
                }
                break block15;
            }
            if (parentExpression instanceof WithinGroupExpression) {
                WithinGroupExpression withinGroupExpression = (WithinGroupExpression)parentExpression;
                for (int i = 0; i < withinGroupExpression.getExprList().getExpressions().size(); ++i) {
                    if (withinGroupExpression.getExprList().getExpressions().get(i) != oldExpression) continue;
                    if (newExpression == null) {
                        withinGroupExpression.getExprList().getExpressions().remove(i);
                    } else {
                        withinGroupExpression.getExprList().getExpressions().set(i, newExpression);
                    }
                    break;
                }
            } else if (parentExpression instanceof RowConstructor) {
                RowConstructor rowConstructor = (RowConstructor)parentExpression;
                for (int i = 0; i < rowConstructor.getExprList().getExpressions().size(); ++i) {
                    if (rowConstructor.getExprList().getExpressions().get(i) != oldExpression) continue;
                    if (newExpression == null) {
                        rowConstructor.getExprList().getExpressions().remove(i);
                    } else {
                        rowConstructor.getExprList().getExpressions().set(i, newExpression);
                    }
                    break;
                }
            }
        }
        return parentExpression;
    }

    private OrderByElement buildOrderByElement(OrderByElement orderByElement, String dataId, List<Table> tables) {
        String[] tokens = dataId.split("/");
        assert (tokens.length > 0);
        String newDbName = tokens.length >= 3 ? tokens[tokens.length - 3] : null;
        String newTableName = tokens.length >= 2 ? tokens[tokens.length - 2] : null;
        String newColumnName = tokens[tokens.length - 1];
        Column column = (Column)orderByElement.getExpression();
        Table table = column.getTable();
        Table newTable = null;
        if (table != null && !table.getFullyQualifiedName().isEmpty() && newTableName != null) {
            if (tables.stream().anyMatch(t -> t.getAlias() != null && t.getAlias().getName().equals(table.getFullyQualifiedName()))) {
                newTable = new Table(table.getDatabase(), table.getSchemaName(), table.getName());
            } else {
                String[] tokens2;
                Database newDatabase = null;
                if (table.getDatabase() != null && !table.getDatabase().getFullyQualifiedName().isEmpty() && newDbName != null) {
                    newDatabase = new Database(newDbName);
                }
                if ((tokens2 = newTableName.split("\\.")).length == 2) {
                    newTableName = tokens2[1];
                }
                String newSchemaName = null;
                if (table.getSchemaName() != null) {
                    newSchemaName = tokens2.length == 2 ? tokens2[0] : "public";
                }
                newTable = new Table(newDatabase, newSchemaName, newTableName);
                newTable.setAlias(table.getAlias());
            }
        }
        OrderByElement newOrderByElement = new OrderByElement();
        newOrderByElement.setAsc(orderByElement.isAsc());
        newOrderByElement.setAscDescPresent(orderByElement.isAscDescPresent());
        newOrderByElement.setNullOrdering(orderByElement.getNullOrdering());
        Column newColumn = new Column(newTable, newColumnName);
        newColumn.setIndex(column.getIndex());
        newOrderByElement.setExpression((Expression)newColumn);
        return newOrderByElement;
    }

    private OutboundDataOperation extractDeclareCursorOperation(ChannelHandlerContext ctx, DeclareCursor stmt, List<ParameterValue> parameterValues) throws ParseException {
        if (!(stmt.getQuery() instanceof Select)) {
            return null;
        }
        ModuleOperation moduleOperation = this.extractSelectOperation(ctx, stmt.getQuery(), parameterValues, null, null);
        if (!(moduleOperation instanceof OutboundDataOperation)) {
            throw new IllegalStateException("unexpected");
        }
        OutboundDataOperation outboundDataOperation = (OutboundDataOperation)moduleOperation;
        outboundDataOperation.addAttribute("cursorName", (Object)stmt.getName());
        return outboundDataOperation;
    }

    private PgsqlStatement<DeclareCursor> modifyDeclareCursorStatement(ChannelHandlerContext ctx, PgsqlStatement<DeclareCursor> statement, OutboundDataOperation outboundDataOperation, boolean newStatement, List<SQLSession.ExpectedField> expectedFields) {
        DeclareCursor stmt;
        block3: {
            stmt = statement.getStatement();
            if (newStatement) {
                String sql = stmt.toString();
                try {
                    stmt = (DeclareCursor)CCJSqlParserUtil.parse((String)sql);
                }
                catch (JSQLParserException | TokenMgrError e) {
                    LOGGER.error("Parsing error for {} : ", (Object)sql);
                    if (!LOGGER.isTraceEnabled()) break block3;
                    LOGGER.trace("Parsing error details:", e);
                }
            }
        }
        Select select = stmt.getQuery();
        PgsqlStatement<Select> selectStatement = new PgsqlStatement<Select>(select, statement.getParameterTypes(), statement.getParameterFormats(), statement.getParameterValues(), statement.getResultFormats(), statement.getColumns());
        PgsqlStatement<Select> newSelectStatement = this.modifySelectStatement(ctx, selectStatement, outboundDataOperation, false, expectedFields);
        Select newSelect = newSelectStatement.getStatement();
        stmt.setQuery(newSelect);
        return new PgsqlStatement<DeclareCursor>(stmt, newSelectStatement.getParameterTypes(), newSelectStatement.getParameterFormats(), newSelectStatement.getParameterValues(), newSelectStatement.getResultFormats(), newSelectStatement.getColumns());
    }

    private OutboundDataOperation extractCursorFetchOperation(ChannelHandlerContext ctx, CursorFetch stmt) throws ParseException {
        OutboundDataOperation outboundDataOperation = new OutboundDataOperation();
        outboundDataOperation.setOperation(null);
        SQLSession session = this.getSession(ctx);
        SQLSession.CursorContext cursorStatus = session.getCursorContext(stmt.getName());
        if (cursorStatus != null) {
            outboundDataOperation.setDataIds(cursorStatus.getExpectedFields().stream().map(SQLSession.AbsractExpectedField::getAttributes).flatMap(Collection::stream).map(Map.Entry::getKey).map(CString::valueOf).collect(Collectors.toList()));
            outboundDataOperation.setPromise(cursorStatus.getPromise());
            outboundDataOperation.setInvolvedCSPs(cursorStatus.getInvolvedBackends());
            outboundDataOperation.setUnprotectingDataEnabled(cursorStatus.isUnprotectingDataEnabled());
        }
        outboundDataOperation.addAttribute("cursorName", (Object)stmt.getName());
        return outboundDataOperation;
    }

    private PgsqlStatement<CursorFetch> modifyCursorFetchStatement(ChannelHandlerContext ctx, PgsqlStatement<CursorFetch> statement, OutboundDataOperation outboundDataOperation, boolean newStatement) {
        CursorFetch stmt;
        block3: {
            stmt = statement.getStatement();
            if (newStatement) {
                String sql = stmt.toString();
                try {
                    stmt = (CursorFetch)CCJSqlParserUtil.parse((String)sql);
                }
                catch (JSQLParserException | TokenMgrError e) {
                    LOGGER.error("Parsing error for {} : ", (Object)sql);
                    if (!LOGGER.isTraceEnabled()) break block3;
                    LOGGER.trace("Parsing error details:", e);
                }
            }
        }
        return new PgsqlStatement<CursorFetch>(stmt, statement.getParameterTypes(), statement.getParameterFormats(), statement.getParameterValues(), statement.getResultFormats(), statement.getColumns());
    }

    private OutboundDataOperation extractCursorCloseOperation(ChannelHandlerContext ctx, CursorClose stmt) throws ParseException {
        OutboundDataOperation outboundDataOperation = new OutboundDataOperation();
        outboundDataOperation.setOperation(null);
        SQLSession session = this.getSession(ctx);
        SQLSession.CursorContext cursorStatus = session.getCursorContext(stmt.getName());
        if (cursorStatus != null) {
            outboundDataOperation.setDataIds(cursorStatus.getExpectedFields().stream().map(SQLSession.AbsractExpectedField::getAttributes).flatMap(Collection::stream).map(Map.Entry::getKey).map(CString::valueOf).collect(Collectors.toList()));
            outboundDataOperation.setPromise(cursorStatus.getPromise());
            outboundDataOperation.setInvolvedCSPs(cursorStatus.getInvolvedBackends());
            outboundDataOperation.setUnprotectingDataEnabled(cursorStatus.isUnprotectingDataEnabled());
        }
        outboundDataOperation.addAttribute("cursorName", (Object)stmt.getName());
        return outboundDataOperation;
    }

    private PgsqlStatement<CursorClose> modifyCursorCloseStatement(ChannelHandlerContext ctx, PgsqlStatement<CursorClose> statement, OutboundDataOperation outboundDataOperation, boolean newStatement) {
        CursorClose stmt;
        block3: {
            stmt = statement.getStatement();
            if (newStatement) {
                String sql = stmt.toString();
                try {
                    stmt = (CursorClose)CCJSqlParserUtil.parse((String)sql);
                }
                catch (JSQLParserException | TokenMgrError e) {
                    LOGGER.error("Parsing error for {} : ", (Object)sql);
                    if (!LOGGER.isTraceEnabled()) break block3;
                    LOGGER.trace("Parsing error details:", e);
                }
            }
        }
        return new PgsqlStatement<CursorClose>(stmt, statement.getParameterTypes(), statement.getParameterFormats(), statement.getParameterValues(), statement.getResultFormats(), statement.getColumns());
    }

    @Override
    public QueriesTransferMode<BindStep, CommandResults> processBindStep(ChannelHandlerContext ctx, BindStep bindStep) throws IOException {
        LOGGER.debug("Bind step: {}", (Object)bindStep);
        SQLSession session = this.getSession(ctx);
        TransferMode transferMode = session.getTransferMode();
        Map<Integer, List<Query>> newQueries = null;
        CommandResults response = null;
        Map<Byte, CString> errorDetails = null;
        SQLSession.ExtendedQueryStatus<ParseStep> parseStepStatus = null;
        SQLSession.ExtendedQueryStatus<BindStep> bindStepStatus = null;
        if (transferMode != TransferMode.ERROR) {
            parseStepStatus = session.getParseStepStatus(bindStep.getPreparedStatement());
            transferMode = TransferMode.FORWARD;
        }
        if (parseStepStatus != null) {
            bindStepStatus = session.addBindStep(bindStep, parseStepStatus.getOperation(), parseStepStatus.getType(), parseStepStatus.isToProcess(), parseStepStatus.getInvolvedBackends());
            Operation operation = parseStepStatus.getOperation();
            if (operation != null) {
                CString error = null;
                switch (operation) {
                    case READ: {
                        boolean retrieveWholeDataset = false;
                        Mode processingMode = this.getProcessingMode(ctx, retrieveWholeDataset, Operation.READ);
                        if (processingMode == null) {
                            transferMode = TransferMode.ERROR;
                            error = CString.valueOf((CharSequence)String.format("%s read not supported by this CLARUS proxy", retrieveWholeDataset ? "Dataset" : "Record"));
                            break;
                        }
                        if (processingMode == Mode.ORCHESTRATION) {
                            transferMode = TransferMode.FORWARD;
                            break;
                        }
                        if (processingMode != Mode.AS_IT_IS && processingMode != Mode.BUFFERING && processingMode != Mode.STREAMING) break;
                        transferMode = TransferMode.FORWARD;
                        break;
                    }
                    case CREATE: {
                        boolean inDatasetCreation = session.isInDatasetCreation();
                        Mode processingMode = this.getProcessingMode(ctx, inDatasetCreation, Operation.CREATE);
                        if (processingMode == null) {
                            transferMode = TransferMode.ERROR;
                            error = CString.valueOf((CharSequence)String.format("%s creation not supported by this CLARUS proxy", inDatasetCreation ? "Dataset" : "Record"));
                            break;
                        }
                        if (processingMode == Mode.BUFFERING) {
                            if (inDatasetCreation) {
                                transferMode = TransferMode.FORGET;
                                break;
                            }
                            transferMode = TransferMode.ERROR;
                            error = CString.valueOf((CharSequence)"Buffering processing mode not supported for record creation by this CLARUS proxy");
                            break;
                        }
                        if (processingMode == Mode.ORCHESTRATION) {
                            transferMode = TransferMode.ERROR;
                            error = CString.valueOf((CharSequence)"Orchestration processing mode not supported for dataset or record creation by this CLARUS proxy");
                            break;
                        }
                        if (processingMode != Mode.AS_IT_IS && processingMode != Mode.STREAMING) break;
                        transferMode = TransferMode.FORWARD;
                        break;
                    }
                    case UPDATE: {
                        boolean inDatasetModification = false;
                        Mode processingMode = this.getProcessingMode(ctx, inDatasetModification, Operation.UPDATE);
                        if (processingMode == null) {
                            transferMode = TransferMode.ERROR;
                            error = CString.valueOf((CharSequence)String.format("%s modification not supported by this CLARUS proxy", inDatasetModification ? "Dataset" : "Record"));
                            break;
                        }
                        if (processingMode == Mode.BUFFERING) {
                            if (inDatasetModification) {
                                transferMode = TransferMode.FORGET;
                                break;
                            }
                            transferMode = TransferMode.ERROR;
                            error = CString.valueOf((CharSequence)"Buffering processing mode not supported for record modification by this CLARUS proxy");
                            break;
                        }
                        if (processingMode == Mode.ORCHESTRATION) {
                            transferMode = TransferMode.ERROR;
                            error = CString.valueOf((CharSequence)"Orchestration processing mode not supported for dataset or record modification by this CLARUS proxy");
                            break;
                        }
                        if (processingMode != Mode.AS_IT_IS && processingMode != Mode.STREAMING) break;
                        transferMode = TransferMode.FORWARD;
                        break;
                    }
                    case DELETE: {
                        boolean deleteWholeDataset = parseStepStatus.getType() == SQLCommandType.DROP_TABLE;
                        Mode processingMode = this.getProcessingMode(ctx, deleteWholeDataset, Operation.DELETE);
                        if (processingMode == null) {
                            transferMode = TransferMode.ERROR;
                            error = CString.valueOf((CharSequence)String.format("%s delete not supported by this CLARUS proxy", deleteWholeDataset ? "Dataset" : "Record"));
                            break;
                        }
                        if (processingMode == Mode.BUFFERING) {
                            if (deleteWholeDataset) {
                                transferMode = TransferMode.FORGET;
                                break;
                            }
                            transferMode = TransferMode.ERROR;
                            error = CString.valueOf((CharSequence)"Buffering processing mode not supported for record delete by this CLARUS proxy");
                            break;
                        }
                        if (processingMode == Mode.ORCHESTRATION) {
                            transferMode = TransferMode.ERROR;
                            error = CString.valueOf((CharSequence)"Orchestration processing mode not supported for dataset or record delete by this CLARUS proxy");
                            break;
                        }
                        if (processingMode != Mode.AS_IT_IS && processingMode != Mode.STREAMING) break;
                        transferMode = TransferMode.FORWARD;
                        break;
                    }
                }
                if (error != null) {
                    errorDetails = new LinkedHashMap<Byte, CString>();
                    errorDetails.put((byte)83, CString.valueOf((CharSequence)"FATAL"));
                    errorDetails.put((byte)77, error);
                }
            }
        }
        session.setTransferMode(transferMode);
        if (transferMode == TransferMode.FORWARD) {
            if (parseStepStatus != null) {
                session.setCommandInvolvedBackends(Collections.singletonList(this.getPreferredBackend(ctx)), false);
                SQLSession.DescribeStepStatus describeStepStatus = session.getDescribeStepStatus((byte)83, parseStepStatus.getQuery().getName());
                Result<List<Query>, CommandResults, CString> result = this.buildNewQueries(ctx, parseStepStatus, describeStepStatus, bindStepStatus);
                if (result.isQuery()) {
                    newQueries = result.queriesAsMap();
                } else if (result.isResponse()) {
                    transferMode = TransferMode.FORGET;
                    response = result.response();
                    newQueries = null;
                } else if (result.isError()) {
                    transferMode = TransferMode.ERROR;
                    errorDetails = new LinkedHashMap<Byte, CString>();
                    errorDetails.put((byte)83, CString.valueOf((CharSequence)"FATAL"));
                    errorDetails.put((byte)77, result.error());
                    if (session.getTransactionStatus() == 84) {
                        session.setTransactionStatus((byte)69);
                        session.setTransactionErrorDetails(errorDetails);
                    }
                    session.resetCurrentCommand();
                    newQueries = null;
                }
            } else {
                newQueries = Collections.singletonMap(this.getPreferredBackend(ctx), Collections.singletonList(bindStep));
            }
        } else if (transferMode == TransferMode.FORGET) {
            if (parseStepStatus != null) {
                errorDetails = this.bufferQuery(ctx, parseStepStatus.getQuery());
            }
            if (errorDetails == null) {
                errorDetails = this.bufferQuery(ctx, bindStep);
            }
            if (errorDetails != null) {
                transferMode = TransferMode.ERROR;
                session.resetCurrentCommand();
            } else {
                response = new CommandResults();
                response.setBindCompleteRequired(true);
            }
            newQueries = null;
        } else if (transferMode == TransferMode.ERROR) {
            if (errorDetails != null) {
                if (session.getTransactionStatus() == 84) {
                    session.setTransactionStatus((byte)69);
                    session.setTransactionErrorDetails(errorDetails);
                }
                session.resetCurrentCommand();
            } else {
                transferMode = TransferMode.FORGET;
                response = new CommandResults();
            }
            newQueries = null;
        }
        QueriesTransferMode<BindStep, CommandResults> mode = new QueriesTransferMode<BindStep, CommandResults>(transferMode, newQueries, response, errorDetails);
        LOGGER.debug("Bind step processed: new queries={}, transfer mode={}", mode.getNewQueries(), (Object)mode.getTransferMode());
        return mode;
    }

    @Override
    public QueriesTransferMode<DescribeStep, CommandResults> processDescribeStep(ChannelHandlerContext ctx, DescribeStep describeStep) throws IOException {
        LOGGER.debug("Describe step: {}", (Object)describeStep);
        SQLSession session = this.getSession(ctx);
        TransferMode transferMode = session.getTransferMode();
        Map<Integer, List<DescribeStep>> newQueries = null;
        boolean buildResponse = false;
        CommandResults response = null;
        Map<Byte, CString> errorDetails = null;
        if (transferMode == TransferMode.FORWARD) {
            SQLSession.DescribeStepStatus describeStepStatus = session.addDescribeStep(describeStep);
            if (describeStep.getCode() == 83) {
                transferMode = TransferMode.FORGET;
                buildResponse = true;
                newQueries = null;
            } else if (describeStep.getCode() == 80) {
                ParseStep parseStep = null;
                SQLSession.ExtendedQueryStatus<BindStep> bindStepStatus = session.getBindStepStatus(describeStep.getName());
                if (bindStepStatus != null) {
                    BindStep bindStep = bindStepStatus.getQuery();
                    SQLSession.ExtendedQueryStatus<ParseStep> parseStepStatus = session.getParseStepStatus(bindStep.getPreparedStatement());
                    parseStep = parseStepStatus.getQuery();
                }
                if (parseStep != null && bindStepStatus != null) {
                    if (parseStep.isMetadata()) {
                        transferMode = TransferMode.FORGET;
                        buildResponse = true;
                        newQueries = null;
                    } else {
                        session.setCommandInvolvedBackends(bindStepStatus.getInvolvedBackends());
                        if (session.getCommandInvolvedBackends().isEmpty()) {
                            transferMode = TransferMode.FORGET;
                            buildResponse = true;
                        } else {
                            List<Integer> involvedBackends = session.getCommandInvolvedBackends();
                            newQueries = involvedBackends.size() > 1 ? involvedBackends.stream().map(backend -> new AbstractMap.SimpleEntry<Integer, List<DescribeStep>>((Integer)backend, Collections.singletonList(new DescribeStep(describeStep.getCode(), describeStep.getName())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : Collections.singletonMap(involvedBackends.get(0), Collections.singletonList(describeStep));
                            newQueries.values().stream().filter(l -> l != null).flatMap(Collection::stream).filter(q -> q != null).forEach(Query::retain);
                            session.setCurrentDescribeStepStatus(describeStepStatus);
                        }
                    }
                } else {
                    newQueries = Collections.singletonMap(this.getPreferredBackend(ctx), Collections.singletonList(describeStep));
                }
            }
        } else if (transferMode == TransferMode.FORGET) {
            errorDetails = this.bufferQuery(ctx, describeStep);
            if (errorDetails != null) {
                transferMode = TransferMode.ERROR;
                session.resetCurrentCommand();
            }
            buildResponse = true;
            newQueries = null;
        } else if (transferMode == TransferMode.ERROR) {
            transferMode = TransferMode.FORGET;
            buildResponse = false;
            response = new CommandResults();
            newQueries = null;
        }
        if (transferMode == TransferMode.FORGET && buildResponse) {
            SQLSession.ExtendedQueryStatus<BindStep> bindStepStatus;
            response = new CommandResults();
            ParseStep parseStep = null;
            if (describeStep.getCode() == 83) {
                SQLSession.ExtendedQueryStatus<ParseStep> parseStepStatus = session.getParseStepStatus(describeStep.getName());
                parseStep = parseStepStatus.getQuery();
                if (parseStep != null && parseStep.getParameterTypes() != null) {
                    ArrayList<Long> parameterTypes = new ArrayList<Long>(parseStep.getParameterTypes());
                    response.setParameterDescription(parameterTypes);
                } else {
                    response.setParameterDescription(Collections.emptyList());
                }
            } else if (describeStep.getCode() == 80 && (bindStepStatus = session.getBindStepStatus(describeStep.getName())) != null) {
                BindStep bindStep = bindStepStatus.getQuery();
                SQLSession.ExtendedQueryStatus<ParseStep> parseStepStatus = session.getParseStepStatus(bindStep.getPreparedStatement());
                parseStep = parseStepStatus.getQuery();
            }
            List<PgsqlRowDescriptionMessage.Field> rowDescription = parseStep != null && parseStep.getColumns() != null ? (parseStep.isMetadata() ? Stream.of("column_name", "protected_column_name").map(CString::valueOf).map(PgsqlRowDescriptionMessage.Field::new).peek(f -> f.setTypeOID(705)).peek(f -> f.setTypeSize((short)-2)).peek(f -> f.setTypeModifier(-1)).collect(Collectors.toList()) : parseStep.getColumns().stream().map(PgsqlRowDescriptionMessage.Field::new).collect(Collectors.toList())) : Collections.emptyList();
            response.setRowDescription(rowDescription);
        }
        QueriesTransferMode<DescribeStep, CommandResults> mode = new QueriesTransferMode<DescribeStep, CommandResults>(transferMode, newQueries, response, errorDetails);
        LOGGER.debug("Describe step processed: new queries={}, transfer mode={}", mode.getNewQueries(), (Object)mode.getTransferMode());
        return mode;
    }

    @Override
    public QueriesTransferMode<ExecuteStep, CommandResults> processExecuteStep(ChannelHandlerContext ctx, ExecuteStep executeStep) throws IOException {
        LOGGER.debug("Execute step: {}", (Object)executeStep);
        SQLSession session = this.getSession(ctx);
        TransferMode transferMode = session.getTransferMode();
        Map<Integer, List<ExecuteStep>> newQueries = null;
        CommandResults response = null;
        Map<Byte, CString> errorDetails = null;
        if (transferMode == TransferMode.FORWARD) {
            ParseStep parseStep = null;
            SQLSession.ExtendedQueryStatus<BindStep> bindStepStatus = session.getBindStepStatus(executeStep.getPortal());
            if (bindStepStatus != null) {
                BindStep bindStep = bindStepStatus.getQuery();
                SQLSession.ExtendedQueryStatus<ParseStep> parseStepStatus = session.getParseStepStatus(bindStep.getPreparedStatement());
                parseStep = parseStepStatus.getQuery();
            }
            if (parseStep != null && bindStepStatus != null) {
                if (parseStep.isMetadata()) {
                    transferMode = TransferMode.FORGET;
                    MetadataOperation metadataOperation = new MetadataOperation();
                    metadataOperation.setDataIds(parseStep.getColumns());
                    metadataOperation = this.newMetaDataOperation(ctx, metadataOperation);
                    response = new CommandResults();
                    if (metadataOperation.isModified()) {
                        boolean multipleDatasets;
                        List metadata = metadataOperation.getMetadata();
                        Set prefixes = metadata.stream().map(Map.Entry::getKey).map(id -> id.substring(0, id.lastIndexOf(47))).collect(Collectors.toSet());
                        boolean bl = multipleDatasets = prefixes.size() > 1 || ((CString)prefixes.stream().findFirst().get()).equals((Object)"*");
                        if (!multipleDatasets) {
                            metadata = metadata.stream().map(e -> new AbstractMap.SimpleEntry(((CString)e.getKey()).substring(((CString)e.getKey()).lastIndexOf(47) + 1), e.getValue())).collect(Collectors.toList());
                        }
                        List<List<ByteBuf>> rows = this.buildRows(metadata, bindStepStatus.getInvolvedBackends(), executeStep.getMaxRows());
                        response.setRows(rows);
                        response.setCompleteTag(CString.valueOf((CharSequence)("SELECT " + rows.size())));
                    } else {
                        response.setCompleteTag(CString.valueOf((CharSequence)"SELECT 0"));
                    }
                    newQueries = null;
                } else {
                    session.setCommandInvolvedBackends(bindStepStatus.getInvolvedBackends());
                    if (session.getCommandInvolvedBackends().isEmpty()) {
                        transferMode = TransferMode.FORGET;
                        response = new CommandResults();
                        response.setCompleteTag(CString.valueOf((CharSequence)"SELECT 0"));
                    } else {
                        List<Integer> involvedBackends = session.getCommandInvolvedBackends();
                        newQueries = involvedBackends.size() > 1 ? involvedBackends.stream().map(backend -> new AbstractMap.SimpleEntry<Integer, List<ExecuteStep>>((Integer)backend, Collections.singletonList(new ExecuteStep(executeStep.getPortal(), executeStep.getMaxRows())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : Collections.singletonMap(involvedBackends.get(0), Collections.singletonList(executeStep));
                        newQueries.values().stream().filter(l -> l != null).flatMap(Collection::stream).filter(q -> q != null).forEach(Query::retain);
                        if (session.getCurrentDescribeStepStatus() == null) {
                            SQLSession.DescribeStepStatus describeStepStatus = session.getDescribeStepStatus((byte)80, bindStepStatus.getQuery().getName());
                            if (describeStepStatus == null) {
                                describeStepStatus = session.getDescribeStepStatus((byte)83, parseStep.getName());
                            }
                            session.setCurrentDescribeStepStatus(describeStepStatus);
                        }
                    }
                }
            } else {
                newQueries = Collections.singletonMap(this.getPreferredBackend(ctx), Collections.singletonList(executeStep));
            }
        } else if (transferMode == TransferMode.FORGET) {
            SQLSession.ExtendedQueryStatus<BindStep> bindStepStatus = session.getBindStepStatus(executeStep.getPortal());
            if (bindStepStatus != null) {
                response = new CommandResults();
                Operation operation = bindStepStatus.getOperation();
                if (operation == null) {
                    SQLCommandType type = bindStepStatus.getType();
                    if (type != null) {
                        switch (type) {
                            case SET: {
                                response.setCompleteTag(CString.valueOf((CharSequence)"SET"));
                                break;
                            }
                            case FETCH_CURSOR: {
                                response.setCompleteTag(CString.valueOf((CharSequence)"FETCH 0"));
                                break;
                            }
                            case CLOSE_CURSOR: {
                                response.setCompleteTag(CString.valueOf((CharSequence)"CLOSE CURSOR"));
                                break;
                            }
                            case START_TRANSACTION: {
                                response.setCompleteTag(CString.valueOf((CharSequence)"BEGIN"));
                                break;
                            }
                            case COMMIT: {
                                response.setCompleteTag(CString.valueOf((CharSequence)"COMMIT"));
                                break;
                            }
                        }
                    }
                } else {
                    block7 : switch (operation) {
                        case READ: {
                            SQLCommandType type = bindStepStatus.getType();
                            if (type == null) break;
                            switch (type) {
                                case SELECT: {
                                    response.setCompleteTag(CString.valueOf((CharSequence)"SELECT 0"));
                                    break block7;
                                }
                                case DECLARE_CURSOR: {
                                    response.setCompleteTag(CString.valueOf((CharSequence)"DECLARE CURSOR"));
                                    break block7;
                                }
                            }
                            break;
                        }
                        case CREATE: {
                            SQLCommandType type = bindStepStatus.getType();
                            if (type == null) break;
                            switch (type) {
                                case CREATE_TABLE: {
                                    response.setCompleteTag(CString.valueOf((CharSequence)"CREATE TABLE"));
                                    break block7;
                                }
                                case ALTER_TABLE: {
                                    response.setCompleteTag(CString.valueOf((CharSequence)"ALTER TABLE"));
                                    break block7;
                                }
                                case ADD_GEOMETRY_COLUMN: {
                                    response.setCompleteTag(CString.valueOf((CharSequence)"SELECT 1"));
                                    break block7;
                                }
                                case INSERT: {
                                    response.setCompleteTag(CString.valueOf((CharSequence)"INSERT 0 1"));
                                    break block7;
                                }
                            }
                            break;
                        }
                        case UPDATE: {
                            SQLCommandType type = bindStepStatus.getType();
                            if (type == null) break;
                            switch (type) {
                                case ALTER_TABLE: {
                                    response.setCompleteTag(CString.valueOf((CharSequence)"ALTER TABLE"));
                                    break block7;
                                }
                                case ADD_GEOMETRY_COLUMN: {
                                    response.setCompleteTag(CString.valueOf((CharSequence)"SELECT 1"));
                                    break block7;
                                }
                                case UPDATE: {
                                    response.setCompleteTag(CString.valueOf((CharSequence)"UPDATE 0 1"));
                                    break block7;
                                }
                            }
                            break;
                        }
                        case DELETE: {
                            SQLCommandType type = bindStepStatus.getType();
                            if (type == null) break;
                            switch (type) {
                                case DROP_TABLE: {
                                    response.setCompleteTag(CString.valueOf((CharSequence)"DROP TABLE"));
                                    break block7;
                                }
                                case DELETE: {
                                    response.setCompleteTag(CString.valueOf((CharSequence)"DELETE 0 1"));
                                    break block7;
                                }
                            }
                            break;
                        }
                    }
                }
                errorDetails = this.bufferQuery(ctx, executeStep);
                if (errorDetails != null) {
                    transferMode = TransferMode.ERROR;
                }
                newQueries = null;
            } else {
                transferMode = TransferMode.FORWARD;
                newQueries = Collections.singletonMap(this.getPreferredBackend(ctx), Collections.singletonList(executeStep));
            }
        } else if (transferMode == TransferMode.ERROR) {
            transferMode = TransferMode.FORGET;
            response = new CommandResults();
            newQueries = null;
        }
        QueriesTransferMode<ExecuteStep, CommandResults> mode = new QueriesTransferMode<ExecuteStep, CommandResults>(transferMode, newQueries, response, errorDetails);
        LOGGER.debug("Execute step processed: new queries={}, transfer mode={}", mode.getNewQueries(), (Object)mode.getTransferMode());
        return mode;
    }

    private List<List<ByteBuf>> buildRows(List<Map.Entry<CString, List<CString>>> metadata, List<Integer> involvedBackends, int maxSize) {
        List<List<ByteBuf>> rows = metadata.stream().flatMap(e -> {
            CString key = ((CString)e.getKey()).replace('/', '.');
            ByteBuf clearColumn = key.getByteBuf(key.length());
            List values = (List)e.getValue();
            List protectedColumns = IntStream.range(0, values.size()).mapToObj(csp -> {
                CString value = (CString)values.get(csp);
                ByteBuf protectedColumn = null;
                if (value != null) {
                    value = CString.valueOf((CharSequence)("csp" + (csp + 1))).append('.').append((CharSequence)value.replace('/', '.'));
                    protectedColumn = value.getByteBuf(value.length());
                }
                return protectedColumn;
            }).filter(pc -> pc != null).collect(Collectors.toList());
            if (protectedColumns.isEmpty()) {
                protectedColumns.add(null);
            }
            if (protectedColumns.size() > 1) {
                clearColumn.retain(protectedColumns.size() - 1);
            }
            return protectedColumns.stream().map(pc -> Stream.of(clearColumn, pc).collect(Collectors.toList()));
        }).limit(maxSize < 0 ? Integer.MAX_VALUE : (long)maxSize).collect(Collectors.toList());
        return rows;
    }

    @Override
    public QueriesTransferMode<CloseStep, CommandResults> processCloseStep(ChannelHandlerContext ctx, CloseStep closeStep) throws IOException {
        LOGGER.debug("Close step: {}", (Object)closeStep);
        SQLSession session = this.getSession(ctx);
        TransferMode transferMode = session.getTransferMode();
        Map<Integer, List<CloseStep>> newQueries = null;
        CommandResults response = null;
        Map<Byte, CString> errorDetails = null;
        if (transferMode == TransferMode.FORWARD) {
            SQLSession.ExtendedQueryStatus<ParseStep> parseStepStatus = null;
            SQLSession.ExtendedQueryStatus<BindStep> bindStepStatus = null;
            if (closeStep.getCode() == 83) {
                parseStepStatus = session.getParseStepStatus(closeStep.getName());
                if (parseStepStatus != null) {
                    ParseStep parseStep = parseStepStatus.getQuery();
                    if (parseStep.isMetadata()) {
                        transferMode = TransferMode.FORGET;
                        response = new CommandResults();
                        response.setCloseCompleteRequired(true);
                        newQueries = null;
                    }
                    session.setCommandInvolvedBackends(parseStepStatus.getInvolvedBackends());
                    session.removeParseStep(closeStep.getName());
                }
            } else {
                bindStepStatus = session.getBindStepStatus(closeStep.getName());
                if (bindStepStatus != null) {
                    session.setCommandInvolvedBackends(bindStepStatus.getInvolvedBackends());
                    session.removeBindStep(closeStep.getName());
                }
            }
            if (transferMode == TransferMode.FORWARD) {
                if (parseStepStatus != null || bindStepStatus != null) {
                    if (session.getCommandInvolvedBackends().isEmpty()) {
                        transferMode = TransferMode.FORGET;
                        response = new CommandResults();
                        response.setCloseCompleteRequired(true);
                    } else {
                        List<Integer> involvedBackends = session.getCommandInvolvedBackends();
                        newQueries = involvedBackends.size() > 1 ? involvedBackends.stream().map(backend -> new AbstractMap.SimpleEntry<Integer, List<CloseStep>>((Integer)backend, Collections.singletonList(new CloseStep(closeStep.getCode(), closeStep.getName())))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : Collections.singletonMap(involvedBackends.get(0), Collections.singletonList(closeStep));
                        newQueries.values().stream().filter(l -> l != null).flatMap(Collection::stream).filter(q -> q != null).forEach(Query::retain);
                    }
                } else {
                    newQueries = Collections.singletonMap(this.getPreferredBackend(ctx), Collections.singletonList(closeStep));
                }
            }
        } else if (transferMode == TransferMode.FORGET) {
            errorDetails = this.bufferQuery(ctx, closeStep);
            if (errorDetails != null) {
                transferMode = TransferMode.ERROR;
            } else {
                response = new CommandResults();
                response.setCloseCompleteRequired(true);
            }
            newQueries = null;
        } else if (transferMode == TransferMode.ERROR) {
            transferMode = TransferMode.FORGET;
            response = new CommandResults();
            newQueries = null;
        }
        QueriesTransferMode<CloseStep, CommandResults> mode = new QueriesTransferMode<CloseStep, CommandResults>(transferMode, newQueries, response, errorDetails);
        LOGGER.debug("Close step processed: new queries={}, transfer mode={}", mode.getNewQueries(), (Object)mode.getTransferMode());
        return mode;
    }

    @Override
    public QueriesTransferMode<SynchronizeStep, Byte> processSynchronizeStep(ChannelHandlerContext ctx, SynchronizeStep synchronizeStep) throws IOException {
        LOGGER.debug("Synchronize step: {}", (Object)synchronizeStep);
        SQLSession session = this.getSession(ctx);
        TransferMode transferMode = session.getTransferMode();
        Map<Integer, List<Query>> newQueries = null;
        Byte response = null;
        Map<Byte, CString> errorDetails = null;
        if (transferMode == TransferMode.FORWARD) {
            if (session.getCommandInvolvedBackends() != null) {
                if (session.getCommandInvolvedBackends().isEmpty()) {
                    transferMode = TransferMode.FORGET;
                    response = session.getTransactionStatus();
                    session.resetCurrentCommand();
                } else {
                    List<Integer> involvedBackends = session.getCommandInvolvedBackends();
                    newQueries = involvedBackends.size() > 1 ? involvedBackends.stream().map(backend -> new AbstractMap.SimpleEntry<Integer, List<SynchronizeStep>>((Integer)backend, Collections.singletonList(new SynchronizeStep()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : Collections.singletonMap(involvedBackends.get(0), Collections.singletonList(synchronizeStep));
                    newQueries.values().stream().filter(l -> l != null).flatMap(Collection::stream).filter(q -> q != null).forEach(Query::retain);
                }
            } else {
                newQueries = Collections.singletonMap(this.getPreferredBackend(ctx), Collections.singletonList(synchronizeStep));
            }
        } else if (transferMode == TransferMode.FORGET) {
            response = session.getTransactionStatus();
            errorDetails = this.bufferQuery(ctx, synchronizeStep);
            if (errorDetails != null) {
                transferMode = TransferMode.ERROR;
            }
            newQueries = null;
        } else if (transferMode == TransferMode.ERROR) {
            session.setTransferMode(TransferMode.FORWARD);
            transferMode = TransferMode.FORGET;
            response = session.getTransactionStatus();
            newQueries = null;
        }
        QueriesTransferMode<SynchronizeStep, Byte> mode = new QueriesTransferMode<SynchronizeStep, Byte>(transferMode, newQueries, response, errorDetails);
        LOGGER.debug("Synchronize step processed: new queries={}, transfer mode={}", mode.getNewQueries(), (Object)mode.getTransferMode());
        return mode;
    }

    @Override
    public QueriesTransferMode<FlushStep, Void> processFlushStep(ChannelHandlerContext ctx, FlushStep flushStep) throws IOException {
        LOGGER.debug("Flush step: {}", (Object)flushStep);
        SQLSession session = this.getSession(ctx);
        TransferMode transferMode = session.getTransferMode();
        Map<Integer, List<Query>> newQueries = null;
        Object response = null;
        Map<Byte, CString> errorDetails = null;
        if (transferMode == TransferMode.FORWARD) {
            if (session.getCommandInvolvedBackends() != null) {
                if (session.getCommandInvolvedBackends().isEmpty()) {
                    transferMode = TransferMode.FORGET;
                } else {
                    List<Integer> involvedBackends = session.getCommandInvolvedBackends();
                    newQueries = involvedBackends.size() > 1 ? involvedBackends.stream().map(backend -> new AbstractMap.SimpleEntry<Integer, List<FlushStep>>((Integer)backend, Collections.singletonList(new FlushStep()))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)) : Collections.singletonMap(involvedBackends.get(0), Collections.singletonList(flushStep));
                    newQueries.values().stream().filter(l -> l != null).flatMap(Collection::stream).filter(q -> q != null).forEach(Query::retain);
                }
            } else {
                newQueries = Collections.singletonMap(this.getPreferredBackend(ctx), Collections.singletonList(flushStep));
            }
        } else if (transferMode == TransferMode.FORGET) {
            errorDetails = this.bufferQuery(ctx, flushStep);
            if (errorDetails != null) {
                transferMode = TransferMode.ERROR;
            }
            newQueries = null;
        } else if (transferMode == TransferMode.ERROR) {
            transferMode = TransferMode.FORGET;
            response = null;
            newQueries = null;
        }
        QueriesTransferMode mode = new QueriesTransferMode(transferMode, newQueries, response, errorDetails);
        LOGGER.debug("Flush step processed: new queries={}, transfer mode={}", mode.getNewQueries(), (Object)mode.getTransferMode());
        return mode;
    }

    private Result<List<Query>, CommandResults, CString> buildNewQueries(ChannelHandlerContext ctx, SQLSession.ExtendedQueryStatus<ParseStep> parseStepStatus, SQLSession.DescribeStepStatus describeStepStatus, SQLSession.ExtendedQueryStatus<BindStep> bindStepStatus) throws IOException {
        List<List<Query>> bufferedQueries = this.processBufferedQueries(ctx);
        SQLSession session = this.getSession(ctx);
        session.setCommandInvolvedBackends(bindStepStatus.getInvolvedBackends());
        List<List<ExtendedQuery>> newExtendedQueries = null;
        if (parseStepStatus.isToProcess()) {
            Result<List<ExtendedQuery>, CommandResults, CString> result = this.processExtendedQuery(ctx, parseStepStatus, describeStepStatus, bindStepStatus);
            if (result.isQuery()) {
                newExtendedQueries = result.queries();
            } else {
                if (result.isResponse()) {
                    return Result.response(result.response());
                }
                if (result.isError()) {
                    return Result.error(result.error());
                }
            }
        } else {
            ArrayList<ExtendedQuery> queries = new ArrayList<ExtendedQuery>();
            queries.add(parseStepStatus.getQuery());
            if (describeStepStatus != null) {
                queries.add((ExtendedQuery)describeStepStatus.getQuery());
                session.setCurrentDescribeStepStatus(describeStepStatus);
            }
            queries.add(bindStepStatus.getQuery());
            newExtendedQueries = Collections.singletonList(queries);
            session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARSE_COMPLETE);
            if (describeStepStatus != null) {
                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARAMETER_DESCRIPTION);
                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.ROW_DESCRIPTION_AND_DATA_ROW_OR_NO_DATA);
            }
        }
        newExtendedQueries.stream().filter(l -> l != null).flatMap(Collection::stream).filter(q -> q != null).forEach(Query::retain);
        List newQueries = null;
        if (bufferedQueries.isEmpty() || bufferedQueries.stream().allMatch(List::isEmpty)) {
            newQueries = newExtendedQueries.stream().map(l -> l != null ? l.stream().collect(Collectors.toList()) : null).collect(Collectors.toList());
        } else {
            int nbDirected = bufferedQueries.size() > newExtendedQueries.size() ? bufferedQueries.size() : newExtendedQueries.size();
            newQueries = new ArrayList(nbDirected);
            for (int i = 0; i < nbDirected; ++i) {
                List<ExtendedQuery> directedExtendedQueries;
                List<Query> directedBufferedQueries;
                List<Query> list = directedBufferedQueries = i < bufferedQueries.size() ? bufferedQueries.get(i) : null;
                if (directedBufferedQueries == null) {
                    directedBufferedQueries = Collections.emptyList();
                }
                List<ExtendedQuery> list2 = directedExtendedQueries = i < newExtendedQueries.size() ? newExtendedQueries.get(i) : null;
                if (directedExtendedQueries == null) {
                    directedExtendedQueries = Collections.emptyList();
                }
                List directedQueries = Stream.concat(directedBufferedQueries.stream(), directedExtendedQueries.stream()).collect(Collectors.toList());
                newQueries.add(directedQueries);
            }
        }
        return Result.queries(newQueries);
    }

    private Result<List<ExtendedQuery>, CommandResults, CString> processExtendedQuery(ChannelHandlerContext ctx, SQLSession.ExtendedQueryStatus<ParseStep> parseStepStatus, SQLSession.DescribeStepStatus describeStepStatus, SQLSession.ExtendedQueryStatus<BindStep> bindStepStatus) {
        ParseStep parseStep = parseStepStatus.getQuery();
        BindStep bindStep = bindStepStatus.getQuery();
        if (parseStep.getSQL().isBuffered()) {
            parseStep.getSQL().getByteBuf().readerIndex(0);
        }
        Statement stmt = this.parseSQL(ctx, parseStep.getSQL());
        SQLSession session = this.getSession(ctx);
        Result result = null;
        if (stmt != null) {
            List<CString> columns;
            List<ParameterValue> parameterValues = bindStep.getParameterValues().stream().map(ParameterValue::new).collect(Collectors.toList());
            if (!parseStep.getParameterTypes().isEmpty()) {
                List<Long> parameterTypes = parseStep.getParameterTypes();
                for (int idx = 0; idx < parameterTypes.size(); ++idx) {
                    ((ParameterValue)parameterValues.get(idx)).setType(parameterTypes.get(idx));
                }
            }
            if (!bindStep.getParameterFormats().isEmpty()) {
                List<Short> formats = bindStep.getParameterFormats();
                for (int i = 0; i < parameterValues.size(); ++i) {
                    ParameterValue parameterValue = (ParameterValue)parameterValues.get(i);
                    Short format = formats.get(formats.size() == 1 ? 0 : i);
                    parameterValue.setFormat(format);
                }
            }
            OutboundDataOperation moduleOperation = null;
            try {
                if (stmt instanceof SetStatement) {
                    moduleOperation = this.extractSetOperation(ctx, (SetStatement)stmt);
                } else if (stmt instanceof StartTransaction) {
                    moduleOperation = this.extractStartTransactionOperation(ctx, (StartTransaction)stmt);
                } else if (stmt instanceof Commit) {
                    moduleOperation = this.extractCommitOperation(ctx, (Commit)stmt);
                } else if (stmt instanceof CreateTable) {
                    moduleOperation = this.extractCreateTableOperation(ctx, (CreateTable)stmt);
                } else if (stmt instanceof Alter) {
                    moduleOperation = this.extractAlterTableOperation(ctx, (Alter)stmt, null, bindStepStatus.getOperation());
                } else if (stmt instanceof CreateIndex) {
                    moduleOperation = this.extractCreateIndexOperation(ctx, (CreateIndex)stmt, null, bindStepStatus.getOperation());
                } else if (stmt instanceof Drop) {
                    moduleOperation = this.extractDropTableOperation(ctx, (Drop)stmt);
                } else if (stmt instanceof Insert) {
                    moduleOperation = this.extractInsertOperation(ctx, (Insert)stmt, parameterValues, null);
                } else if (!(stmt instanceof Update) && !(stmt instanceof Delete)) {
                    if (stmt instanceof Select) {
                        moduleOperation = this.extractSelectOperation(ctx, (Select)stmt, parameterValues, null, bindStepStatus.getOperation());
                    } else if (stmt instanceof DeclareCursor) {
                        moduleOperation = this.extractDeclareCursorOperation(ctx, (DeclareCursor)stmt, parameterValues);
                    } else if (stmt instanceof CursorFetch) {
                        moduleOperation = this.extractCursorFetchOperation(ctx, (CursorFetch)stmt);
                    } else if (stmt instanceof CursorClose) {
                        moduleOperation = this.extractCursorCloseOperation(ctx, (CursorClose)stmt);
                    }
                }
            }
            catch (ParseException e2) {
                return Result.error(CString.valueOf((CharSequence)e2.getMessage()));
            }
            if (moduleOperation instanceof MetadataOperation) {
                MetadataOperation metadataOperation = (MetadataOperation)moduleOperation;
                columns = metadataOperation.getDataIds();
                parseStep.setColumns(columns);
                parseStep.setMetadata(true);
                List<Integer> involvedBackends = metadataOperation.getInvolvedCSPs();
                if (involvedBackends == null) {
                    involvedBackends = Collections.emptyList();
                }
                parseStepStatus.setInvolvedBackends(involvedBackends);
                bindStepStatus.setInvolvedBackends(parseStepStatus.getInvolvedBackends());
                session.setCommandInvolvedBackends(bindStepStatus.getInvolvedBackends());
                CommandResults commandResults = new CommandResults();
                commandResults.setBindCompleteRequired(true);
                result = Result.response(commandResults);
            } else if (moduleOperation instanceof OutboundDataOperation) {
                OutboundDataOperation outBoundDataOperation = moduleOperation;
                columns = outBoundDataOperation.getDataIds().stream().map(id -> id.substring(id.lastIndexOf(47) + 1)).collect(Collectors.toList());
                parseStep.setColumns(columns);
                List<OutboundDataOperation> newOutboundDataOperations = this.newOutboundDataOperation(ctx, outBoundDataOperation);
                if (stmt instanceof SetStatement || stmt instanceof StartTransaction || stmt instanceof Commit || stmt instanceof CreateTable || stmt instanceof Alter || stmt instanceof CreateIndex || stmt instanceof Drop || stmt instanceof Insert || stmt instanceof Select || stmt instanceof DeclareCursor || stmt instanceof CursorFetch || stmt instanceof CursorClose) {
                    if (newOutboundDataOperations.isEmpty()) {
                        CommandResults commandResults = new CommandResults();
                        commandResults.setBindCompleteRequired(true);
                        result = Result.response(commandResults);
                        parseStepStatus.setInvolvedBackends(Collections.emptyList());
                        bindStepStatus.setInvolvedBackends(parseStepStatus.getInvolvedBackends());
                        session.setCommandInvolvedBackends(bindStepStatus.getInvolvedBackends());
                        parseStep.setColumns(null);
                    } else {
                        List<Object> involvedBackends;
                        boolean requestModified;
                        ArrayList<SQLSession.ExpectedField> expectedFields = null;
                        boolean bl = requestModified = newOutboundDataOperations.size() > 1 || newOutboundDataOperations.get(0).isModified();
                        if (FORCE_SQL_PROCESSING || requestModified) {
                            ArrayList extendedQueries = new ArrayList(newOutboundDataOperations.size());
                            involvedBackends = new ArrayList(newOutboundDataOperations.size());
                            if (session.getCurrentCommandOperation() == Operation.READ) {
                                expectedFields = new ArrayList();
                            }
                            for (OutboundDataOperation newOutboundDataOperation : newOutboundDataOperations) {
                                String newSQL;
                                PgsqlStatement<SetStatement> newStatement;
                                PgsqlStatement<SetStatement> statement;
                                if (stmt instanceof SetStatement) {
                                    statement = new PgsqlStatement<SetStatement>((SetStatement)stmt, parseStep.getParameterTypes(), bindStep.getParameterFormats(), parameterValues, bindStep.getResultColumnFormats(), parseStep.getColumns());
                                    newStatement = this.modifySetStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                    SetStatement newSetStatement = newStatement.getStatement();
                                    newSQL = newSetStatement.toString();
                                } else if (stmt instanceof StartTransaction) {
                                    statement = new PgsqlStatement<StartTransaction>((StartTransaction)stmt, parseStep.getParameterTypes(), bindStep.getParameterFormats(), parameterValues, bindStep.getResultColumnFormats(), parseStep.getColumns());
                                    newStatement = this.modifyStartTransactionStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                    SetStatement newStartTransaction = newStatement.getStatement();
                                    newSQL = newStartTransaction.toString();
                                } else if (stmt instanceof Commit) {
                                    statement = new PgsqlStatement<Commit>((Commit)stmt, parseStep.getParameterTypes(), bindStep.getParameterFormats(), parameterValues, bindStep.getResultColumnFormats(), parseStep.getColumns());
                                    newStatement = this.modifyCommitStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                    SetStatement newCommit = newStatement.getStatement();
                                    newSQL = newCommit.toString();
                                } else if (stmt instanceof CreateTable) {
                                    statement = new PgsqlStatement<CreateTable>((CreateTable)stmt, parseStep.getParameterTypes(), bindStep.getParameterFormats(), parameterValues, bindStep.getResultColumnFormats(), parseStep.getColumns());
                                    newStatement = this.modifyCreateTableStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                    SetStatement newCreateTable = newStatement.getStatement();
                                    newSQL = newCreateTable.toString();
                                } else if (stmt instanceof Alter) {
                                    statement = new PgsqlStatement<Alter>((Alter)stmt, parseStep.getParameterTypes(), bindStep.getParameterFormats(), parameterValues, bindStep.getResultColumnFormats(), parseStep.getColumns());
                                    newStatement = this.modifyAlterTableStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                    SetStatement newAlter = newStatement.getStatement();
                                    newSQL = newAlter.toString();
                                } else if (stmt instanceof CreateIndex) {
                                    statement = new PgsqlStatement<CreateIndex>((CreateIndex)stmt, parseStep.getParameterTypes(), bindStep.getParameterFormats(), parameterValues, bindStep.getResultColumnFormats(), parseStep.getColumns());
                                    newStatement = this.modifyCreateIndexStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                    SetStatement newCreateIndex = newStatement.getStatement();
                                    newSQL = newCreateIndex.toString();
                                } else if (stmt instanceof Drop) {
                                    statement = new PgsqlStatement<Drop>((Drop)stmt, parseStep.getParameterTypes(), bindStep.getParameterFormats(), parameterValues, bindStep.getResultColumnFormats(), parseStep.getColumns());
                                    newStatement = this.modifyDropTableStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                    SetStatement newDropTable = newStatement.getStatement();
                                    newSQL = newDropTable.toString();
                                } else if (stmt instanceof Insert) {
                                    statement = new PgsqlStatement<Insert>((Insert)stmt, parseStep.getParameterTypes(), bindStep.getParameterFormats(), parameterValues, bindStep.getResultColumnFormats(), parseStep.getColumns());
                                    newStatement = this.modifyInsertStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1, 0);
                                    SetStatement newInsert = newStatement.getStatement();
                                    newSQL = newInsert.toString();
                                } else if (stmt instanceof Select) {
                                    statement = new PgsqlStatement<Select>((Select)stmt, parseStep.getParameterTypes(), bindStep.getParameterFormats(), parameterValues, bindStep.getResultColumnFormats(), parseStep.getColumns());
                                    newStatement = this.modifySelectStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1, expectedFields);
                                    SetStatement newSelect = newStatement.getStatement();
                                    newSQL = newSelect.toString();
                                } else if (stmt instanceof DeclareCursor) {
                                    statement = new PgsqlStatement<DeclareCursor>((DeclareCursor)stmt, parseStep.getParameterTypes(), bindStep.getParameterFormats(), parameterValues, bindStep.getResultColumnFormats(), parseStep.getColumns());
                                    newStatement = this.modifyDeclareCursorStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1, expectedFields);
                                    SetStatement newDeclareCursor = newStatement.getStatement();
                                    newSQL = newDeclareCursor.toString();
                                } else if (stmt instanceof CursorFetch) {
                                    statement = new PgsqlStatement<CursorFetch>((CursorFetch)stmt, parseStep.getParameterTypes(), bindStep.getParameterFormats(), parameterValues, bindStep.getResultColumnFormats(), parseStep.getColumns());
                                    newStatement = this.modifyCursorFetchStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                    SetStatement newCursorFetch = newStatement.getStatement();
                                    newSQL = newCursorFetch.toString();
                                } else if (stmt instanceof CursorClose) {
                                    statement = new PgsqlStatement<CursorClose>((CursorClose)stmt, parseStep.getParameterTypes(), bindStep.getParameterFormats(), parameterValues, bindStep.getResultColumnFormats(), parseStep.getColumns());
                                    newStatement = this.modifyCursorCloseStatement(ctx, statement, newOutboundDataOperation, newOutboundDataOperations.size() > 1);
                                    SetStatement newCursorClose = newStatement.getStatement();
                                    newSQL = newCursorClose.toString();
                                } else {
                                    newStatement = new PgsqlStatement<Statement>(stmt, parseStep.getParameterTypes(), bindStep.getParameterFormats(), parameterValues, bindStep.getResultColumnFormats(), parseStep.getColumns());
                                    newSQL = stmt.toString();
                                }
                                newSQL = StringUtilities.addIrrelevantCharacters((String)newSQL, (CharSequence)parseStep.getSQL(), (String)" \t\r\n;");
                                parseStep = new ParseStep(parseStep.getName(), CString.valueOf((CharSequence)newSQL), parseStep.isMetadata(), newStatement.getColumns(), newStatement.getParameterTypes());
                                List<ByteBuf> newValues = newStatement.getParameterValues().stream().map(ParameterValue::getValue).collect(Collectors.toList());
                                bindStep = new BindStep(bindStep.getName(), bindStep.getPreparedStatement(), newStatement.getParameterFormats(), newValues, newStatement.getResultFormats());
                                int involvedBackend = newOutboundDataOperation.getInvolvedCSP();
                                if (involvedBackend == -1) {
                                    involvedBackend = this.getPreferredBackend(ctx);
                                }
                                involvedBackends.add(involvedBackend);
                                ArrayList<ExtendedQuery> newQueries = new ArrayList<ExtendedQuery>();
                                if (!parseStepStatus.isProcessed()) {
                                    newQueries.add(parseStep);
                                }
                                if (describeStepStatus != null && !describeStepStatus.isProcessed()) {
                                    newQueries.add((ExtendedQuery)describeStepStatus.getQuery());
                                }
                                if (!bindStepStatus.isProcessed()) {
                                    newQueries.add(bindStep);
                                }
                                if (extendedQueries.size() <= involvedBackend) {
                                    for (int i = extendedQueries.size(); i <= involvedBackend; ++i) {
                                        extendedQueries.add(null);
                                    }
                                }
                                extendedQueries.set(involvedBackend, newQueries);
                            }
                            if (!parseStepStatus.isProcessed()) {
                                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARSE_COMPLETE);
                                parseStepStatus.setProcessed(true);
                            }
                            if (describeStepStatus != null) {
                                session.setCurrentDescribeStepStatus(describeStepStatus);
                                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARAMETER_DESCRIPTION);
                                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.ROW_DESCRIPTION_AND_DATA_ROW_OR_NO_DATA);
                                describeStepStatus.setProcessed(true);
                            }
                            bindStepStatus.setProcessed(true);
                            result = Result.queries(extendedQueries);
                        } else {
                            involvedBackends = outBoundDataOperation.getInvolvedCSPs();
                            if (involvedBackends == null) {
                                involvedBackends = Collections.singletonList(this.getPreferredBackend(ctx));
                            }
                            if (session.getCurrentCommandOperation() == Operation.READ) {
                                List selectItemIds = (List)outBoundDataOperation.getAttribute("selectItemIds");
                                expectedFields = selectItemIds.stream().map(e -> {
                                    SelectItem item = (SelectItem)e.getKey();
                                    String fqOutputName = this.toOutputName(item.toString());
                                    List attributeNames = (List)e.getValue();
                                    List<Map.Entry<String, Integer>> attributeMapping = IntStream.range(0, attributeNames.size()).mapToObj(i -> new AbstractMap.SimpleEntry(attributeNames.get(i), i)).collect(Collectors.toList());
                                    Map<Integer, List<SQLSession.ExpectedProtectedField>> protectedFields = Stream.of(new SQLSession.ExpectedProtectedField(0, fqOutputName, attributeNames, attributeMapping)).collect(Collectors.groupingBy(SQLSession.ExpectedProtectedField::getBackend));
                                    return new SQLSession.ExpectedField(fqOutputName, attributeNames, protectedFields);
                                }).collect(Collectors.toList());
                            }
                            ArrayList<ExtendedQuery> newQueries = new ArrayList<ExtendedQuery>();
                            if (!parseStepStatus.isProcessed()) {
                                newQueries.add(parseStep);
                                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARSE_COMPLETE);
                                parseStepStatus.setProcessed(true);
                            }
                            if (describeStepStatus != null) {
                                newQueries.add((ExtendedQuery)describeStepStatus.getQuery());
                                session.setCurrentDescribeStepStatus(describeStepStatus);
                                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARAMETER_DESCRIPTION);
                                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.ROW_DESCRIPTION_AND_DATA_ROW_OR_NO_DATA);
                                describeStepStatus.setProcessed(true);
                            }
                            if (!bindStepStatus.isProcessed()) {
                                newQueries.add(bindStep);
                                bindStepStatus.setProcessed(true);
                            }
                            result = Result.query(newQueries);
                        }
                        parseStepStatus.setInvolvedBackends(involvedBackends);
                        bindStepStatus.setInvolvedBackends(parseStepStatus.getInvolvedBackends());
                        session.setCommandInvolvedBackends(parseStepStatus.getInvolvedBackends());
                        if (session.getCurrentCommandOperation() == Operation.READ) {
                            session.setResultProcessingEnabled(requestModified || !outBoundDataOperation.isUnprotectingDataEnabled());
                            session.setPromise(newOutboundDataOperations.get(0).getPromise());
                            session.setUnprotectingDataEnabled(outBoundDataOperation.isUnprotectingDataEnabled());
                            session.setExpectedFields(expectedFields);
                            if (stmt instanceof DeclareCursor) {
                                session.saveCursorContext(((DeclareCursor)stmt).getName());
                            }
                        } else if (stmt instanceof CursorFetch) {
                            session.restoreCursorContext(((CursorFetch)stmt).getName());
                        } else if (stmt instanceof CursorClose) {
                            session.removeCursorContext(((CursorClose)stmt).getName());
                        }
                    }
                } else if (stmt instanceof Update) {
                    ArrayList<ExtendedQuery> newQueries = new ArrayList<ExtendedQuery>();
                    if (!parseStepStatus.isProcessed()) {
                        newQueries.add(parseStep);
                        session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARSE_COMPLETE);
                        parseStepStatus.setProcessed(true);
                    }
                    if (describeStepStatus != null) {
                        newQueries.add((ExtendedQuery)describeStepStatus.getQuery());
                        session.setCurrentDescribeStepStatus(describeStepStatus);
                        session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARAMETER_DESCRIPTION);
                        session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.ROW_DESCRIPTION_AND_DATA_ROW_OR_NO_DATA);
                        describeStepStatus.setProcessed(true);
                    }
                    if (!bindStepStatus.isProcessed()) {
                        newQueries.add(bindStep);
                        bindStepStatus.setProcessed(true);
                    }
                    result = Result.query(newQueries);
                } else if (stmt instanceof Delete) {
                    ArrayList<ExtendedQuery> newQueries = new ArrayList<ExtendedQuery>();
                    if (!parseStepStatus.isProcessed()) {
                        newQueries.add(parseStep);
                        session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARSE_COMPLETE);
                        parseStepStatus.setProcessed(true);
                    }
                    if (describeStepStatus != null) {
                        newQueries.add((ExtendedQuery)describeStepStatus.getQuery());
                        session.setCurrentDescribeStepStatus(describeStepStatus);
                        session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARAMETER_DESCRIPTION);
                        session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.ROW_DESCRIPTION_AND_DATA_ROW_OR_NO_DATA);
                        describeStepStatus.setProcessed(true);
                    }
                    if (!bindStepStatus.isProcessed()) {
                        newQueries.add(bindStep);
                        bindStepStatus.setProcessed(true);
                    }
                    result = Result.query(newQueries);
                }
            }
        }
        if (result == null) {
            ArrayList<ExtendedQuery> newQueries = new ArrayList<ExtendedQuery>();
            if (!parseStepStatus.isProcessed()) {
                newQueries.add(parseStep);
                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARSE_COMPLETE);
                parseStepStatus.setProcessed(true);
            }
            if (describeStepStatus != null) {
                newQueries.add((ExtendedQuery)describeStepStatus.getQuery());
                session.setCurrentDescribeStepStatus(describeStepStatus);
                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARAMETER_DESCRIPTION);
                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.ROW_DESCRIPTION_AND_DATA_ROW_OR_NO_DATA);
                describeStepStatus.setProcessed(true);
            }
            if (!bindStepStatus.isProcessed()) {
                newQueries.add(bindStep);
                bindStepStatus.setProcessed(true);
            }
            result = Result.query(newQueries);
        }
        return result;
    }

    private Statement parseSQL(ChannelHandlerContext ctx, CString sql) {
        Statement stmt;
        block5: {
            stmt = null;
            ByteBuf byteBuf = null;
            try {
                if (sql.isBuffered()) {
                    byteBuf = sql.getByteBuf();
                    byteBuf.markReaderIndex();
                    stmt = CCJSqlParserUtil.parse((InputStream)new ByteBufInputStream(byteBuf.readSlice(sql.length())), (String)StandardCharsets.ISO_8859_1.name());
                } else {
                    stmt = CCJSqlParserUtil.parse((String)sql.toString());
                }
            }
            catch (JSQLParserException | TokenMgrError e) {
                if (byteBuf != null) {
                    byteBuf.resetReaderIndex();
                }
                LOGGER.error("Parsing error for {} : ", (Object)sql);
                if (!LOGGER.isTraceEnabled()) break block5;
                LOGGER.trace("Parsing error details:", e);
            }
        }
        return stmt;
    }

    private Map<Byte, CString> bufferQuery(ChannelHandlerContext ctx, Query query) {
        Map<Byte, CString> errorDetails = null;
        SQLSession session = this.getSession(ctx);
        session.addBufferedQuery(query);
        if (query instanceof SimpleQuery) {
            if (session.getTransactionStatus() == 69) {
                if (session.lastQueryResponseToIgnore() != SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR) {
                    session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR);
                }
                errorDetails = session.getRetainedTransactionErrorDetails();
            } else {
                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR);
            }
        } else {
            ExtendedQuery extendedQuery = (ExtendedQuery)query;
            if (session.getTransactionStatus() == 69) {
                if (extendedQuery instanceof ParseStep) {
                    session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR);
                    errorDetails = session.getRetainedTransactionErrorDetails();
                } else if (extendedQuery instanceof BindStep) {
                    if (session.lastQueryResponseToIgnore() != SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR) {
                        session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR);
                        errorDetails = session.getRetainedTransactionErrorDetails();
                    }
                } else if (extendedQuery instanceof DescribeStep) {
                    if (session.lastQueryResponseToIgnore() != SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR) {
                        session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR);
                        errorDetails = session.getRetainedTransactionErrorDetails();
                    }
                } else if (extendedQuery instanceof ExecuteStep) {
                    if (session.lastQueryResponseToIgnore() != SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR) {
                        session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR);
                        errorDetails = session.getRetainedTransactionErrorDetails();
                    }
                } else if (extendedQuery instanceof CloseStep) {
                    if (session.lastQueryResponseToIgnore() != SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR) {
                        session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR);
                        errorDetails = session.getRetainedTransactionErrorDetails();
                    }
                } else if (extendedQuery instanceof SynchronizeStep) {
                    session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.READY_FOR_QUERY);
                } else if (extendedQuery instanceof FlushStep && session.lastQueryResponseToIgnore() != SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR) {
                    errorDetails = session.getRetainedTransactionErrorDetails();
                }
            } else if (extendedQuery instanceof ParseStep) {
                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARSE_COMPLETE);
            } else if (extendedQuery instanceof BindStep) {
                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.BIND_COMPLETE);
            } else if (extendedQuery instanceof DescribeStep) {
                if (((DescribeStep)query).getCode() == 83) {
                    session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.PARAMETER_DESCRIPTION);
                }
                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.ROW_DESCRIPTION_AND_DATA_ROW_OR_NO_DATA);
            } else if (extendedQuery instanceof ExecuteStep) {
                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR);
            } else if (extendedQuery instanceof CloseStep) {
                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.CLOSE_COMPLETE);
            } else if (extendedQuery instanceof SynchronizeStep) {
                session.addLastQueryResponseToIgnore(SQLSession.QueryResponseType.READY_FOR_QUERY);
            } else if (extendedQuery instanceof FlushStep) {
                // empty if block
            }
        }
        return errorDetails;
    }

    @Override
    public MessageTransferMode<Void, Void> processParseCompleteResponse(ChannelHandlerContext ctx) {
        TransferMode transferMode;
        LOGGER.debug("Parse complete");
        SQLSession session = this.getSession(ctx);
        int backend = this.getBackend(ctx);
        List<Integer> involvedBackends = session.getCommandInvolvedBackends();
        int numberOfBackends = involvedBackends.size();
        SortedMap<Integer, Boolean> all = session.newQueryResponse(SQLSession.QueryResponseType.PARSE_COMPLETE, backend, numberOfBackends, Boolean.TRUE);
        if (all == null) {
            transferMode = TransferMode.FORGET;
        } else {
            SQLSession.QueryResponseType nextQueryResponseToIgnore = session.firstQueryResponseToIgnore();
            if (nextQueryResponseToIgnore == null) {
                transferMode = TransferMode.FORWARD;
            } else if (nextQueryResponseToIgnore == SQLSession.QueryResponseType.PARSE_COMPLETE) {
                transferMode = TransferMode.FORGET;
                session.removeFirstQueryResponseToIgnore();
            } else {
                throw new IllegalStateException(String.format("Unexpected %s response (%s or null was expected)", new Object[]{nextQueryResponseToIgnore, SQLSession.QueryResponseType.PARSE_COMPLETE}));
            }
        }
        MessageTransferMode<Void, Void> mode = new MessageTransferMode<Void, Void>(transferMode, null);
        LOGGER.debug("Parse complete processed: transfer mode={}", (Object)mode.getTransferMode());
        return mode;
    }

    @Override
    public MessageTransferMode<Void, Void> processBindCompleteResponse(ChannelHandlerContext ctx) {
        TransferMode transferMode;
        LOGGER.debug("Bind complete");
        SQLSession session = this.getSession(ctx);
        int backend = this.getBackend(ctx);
        List<Integer> involvedBackends = session.getCommandInvolvedBackends();
        int numberOfBackends = involvedBackends.size();
        SortedMap<Integer, Boolean> all = session.newQueryResponse(SQLSession.QueryResponseType.BIND_COMPLETE, backend, numberOfBackends, Boolean.TRUE);
        if (all == null) {
            transferMode = TransferMode.FORGET;
        } else {
            SQLSession.QueryResponseType nextQueryResponseToIgnore = session.firstQueryResponseToIgnore();
            if (nextQueryResponseToIgnore == null || nextQueryResponseToIgnore == SQLSession.QueryResponseType.PARSE_COMPLETE) {
                transferMode = TransferMode.FORWARD;
            } else if (nextQueryResponseToIgnore == SQLSession.QueryResponseType.BIND_COMPLETE) {
                transferMode = TransferMode.FORGET;
                session.removeFirstQueryResponseToIgnore();
            } else {
                throw new IllegalStateException(String.format("Unexpected %s response (%s or null was expected)", new Object[]{nextQueryResponseToIgnore, SQLSession.QueryResponseType.BIND_COMPLETE}));
            }
        }
        MessageTransferMode<Void, Void> mode = new MessageTransferMode<Void, Void>(transferMode, null);
        LOGGER.debug("Bind complete processed: transfer mode={}", (Object)mode.getTransferMode());
        return mode;
    }

    @Override
    public MessageTransferMode<List<Long>, Void> processParameterDescriptionResponse(ChannelHandlerContext ctx, List<Long> types) {
        TransferMode transferMode;
        LOGGER.debug("Parameter description: {}", types);
        List<Long> newTypes = null;
        SQLSession session = this.getSession(ctx);
        int backend = this.getBackend(ctx);
        List<Integer> involvedBackends = session.getCommandInvolvedBackends();
        int numberOfBackends = involvedBackends.size();
        SortedMap<Integer, List<Long>> allTypes = session.newQueryResponse(SQLSession.QueryResponseType.PARAMETER_DESCRIPTION, backend, numberOfBackends, types);
        if (allTypes == null) {
            transferMode = TransferMode.FORGET;
        } else {
            SQLSession.QueryResponseType nextQueryResponseToIgnore = session.firstQueryResponseToIgnore();
            if (nextQueryResponseToIgnore == null) {
                transferMode = TransferMode.FORWARD;
                newTypes = numberOfBackends == 1 ? types : allTypes.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{} new type(s) replace {} old type(s) from {} backend(s)", new Object[]{newTypes.size(), allTypes.values().stream().flatMap(Collection::stream).count(), numberOfBackends});
                }
                if (newTypes == types || newTypes.stream().allMatch(nt -> types.stream().anyMatch(t -> t == nt))) {
                    LOGGER.trace("new types from one backend");
                } else if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("at list one type is new or is from another backend");
                    newTypes.stream().filter(nt -> types.stream().noneMatch(t -> t == nt)).forEach(nt -> LOGGER.trace("type {} is new or is from another backend", nt));
                }
            } else if (nextQueryResponseToIgnore == SQLSession.QueryResponseType.PARAMETER_DESCRIPTION) {
                transferMode = TransferMode.FORGET;
                session.removeFirstQueryResponseToIgnore();
            } else {
                throw new IllegalStateException(String.format("Unexpected %s response (%s or null was expected)", new Object[]{nextQueryResponseToIgnore, SQLSession.QueryResponseType.PARAMETER_DESCRIPTION}));
            }
        }
        MessageTransferMode mode = new MessageTransferMode(transferMode, Collections.singletonList(newTypes));
        LOGGER.debug("Parameter description processed: new types={}, transfer mode={}", mode.getNewContent(), (Object)mode.getTransferMode());
        return mode;
    }

    @Override
    public MessageTransferMode<List<PgsqlRowDescriptionMessage.Field>, Void> processRowDescriptionResponse(ChannelHandlerContext ctx, List<PgsqlRowDescriptionMessage.Field> fields) {
        TransferMode transferMode;
        LOGGER.debug("Row description: {}", fields);
        List<PgsqlRowDescriptionMessage.Field> newFields = null;
        SQLSession session = this.getSession(ctx);
        int backend = this.getBackend(ctx);
        List<Integer> involvedBackends = session.getCommandInvolvedBackends();
        int numberOfBackends = involvedBackends.size();
        SortedMap<Integer, List<PgsqlRowDescriptionMessage.Field>> allFields = session.newQueryResponse(SQLSession.QueryResponseType.ROW_DESCRIPTION, backend, numberOfBackends, fields);
        if (allFields == null) {
            transferMode = TransferMode.FORGET;
        } else {
            SQLSession.QueryResponseType nextQueryResponseToIgnore = session.firstQueryResponseToIgnore();
            if (nextQueryResponseToIgnore == null || nextQueryResponseToIgnore == SQLSession.QueryResponseType.READY_FOR_QUERY) {
                transferMode = TransferMode.FORWARD;
                newFields = numberOfBackends == 1 ? fields : allFields.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                if (session.getCurrentCommandOperation() == Operation.READ) {
                    if ((FORCE_SQL_PROCESSING || session.isResultProcessingEnabled()) && session.getExpectedFields() != null) {
                        newFields = this.processRowDescription(ctx, allFields, involvedBackends);
                    }
                    session.setBackendRowDescriptions(allFields);
                    session.setRowDescription(newFields);
                    if (session.getCurrentDescribeStepStatus() != null) {
                        session.getCurrentDescribeStepStatus().setExpectedFields(session.getExpectedFields());
                        session.getCurrentDescribeStepStatus().setBackendRowDescriptions(allFields);
                        session.getCurrentDescribeStepStatus().setRowDescription(newFields);
                    }
                    Map<Integer, List<Integer>> joinFieldIndexes = this.processRowJoinFields(ctx, allFields, session.getExpectedFields());
                    session.setJoinFieldIndexes(joinFieldIndexes);
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{} new field(s) replace {} old field(s) from {} backend(s)", new Object[]{newFields.size(), allFields.values().stream().flatMap(Collection::stream).count(), numberOfBackends});
                }
                if (newFields == fields || newFields.stream().allMatch(nf -> fields.stream().anyMatch(f -> f == nf))) {
                    LOGGER.trace("new fields from one backend");
                    newFields.stream().forEach(nf -> {
                        if (nf.release() && LOGGER.isTraceEnabled()) {
                            LOGGER.trace("field {} deallocated", nf);
                        }
                    });
                } else if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("at list one field is new or is from another backend");
                    newFields.stream().filter(nf -> fields.stream().noneMatch(f -> f == nf)).forEach(nf -> LOGGER.trace("field {} is new or is from another backend", nf));
                }
                List<PgsqlRowDescriptionMessage.Field> nfs = newFields;
                allFields.values().stream().flatMap(Collection::stream).forEach(f -> {
                    if (nfs.stream().noneMatch(nf -> nf == f) && f.release() && LOGGER.isTraceEnabled()) {
                        LOGGER.trace("field {} deallocated", f);
                    }
                });
            } else if (nextQueryResponseToIgnore == SQLSession.QueryResponseType.ROW_DESCRIPTION_AND_DATA_ROW_OR_NO_DATA) {
                transferMode = TransferMode.FORGET;
                session.removeFirstQueryResponseToIgnore();
            } else {
                throw new IllegalStateException(String.format("Unexpected %s response (%s or null was expected)", new Object[]{nextQueryResponseToIgnore, SQLSession.QueryResponseType.ROW_DESCRIPTION_AND_DATA_ROW_OR_NO_DATA}));
            }
        }
        MessageTransferMode mode = new MessageTransferMode(transferMode, newFields);
        LOGGER.debug("Row description processed: new fields={}, transfer mode={}", mode.getNewContent(), (Object)mode.getTransferMode());
        return mode;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private List<PgsqlRowDescriptionMessage.Field> processRowDescription(ChannelHandlerContext ctx, SortedMap<Integer, List<PgsqlRowDescriptionMessage.Field>> allFields, List<Integer> involvedBackends) {
        session = this.getSession(ctx);
        maxBackend = (Integer)involvedBackends.stream().max(Comparator.naturalOrder()).get();
        v0 = newList = PgsqlEventProcessor.FORCE_SQL_PROCESSING != false || allFields.size() > 1 || session.isUnprotectingDataEnabled() == false;
        if (!newList) {
            expectedFields = session.getExpectedFields();
            newList = expectedFields != null && expectedFields.stream().anyMatch((Predicate<SQLSession.ExpectedField>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processRowDescription$394(eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLSession$ExpectedField ), (Leu/clarussecure/proxy/protocol/plugins/pgsql/message/sql/SQLSession$ExpectedField;)Z)().or((Predicate<SQLSession.ExpectedField>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processRowDescription$395(java.util.List eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLSession$ExpectedField ), (Leu/clarussecure/proxy/protocol/plugins/pgsql/message/sql/SQLSession$ExpectedField;)Z)(involvedBackends))) != false;
        }
        expectedFields = session.getExpectedFields();
        positionPerBackend = new int[maxBackend + 1];
        Arrays.fill(positionPerBackend, 0);
        expectedFields.stream().map((java.util.function.Function<SQLSession.ExpectedField, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getProtectedFields(), (Leu/clarussecure/proxy/protocol/plugins/pgsql/message/sql/SQLSession$ExpectedField;)Ljava/util/Map;)()).forEach((Consumer<Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$processRowDescription$404(java.util.SortedMap int[] java.util.Map ), (Ljava/util/Map;)V)((PgsqlEventProcessor)this, allFields, (int[])positionPerBackend));
        Arrays.fill(positionPerBackend, -1);
        nbFieldsPerBackend = new int[maxBackend + 1];
        for (backend = 0; backend < nbFieldsPerBackend.length; ++backend) {
            backendFields = (List)allFields.get(backend);
            nbFieldsPerBackend[backend] = backendFields != null ? backendFields.size() : 0;
        }
        expectedFields.forEach((Consumer<SQLSession.ExpectedField>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$processRowDescription$408(int[] int[] eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLSession$ExpectedField ), (Leu/clarussecure/proxy/protocol/plugins/pgsql/message/sql/SQLSession$ExpectedField;)V)((int[])nbFieldsPerBackend, (int[])positionPerBackend));
        promise = session.getPromise();
        attributeMapping = promise != null ? promise.stream().map((java.util.function.Function<DataOperationCommand, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processRowDescription$409(eu.clarussecure.dataoperations.DataOperationCommand ), (Leu/clarussecure/dataoperations/DataOperationCommand;)Ljava/util/Map;)()).collect(Collectors.toList()) : null;
        v1 = reversedAttributeMapping = attributeMapping != null ? attributeMapping.stream().map((java.util.function.Function<Map, Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processRowDescription$410(java.util.Map ), (Ljava/util/Map;)Ljava/util/Map;)()).collect(Collectors.toList()) : null;
        if (newList) {
            databaseSchema = this.getDatabaseSchema(ctx);
            allFields.entrySet().forEach((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$processRowDescription$412(eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLDatabaseSchema java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)((SQLDatabaseSchema)databaseSchema));
            expectedFieldToRowDescription = expectedFields.stream().map((java.util.function.Function<SQLSession.ExpectedField, AbstractMap.SimpleEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processRowDescription$418(java.util.SortedMap eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLSession java.util.List eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLSession$ExpectedField ), (Leu/clarussecure/proxy/protocol/plugins/pgsql/message/sql/SQLSession$ExpectedField;)Ljava/util/AbstractMap$SimpleEntry;)((PgsqlEventProcessor)this, allFields, (SQLSession)session, reversedAttributeMapping)).collect(Collectors.toList());
            expectedFieldToRowDescription.stream().forEach((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$processRowDescription$419(eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLSession java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)((PgsqlEventProcessor)this, (SQLSession)session));
            newFields /* !! */  = expectedFieldToRowDescription.stream().map((java.util.function.Function<Map.Entry, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Ljava/util/Map$Entry;)Ljava/util/List;)()).flatMap((java.util.function.Function<List, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/List;)Ljava/util/stream/Stream;)()).filter((Predicate<PgsqlRowDescriptionMessage.Field>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processRowDescription$421(java.util.List eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlRowDescriptionMessage$Field ), (Leu/clarussecure/proxy/protocol/plugins/pgsql/message/PgsqlRowDescriptionMessage$Field;)Z)((PgsqlEventProcessor)this, attributeMapping)).collect(Collectors.toList());
            if (!session.isUnprotectingDataEnabled()) {
                newFields /* !! */  = newFields /* !! */ .stream().sorted(Comparator.comparing((java.util.function.Function<PgsqlRowDescriptionMessage.Field, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processRowDescription$422(eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlRowDescriptionMessage$Field ), (Leu/clarussecure/proxy/protocol/plugins/pgsql/message/PgsqlRowDescriptionMessage$Field;)Ljava/lang/String;)())).collect(Collectors.toList());
            }
            nbExpectedFields = (int)expectedFieldToRowDescription.stream().map((java.util.function.Function<Map.Entry, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Ljava/util/Map$Entry;)Ljava/util/List;)()).flatMap((java.util.function.Function<List, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/List;)Ljava/util/stream/Stream;)()).count();
        } else {
            expectedFieldToRowDescription = expectedFields.stream().map((java.util.function.Function<SQLSession.ExpectedField, AbstractMap.SimpleEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processRowDescription$424(java.util.List java.util.SortedMap eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLSession$ExpectedField ), (Leu/clarussecure/proxy/protocol/plugins/pgsql/message/sql/SQLSession$ExpectedField;)Ljava/util/AbstractMap$SimpleEntry;)(involvedBackends, allFields)).collect(Collectors.toList());
            newFields /* !! */  = (List<PgsqlRowDescriptionMessage.Field>)allFields.get(involvedBackends.get(0));
            nbExpectedFields = newFields /* !! */ .size();
        }
        i = 0;
        j = 0;
        k = 0;
        while (i < expectedFields.size()) {
            block20: {
                block22: {
                    block21: {
                        block19: {
                            expectedField = expectedFields.get(i);
                            if (!expectedField.getProtectedFields().isEmpty()) break block19;
                            --k;
                            break block20;
                        }
                        clearName = expectedField.getName();
                        clearFieldname = this.toOutputName(clearName);
                        if (!clearFieldname.equals("*")) break block21;
                        expectedFields.remove(i);
                        expectedFieldNewFields = (List)((Map.Entry)expectedFieldToRowDescription.get(j)).getValue();
                        for (PgsqlRowDescriptionMessage.Field newField : expectedFieldNewFields) {
                            newFieldName = this.toOutputName(newField.getName().toString());
                            newClearAttributes = expectedField.getAttributes().stream().map((java.util.function.Function<Map.Entry, Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processRowDescription$425(java.lang.String java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/util/Map$Entry;)((PgsqlEventProcessor)this, (String)newFieldName)).filter((Predicate<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processRowDescription$426(java.lang.String java.util.Map$Entry ), (Ljava/util/Map$Entry;)Z)((PgsqlEventProcessor)this, (String)newFieldName)).map((java.util.function.Function<Map.Entry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getKey(), (Ljava/util/Map$Entry;)Ljava/lang/String;)()).map((java.util.function.Function<String, AbstractMap.SimpleEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processRowDescription$427(java.lang.String ), (Ljava/lang/String;)Ljava/util/AbstractMap$SimpleEntry;)()).collect(Collectors.toList());
                            if (newClearAttributes.isEmpty()) {
                                PgsqlEventProcessor.LOGGER.trace("strange... unexpected attribute size");
                                newClearAttributes.add(new AbstractMap.SimpleEntry<String, Integer>(newFieldName, -1));
                            }
                            if ((newClearName = clearName.replace("*", newClearFieldName = newClearAttributes.stream().findAny().map((java.util.function.Function<Map.Entry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getKey(), (Ljava/util/Map$Entry;)Ljava/lang/String;)()).map((java.util.function.Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toOutputName(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((PgsqlEventProcessor)this)).get())).charAt(0) != '?' || newClearName.charAt(newClearName.length() - 1) != '?' || attributeMapping == null) ** GOTO lbl-1000
                            if (attributeMapping.stream().filter((Predicate<Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processRowDescription$428(java.util.Map ), (Ljava/util/Map;)Z)()).map((java.util.function.Function<Map, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, keySet(), (Ljava/util/Map;)Ljava/util/Set;)()).flatMap((java.util.function.Function<Set, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/Set;)Ljava/util/stream/Stream;)()).map((java.util.function.Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toOutputName(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((PgsqlEventProcessor)this)).noneMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/String;)Z)((String)newClearName))) lbl-1000:
                            // 2 sources

                            {
                                v2 = k;
                            } else {
                                v2 = -1;
                            }
                            position = v2;
                            newClearAttributes.stream().forEach((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$processRowDescription$429(int java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)((int)position));
                            if (attributeMapping != null) {
                                protectedFieldNames /* !! */  = attributeMapping.stream().map((java.util.function.Function<Map, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processRowDescription$432(java.util.List java.util.Map ), (Ljava/util/Map;)Ljava/util/List;)((PgsqlEventProcessor)this, newClearAttributes)).collect(Collectors.toList());
                                if (protectedFieldNames /* !! */ .stream().filter((Predicate<List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processRowDescription$433(java.util.List ), (Ljava/util/List;)Z)()).allMatch((Predicate<List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isEmpty(), (Ljava/util/List;)Z)())) {
                                    protectedFieldNames /* !! */ .stream().filter((Predicate<List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processRowDescription$434(java.util.List ), (Ljava/util/List;)Z)()).forEach((Consumer<List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$processRowDescription$435(java.lang.String java.util.List ), (Ljava/util/List;)V)((String)newFieldName));
                                }
                            } else {
                                protectedFieldNames /* !! */  = Collections.singletonList(Collections.singletonList(newFieldName));
                            }
                            newProtectedFields = expectedField.getProtectedFields().entrySet().stream().filter((Predicate<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processRowDescription$438(java.util.List java.util.Map$Entry ), (Ljava/util/Map$Entry;)Z)((PgsqlEventProcessor)this, protectedFieldNames /* !! */ )).map((java.util.function.Function<Map.Entry, AbstractMap.SimpleEntry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$processRowDescription$440(java.util.List java.util.Map$Entry ), (Ljava/util/Map$Entry;)Ljava/util/AbstractMap$SimpleEntry;)((PgsqlEventProcessor)this, protectedFieldNames /* !! */ )).collect(Collectors.toMap((java.util.function.Function<AbstractMap.SimpleEntry, Integer>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getKey(), (Ljava/util/AbstractMap$SimpleEntry;)Ljava/lang/Integer;)(), (java.util.function.Function<AbstractMap.SimpleEntry, List>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getValue(), (Ljava/util/AbstractMap$SimpleEntry;)Ljava/util/List;)()));
                            newProtectedFields.values().stream().flatMap((java.util.function.Function<List, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/List;)Ljava/util/stream/Stream;)()).forEach((Consumer<SQLSession.ExpectedProtectedField>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$processRowDescription$449(eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLSession$ExpectedField java.lang.String java.util.List eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLSession$ExpectedProtectedField ), (Leu/clarussecure/proxy/protocol/plugins/pgsql/message/sql/SQLSession$ExpectedProtectedField;)V)((PgsqlEventProcessor)this, (SQLSession.ExpectedField)expectedField, (String)newClearFieldName, newClearAttributes));
                            newClearField = new SQLSession.ExpectedField(newClearName, position, newClearAttributes, newProtectedFields);
                            expectedFields.add(i, newClearField);
                            ++i;
                            if (position == -1) continue;
                            ++k;
                        }
                        --i;
                        --k;
                        break block22;
                    }
                    newClearName = clearName;
                    newField = (PgsqlRowDescriptionMessage.Field)((List)((Map.Entry)expectedFieldToRowDescription.get(j)).getValue()).get(0);
                    if (!newField.getName().equals((Object)clearFieldname)) {
                        if (session.isUnprotectingDataEnabled() && !newField.getName().equals((Object)"?column?")) {
                            PgsqlEventProcessor.LOGGER.trace("strange... unexpected protected field name");
                        }
                        newClearName = newField.getName().toString();
                        expectedField.setName(newClearName);
                    }
                    if (newClearName.charAt(0) != '?' || newClearName.charAt(newClearName.length() - 1) != '?' || attributeMapping == null) ** GOTO lbl-1000
                    if (attributeMapping.stream().filter((Predicate<Map>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, lambda$processRowDescription$450(java.util.Map ), (Ljava/util/Map;)Z)()).map((java.util.function.Function<Map, Set>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, keySet(), (Ljava/util/Map;)Ljava/util/Set;)()).flatMap((java.util.function.Function<Set, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/Set;)Ljava/util/stream/Stream;)()).map((java.util.function.Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, toOutputName(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((PgsqlEventProcessor)this)).noneMatch((Predicate<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/String;)Z)((String)newClearName))) lbl-1000:
                    // 2 sources

                    {
                        v3 = k;
                    } else {
                        v3 = -1;
                    }
                    position = v3;
                    expectedField.setPosition(position);
                    expectedField.getAttributes().forEach((Consumer<Map.Entry>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$processRowDescription$451(int java.util.Map$Entry ), (Ljava/util/Map$Entry;)V)((int)position));
                    clearAttributeNames = expectedField.getAttributes().stream().map((java.util.function.Function<Map.Entry, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getKey(), (Ljava/util/Map$Entry;)Ljava/lang/String;)()).collect(Collectors.toList());
                    expectedField.getProtectedFields().values().stream().flatMap((java.util.function.Function<List, Stream>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, stream(), (Ljava/util/List;)Ljava/util/stream/Stream;)()).forEach((Consumer<SQLSession.ExpectedProtectedField>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$processRowDescription$459(eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLSession$ExpectedField java.util.List eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLSession$ExpectedProtectedField ), (Leu/clarussecure/proxy/protocol/plugins/pgsql/message/sql/SQLSession$ExpectedProtectedField;)V)((SQLSession.ExpectedField)expectedField, clearAttributeNames));
                    if (position == -1) {
                        --k;
                    }
                }
                if (k >= nbExpectedFields) {
                    throw new IllegalStateException("unexpected");
                }
            }
            ++i;
            ++j;
            ++k;
        }
        positionPerBackend[0] = -1;
        expectedFields.forEach((Consumer<SQLSession.ExpectedField>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, lambda$processRowDescription$462(int int[] eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLSession$ExpectedField ), (Leu/clarussecure/proxy/protocol/plugins/pgsql/message/sql/SQLSession$ExpectedField;)V)((int)nbExpectedFields, (int[])positionPerBackend));
        return newFields /* !! */ ;
    }

    private String toOutputName(String attributeName) {
        int idx = attributeName.lastIndexOf(47);
        if (idx != -1) {
            attributeName = attributeName.substring(idx + 1);
        } else {
            idx = attributeName.toLowerCase().lastIndexOf(" as ");
            if (idx != -1) {
                idx += " as ".length();
            } else {
                idx = attributeName.lastIndexOf(" ");
                if (idx != -1) {
                    idx += " ".length();
                }
            }
            if (idx != -1) {
                if (attributeName.substring(idx).chars().anyMatch(c -> !Character.isLetterOrDigit(c) && c != 95 && c != 36) || this.isKeyword(attributeName.substring(idx))) {
                    idx = -1;
                } else {
                    attributeName = attributeName.substring(idx);
                }
            }
            if (idx == -1) {
                idx = attributeName.indexOf(40);
                if (idx != -1) {
                    if (attributeName.substring(0, idx).trim().length() == 0) {
                        if (attributeName.substring(idx + 1).trim().toLowerCase().startsWith("select")) {
                            attributeName = attributeName.substring(idx + 1).trim().substring("select".length()).trim();
                            idx = attributeName.indexOf(32);
                            attributeName = attributeName.substring(0, idx);
                            attributeName = this.toOutputName(attributeName);
                        }
                    } else if ((idx = (attributeName = attributeName.substring(0, idx)).lastIndexOf(46)) != -1) {
                        attributeName = attributeName.substring(idx + 1);
                    }
                } else {
                    idx = (attributeName = StringUtilities.unquote((String)attributeName)).lastIndexOf(46);
                    if (idx != -1) {
                        attributeName = attributeName.substring(idx + 1);
                    }
                    if ((idx = attributeName.lastIndexOf(91)) != -1) {
                        attributeName = attributeName.substring(0, idx);
                    }
                    if ((idx = attributeName.lastIndexOf("::")) != -1) {
                        attributeName = attributeName.substring(0, idx);
                    }
                }
            }
        }
        return attributeName.trim();
    }

    private boolean isKeyword(String expression) {
        CCJSqlParser parser = new CCJSqlParser((Reader)new StringReader(expression));
        Token token = parser.getNextToken();
        return token != null && token.kind >= 2 && token.kind <= 163 && token.kind != 32 && token.kind != 101;
    }

    private Map<Integer, List<Integer>> processRowJoinFields(ChannelHandlerContext ctx, SortedMap<Integer, List<PgsqlRowDescriptionMessage.Field>> allFields, List<SQLSession.ExpectedField> expectedFields) {
        Pattern dataTechnicalIdPattern;
        Map<Integer, List> joinFieldIndexes = null;
        String dataTechnicalId = this.getDataTechnicalId(ctx);
        Pattern pattern = dataTechnicalIdPattern = dataTechnicalId == null ? null : Pattern.compile(this.escapeRegex(dataTechnicalId));
        if (allFields.values().stream().anyMatch(l -> l.size() > 1) || dataTechnicalIdPattern != null && expectedFields.stream().map(SQLSession.AbsractExpectedField::getAttributes).flatMap(Collection::stream).map(Map.Entry::getKey).allMatch(an -> dataTechnicalIdPattern.matcher((CharSequence)an).matches())) {
            Map<Integer, List> attributesPerBackend;
            Map<Integer, List> map = attributesPerBackend = expectedFields != null ? expectedFields.stream().map(SQLSession.ExpectedField::getProtectedFields).map(Map::values).flatMap(Collection::stream).flatMap(Collection::stream).collect(Collectors.toMap(SQLSession.ExpectedProtectedField::getBackend, SQLSession.AbsractExpectedField::getAttributes, (a, b) -> Stream.concat(a.stream(), b.stream()).collect(Collectors.toList()))) : null;
            if (attributesPerBackend != null && attributesPerBackend.values().stream().flatMap(Collection::stream).map(Map.Entry::getKey).anyMatch(an -> an.contains("geometry_columns/"))) {
                List suffixes = Stream.of("f_table_schema", "f_table_name", "f_geometry_column").map(s -> "geometry_columns/" + s).collect(Collectors.toList());
                Map<Integer, List> indexesPerBackend = attributesPerBackend.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> suffixes.stream().map(suffix -> IntStream.range(0, ((List)e.getValue()).size()).filter(i -> ((String)((Map.Entry)((List)e.getValue()).get(i)).getKey()).endsWith((String)suffix)).findFirst().orElse(-1)).collect(Collectors.toList())));
                if (indexesPerBackend.values().stream().allMatch(l -> l.stream().anyMatch(idx -> idx != -1))) {
                    joinFieldIndexes = indexesPerBackend.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().filter(idx -> idx != -1).map(idx -> (Map.Entry)((List)attributesPerBackend.get(e.getKey())).get((int)idx)).map(Map.Entry::getValue).collect(Collectors.toList())));
                }
            } else {
                PgsqlRowDescriptionMessage.Field joinField = allFields.values().stream().flatMap(Collection::stream).filter(f -> allFields.values().stream().allMatch(l -> l.contains(f))).distinct().filter(f -> f.getTableOID() != 0).sorted(Comparator.comparing(PgsqlRowDescriptionMessage.Field::getColumnNumber)).findFirst().orElse(null);
                if (joinField != null) {
                    joinFieldIndexes = allFields.entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toMap(Map.Entry::getKey, e -> Collections.singletonList(((List)e.getValue()).indexOf(joinField))));
                }
            }
        }
        return joinFieldIndexes;
    }

    @Override
    public MessageTransferMode<List<ByteBuf>, Void> processDataRowResponse(ChannelHandlerContext ctx, List<ByteBuf> values) throws IOException {
        TransferMode transferMode;
        LOGGER.trace("Data row: {}", values);
        List<Object> newValues = null;
        SQLSession session = this.getSession(ctx);
        int backend = this.getBackend(ctx);
        List<Integer> involvedBackends = session.getCommandInvolvedBackends();
        int numberOfBackends = involvedBackends.size();
        SortedMap<Integer, List<ByteBuf>> allValues = session.newQueryResponse(SQLSession.QueryResponseType.DATA_ROW, backend, numberOfBackends, values, session.getJoinFieldIndexes());
        if (allValues == null) {
            transferMode = TransferMode.FORGET;
        } else {
            SQLSession.QueryResponseType nextQueryResponseToIgnore = session.firstQueryResponseToIgnore();
            if (nextQueryResponseToIgnore == null || nextQueryResponseToIgnore == SQLSession.QueryResponseType.READY_FOR_QUERY) {
                transferMode = TransferMode.FORWARD;
                newValues = numberOfBackends == 1 ? values : allValues.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
                if (session.getCurrentCommandOperation() == Operation.READ && (FORCE_SQL_PROCESSING || session.isResultProcessingEnabled())) {
                    newValues = this.processDataRow(ctx, allValues, involvedBackends);
                    if (LOGGER.isTraceEnabled() && numberOfBackends == 1 && !newValues.equals(values)) {
                        LOGGER.trace("values were modified");
                    }
                }
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{} new value(s) replace {} old value(s) from {} backend(s)", new Object[]{newValues.size(), allValues.values().stream().flatMap(Collection::stream).count(), numberOfBackends});
                }
                if (newValues == values || newValues.stream().allMatch(nv -> values.stream().anyMatch(v -> v == nv))) {
                    LOGGER.trace("new values from one backend");
                    newValues.stream().filter(nv -> nv != null).forEach(nv -> {
                        if (nv.release() && LOGGER.isTraceEnabled()) {
                            LOGGER.trace("value {} deallocated", nv);
                        }
                    });
                } else if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("at list one value is new or is from another backend");
                    newValues.stream().filter(nv -> values.stream().noneMatch(v -> v == nv)).forEach(nv -> LOGGER.trace("value {} is new or is from another backend", nv));
                }
                List<Object> nvs = newValues;
                allValues.values().stream().flatMap(Collection::stream).filter(v -> v != null).forEach(v -> {
                    if (nvs.stream().noneMatch(nv -> nv == v) && v.release() && LOGGER.isTraceEnabled()) {
                        LOGGER.trace("value {} deallocated", v);
                    }
                });
            } else if (nextQueryResponseToIgnore == SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR) {
                transferMode = TransferMode.FORGET;
            } else {
                throw new IllegalStateException(String.format("Unexpected %s response (%s or null was expected)", new Object[]{nextQueryResponseToIgnore, SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR}));
            }
        }
        MessageTransferMode mode = new MessageTransferMode(transferMode, newValues);
        LOGGER.trace("Data row processed: new values={}, transfer mode={}", mode.getNewContent(), (Object)mode.getTransferMode());
        return mode;
    }

    private List<ByteBuf> processDataRow(ChannelHandlerContext ctx, SortedMap<Integer, List<ByteBuf>> allValues, List<Integer> involvedBackends) {
        List newValues;
        SQLSession session = this.getSession(ctx);
        if (session.isUnprotectingDataEnabled() && (session.getExpectedFields() != null && session.getBackendRowDescriptions() != null && session.getRowDescription() != null || session.getCurrentDescribeStepStatus() != null && session.getCurrentDescribeStepStatus().getExpectedFields() != null && session.getCurrentDescribeStepStatus().getBackendRowDescriptions() != null && session.getCurrentDescribeStepStatus().getRowDescription() != null)) {
            int maxBackend = (Integer)allValues.keySet().stream().max(Comparator.naturalOrder()).get();
            SortedMap<Integer, List<PgsqlRowDescriptionMessage.Field>> backendFields = session.getBackendRowDescriptions();
            if (backendFields == null && session.getCurrentDescribeStepStatus() != null) {
                backendFields = session.getCurrentDescribeStepStatus().getBackendRowDescriptions();
            }
            if (backendFields == null) {
                throw new IllegalStateException("unexpected");
            }
            List<SQLSession.ExpectedField> expectedFields = session.getExpectedFields();
            if (expectedFields == null && session.getCurrentDescribeStepStatus() != null) {
                expectedFields = session.getCurrentDescribeStepStatus().getExpectedFields();
            }
            if (expectedFields == null) {
                throw new IllegalStateException("unexpected");
            }
            List clearDataIds = expectedFields.stream().filter(ep -> ep.getPosition() != -1).map(SQLSession.AbsractExpectedField::getAttributes).flatMap(Collection::stream).map(Map.Entry::getKey).map(CString::valueOf).collect(Collectors.toList());
            SQLDatabaseSchema databaseSchema = this.getDatabaseSchema(ctx);
            Integer srid = clearDataIds.stream().map(CString::toString).filter(this::isFullyQualifiedDataId).map(did -> did.substring(0, did.lastIndexOf(47))).map(databaseSchema::getDatasetSrid).filter(s -> s != null).map(Integer::valueOf).findFirst().orElse(null);
            List<PgsqlRowDescriptionMessage.Field> fields = session.getRowDescription();
            if (fields == null && session.getCurrentDescribeStepStatus() != null) {
                fields = session.getCurrentDescribeStepStatus().getRowDescription();
            }
            if (fields == null) {
                throw new IllegalStateException("unexpected");
            }
            boolean[] sridAddedFlags = new boolean[fields.size()];
            Arrays.fill(sridAddedFlags, false);
            ArrayList<InboundDataOperation> inboundDataOperations = new ArrayList<InboundDataOperation>(maxBackend + 1);
            for (int backend2 = 0; backend2 < maxBackend + 1; ++backend2) {
                if (!involvedBackends.contains(backend2)) continue;
                InboundDataOperation inboundDataOperation = new InboundDataOperation();
                inboundDataOperation.setInvolvedCSP(backend2);
                inboundDataOperation.setOperation(Operation.READ);
                inboundDataOperation.setClearDataIds(clearDataIds);
                inboundDataOperation.setPromise(session.getPromise());
                int csp = backend2;
                List dataIds = expectedFields.stream().map(SQLSession.ExpectedField::getProtectedFields).map(Map::entrySet).flatMap(Collection::stream).filter(e -> (Integer)e.getKey() == csp).map(Map.Entry::getValue).flatMap(Collection::stream).flatMap(epf -> epf.getAttributes().stream().map(Map.Entry::getKey)).map(CString::valueOf).collect(Collectors.toList());
                inboundDataOperation.setDataIds(dataIds);
                ArrayList<CString> dataValues = new ArrayList<CString>(dataIds.size());
                List values = (List)allValues.get(backend2);
                for (SQLSession.ExpectedField expectedField : expectedFields) {
                    List<SQLSession.ExpectedProtectedField> backendProtectedFields = expectedField.getBackendProtectedFields(backend2);
                    if (backendProtectedFields == null) continue;
                    for (SQLSession.ExpectedProtectedField protectedField : backendProtectedFields) {
                        for (Map.Entry<String, Integer> entry : protectedField.getAttributes()) {
                            int position = entry.getValue();
                            PgsqlRowDescriptionMessage.Field field = (PgsqlRowDescriptionMessage.Field)((List)backendFields.get(backend2)).get(position);
                            Types backendTypes = this.getTypes(ctx, backend2);
                            Type type = backendTypes.getType(field.getTypeOID());
                            CString dataValue = this.convertToText(type, field.getTypeModifier(), field.getFormat(), (ByteBuf)values.get(position));
                            if (srid != null) {
                                if (type == null) {
                                    for (Type typeWithUnfixedOid : backendTypes.getTypesWithUnfixedOid()) {
                                        try {
                                            TypeParser.parse(typeWithUnfixedOid, field.getTypeModifier(), dataValue);
                                            type = typeWithUnfixedOid;
                                            backendTypes.setTypeOid(type.getName(), field.getTypeOID());
                                            break;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                        }
                                    }
                                }
                                if (type != null) {
                                    PGboxbase box;
                                    boolean sridModified = false;
                                    Object object = TypeParser.parse(type, field.getTypeModifier(), dataValue);
                                    if (object instanceof Geometry) {
                                        Geometry geometry = (Geometry)object;
                                        if (geometry.getSrid() == 0) {
                                            geometry.setSrid(srid.intValue());
                                            dataValue = TypeWriter.toCString(type, geometry);
                                            sridModified = true;
                                        }
                                    } else if (object instanceof PGboxbase && ((box = (PGboxbase)object).getLLB().getSrid() == 0 || box.getURT().getSrid() == 0)) {
                                        if (box.getLLB().getSrid() == 0) {
                                            box.getLLB().setSrid(srid.intValue());
                                        }
                                        if (box.getURT().getSrid() == 0) {
                                            box.getURT().setSrid(srid.intValue());
                                        }
                                        dataValue = TypeWriter.toCString(type, box);
                                        sridModified = true;
                                    }
                                    if (sridModified) {
                                        sridAddedFlags[expectedField.getPosition()] = true;
                                    }
                                }
                            }
                            dataValues.add(dataValue);
                        }
                    }
                }
                inboundDataOperation.setDataValues(Collections.singletonList(dataValues));
                inboundDataOperations.add(inboundDataOperation);
            }
            InboundDataOperation newInboundDataOperation = this.newInboundDataOperation(ctx, inboundDataOperations);
            if (FORCE_SQL_PROCESSING || newInboundDataOperation.isModified()) {
                if (newInboundDataOperation.getDataValues().isEmpty()) {
                    throw new IllegalStateException("unexpected");
                }
                List dataValues = (List)newInboundDataOperation.getDataValues().get(0);
                newValues = Stream.generate(() -> null).limit(fields.size()).collect(Collectors.toList());
                int index = 0;
                for (int i = 0; i < expectedFields.size(); ++i) {
                    SQLSession.ExpectedField expectedField = expectedFields.get(i);
                    if (expectedField.getPosition() == -1) continue;
                    for (int j = 0; j < expectedField.getAttributes().size(); ++j) {
                        Map.Entry<String, Integer> entry = expectedField.getAttributes().get(j);
                        int position = entry.getValue();
                        if (newValues.get(position) == null) {
                            PgsqlRowDescriptionMessage.Field field = fields.get(position);
                            CString dataValue = (CString)dataValues.get(index);
                            Types types = this.getTypes(ctx, -1);
                            Type type = types.getType(field.getTypeOID());
                            if (sridAddedFlags[position]) {
                                if (type == null) {
                                    for (Type typeWithUnfixedOid : types.getTypesWithUnfixedOid()) {
                                        try {
                                            TypeParser.parse(typeWithUnfixedOid, field.getTypeModifier(), dataValue);
                                            type = typeWithUnfixedOid;
                                            types.setTypeOid(type.getName(), field.getTypeOID());
                                            break;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                        }
                                    }
                                }
                                if (type != null) {
                                    PGboxbase box;
                                    Object object = TypeParser.parse(type, field.getTypeModifier(), dataValue);
                                    if (object instanceof Geometry) {
                                        Geometry geometry = (Geometry)object;
                                        if (geometry.getSrid() != 0) {
                                            geometry.setSrid(0);
                                            dataValue = TypeWriter.toCString(type, geometry);
                                        }
                                    } else if (object instanceof PGboxbase && ((box = (PGboxbase)object).getLLB().getSrid() != 0 || box.getURT().getSrid() != 0)) {
                                        if (box.getLLB().getSrid() != 0) {
                                            box.getLLB().setSrid(0);
                                        }
                                        if (box.getURT().getSrid() != 0) {
                                            box.getURT().setSrid(0);
                                        }
                                        dataValue = TypeWriter.toCString(type, box);
                                    }
                                }
                            }
                            ByteBuf byteBuf = this.convertToByteBuf(type, field.getTypeModifier(), field.getFormat(), dataValue);
                            newValues.set(position, byteBuf);
                        }
                        ++index;
                    }
                }
                if (!newInboundDataOperation.isModified()) {
                    List values = (List)allValues.get(involvedBackends.get(0));
                    values.stream().filter(v -> v != null).forEach(v -> v.resetReaderIndex());
                    if (!newValues.equals(values)) {
                        throw new IllegalStateException("unexpected");
                    }
                }
            } else {
                newValues = (List)allValues.get(involvedBackends.get(0));
            }
        } else {
            newValues = involvedBackends.size() > 1 ? involvedBackends.stream().flatMap(backend -> ((List)allValues.get(backend)).stream()).collect(Collectors.toList()) : (List)allValues.get(involvedBackends.get(0));
        }
        return newValues;
    }

    private CString convertToText(Type type, int typeModifier, short format, ByteBuf value) {
        CString cs;
        if (format == 0) {
            CString cString = cs = value != null ? CString.valueOf((ByteBuf)value, (int)value.capacity()) : null;
            if (type == Type.BYTEA && cs.startsWith((CharSequence)"\\x")) {
                cs = cs.substring("\\x".length());
            }
        } else {
            Object object = TypeParser.parse(type, typeModifier, value);
            cs = TypeWriter.toCString(type, object);
        }
        return cs;
    }

    private ByteBuf convertToByteBuf(Type type, int typeModifier, short format, CString cs) {
        ByteBuf value;
        if (format == 0) {
            if (cs != null) {
                if (type == Type.BYTEA && !cs.startsWith((CharSequence)"\\x")) {
                    cs = CString.valueOf((CharSequence)"\\x").append((CharSequence)cs);
                }
                value = cs.getByteBuf(cs.length());
            } else {
                value = null;
            }
        } else {
            Object object = TypeParser.parse(type, typeModifier, cs);
            value = TypeWriter.getBytes(type, object);
        }
        return value;
    }

    @Override
    public MessageTransferMode<Void, Void> processNoDataResponse(ChannelHandlerContext ctx) {
        TransferMode transferMode;
        LOGGER.debug("No data");
        SQLSession session = this.getSession(ctx);
        int backend = this.getBackend(ctx);
        List<Integer> involvedBackends = session.getCommandInvolvedBackends();
        int numberOfBackends = involvedBackends.size();
        SortedMap<Integer, Boolean> all = session.newQueryResponse(SQLSession.QueryResponseType.NO_DATA, backend, numberOfBackends, Boolean.TRUE);
        if (all == null) {
            transferMode = TransferMode.FORGET;
        } else {
            SQLSession.QueryResponseType nextQueryResponseToIgnore = session.firstQueryResponseToIgnore();
            if (nextQueryResponseToIgnore == null) {
                transferMode = TransferMode.FORWARD;
            } else if (nextQueryResponseToIgnore == SQLSession.QueryResponseType.ROW_DESCRIPTION_AND_DATA_ROW_OR_NO_DATA) {
                transferMode = TransferMode.FORGET;
                session.removeFirstQueryResponseToIgnore();
            } else {
                throw new IllegalStateException(String.format("Unexpected %s response (%s or null was expected)", new Object[]{nextQueryResponseToIgnore, SQLSession.QueryResponseType.ROW_DESCRIPTION_AND_DATA_ROW_OR_NO_DATA}));
            }
        }
        MessageTransferMode<Void, Void> mode = new MessageTransferMode<Void, Void>(transferMode, null);
        LOGGER.debug("No data processed: transfer mode={}", (Object)mode.getTransferMode());
        return mode;
    }

    @Override
    public MessageTransferMode<CString, Void> processCommandCompleteResult(ChannelHandlerContext ctx, CString tag) throws IOException {
        TransferMode transferMode;
        LOGGER.debug("Command complete: {}", (Object)tag);
        CString newTag = null;
        LinkedHashMap<Byte, CString> errorDetails = null;
        SQLSession session = this.getSession(ctx);
        int backend = this.getBackend(ctx);
        List<Integer> involvedBackends = session.getCommandInvolvedBackends();
        int numberOfBackends = involvedBackends.size();
        SortedMap<Integer, CString> allTags = session.newQueryResponse(SQLSession.QueryResponseType.COMMAND_COMPLETE, backend, numberOfBackends, tag);
        if (allTags == null) {
            transferMode = TransferMode.FORGET;
        } else {
            SQLSession.QueryResponseType nextQueryResponseToIgnore;
            if (CHECK_BUFFER_REFERENCE_COUNT) {
                allTags.values().forEach(tg -> {
                    int refCnt = tg.refCnt();
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("in tag {} ({}) reference count: {}", new Object[]{tg, System.identityHashCode(tg), refCnt});
                    }
                    if (refCnt == 0) {
                        throw new IllegalStateException(String.format("Unexpected reference count (0) for tag '%s' (expected greater than 0)", tg));
                    }
                });
            }
            if ((nextQueryResponseToIgnore = session.firstQueryResponseToIgnore()) == null || nextQueryResponseToIgnore == SQLSession.QueryResponseType.READY_FOR_QUERY || nextQueryResponseToIgnore == SQLSession.QueryResponseType.PARSE_COMPLETE) {
                transferMode = TransferMode.FORWARD;
                if (numberOfBackends == 1) {
                    newTag = tag;
                } else if (allTags.values().stream().distinct().count() > 1L) {
                    Map<String, List<String[]>> tagsByCommand = allTags.values().stream().map(CString::toString).map(s -> s.split(" ")).collect(Collectors.groupingBy(tk -> tk[0]));
                    if (tagsByCommand.size() == 1) {
                        String command = (String)tagsByCommand.keySet().stream().findAny().get();
                        Stream<String> commands = Stream.of("INSERT", "UPDATE", "DELETE", "SELECT", "FETCH", "MOVE", "COPY");
                        if (commands.anyMatch(c -> c.equalsIgnoreCase(command))) {
                            newTag = allTags.values().stream().sorted().findFirst().get();
                        }
                    }
                    if (newTag == null) {
                        transferMode = TransferMode.ERROR;
                        errorDetails = new LinkedHashMap<Byte, CString>();
                        errorDetails.put((byte)83, CString.valueOf((CharSequence)"FATAL"));
                        errorDetails.put((byte)77, CString.valueOf((CharSequence)"Unexpected different tags from the backends"));
                    }
                } else {
                    newTag = tag;
                }
                session.resetCurrentCommand();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{} new tag replace {} old tag(s) from {} backend(s)", new Object[]{1, allTags.values().stream().count(), numberOfBackends});
                }
                if (newTag == tag) {
                    LOGGER.trace("new tag from one backend");
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("releasing {} ({}), refcount={}", new Object[]{newTag, System.identityHashCode(newTag), newTag.refCnt()});
                    }
                    if (newTag.release() && LOGGER.isTraceEnabled()) {
                        LOGGER.trace("tag {} deallocated", (Object)newTag);
                    }
                } else if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("tag {} is new or is from another backend", (Object)newTag);
                }
                CString ntg = newTag;
                allTags.values().stream().forEach(tg -> {
                    if (ntg != tg) {
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("releasing {} ({}), refcount={}", new Object[]{tg, System.identityHashCode(tg), tg.refCnt()});
                        }
                        if (tg.release() && LOGGER.isTraceEnabled()) {
                            LOGGER.trace("tag {} deallocated", tg);
                        }
                    }
                });
                if (CHECK_BUFFER_REFERENCE_COUNT) {
                    allTags.values().forEach(tg -> {
                        int refCnt = tg.refCnt();
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("out tag {} ({}) reference count: {}", new Object[]{tg, System.identityHashCode(tg), refCnt});
                        }
                        if (tg == ntg) {
                            if (refCnt == 0) {
                                throw new IllegalStateException(String.format("Unexpected reference count (0) for tag '%s' (expected greater than 0)", tg));
                            }
                        } else if (tg == tag) {
                            if (refCnt == 0) {
                                throw new IllegalStateException(String.format("Unexpected reference count (0) for tag '%s' (expected greater than 0)", tg));
                            }
                        } else if (refCnt != 0) {
                            throw new IllegalStateException(String.format("Unexpected reference count (%d) for tag '%s' (expected 0)", refCnt, tg));
                        }
                    });
                }
            } else if (nextQueryResponseToIgnore == SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR) {
                transferMode = TransferMode.FORGET;
                session.removeFirstQueryResponseToIgnore();
            } else {
                throw new IllegalStateException(String.format("Unexpected %s response (%s or null was expected)", new Object[]{nextQueryResponseToIgnore, SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR}));
            }
        }
        MessageTransferMode mode = new MessageTransferMode(transferMode, newTag);
        LOGGER.debug("Command complete processed: new tag={}, transfer mode={}", mode.getNewContent(), (Object)mode.getTransferMode());
        return mode;
    }

    @Override
    public MessageTransferMode<Void, Void> processEmptyQueryResponse(ChannelHandlerContext ctx) throws IOException {
        TransferMode transferMode;
        LOGGER.debug("Empty query");
        SQLSession session = this.getSession(ctx);
        int backend = this.getBackend(ctx);
        List<Integer> involvedBackends = session.getCommandInvolvedBackends();
        int numberOfBackends = involvedBackends.size();
        SortedMap<Integer, Boolean> all = session.newQueryResponse(SQLSession.QueryResponseType.EMPTY_QUERY, backend, numberOfBackends, Boolean.TRUE);
        if (all == null) {
            transferMode = TransferMode.FORGET;
        } else {
            SQLSession.QueryResponseType nextQueryResponseToIgnore = session.firstQueryResponseToIgnore();
            if (nextQueryResponseToIgnore == null || nextQueryResponseToIgnore == SQLSession.QueryResponseType.READY_FOR_QUERY) {
                transferMode = TransferMode.FORWARD;
                session.resetCurrentCommand();
            } else if (nextQueryResponseToIgnore == SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR) {
                transferMode = TransferMode.FORGET;
                session.removeFirstQueryResponseToIgnore();
            } else {
                throw new IllegalStateException(String.format("Unexpected %s response (%s or null was expected)", new Object[]{nextQueryResponseToIgnore, SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR}));
            }
        }
        MessageTransferMode<Void, Void> mode = new MessageTransferMode<Void, Void>(transferMode, null);
        LOGGER.debug("Empty query processed: transfer mode={}", (Object)mode.getTransferMode());
        return mode;
    }

    @Override
    public MessageTransferMode<Void, Void> processPortalSuspendedResponse(ChannelHandlerContext ctx) throws IOException {
        TransferMode transferMode;
        LOGGER.debug("Portal suspended");
        SQLSession session = this.getSession(ctx);
        int backend = this.getBackend(ctx);
        List<Integer> involvedBackends = session.getCommandInvolvedBackends();
        int numberOfBackends = involvedBackends.size();
        SortedMap<Integer, Boolean> all = session.newQueryResponse(SQLSession.QueryResponseType.PORTAL_SUSPENDED, backend, numberOfBackends, Boolean.TRUE);
        if (all == null) {
            transferMode = TransferMode.FORGET;
        } else {
            SQLSession.QueryResponseType nextQueryResponseToIgnore = session.firstQueryResponseToIgnore();
            if (nextQueryResponseToIgnore == null || nextQueryResponseToIgnore == SQLSession.QueryResponseType.READY_FOR_QUERY) {
                transferMode = TransferMode.FORWARD;
            } else if (nextQueryResponseToIgnore == SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR) {
                transferMode = TransferMode.FORGET;
                session.removeFirstQueryResponseToIgnore();
            } else {
                throw new IllegalStateException(String.format("Unexpected %s response (%s or null was expected)", new Object[]{nextQueryResponseToIgnore, SQLSession.QueryResponseType.COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR}));
            }
        }
        MessageTransferMode<Void, Void> mode = new MessageTransferMode<Void, Void>(transferMode, null);
        LOGGER.debug("Portal suspended processed: transfer mode={}", (Object)mode.getTransferMode());
        return mode;
    }

    @Override
    public MessageTransferMode<Map<Byte, CString>, Void> processErrorResult(ChannelHandlerContext ctx, Map<Byte, CString> fields) throws IOException {
        TransferMode transferMode;
        LOGGER.debug("Error: {}", fields);
        Map<Byte, CString> newFields = null;
        SQLSession session = this.getSession(ctx);
        int backend = this.getBackend(ctx);
        List<Integer> involvedBackends = session.getQueryInvolvedBackends();
        int numberOfBackends = involvedBackends.size();
        SortedMap<Integer, Map<Byte, CString>> allFields = session.newQueryResponse(SQLSession.QueryResponseType.ERROR, backend, numberOfBackends, fields);
        if (allFields == null) {
            transferMode = TransferMode.FORGET;
        } else {
            session.setTransactionErrorDetails(fields);
            SQLSession.QueryResponseType nextQueryResponseToIgnore = session.firstQueryResponseToIgnore();
            while (nextQueryResponseToIgnore != null && nextQueryResponseToIgnore != SQLSession.QueryResponseType.READY_FOR_QUERY) {
                session.removeFirstQueryResponseToIgnore();
                nextQueryResponseToIgnore = session.firstQueryResponseToIgnore();
            }
            if (session.getQueryResponsesToIgnore().isEmpty()) {
                transferMode = TransferMode.FORWARD;
                newFields = fields;
                session.resetCurrentCommand();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{} new field(s) replace {} old field(s) from {} backend(s)", new Object[]{newFields.size(), allFields.values().stream().map(Map::entrySet).flatMap(Collection::stream).count(), numberOfBackends});
                }
                if (newFields == fields || newFields.entrySet().stream().allMatch(ne -> fields.entrySet().stream().anyMatch(e -> e.getKey() == ne.getKey() && e.getValue() == ne.getValue()))) {
                    LOGGER.trace("new fields from one backend");
                    newFields.values().stream().forEach(nf -> {
                        if (nf.release() && LOGGER.isTraceEnabled()) {
                            LOGGER.trace("field {} deallocated", nf);
                        }
                    });
                } else if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("at list one field is new or is from another backend");
                    newFields.entrySet().stream().filter(ne -> fields.entrySet().stream().noneMatch(e -> e.getKey() == ne.getKey() && e.getValue() == ne.getValue())).forEach(ne -> LOGGER.trace("field {}:{} is new or is from another backend", ne.getKey(), ne.getValue()));
                }
                Map<Byte, CString> nfs = newFields;
                allFields.values().stream().map(Map::values).flatMap(Collection::stream).forEach(f -> {
                    if (nfs.values().stream().noneMatch(nf -> nf == f) && f.release() && LOGGER.isTraceEnabled()) {
                        LOGGER.trace("field {} deallocated", f);
                    }
                });
            } else {
                transferMode = TransferMode.FORGET;
            }
            session.responsesReceived();
        }
        MessageTransferMode mode = new MessageTransferMode(transferMode, newFields);
        LOGGER.debug("Error processed: new fields={}, transfer mode={}", mode.getNewContent(), (Object)mode.getTransferMode());
        return mode;
    }

    @Override
    public MessageTransferMode<Void, Void> processCloseCompleteResponse(ChannelHandlerContext ctx) {
        TransferMode transferMode;
        LOGGER.debug("Close complete");
        SQLSession session = this.getSession(ctx);
        int backend = this.getBackend(ctx);
        List<Integer> involvedBackends = session.getCommandInvolvedBackends();
        int numberOfBackends = involvedBackends.size();
        SortedMap<Integer, Boolean> all = session.newQueryResponse(SQLSession.QueryResponseType.CLOSE_COMPLETE, backend, numberOfBackends, Boolean.TRUE);
        if (all == null) {
            transferMode = TransferMode.FORGET;
        } else {
            SQLSession.QueryResponseType nextQueryResponseToIgnore = session.firstQueryResponseToIgnore();
            if (nextQueryResponseToIgnore == null) {
                transferMode = TransferMode.FORWARD;
            } else if (nextQueryResponseToIgnore == SQLSession.QueryResponseType.CLOSE_COMPLETE) {
                transferMode = TransferMode.FORGET;
                session.removeFirstQueryResponseToIgnore();
            } else {
                throw new IllegalStateException(String.format("Unexpected %s response (%s or null was expected)", new Object[]{nextQueryResponseToIgnore, SQLSession.QueryResponseType.CLOSE_COMPLETE}));
            }
        }
        MessageTransferMode<Void, Void> mode = new MessageTransferMode<Void, Void>(transferMode, null);
        LOGGER.debug("Close complete processed: transfer mode={}", (Object)mode.getTransferMode());
        return mode;
    }

    @Override
    public MessageTransferMode<Byte, Void> processReadyForQueryResponse(ChannelHandlerContext ctx, Byte transactionStatus) throws IOException {
        TransferMode transferMode;
        LOGGER.debug("Ready for query: {}", (Object)Character.valueOf((char)transactionStatus.byteValue()));
        Byte newTransactionStatus = null;
        SQLSession session = this.getSession(ctx);
        int backend = this.getBackend(ctx);
        List<Integer> involvedBackends = session.getQueryInvolvedBackends();
        int numberOfBackends = involvedBackends.size();
        SortedMap<Integer, Byte> allTransactionStatus = session.newQueryResponse(SQLSession.QueryResponseType.READY_FOR_QUERY, backend, numberOfBackends, transactionStatus);
        if (allTransactionStatus == null) {
            transferMode = TransferMode.FORGET;
        } else {
            SQLSession.QueryResponseType nextQueryResponseToIgnore = session.firstQueryResponseToIgnore();
            if (nextQueryResponseToIgnore == null) {
                transferMode = TransferMode.FORWARD;
                newTransactionStatus = numberOfBackends == 1 ? transactionStatus : allTransactionStatus.values().stream().distinct().filter(ts -> ts == 69).findAny().orElse(transactionStatus);
                session.setTransactionStatus(transactionStatus);
                if (transactionStatus != 69) {
                    session.setTransactionErrorDetails(null);
                }
                session.resetCurrentQuery();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{} new transaction status replace {} old transaction status(s) from {} backend(s)", new Object[]{1, allTransactionStatus.values().stream().count(), numberOfBackends});
                }
                if (newTransactionStatus == transactionStatus) {
                    LOGGER.trace("new transaction status from one backend");
                } else if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("transaction status {} is new or is from another backend", (Object)newTransactionStatus);
                }
            } else if (nextQueryResponseToIgnore == SQLSession.QueryResponseType.READY_FOR_QUERY) {
                transferMode = TransferMode.FORGET;
                session.removeFirstQueryResponseToIgnore();
                session.resetCurrentQuery();
            } else {
                throw new IllegalStateException(String.format("Unexpected %s response (%s or null was expected)", new Object[]{nextQueryResponseToIgnore, SQLSession.QueryResponseType.READY_FOR_QUERY}));
            }
            session.responsesReceived();
        }
        MessageTransferMode mode = new MessageTransferMode(transferMode, newTransactionStatus);
        LOGGER.debug("Ready for query processed: new transaction status={}, transfer mode={}", (Object)(newTransactionStatus == null ? null : Character.valueOf((char)newTransactionStatus.byteValue())), (Object)mode.getTransferMode());
        return mode;
    }

    private PgsqlSession getPgsqlSession(ChannelHandlerContext ctx) {
        PgsqlSession pgsqlSession = (PgsqlSession)((Object)ctx.channel().attr(PgsqlConstants.SESSION_KEY).get());
        return pgsqlSession;
    }

    private SQLSession getSession(ChannelHandlerContext ctx) {
        PgsqlSession pgsqlSession = this.getPgsqlSession(ctx);
        return pgsqlSession.getSqlSession();
    }

    private SQLDatabaseSchema getDatabaseSchema(ChannelHandlerContext ctx) {
        Map customData = (Map)ctx.channel().attr(PgsqlConstants.CUSTOM_DATA_KEY).get();
        SQLDatabaseSchema sqlDatabaseSchema = (SQLDatabaseSchema)customData.get(SQL_DATABASE_SCHEMA);
        if (sqlDatabaseSchema == null) {
            sqlDatabaseSchema = new SQLDatabaseSchema();
            customData.put(SQL_DATABASE_SCHEMA, sqlDatabaseSchema);
        }
        return sqlDatabaseSchema;
    }

    private Types getTypes(ChannelHandlerContext ctx, int backend) {
        SQLDatabaseSchema sqlDatabaseSchema = this.getDatabaseSchema(ctx);
        Types types = backend != -1 ? sqlDatabaseSchema.getBackendTypes(backend) : sqlDatabaseSchema.getTypes();
        return types;
    }

    private Mode getProcessingMode(ChannelHandlerContext ctx, boolean wholeDataset, Operation operation) {
        Configuration configuration = (Configuration)ctx.channel().attr(PgsqlConstants.CONFIGURATION_KEY).get();
        return configuration.getProcessingMode(wholeDataset, operation);
    }

    private ProtocolService getProtocolService(ChannelHandlerContext ctx) {
        Configuration configuration = (Configuration)ctx.channel().attr(PgsqlConstants.CONFIGURATION_KEY).get();
        return configuration.getProtocolService();
    }

    private String getDataTechnicalId(ChannelHandlerContext ctx) {
        PgsqlConfiguration configuration = (PgsqlConfiguration)((Object)ctx.channel().attr(PgsqlConstants.CONFIGURATION_KEY).get());
        return configuration.getDataTechnicalId();
    }

    private Map<String, String> getGeometryObjectDefinition(ChannelHandlerContext ctx) {
        PgsqlConfiguration configuration = (PgsqlConfiguration)((Object)ctx.channel().attr(PgsqlConstants.CONFIGURATION_KEY).get());
        return configuration.getGeometryObjectDefinition();
    }

    private String getDatabaseName(ChannelHandlerContext ctx) {
        SQLSession session = this.getSession(ctx);
        return session.getDatabaseName();
    }

    private List<String> getBackendDatabaseNames(ChannelHandlerContext ctx) {
        PgsqlConfiguration configuration = (PgsqlConfiguration)((Object)ctx.channel().attr(PgsqlConstants.CONFIGURATION_KEY).get());
        return configuration.getBackendDatabaseNames();
    }

    private int getNumberOfBackends(ChannelHandlerContext ctx) {
        PgsqlSession pgsqlSession = (PgsqlSession)((Object)ctx.channel().attr(PgsqlConstants.SESSION_KEY).get());
        return pgsqlSession.getServerSideChannels().size();
    }

    private int getBackend(ChannelHandlerContext ctx) {
        Integer serverEndpointNumber = (Integer)ctx.channel().attr(TCPConstants.SERVER_ENDPOINT_NUMBER_KEY).get();
        if (serverEndpointNumber == null) {
            throw new NullPointerException(TCPConstants.SERVER_ENDPOINT_NUMBER_KEY.name() + " is not set");
        }
        int numberOfBackends = this.getNumberOfBackends(ctx);
        if (serverEndpointNumber < 0 || serverEndpointNumber >= numberOfBackends) {
            throw new IndexOutOfBoundsException(String.format("invalid %s: value: %d, number of server endpoints: %d ", TCPConstants.SERVER_ENDPOINT_NUMBER_KEY.name(), serverEndpointNumber, numberOfBackends));
        }
        return serverEndpointNumber;
    }

    private int getPreferredBackend(ChannelHandlerContext ctx) {
        Integer preferredServerEndpoint = (Integer)ctx.channel().attr(TCPConstants.PREFERRED_SERVER_ENDPOINT_KEY).get();
        if (preferredServerEndpoint == null) {
            throw new NullPointerException(TCPConstants.PREFERRED_SERVER_ENDPOINT_KEY.name() + " is not set");
        }
        int numberOfBackends = this.getNumberOfBackends(ctx);
        if (preferredServerEndpoint < 0 || preferredServerEndpoint >= numberOfBackends) {
            throw new IndexOutOfBoundsException(String.format("invalid %s: value: %d, number of server endpoints: %d ", TCPConstants.PREFERRED_SERVER_ENDPOINT_KEY.name(), preferredServerEndpoint, numberOfBackends));
        }
        return preferredServerEndpoint;
    }

    private static /* synthetic */ void lambda$processRowDescription$462(int nbExpectedFields, int[] positionPerBackend, SQLSession.ExpectedField ef) {
        Integer position = ef.getPosition();
        if (ef.getProtectedFields().isEmpty()) {
            if (position != -1) {
                throw new IllegalStateException("unexpected");
            }
            ef.getAttributes().stream().map(Map.Entry::getValue).forEach(pos -> {
                if (pos != -1) {
                    throw new IllegalStateException("unexpected");
                }
            });
        } else {
            if (position == null || position >= nbExpectedFields || position >= 0 && position - positionPerBackend[0] != 1) {
                throw new IllegalStateException("unexpected");
            }
            ef.getAttributes().stream().map(Map.Entry::getValue).forEach(pos -> {
                if (pos == null || pos >= nbExpectedFields || pos >= 0 && (pos - positionPerBackend[0] < 0 || pos - positionPerBackend[0] > 1)) {
                    throw new IllegalStateException("unexpected");
                }
            });
            if (position >= 0) {
                positionPerBackend[0] = position;
            }
            int nbAttributes = ef.getAttributes().size();
            int nbProtectedAttributes = ef.getProtectedFields().values().stream().flatMap(Collection::stream).map(SQLSession.AbsractExpectedField::getAttributes).map(List::size).reduce(0, Integer::sum);
            if (nbProtectedAttributes != nbAttributes) {
                LOGGER.trace("{} protected attribute(s) for {} clear attribute(s)", (Object)nbProtectedAttributes, (Object)nbAttributes);
                if (nbProtectedAttributes != nbAttributes * ef.getProtectedFields().size()) {
                    throw new IllegalStateException("unexpected");
                }
            }
        }
    }

    private static /* synthetic */ void lambda$processRowDescription$459(SQLSession.ExpectedField expectedField, List clearAttributeNames, SQLSession.ExpectedProtectedField epf) {
        epf.getAttributes().removeIf(e -> epf.getAttributeMapping().stream().filter(e2 -> ((String)e2.getKey()).equals(e.getKey())).map(Map.Entry::getValue).map(idx -> expectedField.getAttributes().get((int)idx)).map(Map.Entry::getKey).noneMatch(an -> clearAttributeNames.stream().anyMatch(nan -> nan.equals(an))));
        epf.getAttributeMapping().removeIf(e -> {
            String an = expectedField.getAttributes().get((Integer)e.getValue()).getKey();
            return clearAttributeNames.stream().noneMatch(nan -> nan.equals(an));
        });
    }

    private static /* synthetic */ void lambda$processRowDescription$451(int position, Map.Entry e) {
        e.setValue(position);
    }

    private static /* synthetic */ boolean lambda$processRowDescription$450(Map map) {
        return map != null;
    }

    private /* synthetic */ void lambda$processRowDescription$449(SQLSession.ExpectedField expectedField, String newClearFieldName, List newClearAttributes, SQLSession.ExpectedProtectedField epf) {
        epf.getAttributes().removeIf(e -> epf.getAttributeMapping().stream().filter(e2 -> ((String)e2.getKey()).equals(e.getKey())).map(Map.Entry::getValue).map(idx -> expectedField.getAttributes().get((int)idx)).map(Map.Entry::getKey).map(an -> this.toOutputName((String)an).equals("*") ? an.replace("*", newClearFieldName) : an).noneMatch(an -> newClearAttributes.stream().map(Map.Entry::getKey).anyMatch(nan -> nan.equals(an))));
        epf.getAttributeMapping().removeIf(e -> {
            String an = expectedField.getAttributes().get((Integer)e.getValue()).getKey();
            if (this.toOutputName(an).equals("*")) {
                an = an.replace("*", newClearFieldName);
            }
            String an2 = an;
            return newClearAttributes.stream().map(Map.Entry::getKey).noneMatch(nan -> nan.equals(an2));
        });
    }

    private /* synthetic */ AbstractMap.SimpleEntry lambda$processRowDescription$440(List protectedFieldNames, Map.Entry e) {
        return new AbstractMap.SimpleEntry(e.getKey(), ((List)e.getValue()).stream().filter(epf -> {
            List backendProtectedFieldNames = (List)protectedFieldNames.get((Integer)e.getKey());
            return backendProtectedFieldNames != null && backendProtectedFieldNames.contains(this.toOutputName(epf.getName()));
        }).collect(Collectors.toList()));
    }

    private /* synthetic */ boolean lambda$processRowDescription$438(List protectedFieldNames, Map.Entry e) {
        return ((List)e.getValue()).stream().map(SQLSession.AbsractExpectedField::getName).map(n -> this.toOutputName((String)n)).anyMatch(n -> {
            List backendProtectedFieldNames = (List)protectedFieldNames.get((Integer)e.getKey());
            return backendProtectedFieldNames != null && backendProtectedFieldNames.contains(n);
        });
    }

    private static /* synthetic */ void lambda$processRowDescription$435(String newFieldName, List l) {
        l.add(newFieldName);
    }

    private static /* synthetic */ boolean lambda$processRowDescription$434(List l) {
        return l != null;
    }

    private static /* synthetic */ boolean lambda$processRowDescription$433(List l) {
        return l != null;
    }

    private /* synthetic */ List lambda$processRowDescription$432(List newClearAttributes, Map map) {
        return map != null ? map.entrySet().stream().filter(e -> newClearAttributes.stream().anyMatch(e2 -> ((String)e.getKey()).equals(e2.getKey()))).map(Map.Entry::getValue).map(this::toOutputName).distinct().collect(Collectors.toList()) : null;
    }

    private static /* synthetic */ void lambda$processRowDescription$429(int position, Map.Entry e) {
        e.setValue(position);
    }

    private static /* synthetic */ boolean lambda$processRowDescription$428(Map map) {
        return map != null;
    }

    private static /* synthetic */ AbstractMap.SimpleEntry lambda$processRowDescription$427(String an) {
        return new AbstractMap.SimpleEntry<String, Integer>(an, -1);
    }

    private /* synthetic */ boolean lambda$processRowDescription$426(String newFieldName, Map.Entry e) {
        return newFieldName.equals(this.toOutputName((String)e.getKey()));
    }

    private /* synthetic */ Map.Entry lambda$processRowDescription$425(String newFieldName, Map.Entry e) {
        return this.toOutputName((String)e.getKey()).equals("*") ? new AbstractMap.SimpleEntry<String, Integer>(((String)e.getKey()).replace("*", newFieldName), 0) : e;
    }

    private static /* synthetic */ AbstractMap.SimpleEntry lambda$processRowDescription$424(List involvedBackends, SortedMap allFields, SQLSession.ExpectedField ef) {
        return new AbstractMap.SimpleEntry(ef.getName(), ef.getProtectedFields().get(involvedBackends.get(0)).stream().map(epf -> (PgsqlRowDescriptionMessage.Field)((List)allFields.get(involvedBackends.get(0))).get(epf.getPosition())).collect(Collectors.toList()));
    }

    private static /* synthetic */ String lambda$processRowDescription$422(PgsqlRowDescriptionMessage.Field f) {
        return f.getName().substring(0, f.getName().indexOf(46)).toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private /* synthetic */ boolean lambda$processRowDescription$421(List attributeMapping, PgsqlRowDescriptionMessage.Field f) {
        if (f.getName().charAt(0) != '?') return true;
        if (f.getName().charAt(f.getName().length() - 1) != '?') return true;
        if (attributeMapping == null) return true;
        if (!attributeMapping.stream().filter(map -> map != null).map(Map::keySet).flatMap(Collection::stream).map(this::toOutputName).noneMatch(arg_0 -> ((CString)f.getName()).equals(arg_0))) return false;
        return true;
    }

    private /* synthetic */ void lambda$processRowDescription$419(SQLSession session, Map.Entry e) {
        Stream<Object> stream;
        String clearFieldname = (String)e.getKey();
        List fields = (List)e.getValue();
        if (clearFieldname.equals("*")) {
            stream = fields.stream();
            if (session.isUnprotectingDataEnabled()) {
                stream = stream.distinct().sorted(Comparator.comparing(PgsqlRowDescriptionMessage.Field::getColumnNumber));
            }
            stream = stream.map(new java.util.function.Function<PgsqlRowDescriptionMessage.Field, PgsqlRowDescriptionMessage.Field>(){
                private short previous = (short)-1;

                @Override
                public PgsqlRowDescriptionMessage.Field apply(PgsqlRowDescriptionMessage.Field field) {
                    if (field.getColumnNumber() <= this.previous) {
                        short newColumnNumber = (short)(this.previous + 1);
                        field = new PgsqlRowDescriptionMessage.Field((CString)field.getName().clone(), field.getTableOID(), newColumnNumber, field.getTypeOID(), field.getTypeSize(), field.getTypeModifier(), field.getFormat());
                    }
                    this.previous = field.getColumnNumber();
                    return field;
                }
            });
        } else {
            stream = session.isUnprotectingDataEnabled() ? fields.stream().limit(1L) : fields.stream();
        }
        fields = stream.collect(Collectors.toList());
        e.setValue(fields);
    }

    private /* synthetic */ AbstractMap.SimpleEntry lambda$processRowDescription$418(SortedMap allFields, SQLSession session, List reversedAttributeMapping, SQLSession.ExpectedField ef) {
        String clearFieldName = ef.getName();
        return new AbstractMap.SimpleEntry(clearFieldName, ef.getProtectedFields().entrySet().stream().flatMap(e -> {
            int backend = (Integer)e.getKey();
            List protectedFields = (List)e.getValue();
            List backendFields = (List)allFields.get(backend);
            return protectedFields.stream().map(epf -> {
                int position = epf.getPosition();
                PgsqlRowDescriptionMessage.Field backendField = (PgsqlRowDescriptionMessage.Field)backendFields.get(position);
                if (session.isUnprotectingDataEnabled()) {
                    if (!backendField.getName().equals((Object)"?column?")) {
                        String outputName = clearFieldName.equals("*") ? (reversedAttributeMapping != null ? reversedAttributeMapping.stream().filter(map -> map != null).map(Map::entrySet).flatMap(Collection::stream).filter(e2 -> this.toOutputName((String)e2.getKey()).equals(epf.getName())).findAny().map(Map.Entry::getValue).map(this::toOutputName).orElse(epf.getName()) : epf.getName()) : clearFieldName;
                        if (!backendField.getName().equals((Object)outputName)) {
                            backendField = new PgsqlRowDescriptionMessage.Field(CString.valueOf((CharSequence)outputName), backendField.getTableOID(), backendField.getColumnNumber(), backendField.getTypeOID(), backendField.getTypeSize(), backendField.getTypeModifier(), backendField.getFormat());
                        }
                    }
                } else {
                    CString backendFieldName = backendField.getName();
                    String protectedAttributeName = epf.getAttributes().stream().map(Map.Entry::getKey).filter(pan -> backendFieldName.equals((Object)this.toOutputName((String)pan))).findFirst().orElse(epf.getAttributes().get(0).getKey());
                    backendField = new PgsqlRowDescriptionMessage.Field(CString.valueOf((CharSequence)("csp" + (backend + 1) + "/" + protectedAttributeName)).replace('/', '.'), backendField.getTableOID(), backendField.getColumnNumber(), backendField.getTypeOID(), backendField.getTypeSize(), backendField.getTypeModifier(), backendField.getFormat());
                }
                return backendField;
            });
        }).collect(Collectors.toList()));
    }

    private static /* synthetic */ void lambda$processRowDescription$412(SQLDatabaseSchema databaseSchema, Map.Entry e) {
        ((List)e.getValue()).forEach(f -> databaseSchema.addTypeOIDBackend(f.getTypeOID(), (Integer)e.getKey()));
    }

    private static /* synthetic */ Map lambda$processRowDescription$410(Map map) {
        return map != null ? map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey)) : null;
    }

    private static /* synthetic */ Map lambda$processRowDescription$409(DataOperationCommand doc) {
        return doc != null ? doc.getMapping() : null;
    }

    private static /* synthetic */ void lambda$processRowDescription$408(int[] nbFieldsPerBackend, int[] positionPerBackend, SQLSession.ExpectedField ef) {
        ef.getProtectedFields().entrySet().stream().forEach(entry -> {
            int backend = (Integer)entry.getKey();
            List backendProtectedFields = (List)entry.getValue();
            if (!ef.getName().equals("*") && backendProtectedFields.size() > 1) {
                throw new IllegalStateException("unexpected");
            }
            backendProtectedFields.forEach(epf -> {
                Integer position = epf.getPosition();
                if (position == null || position < 0 || position >= nbFieldsPerBackend[backend] || position - positionPerBackend[backend] != 1) {
                    throw new IllegalStateException("unexpected");
                }
                epf.getAttributes().stream().map(Map.Entry::getValue).forEach(pos -> {
                    if (pos == null || pos < 0 || pos >= nbFieldsPerBackend[backend] || pos - positionPerBackend[backend] < 0 || pos - positionPerBackend[backend] > 1) {
                        throw new IllegalStateException("unexpected");
                    }
                });
                positionPerBackend[backend] = position;
            });
        });
    }

    private /* synthetic */ void lambda$processRowDescription$404(SortedMap allFields, int[] positionPerBackend, Map protectedFields) {
        allFields.entrySet().forEach(entry -> {
            int backend = (Integer)entry.getKey();
            List backendProtectedFields = (List)protectedFields.get(backend);
            if (backendProtectedFields == null) {
                return;
            }
            List backendFields = (List)entry.getValue();
            for (int i = 0; i < backendProtectedFields.size(); ++i) {
                SQLSession.ExpectedProtectedField protectedField = (SQLSession.ExpectedProtectedField)backendProtectedFields.get(i);
                String protectedName = protectedField.getName();
                String protectedFieldname = this.toOutputName(protectedName);
                if (protectedFieldname.equals("*")) {
                    short columnNumber;
                    PgsqlRowDescriptionMessage.Field backendField;
                    backendProtectedFields.remove(i);
                    int tableOID = ((PgsqlRowDescriptionMessage.Field)backendFields.get(positionPerBackend[backend])).getTableOID();
                    ArrayList<Short> columnNumbers = new ArrayList<Short>(backendFields.size() - positionPerBackend[backend]);
                    while (positionPerBackend[backend] < backendFields.size() && (backendField = (PgsqlRowDescriptionMessage.Field)backendFields.get(positionPerBackend[backend])).getTableOID() == tableOID && !columnNumbers.contains(columnNumber = backendField.getColumnNumber())) {
                        columnNumbers.add(columnNumber);
                        String newFieldName = protectedName.replace("*", backendField.getName().toString());
                        List<Map.Entry<String, Integer>> protectedAttributes = protectedField.getAttributes();
                        List<Map.Entry<String, Integer>> newProtectedAttributes = protectedAttributes.stream().map(e -> this.toOutputName((String)e.getKey()).equals("*") ? new AbstractMap.SimpleEntry<String, Integer>(((String)e.getKey()).replace("*", backendField.getName().toString()), 0) : e).filter(e -> backendField.getName().equals((Object)this.toOutputName((String)e.getKey()))).peek(e -> e.setValue(positionPerBackend[backend])).collect(Collectors.toList());
                        if (newProtectedAttributes.isEmpty()) {
                            LOGGER.trace("strange... unexpected protected attribute size");
                            newProtectedAttributes = Stream.of(new AbstractMap.SimpleEntry<String, Integer>(backendField.getName().toString(), positionPerBackend[backend])).collect(Collectors.toList());
                        }
                        List<Map.Entry<String, Integer>> newProtectedAttributes2 = newProtectedAttributes;
                        List<Map.Entry<String, Integer>> newAttributeMapping = protectedField.getAttributeMapping().stream().map(e -> this.toOutputName((String)e.getKey()).equals("*") ? new AbstractMap.SimpleEntry<String, Integer>(((String)e.getKey()).replace("*", backendField.getName().toString()), 0) : e).filter(e -> newProtectedAttributes2.stream().anyMatch(e2 -> ((String)e2.getKey()).equals(e.getKey()))).collect(Collectors.toList());
                        SQLSession.ExpectedProtectedField newProtectedField = new SQLSession.ExpectedProtectedField(backend, newFieldName, positionPerBackend[backend], newProtectedAttributes, newAttributeMapping);
                        backendProtectedFields.add(i, newProtectedField);
                        ++i;
                        int n = backend;
                        positionPerBackend[n] = positionPerBackend[n] + 1;
                    }
                    --i;
                } else {
                    PgsqlRowDescriptionMessage.Field backendField = (PgsqlRowDescriptionMessage.Field)backendFields.get(positionPerBackend[backend]);
                    if (!backendField.getName().equals((Object)protectedFieldname)) {
                        if (!backendField.getName().equals((Object)"?column?")) {
                            LOGGER.trace("strange... unexpected protected field name");
                        }
                        protectedField.setName(backendField.getName().toString());
                    }
                    protectedField.setPosition(positionPerBackend[backend]);
                    protectedField.getAttributes().forEach(e -> e.setValue(positionPerBackend[backend]));
                    int n = backend;
                    positionPerBackend[n] = positionPerBackend[n] + 1;
                }
                if (positionPerBackend[backend] <= backendFields.size()) continue;
                throw new IllegalStateException("unexpected");
            }
        });
    }

    private static /* synthetic */ boolean lambda$processRowDescription$395(List involvedBackends, SQLSession.ExpectedField ef) {
        return ef.getProtectedFields().size() > 0 && ef.getProtectedFields().get(involvedBackends.get(0)).size() > 0 && (!ef.getProtectedFields().get(involvedBackends.get(0)).get(0).getName().equals(ef.getName()) || ef.getName().equals("*"));
    }

    private static /* synthetic */ boolean lambda$processRowDescription$394(SQLSession.ExpectedField ef) {
        return ef.getProtectedFields().size() != 1;
    }

    static {
        String sqlForceProcessing = System.getProperty("pgsql.sql.force.processing", "false");
        FORCE_SQL_PROCESSING = Boolean.TRUE.toString().equalsIgnoreCase(sqlForceProcessing) || "1".equalsIgnoreCase(sqlForceProcessing) || "yes".equalsIgnoreCase(sqlForceProcessing) || "on".equalsIgnoreCase(sqlForceProcessing);
        String bufferCheckReferenceCount = System.getProperty("buffer.check.reference.count", "false");
        CHECK_BUFFER_REFERENCE_COUNT = Boolean.TRUE.toString().equalsIgnoreCase(bufferCheckReferenceCount) || "1".equalsIgnoreCase(bufferCheckReferenceCount) || "yes".equalsIgnoreCase(bufferCheckReferenceCount) || "on".equalsIgnoreCase(bufferCheckReferenceCount);
        FQ_DATA_ID_PATTERN = Pattern.compile("([\\w_\\*]+)/([\\w_\\*]+)\\.([\\w_\\*]+)/([\\w_\\*]+)");
    }

    private static class PgsqlStatement<T extends Statement> {
        private final T statement;
        private final List<Long> parameterTypes;
        private final List<Short> parameterFormats;
        private final List<ParameterValue> parameterValues;
        private final List<Short> resultFormats;
        private final List<CString> columns;

        public PgsqlStatement(T statement) {
            this(statement, null, null, null, null, null);
        }

        public PgsqlStatement(T statement, List<Long> parameterTypes, List<Short> parameterFormats, List<ParameterValue> parameterValues, List<Short> resultFormats, List<CString> columns) {
            this.statement = statement;
            this.parameterTypes = parameterTypes;
            this.parameterFormats = parameterFormats;
            this.parameterValues = parameterValues;
            this.resultFormats = resultFormats;
            this.columns = columns;
        }

        public T getStatement() {
            return this.statement;
        }

        public List<Long> getParameterTypes() {
            return this.parameterTypes;
        }

        public List<Short> getParameterFormats() {
            return this.parameterFormats;
        }

        public List<ParameterValue> getParameterValues() {
            return this.parameterValues;
        }

        public List<Short> getResultFormats() {
            return this.resultFormats;
        }

        public List<CString> getColumns() {
            return this.columns;
        }
    }

    private static class Result<Q, R, E> {
        private final Optional<List<Q>> queries;
        private final Optional<R> response;
        private final Optional<E> error;

        public static <Q, R, E> Result<Q, R, E> query(Q query) {
            return Result.queries(Collections.singletonList(query));
        }

        public static <Q, R, E> Result<Q, R, E> queries(List<Q> queries) {
            return new Result<Q, R, E>(Optional.ofNullable(queries), null, null);
        }

        public static <Q, R, E> Result<Q, R, E> response(R response) {
            return new Result<Q, R, E>(null, Optional.ofNullable(response), null);
        }

        public static <Q, R, E> Result<Q, R, E> error(E error) {
            return new Result<Q, R, E>(null, null, Optional.ofNullable(error));
        }

        private Result(Optional<List<Q>> queries, Optional<R> response, Optional<E> error) {
            this.queries = queries;
            this.response = response;
            this.error = error;
        }

        public List<Q> queries() {
            return this.queries == null ? null : (List)this.queries.orElse(null);
        }

        public Map<Integer, Q> queriesAsMap() {
            return this.queries == null || !this.queries.isPresent() ? null : IntStream.range(0, this.queries.get().size()).mapToObj(i -> new AbstractMap.SimpleEntry<Integer, Q>(i, this.queries.get().get(i))).filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }

        public R response() {
            return this.response == null ? null : this.response.orElse(null);
        }

        public E error() {
            return this.error == null ? null : this.error.orElse(null);
        }

        public boolean isQuery() {
            return this.queries != null;
        }

        public boolean isResponse() {
            return this.response != null;
        }

        public boolean isError() {
            return this.error != null;
        }
    }
}

