/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql;

import eu.clarussecure.dataoperations.DataOperationCommand;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlRowDescriptionMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.AuthenticationResponse;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.BindStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.DescribeStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.ExtendedQuery;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.ParseStep;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.Query;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.SQLCommandType;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.TransferMode;
import eu.clarussecure.proxy.spi.CString;
import eu.clarussecure.proxy.spi.Operation;
import io.netty.util.ReferenceCounted;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(SQLSession.class);
    private static final boolean FORCE_LEAK_DETECTION;
    private static final boolean CHECK_BUFFER_REFERENCE_COUNT;
    private String user;
    private String databaseName;
    private AuthenticationPhase authenticationPhase;
    private byte transactionStatus = (byte)73;
    private Map<Byte, CString> transactionErrorDetails;
    private boolean inDatasetCreation;
    private Operation currentCommandOperation;
    private List<DataOperationCommand> promise;
    private boolean resultProcessingEnabled = true;
    private boolean unprotectingDataEnabled = false;
    private Deque<List<Integer>> commandsInvolvedBackends;
    private List<Integer> queryInvolvedBackends;
    private List<ExpectedField> expectedFields;
    private boolean tableDefinitionEnabled;
    private Map<String, String> rowDescriptionFieldsToTrack;
    private TransferMode transferMode;
    private List<Query> bufferedQueries;
    private Map<Map.Entry<QueryResponseType, Integer>, QueryResponseStatus<?>> queryResponses;
    private SortedMap<Integer, List<PgsqlRowDescriptionMessage.Field>> backendRowDescriptions;
    private List<PgsqlRowDescriptionMessage.Field> rowDescription;
    private Map<Integer, List<Integer>> joinFieldIndexes;
    private Deque<QueryResponseType> queryResponsesToIgnore;
    private SortedMap<CString, ExtendedQueryStatus<ParseStep>> parseStepStatuses;
    private SortedMap<CString, ExtendedQueryStatus<BindStep>> bindStepStatuses;
    private SortedMap<CString, DescribeStepStatus> describeStepStatuses;
    private CString currentDescribeStepKey;
    private SortedMap<String, CursorContext> cursorContexts;
    private CountDownLatch responsesReceived = null;

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public AuthenticationPhase getAuthenticationPhase() {
        return this.authenticationPhase;
    }

    public void setAuthenticationPhase(AuthenticationPhase authenticationPhase) {
        if (this.authenticationPhase != null) {
            this.authenticationPhase.clear();
        }
        this.authenticationPhase = authenticationPhase;
    }

    public byte getTransactionStatus() {
        return this.transactionStatus;
    }

    public void setTransactionStatus(byte transactionStatus) {
        this.transactionStatus = transactionStatus;
    }

    public Map<Byte, CString> getTransactionErrorDetails() {
        return this.transactionErrorDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Byte, CString> getRetainedTransactionErrorDetails() {
        if (this.transactionErrorDetails != null) {
            Map<Byte, CString> map = this.transactionErrorDetails;
            synchronized (map) {
                for (CString fieldValue : this.transactionErrorDetails.values()) {
                    fieldValue.retain();
                }
            }
        }
        return this.transactionErrorDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactionErrorDetails(Map<Byte, CString> errorDetails) {
        if (errorDetails != null) {
            for (CString fieldValue : errorDetails.values()) {
                fieldValue.retain();
            }
        }
        if (this.transactionErrorDetails != null) {
            Map<Byte, CString> map = this.transactionErrorDetails;
            synchronized (map) {
                for (CString fieldValue : this.transactionErrorDetails.values()) {
                    fieldValue.release();
                }
            }
        }
        this.transactionErrorDetails = errorDetails;
    }

    public boolean isInDatasetCreation() {
        return this.inDatasetCreation;
    }

    public void setInDatasetCreation(boolean inDatasetCreation) {
        this.inDatasetCreation = inDatasetCreation;
    }

    public Operation getCurrentCommandOperation() {
        return this.currentCommandOperation;
    }

    public void setCurrentCommandOperation(Operation operation) {
        this.currentCommandOperation = operation;
    }

    public List<DataOperationCommand> getPromise() {
        return this.promise;
    }

    public void setPromise(List<DataOperationCommand> promise) {
        this.promise = promise;
    }

    public TransferMode getTransferMode() {
        return this.transferMode;
    }

    public void setTransferMode(TransferMode transferMode) {
        this.transferMode = transferMode;
    }

    public boolean isResultProcessingEnabled() {
        return this.resultProcessingEnabled;
    }

    public void setResultProcessingEnabled(boolean resultProcessingEnabled) {
        this.resultProcessingEnabled = resultProcessingEnabled;
    }

    public boolean isUnprotectingDataEnabled() {
        return this.unprotectingDataEnabled;
    }

    public void setUnprotectingDataEnabled(boolean unprotectingDataEnabled) {
        this.unprotectingDataEnabled = unprotectingDataEnabled;
    }

    public synchronized List<Integer> getCommandInvolvedBackends() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getting first of commands involved backends: {}", this.commandsInvolvedBackends);
        }
        return this.commandsInvolvedBackends != null ? this.commandsInvolvedBackends.peek() : null;
    }

    public synchronized void setCommandInvolvedBackends(List<Integer> involvedBackends) {
        this.setCommandInvolvedBackends(involvedBackends, true);
    }

    public synchronized void setCommandInvolvedBackends(List<Integer> involvedBackends, boolean overwrite) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("setting {} command involved backends (overwite={})", involvedBackends, (Object)overwrite);
        }
        if (involvedBackends == null) {
            if (this.commandsInvolvedBackends != null) {
                this.commandsInvolvedBackends.poll();
                if (this.commandsInvolvedBackends.size() == 0) {
                    this.commandsInvolvedBackends = null;
                }
            }
        } else {
            if (overwrite && this.commandsInvolvedBackends != null) {
                this.commandsInvolvedBackends.pollLast();
            }
            if (this.commandsInvolvedBackends == null) {
                this.commandsInvolvedBackends = new ConcurrentLinkedDeque<List<Integer>>();
            }
            this.commandsInvolvedBackends.add(involvedBackends);
            this.queryInvolvedBackends = this.commandsInvolvedBackends.peek();
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("after setting commands involved backends: {}", this.commandsInvolvedBackends);
            LOGGER.trace("and query involved backends: {}", this.queryInvolvedBackends);
        }
    }

    public synchronized List<Integer> getQueryInvolvedBackends() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getting query involved backends: {}", this.queryInvolvedBackends);
        }
        return this.queryInvolvedBackends;
    }

    public synchronized void setQueryInvolvedBackends(List<Integer> involvedBackends) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("setting {} query involved backends", involvedBackends);
        }
        this.queryInvolvedBackends = involvedBackends == null && this.commandsInvolvedBackends != null ? this.commandsInvolvedBackends.peek() : involvedBackends;
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("after setting query involved backends: {}", this.queryInvolvedBackends);
        }
    }

    public List<ExpectedField> getExpectedFields() {
        return this.expectedFields;
    }

    public void setExpectedFields(List<ExpectedField> expectedFields) {
        this.expectedFields = expectedFields;
    }

    public void setTableDefinitionEnabled(boolean tableDefinitionEnabled) {
        this.tableDefinitionEnabled = tableDefinitionEnabled;
        if (!tableDefinitionEnabled) {
            this.resetRowDescriptionFieldsToTrack();
        }
    }

    public boolean isTableDefinitionEnabled() {
        return this.tableDefinitionEnabled;
    }

    public Map<String, String> getRowDescriptionFieldsToTrack() {
        if (this.rowDescriptionFieldsToTrack == null) {
            this.rowDescriptionFieldsToTrack = Collections.synchronizedMap(new HashMap());
        }
        return this.rowDescriptionFieldsToTrack;
    }

    public void addRowDescriptionFieldToTrack(String fieldName, String columnName) {
        this.getRowDescriptionFieldsToTrack().put(fieldName, columnName);
    }

    public void resetRowDescriptionFieldsToTrack() {
        if (this.rowDescriptionFieldsToTrack != null) {
            this.rowDescriptionFieldsToTrack.clear();
        }
    }

    public List<Query> getBufferedQueries() {
        if (this.bufferedQueries == null) {
            this.bufferedQueries = Collections.synchronizedList(new ArrayList());
        }
        return this.bufferedQueries;
    }

    public void setBufferedQueries(List<Query> bufferedQueries) {
        this.bufferedQueries = bufferedQueries;
    }

    public int addBufferedQuery(Query query) {
        query.retain();
        this.getBufferedQueries().add(query);
        return this.getBufferedQueries().size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBufferedQueries() {
        if (this.bufferedQueries != null) {
            List<Query> list = this.bufferedQueries;
            synchronized (list) {
                for (Query bufferedQuery : this.bufferedQueries) {
                    bufferedQuery.release();
                }
                this.bufferedQueries.clear();
            }
        }
    }

    public synchronized Map<Map.Entry<QueryResponseType, Integer>, QueryResponseStatus<?>> getQueryResponses() {
        if (this.queryResponses == null) {
            this.queryResponses = new ConcurrentHashMap();
        }
        return this.queryResponses;
    }

    public void resetQueryResponses() {
        if (this.queryResponses != null) {
            for (QueryResponseStatus<?> queryResponse : this.queryResponses.values()) {
                queryResponse.clear();
            }
            this.queryResponses.clear();
        }
    }

    public <T> SortedMap<Integer, T> newQueryResponse(QueryResponseType type, int backend, int nbBackends, T details) {
        if (type == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("type cannot be null");
            }
            throw new NullPointerException("type cannot be null");
        }
        if (nbBackends <= 0) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("nbBackends ({}) must be positive", (Object)nbBackends);
            }
            throw new IllegalArgumentException(String.format("nbBackends (%d) must be positive", nbBackends));
        }
        if (backend < 0) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("backend ({}) must be positive or zero", (Object)backend);
            }
            throw new IllegalArgumentException(String.format("backend (%d) must be positive or zero", backend));
        }
        AbstractMap.SimpleEntry<QueryResponseType, Integer> key = new AbstractMap.SimpleEntry<QueryResponseType, Integer>(type, nbBackends);
        QueryResponseStatus queryResponses = this.getQueryResponses().computeIfAbsent(key, nil -> new QueryResponseStatus(type, nbBackends));
        return queryResponses.addAndRemove(backend, details);
    }

    public <T> SortedMap<Integer, T> newQueryResponse(QueryResponseType type, int backend, int nbBackends, T details, Map<Integer, List<Integer>> detailsIndexesPerBackend) {
        if (type == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("type cannot be null");
            }
            throw new NullPointerException("type cannot be null");
        }
        if (nbBackends <= 0) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("nbBackends ({}) must be positive", (Object)nbBackends);
            }
            throw new IllegalArgumentException(String.format("nbBackends (%d) must be positive", nbBackends));
        }
        if (backend < 0) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("backend ({}) must be positive or zero", (Object)backend);
            }
            throw new IllegalArgumentException(String.format("backend (%d) must be positive or zero", backend));
        }
        AbstractMap.SimpleEntry<QueryResponseType, Integer> key = new AbstractMap.SimpleEntry<QueryResponseType, Integer>(type, nbBackends);
        QueryResponseStatus queryResponses = this.getQueryResponses().computeIfAbsent(key, nil -> new QueryResponseStatus(type, nbBackends));
        return queryResponses.addAndRemove(backend, details, detailsIndexesPerBackend);
    }

    public <T> SortedMap<Integer, T> nextQueryResponses(QueryResponseType type) {
        if (type == null) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("type cannot be null");
            }
            throw new NullPointerException("type cannot be null");
        }
        List candidates = this.getQueryResponses().entrySet().stream().filter(e -> ((Map.Entry)e.getKey()).getKey() == type).map(Map.Entry::getValue).collect(Collectors.toList());
        for (QueryResponseStatus candidate : candidates) {
            QueryResponseStatus queryResponses = candidate;
            SortedMap nextQueryResponses = queryResponses.remove();
            if (nextQueryResponses == null) continue;
            return nextQueryResponses;
        }
        return null;
    }

    public SortedMap<Integer, List<PgsqlRowDescriptionMessage.Field>> getBackendRowDescriptions() {
        return this.backendRowDescriptions;
    }

    public void setBackendRowDescriptions(SortedMap<Integer, List<PgsqlRowDescriptionMessage.Field>> backendRowDescriptions) {
        if (backendRowDescriptions != null) {
            for (List<PgsqlRowDescriptionMessage.Field> fields : backendRowDescriptions.values()) {
                for (PgsqlRowDescriptionMessage.Field field : fields) {
                    field.retain();
                }
            }
        }
        this.backendRowDescriptions = backendRowDescriptions;
    }

    public void resetBackendRowDescriptions() {
        SortedMap<Integer, List<PgsqlRowDescriptionMessage.Field>> backendRowDescriptions = this.backendRowDescriptions;
        this.backendRowDescriptions = null;
        if (backendRowDescriptions != null) {
            for (List<PgsqlRowDescriptionMessage.Field> fields : backendRowDescriptions.values()) {
                for (PgsqlRowDescriptionMessage.Field field : fields) {
                    field.release();
                }
            }
            if (FORCE_LEAK_DETECTION) {
                for (List<PgsqlRowDescriptionMessage.Field> fields : backendRowDescriptions.values()) {
                    for (PgsqlRowDescriptionMessage.Field field : fields) {
                        if (field.refCnt() <= 0 || this.rowDescription == null || this.rowDescription.contains(field)) continue;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (field.refCnt() <= 0) continue;
                        LOGGER.trace("potential memory leak ({} refs) detected for {}", (Object)field.refCnt(), (Object)field);
                    }
                }
            }
        }
    }

    public Map<Integer, List<Integer>> getJoinFieldIndexes() {
        return this.joinFieldIndexes;
    }

    public void setJoinFieldIndexes(Map<Integer, List<Integer>> joinFieldIndexes) {
        this.joinFieldIndexes = joinFieldIndexes;
    }

    public List<PgsqlRowDescriptionMessage.Field> getRowDescription() {
        return this.rowDescription;
    }

    public void setRowDescription(List<PgsqlRowDescriptionMessage.Field> rowDescription) {
        if (rowDescription != null) {
            for (PgsqlRowDescriptionMessage.Field field : rowDescription) {
                field.retain();
            }
        }
        this.rowDescription = rowDescription;
    }

    public void resetRowDescription() {
        List<PgsqlRowDescriptionMessage.Field> rowDescription = this.rowDescription;
        this.rowDescription = null;
        if (rowDescription != null) {
            for (PgsqlRowDescriptionMessage.Field field : rowDescription) {
                field.release();
            }
            if (FORCE_LEAK_DETECTION) {
                for (PgsqlRowDescriptionMessage.Field field : rowDescription) {
                    if (field.refCnt() <= 0) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (field.refCnt() <= 0) continue;
                    LOGGER.trace("potential memory leak ({} refs) detected for {}", (Object)field.refCnt(), (Object)field);
                }
            }
        }
    }

    public Deque<QueryResponseType> getQueryResponsesToIgnore() {
        if (this.queryResponsesToIgnore == null) {
            this.queryResponsesToIgnore = new ConcurrentLinkedDeque<QueryResponseType>();
        }
        return this.queryResponsesToIgnore;
    }

    public void resetQueryResponsesToIgnore() {
        if (this.queryResponsesToIgnore != null) {
            this.queryResponsesToIgnore.clear();
        }
    }

    public void addFirstQueryResponseToIgnore(QueryResponseType queryResponseType) {
        this.getQueryResponsesToIgnore().addFirst(queryResponseType);
    }

    public void addLastQueryResponseToIgnore(QueryResponseType queryResponseType) {
        this.getQueryResponsesToIgnore().addLast(queryResponseType);
    }

    public QueryResponseType firstQueryResponseToIgnore() {
        return this.getQueryResponsesToIgnore().peekFirst();
    }

    public QueryResponseType lastQueryResponseToIgnore() {
        return this.getQueryResponsesToIgnore().peekLast();
    }

    public QueryResponseType removeFirstQueryResponseToIgnore() {
        return this.getQueryResponsesToIgnore().pollFirst();
    }

    public QueryResponseType removeLastQueryResponseToIgnore() {
        return this.getQueryResponsesToIgnore().pollLast();
    }

    public boolean isProcessingQuery() {
        return this.getCurrentCommandOperation() != null || !this.getBufferedQueries().isEmpty();
    }

    public SortedMap<CString, ExtendedQueryStatus<ParseStep>> getParseStepStatuses() {
        if (this.parseStepStatuses == null) {
            this.parseStepStatuses = Collections.synchronizedSortedMap(new TreeMap());
        }
        return this.parseStepStatuses;
    }

    public void setParseStepStatuses(SortedMap<CString, ExtendedQueryStatus<ParseStep>> parseStepStatuses) {
        this.parseStepStatuses = parseStepStatuses;
    }

    public ExtendedQueryStatus<ParseStep> addParseStep(ParseStep parseStep, Operation operation, SQLCommandType type, boolean toProcess, List<Integer> involvedBackends) {
        ExtendedQueryStatus<ParseStep> parseStepStatus = new ExtendedQueryStatus<ParseStep>(parseStep, operation, type, toProcess, involvedBackends);
        parseStepStatus.retain();
        ExtendedQueryStatus<ParseStep> previousParseStepStatus = this.getParseStepStatuses().put(parseStep.getName(), parseStepStatus);
        if (previousParseStepStatus != null) {
            previousParseStepStatus.release();
        }
        return parseStepStatus;
    }

    public void removeParseStep(CString name) {
        this.removeDescribeStep((byte)83, name);
        this.getBindStepStatuses().values().stream().map(ExtendedQueryStatus::getQuery).filter(q -> name.equals((Object)q.getPreparedStatement())).forEach(q -> this.removeBindStep(q.getName()));
        ExtendedQueryStatus parseStepStatus = (ExtendedQueryStatus)this.getParseStepStatuses().remove(name);
        if (parseStepStatus != null) {
            parseStepStatus.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetParseSteps() {
        if (this.parseStepStatuses != null) {
            SortedMap<CString, ExtendedQueryStatus<ParseStep>> sortedMap = this.parseStepStatuses;
            synchronized (sortedMap) {
                for (ExtendedQueryStatus<ParseStep> parseStepStatus : this.parseStepStatuses.values()) {
                    parseStepStatus.getQuery().release();
                }
                this.parseStepStatuses.clear();
            }
        }
    }

    public ExtendedQueryStatus<ParseStep> getParseStepStatus(CString name) {
        return (ExtendedQueryStatus)this.getParseStepStatuses().get(name);
    }

    public ExtendedQueryStatus<ParseStep> getLastParseStepStatus() {
        CString name = this.getParseStepStatuses().lastKey();
        return name != null ? (ExtendedQueryStatus)this.getParseStepStatuses().get(name) : null;
    }

    public SortedMap<CString, ExtendedQueryStatus<BindStep>> getBindStepStatuses() {
        if (this.bindStepStatuses == null) {
            this.bindStepStatuses = Collections.synchronizedSortedMap(new TreeMap());
        }
        return this.bindStepStatuses;
    }

    public void setBindStepStatuses(SortedMap<CString, ExtendedQueryStatus<BindStep>> bindStepStatuses) {
        this.bindStepStatuses = bindStepStatuses;
    }

    public ExtendedQueryStatus<BindStep> addBindStep(BindStep bindStep, Operation operation, SQLCommandType type, boolean toProcess, List<Integer> involvedBackends) {
        ExtendedQueryStatus<BindStep> bindStepStatus = new ExtendedQueryStatus<BindStep>(bindStep, operation, type, toProcess, involvedBackends);
        bindStepStatus.retain();
        ExtendedQueryStatus<BindStep> previousBindStepStatus = this.getBindStepStatuses().put(bindStep.getName(), bindStepStatus);
        if (previousBindStepStatus != null) {
            previousBindStepStatus.release();
        }
        return bindStepStatus;
    }

    public void removeBindStep(CString name) {
        this.removeDescribeStep((byte)80, name);
        ExtendedQueryStatus previousBindStepStatus = (ExtendedQueryStatus)this.getBindStepStatuses().remove(name);
        if (previousBindStepStatus != null) {
            previousBindStepStatus.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetBindSteps() {
        if (this.bindStepStatuses != null) {
            SortedMap<CString, ExtendedQueryStatus<BindStep>> sortedMap = this.bindStepStatuses;
            synchronized (sortedMap) {
                for (ExtendedQueryStatus<BindStep> bindStepStatus : this.bindStepStatuses.values()) {
                    bindStepStatus.release();
                }
                this.bindStepStatuses.clear();
            }
        }
    }

    public ExtendedQueryStatus<BindStep> getBindStepStatus(CString name) {
        return (ExtendedQueryStatus)this.getBindStepStatuses().get(name);
    }

    public ExtendedQueryStatus<BindStep> getLastBindStepStatus() {
        CString name = this.getBindStepStatuses().lastKey();
        return name != null ? (ExtendedQueryStatus)this.getBindStepStatuses().get(name) : null;
    }

    public SortedMap<CString, DescribeStepStatus> getDescribeStepStatuses() {
        if (this.describeStepStatuses == null) {
            this.describeStepStatuses = Collections.synchronizedSortedMap(new TreeMap());
        }
        return this.describeStepStatuses;
    }

    public void setDescribeStepStatuses(SortedMap<CString, DescribeStepStatus> describeStepStatuses) {
        this.describeStepStatuses = describeStepStatuses;
    }

    public DescribeStepStatus addDescribeStep(DescribeStep describeStep) {
        CString key = CString.valueOf((CharSequence)((char)describeStep.getCode() + ":")).append((CharSequence)describeStep.getName());
        DescribeStepStatus describeStepStatus = new DescribeStepStatus(describeStep, null, null);
        describeStepStatus.retain();
        DescribeStepStatus previousDescribeStepStatus = this.getDescribeStepStatuses().put(key, describeStepStatus);
        if (previousDescribeStepStatus != null) {
            previousDescribeStepStatus.release();
        }
        return describeStepStatus;
    }

    public void removeDescribeStep(byte code, CString name) {
        CString key = CString.valueOf((CharSequence)((char)code + ":")).append((CharSequence)name);
        DescribeStepStatus previousDescribeStepStatus = (DescribeStepStatus)this.getDescribeStepStatuses().remove(key);
        if (previousDescribeStepStatus != null) {
            previousDescribeStepStatus.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetDescribeSteps() {
        if (this.describeStepStatuses != null) {
            SortedMap<CString, DescribeStepStatus> sortedMap = this.describeStepStatuses;
            synchronized (sortedMap) {
                for (DescribeStepStatus describeStepStatus : this.describeStepStatuses.values()) {
                    describeStepStatus.release();
                }
                this.describeStepStatuses.clear();
            }
        }
    }

    public DescribeStepStatus getDescribeStepStatus(byte code, CString name) {
        CString key = CString.valueOf((CharSequence)((char)code + ":")).append((CharSequence)name);
        return (DescribeStepStatus)this.getDescribeStepStatuses().get(key);
    }

    public DescribeStepStatus getCurrentDescribeStepStatus() {
        if (this.currentDescribeStepKey != null) {
            return (DescribeStepStatus)this.getDescribeStepStatuses().get(this.currentDescribeStepKey);
        }
        return null;
    }

    public void setCurrentDescribeStepStatus(DescribeStepStatus describeStepStatus) {
        this.currentDescribeStepKey = describeStepStatus != null ? CString.valueOf((CharSequence)((char)((DescribeStep)describeStepStatus.getQuery()).getCode() + ":")).append((CharSequence)((DescribeStep)describeStepStatus.getQuery()).getName()) : null;
    }

    public SortedMap<String, CursorContext> getCursorContexts() {
        if (this.cursorContexts == null) {
            this.cursorContexts = Collections.synchronizedSortedMap(new TreeMap());
        }
        return this.cursorContexts;
    }

    public void setCursorContexts(SortedMap<String, CursorContext> cursorContexts) {
        this.cursorContexts = cursorContexts;
    }

    public CursorContext saveCursorContext(String name) {
        CursorContext cursorContext = new CursorContext(name, this.getPromise(), this.isResultProcessingEnabled(), this.isUnprotectingDataEnabled(), this.getCommandInvolvedBackends(), this.getExpectedFields());
        this.getCursorContexts().put(name, cursorContext);
        return cursorContext;
    }

    public void removeCursorContext(String name) {
        this.getCursorContexts().remove(name);
    }

    public CursorContext getCursorContext(String name) {
        return (CursorContext)this.getCursorContexts().get(name);
    }

    public void restoreCursorContext(String name) {
        CursorContext cursorStatus = this.getCursorContext(name);
        if (cursorStatus != null) {
            this.setPromise(cursorStatus.getPromise());
            this.setResultProcessingEnabled(cursorStatus.isResultProcessingEnabled());
            this.setUnprotectingDataEnabled(cursorStatus.isUnprotectingDataEnabled());
            this.setCommandInvolvedBackends(cursorStatus.getInvolvedBackends());
            this.setExpectedFields(cursorStatus.getExpectedFields());
            this.setCurrentCommandOperation(Operation.READ);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetCursorContexts() {
        if (this.cursorContexts != null) {
            SortedMap<String, CursorContext> sortedMap = this.cursorContexts;
            synchronized (sortedMap) {
                this.cursorContexts.clear();
            }
        }
    }

    public void resetCurrentCommand() {
        this.setCurrentCommandOperation(null);
        this.setPromise(null);
        this.setResultProcessingEnabled(false);
        this.setExpectedFields(null);
        this.resetBackendRowDescriptions();
        this.setJoinFieldIndexes(null);
        this.resetRowDescription();
        this.setCurrentDescribeStepStatus(null);
        this.setCommandInvolvedBackends(null);
    }

    public void resetCurrentQuery() {
        this.setQueryInvolvedBackends(null);
        this.resetQueryResponses();
    }

    public void resetCurrentQueries() {
        this.resetCurrentQuery();
        this.resetBufferedQueries();
        this.resetQueryResponsesToIgnore();
    }

    public void reset() {
        this.setUser(null);
        this.setDatabaseName(null);
        this.setAuthenticationPhase(null);
        this.setTransactionStatus((byte)73);
        this.setInDatasetCreation(false);
        this.setTransferMode(null);
        this.setTableDefinitionEnabled(false);
        this.resetCurrentCommand();
        this.resetCurrentQueries();
        this.resetCursorContexts();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForResponses() throws InterruptedException {
        SQLSession sQLSession;
        if (this.responsesReceived == null || this.responsesReceived.getCount() == 0L) {
            sQLSession = this;
            synchronized (sQLSession) {
                if (this.responsesReceived == null || this.responsesReceived.getCount() == 0L) {
                    this.responsesReceived = new CountDownLatch(1);
                }
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("waiting for responses");
        }
        this.responsesReceived.await();
        sQLSession = this;
        synchronized (sQLSession) {
            if (this.responsesReceived != null && this.responsesReceived.getCount() == 0L) {
                this.responsesReceived = null;
            }
        }
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("responses have been received");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responsesReceived() {
        CountDownLatch responsesReceived;
        SQLSession sQLSession = this;
        synchronized (sQLSession) {
            responsesReceived = this.responsesReceived;
        }
        if (responsesReceived != null && responsesReceived.getCount() == 1L) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("notifying responses have been received");
            }
            responsesReceived.countDown();
        }
    }

    static {
        String leakDetectionLevel = System.getProperty("io.netty.leakDetectionLevel", "SIMPLE");
        FORCE_LEAK_DETECTION = "PARANOID".equalsIgnoreCase(leakDetectionLevel);
        String bufferCheckReferenceCount = System.getProperty("buffer.check.reference.count", "false");
        CHECK_BUFFER_REFERENCE_COUNT = Boolean.TRUE.toString().equalsIgnoreCase(bufferCheckReferenceCount) || "1".equalsIgnoreCase(bufferCheckReferenceCount) || "yes".equalsIgnoreCase(bufferCheckReferenceCount) || "on".equalsIgnoreCase(bufferCheckReferenceCount);
    }

    public static class CursorContext {
        private final String name;
        private final List<DataOperationCommand> promise;
        private final boolean resultProcessingEnabled;
        private final boolean unprotectingDataEnabled;
        private final List<Integer> involvedBackends;
        private final List<ExpectedField> expectedFields;

        public CursorContext(String name, List<DataOperationCommand> promise, boolean resultProcessingEnabled, boolean unprotectingDataEnabled, List<Integer> involvedBackends, List<ExpectedField> expectedFields) {
            this.name = name;
            this.promise = promise;
            this.resultProcessingEnabled = resultProcessingEnabled;
            this.unprotectingDataEnabled = unprotectingDataEnabled;
            this.involvedBackends = involvedBackends;
            this.expectedFields = expectedFields;
        }

        public String getName() {
            return this.name;
        }

        public List<DataOperationCommand> getPromise() {
            return this.promise;
        }

        public boolean isResultProcessingEnabled() {
            return this.resultProcessingEnabled;
        }

        public boolean isUnprotectingDataEnabled() {
            return this.unprotectingDataEnabled;
        }

        public List<Integer> getInvolvedBackends() {
            return this.involvedBackends;
        }

        public List<ExpectedField> getExpectedFields() {
            return this.expectedFields;
        }
    }

    public static class QueryResponseStatus<T> {
        private final QueryResponseType type;
        private final Map<Integer, Queue<T>> detailsPerBackend;
        private final int nbBackends;

        public QueryResponseStatus(QueryResponseType type, int nbBackends) {
            this.type = type;
            this.detailsPerBackend = new ConcurrentHashMap<Integer, Queue<T>>(nbBackends);
            this.nbBackends = nbBackends;
        }

        private Queue<T> getDetails(int backend) {
            return this.detailsPerBackend.computeIfAbsent(backend, nil -> new LinkedList());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized SortedMap<Integer, T> addAndRemove(int backend, T details) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("adding {} response {} for backend {}/{}", new Object[]{this.type, System.identityHashCode(details), backend + 1, this.nbBackends});
            }
            this.retain(details);
            QueryResponseStatus queryResponseStatus = this;
            synchronized (queryResponseStatus) {
                this.getDetails(backend).add(details);
                return this.remove();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized SortedMap<Integer, T> addAndRemove(int backend, T details, Map<Integer, List<Integer>> detailIndexesPerBackend) {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("adding {} response {} for backend {}/{}", new Object[]{this.type, System.identityHashCode(details), backend + 1, this.nbBackends});
            }
            this.retain(details);
            QueryResponseStatus queryResponseStatus = this;
            synchronized (queryResponseStatus) {
                this.getDetails(backend).add(details);
                return this.remove(detailIndexesPerBackend);
            }
        }

        public synchronized void clear() {
            for (Map.Entry<Integer, Queue<T>> entry : this.detailsPerBackend.entrySet()) {
                Queue<T> backendDetails = entry.getValue();
                if (backendDetails.size() > 0) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("strange: {} remaining {} responses of backend {}/{} are to be ignored", new Object[]{backendDetails.size(), this.type, entry.getKey() + 1, this.nbBackends});
                    }
                } else if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("{} remaining {} responses of backend {}/{} are to be ignored", new Object[]{backendDetails.size(), this.type, entry.getKey() + 1, this.nbBackends});
                }
                for (Object details : backendDetails) {
                    this.release(details);
                }
            }
            this.detailsPerBackend.clear();
        }

        public synchronized SortedMap<Integer, T> remove() {
            if (!this.available()) {
                return null;
            }
            boolean allEmpty = true;
            TreeMap<Integer, T> firstDetailsPerBackend = new TreeMap<Integer, T>();
            for (Map.Entry<Integer, Queue<T>> entry : this.detailsPerBackend.entrySet()) {
                Integer backend = entry.getKey();
                Queue<T> backendDetails = entry.getValue();
                T details = backendDetails.remove();
                allEmpty &= backendDetails.isEmpty();
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("removing {} response {} of backend {}/{}", new Object[]{this.type, System.identityHashCode(details), backend + 1, this.nbBackends});
                }
                firstDetailsPerBackend.put(backend, details);
            }
            if (allEmpty) {
                this.detailsPerBackend.clear();
            }
            return firstDetailsPerBackend;
        }

        private SortedMap<Integer, T> remove(Map<Integer, List<Integer>> detailIndexesPerBackend) {
            int b;
            if (this.nbBackends == 1 || detailIndexesPerBackend == null) {
                return this.remove();
            }
            if (!this.available()) {
                return null;
            }
            List backendDetails = this.detailsPerBackend.entrySet().stream().sorted(Map.Entry.comparingByKey()).map(Map.Entry::getValue).collect(Collectors.toList());
            int matchingBackends = 0;
            Iterator[] iters = new Iterator[this.nbBackends];
            Object[] backendsDetails = new Object[this.nbBackends];
            List backends = detailIndexesPerBackend.keySet().stream().sorted().collect(Collectors.toList());
            iters[0] = ((Queue)backendDetails.get(0)).iterator();
            while (iters[0].hasNext()) {
                List<Object> details1Item;
                backendsDetails[0] = iters[0].next();
                if (backendsDetails[0] instanceof List) {
                    int backend = (Integer)backends.get(0);
                    List backendDetails2 = (List)backendsDetails[backend];
                    List<Integer> backendDetailIndexes = detailIndexesPerBackend.get(backend);
                    details1Item = backendDetailIndexes.stream().map(i -> backendDetails2.get((int)i)).collect(Collectors.toList());
                } else {
                    details1Item = Collections.singletonList(backendsDetails[0]);
                }
                ++matchingBackends;
                for (b = 1; b < this.nbBackends; ++b) {
                    iters[b] = ((Queue)backendDetails.get(b)).iterator();
                    while (iters[b].hasNext()) {
                        List<Object> details2Item;
                        backendsDetails[b] = iters[b].next();
                        if (backendsDetails[b] instanceof List) {
                            int backend = (Integer)backends.get(b);
                            List backendDetails2 = (List)backendsDetails[backend];
                            List<Integer> backendDetailIndexes = detailIndexesPerBackend.get(backend);
                            details2Item = backendDetailIndexes.stream().map(i -> backendDetails2.get((int)i)).collect(Collectors.toList());
                        } else {
                            details2Item = Collections.singletonList(backendsDetails[b]);
                        }
                        if (details1Item != details2Item && (details1Item == null || !details1Item.equals(details2Item))) continue;
                        ++matchingBackends;
                        break;
                    }
                    if (matchingBackends < b + 1) break;
                }
                if (matchingBackends == this.nbBackends) break;
                matchingBackends = 0;
            }
            if (matchingBackends == 0) {
                return null;
            }
            TreeMap<Integer, Object> matchingDetailsPerBackend = new TreeMap<Integer, Object>();
            for (b = 0; b < this.nbBackends; ++b) {
                matchingDetailsPerBackend.put(b, backendsDetails[b]);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("removing {} response {} of backend {}/{}", new Object[]{this.type, System.identityHashCode(backendsDetails[b]), b + 1, this.nbBackends});
                }
                iters[b].remove();
            }
            boolean allEmpty = this.detailsPerBackend.values().stream().allMatch(q -> q.isEmpty());
            if (allEmpty) {
                this.detailsPerBackend.clear();
            }
            return matchingDetailsPerBackend;
        }

        private boolean available() {
            boolean available;
            boolean bl = available = this.detailsPerBackend.size() == this.nbBackends;
            if (available) {
                for (Queue<T> backendDetails : this.detailsPerBackend.values()) {
                    available &= backendDetails != null && !backendDetails.isEmpty();
                }
            }
            return available;
        }

        private void retain(T details) {
            block8: {
                block9: {
                    block7: {
                        if (!(details instanceof ReferenceCounted)) break block7;
                        if (CHECK_BUFFER_REFERENCE_COUNT && LOGGER.isTraceEnabled()) {
                            LOGGER.trace("retaining {} ({}), refcount={}", new Object[]{details, System.identityHashCode(details), ((ReferenceCounted)details).refCnt()});
                        }
                        ((ReferenceCounted)details).retain();
                        break block8;
                    }
                    if (!(details instanceof Collection)) break block9;
                    for (Object responseDetail : (Collection)details) {
                        if (!(responseDetail instanceof ReferenceCounted)) continue;
                        if (CHECK_BUFFER_REFERENCE_COUNT && LOGGER.isTraceEnabled()) {
                            LOGGER.trace("retaining {} ({}), refcount={}", new Object[]{responseDetail, System.identityHashCode(responseDetail), ((ReferenceCounted)responseDetail).refCnt()});
                        }
                        ((ReferenceCounted)responseDetail).retain();
                    }
                    break block8;
                }
                if (!(details instanceof Map)) break block8;
                for (Map.Entry entry : ((Map)details).entrySet()) {
                    Object value;
                    Object key = entry.getKey();
                    if (key instanceof ReferenceCounted) {
                        if (CHECK_BUFFER_REFERENCE_COUNT && LOGGER.isTraceEnabled()) {
                            LOGGER.trace("retaining {} ({}), refcount={}", new Object[]{key, System.identityHashCode(key), ((ReferenceCounted)key).refCnt()});
                        }
                        ((ReferenceCounted)key).retain();
                    }
                    if (!((value = entry.getValue()) instanceof ReferenceCounted)) continue;
                    if (CHECK_BUFFER_REFERENCE_COUNT && LOGGER.isTraceEnabled()) {
                        LOGGER.trace("retaining {} ({}), refcount={}", new Object[]{value, System.identityHashCode(value), ((ReferenceCounted)value).refCnt()});
                    }
                    ((ReferenceCounted)value).retain();
                }
            }
        }

        private void release(T details) {
            block8: {
                block9: {
                    block7: {
                        if (!(details instanceof ReferenceCounted)) break block7;
                        if (CHECK_BUFFER_REFERENCE_COUNT && LOGGER.isTraceEnabled()) {
                            LOGGER.trace("releasing {} ({}), refcount={}", new Object[]{details, System.identityHashCode(details), ((ReferenceCounted)details).refCnt()});
                        }
                        ((ReferenceCounted)details).release();
                        break block8;
                    }
                    if (!(details instanceof Collection)) break block9;
                    for (Object responseDetail : (Collection)details) {
                        if (!(responseDetail instanceof ReferenceCounted)) continue;
                        if (CHECK_BUFFER_REFERENCE_COUNT && LOGGER.isTraceEnabled()) {
                            LOGGER.trace("releasing {} ({}), refcount={}", new Object[]{responseDetail, System.identityHashCode(responseDetail), ((ReferenceCounted)responseDetail).refCnt()});
                        }
                        ((ReferenceCounted)responseDetail).release();
                    }
                    break block8;
                }
                if (!(details instanceof Map)) break block8;
                for (Map.Entry entry : ((Map)details).entrySet()) {
                    Object value;
                    Object key = entry.getKey();
                    if (key instanceof ReferenceCounted) {
                        if (CHECK_BUFFER_REFERENCE_COUNT && LOGGER.isTraceEnabled()) {
                            LOGGER.trace("releasing {} ({}), refcount={}", new Object[]{key, System.identityHashCode(key), ((ReferenceCounted)key).refCnt()});
                        }
                        ((ReferenceCounted)key).release();
                    }
                    if (!((value = entry.getValue()) instanceof ReferenceCounted)) continue;
                    if (CHECK_BUFFER_REFERENCE_COUNT && LOGGER.isTraceEnabled()) {
                        LOGGER.trace("releasing {} ({}), refcount={}", new Object[]{value, System.identityHashCode(value), ((ReferenceCounted)value).refCnt()});
                    }
                    ((ReferenceCounted)value).release();
                }
            }
        }
    }

    public static enum QueryResponseType {
        PARSE_COMPLETE,
        BIND_COMPLETE,
        PARAMETER_DESCRIPTION,
        ROW_DESCRIPTION,
        DATA_ROW,
        NO_DATA,
        ROW_DESCRIPTION_AND_DATA_ROW_OR_NO_DATA,
        COMMAND_COMPLETE,
        EMPTY_QUERY,
        PORTAL_SUSPENDED,
        ERROR,
        COMMAND_COMPLETE_OR_EMPTY_QUERY_OR_PORTAL_SUSPENDED_OR_ERROR,
        CLOSE_COMPLETE,
        READY_FOR_QUERY;

    }

    public static class DescribeStepStatus
    extends ExtendedQueryStatus<DescribeStep> {
        private List<ExpectedField> expectedFields;
        private SortedMap<Integer, List<PgsqlRowDescriptionMessage.Field>> backendRowDescriptions;
        private List<PgsqlRowDescriptionMessage.Field> rowDescription;

        public DescribeStepStatus(DescribeStep describeStep, Operation operation, SQLCommandType type) {
            super(describeStep, operation, type);
        }

        public DescribeStepStatus(DescribeStep describeStep, Operation operation, SQLCommandType type, boolean toProcess, List<Integer> involvedBackends) {
            super(describeStep, operation, type, toProcess, involvedBackends);
        }

        public List<ExpectedField> getExpectedFields() {
            return this.expectedFields;
        }

        public void setExpectedFields(List<ExpectedField> expectedFields) {
            this.expectedFields = expectedFields;
        }

        public SortedMap<Integer, List<PgsqlRowDescriptionMessage.Field>> getBackendRowDescriptions() {
            return this.backendRowDescriptions;
        }

        public void setBackendRowDescriptions(SortedMap<Integer, List<PgsqlRowDescriptionMessage.Field>> backendRowDescriptions) {
            if (backendRowDescriptions != null) {
                for (List<PgsqlRowDescriptionMessage.Field> fields : backendRowDescriptions.values()) {
                    for (PgsqlRowDescriptionMessage.Field field : fields) {
                        field.getName().toString();
                    }
                }
            }
            this.backendRowDescriptions = backendRowDescriptions;
        }

        public List<PgsqlRowDescriptionMessage.Field> getRowDescription() {
            return this.rowDescription;
        }

        public void setRowDescription(List<PgsqlRowDescriptionMessage.Field> rowDescription) {
            if (rowDescription != null) {
                for (PgsqlRowDescriptionMessage.Field field : rowDescription) {
                    field.getName().toString();
                }
            }
            this.rowDescription = rowDescription;
        }
    }

    public static class ExtendedQueryStatus<Q extends ExtendedQuery> {
        private final Q query;
        private final Operation operation;
        private final SQLCommandType type;
        private final boolean toProcess;
        private boolean processed;
        private List<Integer> involvedBackends;

        public ExtendedQueryStatus(Q query, Operation operation, SQLCommandType type) {
            this(query, operation, type, false, Collections.singletonList(0));
        }

        public ExtendedQueryStatus(Q query, Operation operation, SQLCommandType type, boolean toProcess, List<Integer> involvedBackends) {
            this.query = query;
            this.operation = operation;
            this.type = type;
            this.toProcess = toProcess;
            this.processed = false;
            this.involvedBackends = involvedBackends;
        }

        public Q getQuery() {
            return this.query;
        }

        public Operation getOperation() {
            return this.operation;
        }

        public SQLCommandType getType() {
            return this.type;
        }

        public boolean isToProcess() {
            return this.toProcess;
        }

        public boolean isProcessed() {
            return this.processed;
        }

        public void setProcessed(boolean processed) {
            this.processed = processed;
        }

        public List<Integer> getInvolvedBackends() {
            return this.involvedBackends;
        }

        public void setInvolvedBackends(List<Integer> involvedBackends) {
            this.involvedBackends = involvedBackends;
        }

        public void retain() {
            this.query.retain();
        }

        public boolean release() {
            return this.query.release();
        }
    }

    public static class ExpectedField
    extends AbsractExpectedField {
        private Map<Integer, List<ExpectedProtectedField>> protectedFields;

        public ExpectedField(String name) {
            this(name, null, new HashMap<Integer, List<ExpectedProtectedField>>());
        }

        public ExpectedField(String name, List<String> attributeNames, Map<Integer, List<ExpectedProtectedField>> protectedFields) {
            super(name, attributeNames);
            this.protectedFields = protectedFields;
        }

        public ExpectedField(String name, int position, List<Map.Entry<String, Integer>> attributes, Map<Integer, List<ExpectedProtectedField>> protectedFields) {
            super(name, position, attributes);
            this.protectedFields = protectedFields;
        }

        public Map<Integer, List<ExpectedProtectedField>> getProtectedFields() {
            return this.protectedFields;
        }

        public void setProtectedFields(Map<Integer, List<ExpectedProtectedField>> protectedFields) {
            this.protectedFields = protectedFields;
        }

        public List<ExpectedProtectedField> getBackendProtectedFields(int backend) {
            return this.protectedFields.get(backend);
        }

        public void setBackendProtectedFields(int backend, List<ExpectedProtectedField> backendProtectedFields) {
            this.protectedFields.put(backend, backendProtectedFields);
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ExpectedField [name=");
            builder.append(this.name);
            builder.append(", position=");
            builder.append(this.position);
            builder.append(", attributes=");
            builder.append(this.attributes);
            builder.append(", protectedFields=");
            builder.append(this.protectedFields);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class ExpectedProtectedField
    extends AbsractExpectedField {
        private final int backend;
        private List<Map.Entry<String, Integer>> attributeMapping;

        public ExpectedProtectedField(int backend, String name) {
            super(name);
            this.backend = backend;
            this.attributeMapping = new ArrayList<Map.Entry<String, Integer>>();
        }

        public ExpectedProtectedField(int backend, String name, List<String> attributeNames, List<Map.Entry<String, Integer>> attributeMapping) {
            super(name, attributeNames);
            this.backend = backend;
            this.attributeMapping = attributeMapping;
        }

        public ExpectedProtectedField(int backend, String name, int position, List<Map.Entry<String, Integer>> attributes, List<Map.Entry<String, Integer>> attributeMapping) {
            super(name, position, attributes);
            this.backend = backend;
            this.attributeMapping = attributeMapping;
        }

        public int getBackend() {
            return this.backend;
        }

        public List<Map.Entry<String, Integer>> getAttributeMapping() {
            return this.attributeMapping;
        }

        public void setAttributeMapping(List<Map.Entry<String, Integer>> attributeMapping) {
            this.attributeMapping = attributeMapping;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("ExpectedProtectedField [backend=");
            builder.append(this.backend);
            builder.append(", name=");
            builder.append(this.name);
            builder.append(", position=");
            builder.append(this.position);
            builder.append(", attributes=");
            builder.append(this.attributes);
            builder.append(", attributeMapping=");
            builder.append(this.attributeMapping);
            builder.append("]");
            return builder.toString();
        }
    }

    public static abstract class AbsractExpectedField {
        protected String name;
        protected int position;
        protected List<Map.Entry<String, Integer>> attributes;

        public AbsractExpectedField(String name) {
            this(name, null);
        }

        public AbsractExpectedField(String name, List<String> attributeNames) {
            this(name, -1, new ArrayList<Map.Entry<String, Integer>>());
            if (attributeNames != null) {
                this.addAttributeNames(attributeNames);
            }
        }

        public AbsractExpectedField(String name, int position, List<Map.Entry<String, Integer>> attributes) {
            this.name = name;
            this.position = position;
            this.attributes = attributes;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public int getPosition() {
            return this.position;
        }

        public void setPosition(int position) {
            this.position = position;
        }

        public List<Map.Entry<String, Integer>> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(List<Map.Entry<String, Integer>> attributes) {
            this.attributes = attributes;
        }

        public void addAttributeNames(List<String> attributeNames) {
            this.attributes.addAll(attributeNames.stream().map(an -> new AbstractMap.SimpleEntry<String, Integer>((String)an, -1)).collect(Collectors.toList()));
        }
    }

    public static class AuthenticationPhase {
        private final List<AuthenticationResponse> authenticationResponses;
        private final AtomicInteger receivedAuthenticationResponses;

        public AuthenticationPhase(int nbBackends) {
            this.authenticationResponses = new ArrayList<Object>(Collections.nCopies(nbBackends, null));
            this.receivedAuthenticationResponses = new AtomicInteger(0);
        }

        public int getNbAuthenticationResponses() {
            return this.authenticationResponses.size();
        }

        public synchronized AuthenticationResponse getAuthenticationResponse(int serverEndpoint) {
            return this.authenticationResponses.get(serverEndpoint);
        }

        public synchronized boolean setAndCountAuthenticationResponse(int serverEndpoint, AuthenticationResponse authenticationResponse) {
            this.setAuthenticationResponse(serverEndpoint, authenticationResponse);
            return this.areAllAuthenticationResponsesReceived();
        }

        public synchronized AuthenticationResponse setAuthenticationResponse(int backend, AuthenticationResponse authenticationResponse) {
            AuthenticationResponse previousAuthenticationResponse = this.authenticationResponses.set(backend, authenticationResponse);
            if (previousAuthenticationResponse != null) {
                this.receivedAuthenticationResponses.decrementAndGet();
                if (previousAuthenticationResponse.getParameters() != null) {
                    previousAuthenticationResponse.getParameters().release();
                }
            }
            if (authenticationResponse != null) {
                this.receivedAuthenticationResponses.incrementAndGet();
                if (authenticationResponse.getParameters() != null) {
                    authenticationResponse.getParameters().retain();
                }
            }
            return previousAuthenticationResponse;
        }

        public synchronized void clear() {
            for (int i = 0; i < this.authenticationResponses.size(); ++i) {
                this.setAuthenticationResponse(i, null);
            }
        }

        public synchronized boolean areAllAuthenticationResponsesReceived() {
            return this.receivedAuthenticationResponses.get() == this.authenticationResponses.size();
        }

        public synchronized void waitForAllResponses() throws IOException {
            if (this.areAllAuthenticationResponsesReceived()) {
                return;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("waiting authentication responses ({})", (Object)System.identityHashCode(this));
            }
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("unexpected thread interruption", (Throwable)e);
                }
                throw new IOException(e);
            }
            if (!this.areAllAuthenticationResponsesReceived()) {
                if (LOGGER.isErrorEnabled()) {
                    LOGGER.error("unexpected: missing authentication responses");
                }
                throw new IllegalStateException("unexpected: missing authentication responses");
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("authentication responses have been received ({})", (Object)System.identityHashCode(this));
            }
        }

        public synchronized void allResponsesReceived() {
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("notifying authentication responses have been received ({})", (Object)System.identityHashCode(this));
            }
            this.notifyAll();
        }
    }
}

