/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.sql.data.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Types {
    private final Map<Long, Type> oid2Types = new HashMap<Long, Type>(Type.values().length);
    private final List<Type> typesWithUnfixedOid = new ArrayList<Type>(Type.values().length);
    private final Map<String, Type> name2Types;

    public Types() {
        for (Type type : Type.values()) {
            if (type.getOid() != -1L) {
                this.oid2Types.put(type.getOid(), type);
                continue;
            }
            this.typesWithUnfixedOid.add(type);
        }
        this.name2Types = new HashMap<String, Type>(Type.values().length);
        for (Type type : Type.values()) {
            this.name2Types.put(type.getName(), type);
        }
    }

    public synchronized void setTypeOid(String name, long oid) {
        Type type = this.getType(name);
        if (type != null && type.getOid() != oid) {
            if (type.getOid() != -1L) {
                this.oid2Types.remove(type.getOid());
            }
            type.setOid(oid);
            this.oid2Types.put(type.getOid(), type);
            this.typesWithUnfixedOid.remove((Object)type);
        }
    }

    public Type getType(long typeID) {
        Type type = this.oid2Types.get(typeID);
        return type;
    }

    public Type getType(String name) {
        Type type = this.name2Types.get(name);
        return type;
    }

    public Map<Long, Type> getOid2Types() {
        return this.oid2Types;
    }

    public List<Type> getTypesWithUnfixedOid() {
        return this.typesWithUnfixedOid;
    }
}

