/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlBindMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer.PgsqlMessageWriter;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class PgsqlBindMessageWriter
implements PgsqlMessageWriter<PgsqlBindMessage> {
    @Override
    public int contentSize(PgsqlBindMessage msg) {
        int size = msg.getPortal().clen();
        size += msg.getPreparedStatement().clen();
        size += 2;
        size += 2 * msg.getParameterFormats().size();
        size += 2;
        for (ByteBuf parameterValue : msg.getParameterValues()) {
            size += 4;
            if (parameterValue == null) continue;
            size += parameterValue.capacity();
        }
        size += 2;
        return size += 2 * msg.getResultColumnFormats().size();
    }

    @Override
    public Map<Integer, ByteBuf> offsets(PgsqlBindMessage msg) {
        int headerSize = msg.getHeaderSize();
        LinkedHashMap<Integer, ByteBuf> offsets = new LinkedHashMap<Integer, ByteBuf>(2 + msg.getParameterValues().size());
        int offset = headerSize;
        offsets.put(offset, msg.getPortal().getByteBuf());
        offsets.put(offset += msg.getPortal().clen(), msg.getPreparedStatement().getByteBuf());
        offset += msg.getPreparedStatement().clen();
        offset += 2;
        offset += 2 * msg.getParameterFormats().size();
        offset += 2;
        for (ByteBuf parameterValue : msg.getParameterValues()) {
            offset += 4;
            if (parameterValue == null) continue;
            offsets.put(offset, parameterValue);
            offset += parameterValue.capacity();
        }
        return offsets;
    }

    @Override
    public void writeContent(PgsqlBindMessage msg, ByteBuf buffer) throws IOException {
        ByteBuf value = msg.getPortal().getByteBuf();
        this.writeBytes(buffer, value);
        value = msg.getPreparedStatement().getByteBuf();
        this.writeBytes(buffer, value);
        buffer.writeShort(msg.getParameterFormats().size());
        for (Short parameterFormat : msg.getParameterFormats()) {
            buffer.writeShort((int)parameterFormat.shortValue());
        }
        buffer.writeShort(msg.getParameterValues().size());
        for (ByteBuf parameterValue : msg.getParameterValues()) {
            if (parameterValue == null) {
                buffer.writeInt(-1);
                continue;
            }
            buffer.writeInt(parameterValue.capacity());
            parameterValue.readerIndex(0);
            buffer.writeBytes(parameterValue);
        }
        buffer.writeShort(msg.getResultColumnFormats().size());
        for (Short resultColumnFormat : msg.getResultColumnFormats()) {
            buffer.writeShort((int)resultColumnFormat.shortValue());
        }
    }
}

