/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlErrorMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer.PgsqlMessageWriter;
import eu.clarussecure.proxy.spi.CString;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class PgsqlErrorMessageWriter
implements PgsqlMessageWriter<PgsqlErrorMessage> {
    @Override
    public int contentSize(PgsqlErrorMessage msg) {
        int size = 0;
        for (Map.Entry<Byte, CString> field : msg.getFields().entrySet()) {
            ++size;
            size += field.getValue().clen();
        }
        return ++size;
    }

    @Override
    public Map<Integer, ByteBuf> offsets(PgsqlErrorMessage msg) {
        int firstPartSize = msg.getHeaderSize();
        LinkedHashMap<Integer, ByteBuf> offsets = new LinkedHashMap<Integer, ByteBuf>(msg.getFields().size());
        int offset = firstPartSize;
        for (Map.Entry<Byte, CString> entry : msg.getFields().entrySet()) {
            offsets.put(++offset, entry.getValue().getByteBuf());
            offset += entry.getValue().clen();
        }
        return offsets;
    }

    @Override
    public void writeContent(PgsqlErrorMessage msg, ByteBuf buffer) throws IOException {
        for (Map.Entry<Byte, CString> field : msg.getFields().entrySet()) {
            byte key = field.getKey();
            ByteBuf value = field.getValue().getByteBuf();
            buffer.writeByte((int)key);
            this.writeBytes(buffer, value);
        }
        buffer.writeByte(0);
    }
}

