/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlParseMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer.PgsqlMessageWriter;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;

public class PgsqlParseMessageWriter
implements PgsqlMessageWriter<PgsqlParseMessage> {
    @Override
    public int contentSize(PgsqlParseMessage msg) {
        int size = msg.getPreparedStatement().clen();
        size += msg.getQuery().clen();
        size += 2;
        return size += 4 * msg.getParameterTypes().size();
    }

    @Override
    public Map<Integer, ByteBuf> offsets(PgsqlParseMessage msg) {
        int headerSize = msg.getHeaderSize();
        LinkedHashMap<Integer, ByteBuf> offsets = new LinkedHashMap<Integer, ByteBuf>(2);
        int offset = headerSize;
        offsets.put(offset, msg.getPreparedStatement().getByteBuf());
        offsets.put(offset += msg.getPreparedStatement().clen(), msg.getQuery().getByteBuf());
        return offsets;
    }

    @Override
    public void writeContent(PgsqlParseMessage msg, ByteBuf buffer) throws IOException {
        ByteBuf value = msg.getPreparedStatement().getByteBuf();
        this.writeBytes(buffer, value);
        value = msg.getQuery().getByteBuf();
        this.writeBytes(buffer, value);
        buffer.writeShort(msg.getParameterTypes().size());
        for (Long parameterType : msg.getParameterTypes()) {
            buffer.writeInt(parameterType.intValue());
        }
    }
}

