/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer;

import eu.clarussecure.proxy.protocol.plugins.pgsql.message.PgsqlSimpleQueryMessage;
import eu.clarussecure.proxy.protocol.plugins.pgsql.message.writer.PgsqlMessageWriter;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

public class PgsqlSimpleQueryMessageWriter
implements PgsqlMessageWriter<PgsqlSimpleQueryMessage> {
    @Override
    public int contentSize(PgsqlSimpleQueryMessage msg) {
        return msg.getQuery().clen();
    }

    @Override
    public Map<Integer, ByteBuf> offsets(PgsqlSimpleQueryMessage msg) {
        int headerSize = msg.getHeaderSize();
        Map<Integer, ByteBuf> offsets = Collections.singletonMap(headerSize, msg.getQuery().getByteBuf());
        return offsets;
    }

    @Override
    public void writeContent(PgsqlSimpleQueryMessage msg, ByteBuf buffer) throws IOException {
        ByteBuf value = msg.getQuery().getByteBuf();
        this.writeBytes(buffer, value);
        if (buffer.writableBytes() == 1) {
            buffer.writeByte(0);
        }
    }
}

