/*
 * Decompiled with CFR 0.152.
 */
package eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler;

import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.DefaultPgsqlRawPart;
import eu.clarussecure.proxy.protocol.plugins.pgsql.raw.handler.PgsqlRawMessage;
import io.netty.buffer.ByteBuf;
import io.netty.util.internal.StringUtil;

public class DefaultPgsqlRawMessage
extends DefaultPgsqlRawPart<PgsqlRawMessage>
implements PgsqlRawMessage {
    private final byte type;
    private final int length;
    private final ByteBuf content;

    public DefaultPgsqlRawMessage(ByteBuf bytes) {
        this(bytes, 0, 0);
    }

    public DefaultPgsqlRawMessage(ByteBuf bytes, byte type, int length) {
        super(bytes);
        this.type = type;
        this.length = length;
        this.content = bytes.slice(this.getBytes().readerIndex() + this.getHeaderSize(), this.getBytes().readableBytes() - this.getHeaderSize());
    }

    @Override
    public byte getType() {
        return this.type;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public ByteBuf getContent() {
        return this.content;
    }

    @Override
    public DefaultPgsqlRawMessage replace(ByteBuf bytes) {
        return new DefaultPgsqlRawMessage(bytes, this.type, this.length);
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "(bytes: " + this.getBytes().capacity() + ", type: " + (char)this.type + ", length: " + this.length + ", content: " + this.getContent().readableBytes() + ')';
    }
}

