/*
 * Decompiled with CFR 0.152.
 */
package eu.miaplatform.customplugin.springboot;

import eu.miaplatform.customplugin.springboot.CPRequest;
import eu.miaplatform.customplugin.springboot.CPService;
import eu.miaplatform.customplugin.springboot.CPStatus;
import eu.miaplatform.customplugin.springboot.CPStatusBody;
import eu.miaplatform.customplugin.springboot.Options;
import io.swagger.annotations.ApiOperation;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;
import springfox.documentation.annotations.ApiIgnore;

@RestController
public abstract class CPController {
    protected final String CP_REQUEST = "CP_REQUEST";
    protected final Logger logger = LoggerFactory.getLogger(CPController.class);
    @Autowired
    protected CPService customPluginService;

    @ModelAttribute(value="CP_REQUEST")
    public CPRequest populate(HttpServletRequest request) {
        return new CPRequest(request, new Options());
    }

    @GetMapping(value={"/-/healthz"})
    @ApiOperation(value="Healthz")
    @ResponseBody
    public ResponseEntity healthz(@ApiIgnore @ModelAttribute(value="CP_REQUEST") CPRequest cpRequest) {
        return this.healthinessHandler(cpRequest);
    }

    @GetMapping(value={"/-/ready"})
    @ApiOperation(value="Ready")
    public ResponseEntity ready(@ApiIgnore @ModelAttribute(value="CP_REQUEST") CPRequest cpRequest) {
        return this.readinessHandler(cpRequest);
    }

    public ResponseEntity healthinessHandler(CPRequest cpRequest) {
        return CPStatus.statusOk(new CPStatusBody());
    }

    public ResponseEntity readinessHandler(CPRequest cpRequest) {
        return CPStatus.statusKo(new CPStatusBody());
    }
}

