/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.css.dom;

import org.apache.batik.css.engine.value.FloatValue;
import org.apache.batik.css.engine.value.ListValue;
import org.apache.batik.css.engine.value.StringValue;
import org.apache.batik.css.engine.value.Value;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSPrimitiveValue;
import org.w3c.dom.css.CSSValue;
import org.w3c.dom.css.CSSValueList;
import org.w3c.dom.css.Counter;
import org.w3c.dom.css.RGBColor;
import org.w3c.dom.css.Rect;

public class CSSOMValue
implements CSSPrimitiveValue,
CSSValueList,
Counter,
Rect,
RGBColor {
    protected ValueProvider valueProvider;
    protected ModificationHandler handler;
    protected LeftComponent leftComponent;
    protected RightComponent rightComponent;
    protected BottomComponent bottomComponent;
    protected TopComponent topComponent;
    protected RedComponent redComponent;
    protected GreenComponent greenComponent;
    protected BlueComponent blueComponent;
    protected CSSValue[] items;

    public CSSOMValue(ValueProvider vp) {
        this.valueProvider = vp;
    }

    public void setModificationHandler(ModificationHandler h) {
        this.handler = h;
    }

    public String getCssText() {
        return this.valueProvider.getValue().getCssText();
    }

    public void setCssText(String cssText) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.textChanged(cssText);
    }

    public short getCssValueType() {
        return this.valueProvider.getValue().getCssValueType();
    }

    public short getPrimitiveType() {
        return this.valueProvider.getValue().getPrimitiveType();
    }

    public void setFloatValue(short unitType, float floatValue) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.floatValueChanged(unitType, floatValue);
    }

    public float getFloatValue(short unitType) throws DOMException {
        return CSSOMValue.convertFloatValue(unitType, this.valueProvider.getValue());
    }

    public static float convertFloatValue(short unitType, Value value2) {
        switch (unitType) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 18: {
                if (value2.getPrimitiveType() != unitType) break;
                return value2.getFloatValue();
            }
            case 6: {
                return CSSOMValue.toCentimeters(value2);
            }
            case 7: {
                return CSSOMValue.toMillimeters(value2);
            }
            case 8: {
                return CSSOMValue.toInches(value2);
            }
            case 9: {
                return CSSOMValue.toPoints(value2);
            }
            case 10: {
                return CSSOMValue.toPicas(value2);
            }
            case 11: {
                return CSSOMValue.toDegrees(value2);
            }
            case 12: {
                return CSSOMValue.toRadians(value2);
            }
            case 13: {
                return CSSOMValue.toGradians(value2);
            }
            case 14: {
                return CSSOMValue.toMilliseconds(value2);
            }
            case 15: {
                return CSSOMValue.toSeconds(value2);
            }
            case 16: {
                return CSSOMValue.toHertz(value2);
            }
            case 17: {
                return CSSOMValue.tokHertz(value2);
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toCentimeters(Value value2) {
        switch (value2.getPrimitiveType()) {
            case 6: {
                return value2.getFloatValue();
            }
            case 7: {
                return value2.getFloatValue() / 10.0f;
            }
            case 8: {
                return value2.getFloatValue() * 2.54f;
            }
            case 9: {
                return value2.getFloatValue() * 2.54f / 72.0f;
            }
            case 10: {
                return value2.getFloatValue() * 2.54f / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toInches(Value value2) {
        switch (value2.getPrimitiveType()) {
            case 6: {
                return value2.getFloatValue() / 2.54f;
            }
            case 7: {
                return value2.getFloatValue() / 25.4f;
            }
            case 8: {
                return value2.getFloatValue();
            }
            case 9: {
                return value2.getFloatValue() / 72.0f;
            }
            case 10: {
                return value2.getFloatValue() / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toMillimeters(Value value2) {
        switch (value2.getPrimitiveType()) {
            case 6: {
                return value2.getFloatValue() * 10.0f;
            }
            case 7: {
                return value2.getFloatValue();
            }
            case 8: {
                return value2.getFloatValue() * 25.4f;
            }
            case 9: {
                return value2.getFloatValue() * 25.4f / 72.0f;
            }
            case 10: {
                return value2.getFloatValue() * 25.4f / 6.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toPoints(Value value2) {
        switch (value2.getPrimitiveType()) {
            case 6: {
                return value2.getFloatValue() * 72.0f / 2.54f;
            }
            case 7: {
                return value2.getFloatValue() * 72.0f / 25.4f;
            }
            case 8: {
                return value2.getFloatValue() * 72.0f;
            }
            case 9: {
                return value2.getFloatValue();
            }
            case 10: {
                return value2.getFloatValue() * 12.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toPicas(Value value2) {
        switch (value2.getPrimitiveType()) {
            case 6: {
                return value2.getFloatValue() * 6.0f / 2.54f;
            }
            case 7: {
                return value2.getFloatValue() * 6.0f / 25.4f;
            }
            case 8: {
                return value2.getFloatValue() * 6.0f;
            }
            case 9: {
                return value2.getFloatValue() / 12.0f;
            }
            case 10: {
                return value2.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toDegrees(Value value2) {
        switch (value2.getPrimitiveType()) {
            case 11: {
                return value2.getFloatValue();
            }
            case 12: {
                return (float)Math.toDegrees(value2.getFloatValue());
            }
            case 13: {
                return value2.getFloatValue() * 9.0f / 5.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toRadians(Value value2) {
        switch (value2.getPrimitiveType()) {
            case 11: {
                return value2.getFloatValue() * 5.0f / 9.0f;
            }
            case 12: {
                return value2.getFloatValue();
            }
            case 13: {
                return (float)((double)(value2.getFloatValue() * 100.0f) / Math.PI);
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toGradians(Value value2) {
        switch (value2.getPrimitiveType()) {
            case 11: {
                return (float)((double)value2.getFloatValue() * Math.PI / 180.0);
            }
            case 12: {
                return (float)((double)value2.getFloatValue() * Math.PI / 100.0);
            }
            case 13: {
                return value2.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toMilliseconds(Value value2) {
        switch (value2.getPrimitiveType()) {
            case 14: {
                return value2.getFloatValue();
            }
            case 15: {
                return value2.getFloatValue() * 1000.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toSeconds(Value value2) {
        switch (value2.getPrimitiveType()) {
            case 14: {
                return value2.getFloatValue() / 1000.0f;
            }
            case 15: {
                return value2.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    protected static float toHertz(Value value2) {
        switch (value2.getPrimitiveType()) {
            case 16: {
                return value2.getFloatValue();
            }
            case 17: {
                return value2.getFloatValue() / 1000.0f;
            }
        }
        throw new DOMException(15, "");
    }

    protected static float tokHertz(Value value2) {
        switch (value2.getPrimitiveType()) {
            case 16: {
                return value2.getFloatValue() * 1000.0f;
            }
            case 17: {
                return value2.getFloatValue();
            }
        }
        throw new DOMException(15, "");
    }

    public void setStringValue(short stringType, String stringValue) throws DOMException {
        if (this.handler == null) {
            throw new DOMException(7, "");
        }
        this.handler.stringValueChanged(stringType, stringValue);
    }

    public String getStringValue() throws DOMException {
        return this.valueProvider.getValue().getStringValue();
    }

    public Counter getCounterValue() throws DOMException {
        return this;
    }

    public Rect getRectValue() throws DOMException {
        return this;
    }

    public RGBColor getRGBColorValue() throws DOMException {
        return this;
    }

    public int getLength() {
        return this.valueProvider.getValue().getLength();
    }

    public CSSValue item(int index2) {
        int len = this.valueProvider.getValue().getLength();
        if (index2 < 0 || index2 >= len) {
            return null;
        }
        if (this.items == null) {
            this.items = new CSSValue[this.valueProvider.getValue().getLength()];
        } else if (this.items.length < len) {
            CSSValue[] nitems = new CSSValue[len];
            System.arraycopy(this.items, 0, nitems, 0, this.items.length);
            this.items = nitems;
        }
        CSSValue result2 = this.items[index2];
        if (result2 == null) {
            this.items[index2] = result2 = new ListComponent(index2);
        }
        return result2;
    }

    public String getIdentifier() {
        return this.valueProvider.getValue().getIdentifier();
    }

    public String getListStyle() {
        return this.valueProvider.getValue().getListStyle();
    }

    public String getSeparator() {
        return this.valueProvider.getValue().getSeparator();
    }

    public CSSPrimitiveValue getTop() {
        this.valueProvider.getValue().getTop();
        if (this.topComponent == null) {
            this.topComponent = new TopComponent();
        }
        return this.topComponent;
    }

    public CSSPrimitiveValue getRight() {
        this.valueProvider.getValue().getRight();
        if (this.rightComponent == null) {
            this.rightComponent = new RightComponent();
        }
        return this.rightComponent;
    }

    public CSSPrimitiveValue getBottom() {
        this.valueProvider.getValue().getBottom();
        if (this.bottomComponent == null) {
            this.bottomComponent = new BottomComponent();
        }
        return this.bottomComponent;
    }

    public CSSPrimitiveValue getLeft() {
        this.valueProvider.getValue().getLeft();
        if (this.leftComponent == null) {
            this.leftComponent = new LeftComponent();
        }
        return this.leftComponent;
    }

    public CSSPrimitiveValue getRed() {
        this.valueProvider.getValue().getRed();
        if (this.redComponent == null) {
            this.redComponent = new RedComponent();
        }
        return this.redComponent;
    }

    public CSSPrimitiveValue getGreen() {
        this.valueProvider.getValue().getGreen();
        if (this.greenComponent == null) {
            this.greenComponent = new GreenComponent();
        }
        return this.greenComponent;
    }

    public CSSPrimitiveValue getBlue() {
        this.valueProvider.getValue().getBlue();
        if (this.blueComponent == null) {
            this.blueComponent = new BlueComponent();
        }
        return this.blueComponent;
    }

    protected class ListComponent
    extends AbstractComponent {
        protected int index;

        public ListComponent(int idx) {
            this.index = idx;
        }

        protected Value getValue() {
            if (this.index >= CSSOMValue.this.valueProvider.getValue().getLength()) {
                throw new DOMException(7, "");
            }
            return CSSOMValue.this.valueProvider.getValue().item(this.index);
        }

        public void setCssText(String cssText) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.listTextChanged(this.index, cssText);
        }

        public void setFloatValue(short unitType, float floatValue) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.listFloatValueChanged(this.index, unitType, floatValue);
        }

        public void setStringValue(short stringType, String stringValue) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.listStringValueChanged(this.index, stringType, stringValue);
        }
    }

    protected class BlueComponent
    extends FloatComponent {
        protected BlueComponent() {
        }

        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getBlue();
        }

        public void setCssText(String cssText) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.blueTextChanged(cssText);
        }

        public void setFloatValue(short unitType, float floatValue) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.blueFloatValueChanged(unitType, floatValue);
        }
    }

    protected class GreenComponent
    extends FloatComponent {
        protected GreenComponent() {
        }

        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getGreen();
        }

        public void setCssText(String cssText) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.greenTextChanged(cssText);
        }

        public void setFloatValue(short unitType, float floatValue) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.greenFloatValueChanged(unitType, floatValue);
        }
    }

    protected class RedComponent
    extends FloatComponent {
        protected RedComponent() {
        }

        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getRed();
        }

        public void setCssText(String cssText) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.redTextChanged(cssText);
        }

        public void setFloatValue(short unitType, float floatValue) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.redFloatValueChanged(unitType, floatValue);
        }
    }

    protected class BottomComponent
    extends FloatComponent {
        protected BottomComponent() {
        }

        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getBottom();
        }

        public void setCssText(String cssText) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.bottomTextChanged(cssText);
        }

        public void setFloatValue(short unitType, float floatValue) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.bottomFloatValueChanged(unitType, floatValue);
        }
    }

    protected class RightComponent
    extends FloatComponent {
        protected RightComponent() {
        }

        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getRight();
        }

        public void setCssText(String cssText) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.rightTextChanged(cssText);
        }

        public void setFloatValue(short unitType, float floatValue) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.rightFloatValueChanged(unitType, floatValue);
        }
    }

    protected class TopComponent
    extends FloatComponent {
        protected TopComponent() {
        }

        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getTop();
        }

        public void setCssText(String cssText) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.topTextChanged(cssText);
        }

        public void setFloatValue(short unitType, float floatValue) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.topFloatValueChanged(unitType, floatValue);
        }
    }

    protected class LeftComponent
    extends FloatComponent {
        protected LeftComponent() {
        }

        protected Value getValue() {
            return CSSOMValue.this.valueProvider.getValue().getLeft();
        }

        public void setCssText(String cssText) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.leftTextChanged(cssText);
        }

        public void setFloatValue(short unitType, float floatValue) throws DOMException {
            if (CSSOMValue.this.handler == null) {
                throw new DOMException(7, "");
            }
            this.getValue();
            CSSOMValue.this.handler.leftFloatValueChanged(unitType, floatValue);
        }
    }

    protected abstract class FloatComponent
    extends AbstractComponent {
        protected FloatComponent() {
        }

        public void setStringValue(short stringType, String stringValue) throws DOMException {
            throw new DOMException(15, "");
        }
    }

    protected abstract class AbstractComponent
    implements CSSPrimitiveValue {
        protected AbstractComponent() {
        }

        protected abstract Value getValue();

        public String getCssText() {
            return this.getValue().getCssText();
        }

        public short getCssValueType() {
            return this.getValue().getCssValueType();
        }

        public short getPrimitiveType() {
            return this.getValue().getPrimitiveType();
        }

        public float getFloatValue(short unitType) throws DOMException {
            return CSSOMValue.convertFloatValue(unitType, this.getValue());
        }

        public String getStringValue() throws DOMException {
            return CSSOMValue.this.valueProvider.getValue().getStringValue();
        }

        public Counter getCounterValue() throws DOMException {
            throw new DOMException(15, "");
        }

        public Rect getRectValue() throws DOMException {
            throw new DOMException(15, "");
        }

        public RGBColor getRGBColorValue() throws DOMException {
            throw new DOMException(15, "");
        }

        public int getLength() {
            throw new DOMException(15, "");
        }

        public CSSValue item(int index2) {
            throw new DOMException(15, "");
        }
    }

    public abstract class AbstractModificationHandler
    implements ModificationHandler {
        protected abstract Value getValue();

        public void floatValueChanged(short unit, float value2) throws DOMException {
            this.textChanged(FloatValue.getCssText(unit, value2));
        }

        public void stringValueChanged(short type, String value2) throws DOMException {
            this.textChanged(StringValue.getCssText(type, value2));
        }

        public void leftTextChanged(String text2) throws DOMException {
            Value val = this.getValue();
            text2 = "rect(" + val.getTop().getCssText() + ", " + val.getRight().getCssText() + ", " + val.getBottom().getCssText() + ", " + text2 + ')';
            this.textChanged(text2);
        }

        public void leftFloatValueChanged(short unit, float value2) throws DOMException {
            Value val = this.getValue();
            String text2 = "rect(" + val.getTop().getCssText() + ", " + val.getRight().getCssText() + ", " + val.getBottom().getCssText() + ", " + FloatValue.getCssText(unit, value2) + ')';
            this.textChanged(text2);
        }

        public void topTextChanged(String text2) throws DOMException {
            Value val = this.getValue();
            text2 = "rect(" + text2 + ", " + val.getRight().getCssText() + ", " + val.getBottom().getCssText() + ", " + val.getLeft().getCssText() + ')';
            this.textChanged(text2);
        }

        public void topFloatValueChanged(short unit, float value2) throws DOMException {
            Value val = this.getValue();
            String text2 = "rect(" + FloatValue.getCssText(unit, value2) + ", " + val.getRight().getCssText() + ", " + val.getBottom().getCssText() + ", " + val.getLeft().getCssText() + ')';
            this.textChanged(text2);
        }

        public void rightTextChanged(String text2) throws DOMException {
            Value val = this.getValue();
            text2 = "rect(" + val.getTop().getCssText() + ", " + text2 + ", " + val.getBottom().getCssText() + ", " + val.getLeft().getCssText() + ')';
            this.textChanged(text2);
        }

        public void rightFloatValueChanged(short unit, float value2) throws DOMException {
            Value val = this.getValue();
            String text2 = "rect(" + val.getTop().getCssText() + ", " + FloatValue.getCssText(unit, value2) + ", " + val.getBottom().getCssText() + ", " + val.getLeft().getCssText() + ')';
            this.textChanged(text2);
        }

        public void bottomTextChanged(String text2) throws DOMException {
            Value val = this.getValue();
            text2 = "rect(" + val.getTop().getCssText() + ", " + val.getRight().getCssText() + ", " + text2 + ", " + val.getLeft().getCssText() + ')';
            this.textChanged(text2);
        }

        public void bottomFloatValueChanged(short unit, float value2) throws DOMException {
            Value val = this.getValue();
            String text2 = "rect(" + val.getTop().getCssText() + ", " + val.getRight().getCssText() + ", " + FloatValue.getCssText(unit, value2) + ", " + val.getLeft().getCssText() + ')';
            this.textChanged(text2);
        }

        public void redTextChanged(String text2) throws DOMException {
            Value val = this.getValue();
            text2 = "rgb(" + text2 + ", " + val.getGreen().getCssText() + ", " + val.getBlue().getCssText() + ')';
            this.textChanged(text2);
        }

        public void redFloatValueChanged(short unit, float value2) throws DOMException {
            Value val = this.getValue();
            String text2 = "rgb(" + FloatValue.getCssText(unit, value2) + ", " + val.getGreen().getCssText() + ", " + val.getBlue().getCssText() + ')';
            this.textChanged(text2);
        }

        public void greenTextChanged(String text2) throws DOMException {
            Value val = this.getValue();
            text2 = "rgb(" + val.getRed().getCssText() + ", " + text2 + ", " + val.getBlue().getCssText() + ')';
            this.textChanged(text2);
        }

        public void greenFloatValueChanged(short unit, float value2) throws DOMException {
            Value val = this.getValue();
            String text2 = "rgb(" + val.getRed().getCssText() + ", " + FloatValue.getCssText(unit, value2) + ", " + val.getBlue().getCssText() + ')';
            this.textChanged(text2);
        }

        public void blueTextChanged(String text2) throws DOMException {
            Value val = this.getValue();
            text2 = "rgb(" + val.getRed().getCssText() + ", " + val.getGreen().getCssText() + ", " + text2 + ')';
            this.textChanged(text2);
        }

        public void blueFloatValueChanged(short unit, float value2) throws DOMException {
            Value val = this.getValue();
            String text2 = "rgb(" + val.getRed().getCssText() + ", " + val.getGreen().getCssText() + ", " + FloatValue.getCssText(unit, value2) + ')';
            this.textChanged(text2);
        }

        public void listTextChanged(int idx, String text2) throws DOMException {
            int i;
            ListValue lv = (ListValue)this.getValue();
            int len = lv.getLength();
            StringBuffer sb = new StringBuffer(len * 8);
            for (i = 0; i < idx; ++i) {
                sb.append(lv.item(i).getCssText());
                sb.append(lv.getSeparatorChar());
            }
            sb.append(text2);
            for (i = idx + 1; i < len; ++i) {
                sb.append(lv.getSeparatorChar());
                sb.append(lv.item(i).getCssText());
            }
            text2 = sb.toString();
            this.textChanged(text2);
        }

        public void listFloatValueChanged(int idx, short unit, float value2) throws DOMException {
            int i;
            ListValue lv = (ListValue)this.getValue();
            int len = lv.getLength();
            StringBuffer sb = new StringBuffer(len * 8);
            for (i = 0; i < idx; ++i) {
                sb.append(lv.item(i).getCssText());
                sb.append(lv.getSeparatorChar());
            }
            sb.append(FloatValue.getCssText(unit, value2));
            for (i = idx + 1; i < len; ++i) {
                sb.append(lv.getSeparatorChar());
                sb.append(lv.item(i).getCssText());
            }
            this.textChanged(sb.toString());
        }

        public void listStringValueChanged(int idx, short unit, String value2) throws DOMException {
            int i;
            ListValue lv = (ListValue)this.getValue();
            int len = lv.getLength();
            StringBuffer sb = new StringBuffer(len * 8);
            for (i = 0; i < idx; ++i) {
                sb.append(lv.item(i).getCssText());
                sb.append(lv.getSeparatorChar());
            }
            sb.append(StringValue.getCssText(unit, value2));
            for (i = idx + 1; i < len; ++i) {
                sb.append(lv.getSeparatorChar());
                sb.append(lv.item(i).getCssText());
            }
            this.textChanged(sb.toString());
        }
    }

    public static interface ModificationHandler {
        public void textChanged(String var1) throws DOMException;

        public void floatValueChanged(short var1, float var2) throws DOMException;

        public void stringValueChanged(short var1, String var2) throws DOMException;

        public void leftTextChanged(String var1) throws DOMException;

        public void leftFloatValueChanged(short var1, float var2) throws DOMException;

        public void topTextChanged(String var1) throws DOMException;

        public void topFloatValueChanged(short var1, float var2) throws DOMException;

        public void rightTextChanged(String var1) throws DOMException;

        public void rightFloatValueChanged(short var1, float var2) throws DOMException;

        public void bottomTextChanged(String var1) throws DOMException;

        public void bottomFloatValueChanged(short var1, float var2) throws DOMException;

        public void redTextChanged(String var1) throws DOMException;

        public void redFloatValueChanged(short var1, float var2) throws DOMException;

        public void greenTextChanged(String var1) throws DOMException;

        public void greenFloatValueChanged(short var1, float var2) throws DOMException;

        public void blueTextChanged(String var1) throws DOMException;

        public void blueFloatValueChanged(short var1, float var2) throws DOMException;

        public void listTextChanged(int var1, String var2) throws DOMException;

        public void listFloatValueChanged(int var1, short var2, float var3) throws DOMException;

        public void listStringValueChanged(int var1, short var2, String var3) throws DOMException;
    }

    public static interface ValueProvider {
        public Value getValue();
    }
}

