/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.apache.bcel.generic.ClassGenException;
import org.apache.bcel.generic.ConstantPoolGen;
import org.apache.bcel.generic.IndexedInstruction;
import org.apache.bcel.generic.Instruction;
import org.apache.bcel.generic.ReturnaddressType;
import org.apache.bcel.generic.Type;
import org.apache.bcel.generic.TypedInstruction;
import org.apache.bcel.generic.Visitor;
import org.apache.bcel.util.ByteSequence;

public class RET
extends Instruction
implements IndexedInstruction,
TypedInstruction {
    private boolean wide;
    private int index;

    RET() {
    }

    public RET(int index2) {
        super((short)169, (short)2);
        this.setIndex(index2);
    }

    public void dump(DataOutputStream out) throws IOException {
        if (this.wide) {
            out.writeByte(196);
        }
        out.writeByte(this.opcode);
        if (this.wide) {
            out.writeShort(this.index);
        } else {
            out.writeByte(this.index);
        }
    }

    private final void setWide() {
        this.wide = this.index > 255;
        this.length = this.wide ? (short)4 : (short)2;
    }

    protected void initFromFile(ByteSequence bytes, boolean wide) throws IOException {
        this.wide = wide;
        if (wide) {
            this.index = bytes.readUnsignedShort();
            this.length = (short)4;
        } else {
            this.index = bytes.readUnsignedByte();
            this.length = (short)2;
        }
    }

    public final int getIndex() {
        return this.index;
    }

    public final void setIndex(int n) {
        if (n < 0) {
            throw new ClassGenException("Negative index value: " + n);
        }
        this.index = n;
        this.setWide();
    }

    public String toString(boolean verbose) {
        return super.toString(verbose) + " " + this.index;
    }

    public Type getType(ConstantPoolGen cp) {
        return ReturnaddressType.NO_TARGET;
    }

    public void accept(Visitor v) {
        v.visitRET(this);
    }
}

