/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.fop.afp.modca.AbstractAFPObject;
import org.apache.fop.afp.modca.MaximumSizeExceededException;
import org.apache.fop.afp.util.BinaryUtils;

public class MapPageSegment
extends AbstractAFPObject {
    private static final int MAX_SIZE = 127;
    private Set pageSegments = null;

    private Set getPageSegments() {
        if (this.pageSegments == null) {
            this.pageSegments = new HashSet();
        }
        return this.pageSegments;
    }

    public void addPageSegment(String name) throws MaximumSizeExceededException {
        if (this.getPageSegments().size() > 127) {
            throw new MaximumSizeExceededException();
        }
        if (name.length() > 8) {
            throw new IllegalArgumentException("The name of page segment " + name + " must not be longer than 8 characters");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("addPageSegment():: adding page segment " + name);
        }
        this.getPageSegments().add(name);
    }

    public boolean isFull() {
        return this.pageSegments.size() >= 127;
    }

    public void writeToStream(OutputStream os) throws IOException {
        int count2 = this.getPageSegments().size();
        int groupLength = 12;
        int groupsLength = count2 * groupLength;
        byte[] data2 = new byte[groupsLength + 12 + 1];
        data2[0] = 90;
        byte[] rl1 = BinaryUtils.convert(data2.length - 1, 2);
        data2[1] = rl1[0];
        data2[2] = rl1[1];
        data2[3] = -45;
        data2[4] = -79;
        data2[5] = 95;
        data2[6] = 0;
        data2[7] = 0;
        data2[8] = 0;
        data2[9] = groupLength;
        data2[10] = 0;
        data2[11] = 0;
        data2[12] = 0;
        int pos = 13;
        Iterator iter2 = this.pageSegments.iterator();
        while (iter2.hasNext()) {
            pos += 4;
            String name = (String)iter2.next();
            try {
                byte[] nameBytes = name.getBytes("Cp1146");
                System.arraycopy(nameBytes, 0, data2, pos, nameBytes.length);
            }
            catch (UnsupportedEncodingException usee) {
                LOG.error("UnsupportedEncodingException translating the name " + name);
            }
            pos += 8;
        }
        os.write(data2);
    }
}

