/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.List;
import org.apache.fop.area.Area;
import org.apache.fop.area.BodyRegion;
import org.apache.fop.area.RegionViewport;
import org.apache.fop.area.Span;
import org.apache.fop.area.Trait;
import org.apache.fop.traits.WritingModeTraitsGetter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MainReference
extends Area {
    private static final long serialVersionUID = 7635126485620012448L;
    private BodyRegion parent;
    private List<Span> spanAreas = new ArrayList<Span>();
    private boolean isEmpty = true;

    public MainReference(BodyRegion parent) {
        this.parent = parent;
        this.addTrait(Trait.IS_REFERENCE_AREA, Boolean.TRUE);
    }

    public Span createSpan(boolean spanAll) {
        if (this.spanAreas.size() > 0 && this.getCurrentSpan().isEmpty()) {
            this.spanAreas.remove(this.spanAreas.size() - 1);
        }
        RegionViewport rv = this.parent.getRegionViewport();
        int ipdWidth = this.parent.getIPD() - rv.getBorderAndPaddingWidthStart() - rv.getBorderAndPaddingWidthEnd();
        Span newSpan = new Span(spanAll ? 1 : this.getColumnCount(), this.getColumnGap(), ipdWidth);
        this.spanAreas.add(newSpan);
        return this.getCurrentSpan();
    }

    public List getSpans() {
        return this.spanAreas;
    }

    public void setSpans(List<Span> spans) {
        this.spanAreas = new ArrayList<Span>(spans);
    }

    public Span getCurrentSpan() {
        return this.spanAreas.get(this.spanAreas.size() - 1);
    }

    public boolean isEmpty() {
        if (this.isEmpty && this.spanAreas != null) {
            for (Span spanArea : this.spanAreas) {
                if (spanArea.isEmpty()) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    public int getColumnCount() {
        return this.parent.getColumnCount();
    }

    public int getColumnGap() {
        return this.parent.getColumnGap();
    }

    @Override
    public void setWritingModeTraits(WritingModeTraitsGetter wmtg) {
        for (Span s2 : this.getSpans()) {
            s2.setWritingModeTraits(wmtg);
        }
    }
}

