/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.fop.pdf.StreamCache;

public class InMemoryStreamCache
implements StreamCache {
    private int hintSize = -1;
    private ByteArrayOutputStream output;

    public InMemoryStreamCache() {
    }

    public InMemoryStreamCache(int hintSize) {
        this.hintSize = hintSize;
    }

    public OutputStream getOutputStream() throws IOException {
        if (this.output == null) {
            this.output = this.hintSize <= 0 ? new ByteArrayOutputStream(512) : new ByteArrayOutputStream(this.hintSize);
        }
        return this.output;
    }

    public void write(byte[] data2) throws IOException {
        this.getOutputStream().write(data2);
    }

    public int outputContents(OutputStream out) throws IOException {
        if (this.output == null) {
            return 0;
        }
        this.output.writeTo(out);
        return this.output.size();
    }

    public int getSize() throws IOException {
        if (this.output == null) {
            return 0;
        }
        return this.output.size();
    }

    public void clear() throws IOException {
        if (this.output != null) {
            this.output.close();
            this.output = null;
        }
    }
}

