/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Rectangle;
import java.util.Map;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPUnitConverter;
import org.apache.fop.render.ImageHandlerBase;
import org.apache.fop.render.afp.AFPForeignAttributeReader;

public abstract class AFPImageHandler
implements ImageHandlerBase {
    private static final int X = 0;
    private static final int Y = 1;
    private final AFPForeignAttributeReader foreignAttributeReader = new AFPForeignAttributeReader();

    protected void setResourceInformation(AFPDataObjectInfo dataObjectInfo, String uri, Map foreignAttributes) {
        AFPResourceInfo resourceInfo = this.foreignAttributeReader.getResourceInfo(foreignAttributes);
        resourceInfo.setUri(uri);
        dataObjectInfo.setResourceInfo(resourceInfo);
    }

    public static AFPObjectAreaInfo createObjectAreaInfo(AFPPaintingState paintingState, Rectangle targetRect) {
        AFPUnitConverter unitConv = paintingState.getUnitConverter();
        int[] coords = unitConv.mpts2units(new float[]{targetRect.x, targetRect.y});
        int width = Math.round(unitConv.mpt2units(targetRect.width));
        int height = Math.round(unitConv.mpt2units(targetRect.height));
        int resolution = paintingState.getResolution();
        AFPObjectAreaInfo objectAreaInfo = new AFPObjectAreaInfo(coords[0], coords[1], width, height, resolution, paintingState.getRotation());
        return objectAreaInfo;
    }

    protected abstract AFPDataObjectInfo createDataObjectInfo();
}

