/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.afp;

import java.awt.Rectangle;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPDataObjectInfo;
import org.apache.fop.render.RenderingContext;
import org.apache.fop.render.afp.AFPImageHandlerRawJPEG;
import org.apache.fop.render.afp.AFPRenderingContext;
import org.apache.fop.render.afp.AbstractAFPImageHandlerRawStream;
import org.apache.xmlgraphics.image.loader.Image;
import org.apache.xmlgraphics.image.loader.ImageFlavor;
import org.apache.xmlgraphics.image.loader.impl.ImageRawEPS;
import org.apache.xmlgraphics.image.loader.impl.ImageRawJPEG;
import org.apache.xmlgraphics.image.loader.impl.ImageRawStream;

public class AFPImageHandlerRawStream
extends AbstractAFPImageHandlerRawStream {
    private static final ImageFlavor[] FLAVORS = new ImageFlavor[]{ImageFlavor.RAW_JPEG, ImageFlavor.RAW_TIFF, ImageFlavor.RAW_EPS};
    private final Log log = LogFactory.getLog(AFPImageHandlerRawJPEG.class);

    public int getPriority() {
        return 200;
    }

    public Class getSupportedImageClass() {
        return ImageRawStream.class;
    }

    public ImageFlavor[] getSupportedImageFlavors() {
        return FLAVORS;
    }

    protected AFPDataObjectInfo createDataObjectInfo() {
        return new AFPDataObjectInfo();
    }

    public void handleImage(RenderingContext context, Image image2, Rectangle pos) throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Embedding undecoded image data (" + image2.getInfo().getMimeType() + ") as data container...");
        }
        super.handleImage(context, image2, pos);
    }

    public boolean isCompatible(RenderingContext targetContext, Image image2) {
        if (targetContext instanceof AFPRenderingContext) {
            AFPRenderingContext afpContext = (AFPRenderingContext)targetContext;
            return afpContext.getPaintingState().isNativeImagesSupported() && (image2 == null || image2 instanceof ImageRawJPEG || image2 instanceof ImageRawEPS || image2 instanceof ImageRawStream && "image/tiff".equals(((ImageRawStream)image2).getMimeType()));
        }
        return false;
    }
}

