/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.Writer;
import org.apache.xml.serializer.SerializerTrace;

public class SerializerTraceWriter
extends Writer {
    private final Writer m_writer;
    private final SerializerTrace m_tracer;
    private int buf_length;
    private byte[] buf;
    private int count;

    private void setBufferSize(int size2) {
        this.buf = new byte[size2 + 3];
        this.buf_length = size2;
        this.count = 0;
    }

    public SerializerTraceWriter(Writer out, SerializerTrace tracer) {
        this.m_writer = out;
        this.m_tracer = tracer;
        this.setBufferSize(1024);
    }

    private void flushBuffer() throws IOException {
        if (this.count > 0) {
            char[] chars = new char[this.count];
            int i = 0;
            while (i < this.count) {
                chars[i] = (char)this.buf[i];
                ++i;
            }
            if (this.m_tracer != null) {
                this.m_tracer.fireGenerateEvent(12, chars, 0, chars.length);
            }
            this.count = 0;
        }
    }

    public void flush() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.flush();
        }
        this.flushBuffer();
    }

    public void close() throws IOException {
        if (this.m_writer != null) {
            this.m_writer.close();
        }
        this.flushBuffer();
    }

    public void write(int c) throws IOException {
        if (this.m_writer != null) {
            this.m_writer.write(c);
        }
        if (this.count >= this.buf_length) {
            this.flushBuffer();
        }
        if (c < 128) {
            this.buf[this.count++] = (byte)c;
        } else if (c < 2048) {
            this.buf[this.count++] = (byte)(192 + (c >> 6));
            this.buf[this.count++] = (byte)(128 + (c & 0x3F));
        } else {
            this.buf[this.count++] = (byte)(224 + (c >> 12));
            this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
            this.buf[this.count++] = (byte)(128 + (c & 0x3F));
        }
    }

    public void write(char[] chars, int start, int length) throws IOException {
        int lengthx3;
        if (this.m_writer != null) {
            this.m_writer.write(chars, start, length);
        }
        if ((lengthx3 = (length << 1) + length) >= this.buf_length) {
            this.flushBuffer();
            this.setBufferSize(2 * lengthx3);
        }
        if (lengthx3 > this.buf_length - this.count) {
            this.flushBuffer();
        }
        int n = length + start;
        int i = start;
        while (i < n) {
            char c = chars[i];
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
            } else if (c < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c >> 6));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c >> 12));
                this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            }
            ++i;
        }
    }

    public void write(String s2) throws IOException {
        int length;
        int lengthx3;
        if (this.m_writer != null) {
            this.m_writer.write(s2);
        }
        if ((lengthx3 = ((length = s2.length()) << 1) + length) >= this.buf_length) {
            this.flushBuffer();
            this.setBufferSize(2 * lengthx3);
        }
        if (lengthx3 > this.buf_length - this.count) {
            this.flushBuffer();
        }
        int i = 0;
        while (i < length) {
            char c = s2.charAt(i);
            if (c < '\u0080') {
                this.buf[this.count++] = (byte)c;
            } else if (c < '\u0800') {
                this.buf[this.count++] = (byte)(192 + (c >> 6));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            } else {
                this.buf[this.count++] = (byte)(224 + (c >> 12));
                this.buf[this.count++] = (byte)(128 + (c >> 6 & 0x3F));
                this.buf[this.count++] = (byte)(128 + (c & 0x3F));
            }
            ++i;
        }
    }
}

