/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import org.mozilla.javascript.Context;
import org.mozilla.javascript.IdFunctionObject;
import org.mozilla.javascript.IdScriptableObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.Undefined;

public class NativeObject
extends IdScriptableObject {
    static final long serialVersionUID = -6345305608474346996L;
    private static final Object OBJECT_TAG = new Object();
    private static final int Id_constructor = 1;
    private static final int Id_toString = 2;
    private static final int Id_toLocaleString = 3;
    private static final int Id_valueOf = 4;
    private static final int Id_hasOwnProperty = 5;
    private static final int Id_propertyIsEnumerable = 6;
    private static final int Id_isPrototypeOf = 7;
    private static final int Id_toSource = 8;
    private static final int MAX_PROTOTYPE_ID = 8;

    static void init(Scriptable scriptable, boolean bl) {
        NativeObject nativeObject = new NativeObject();
        nativeObject.exportAsJSClass(8, scriptable, bl);
    }

    public String getClassName() {
        return "Object";
    }

    public String toString() {
        return ScriptRuntime.defaultObjectToString(this);
    }

    protected void initPrototypeId(int n) {
        String string2;
        int n2;
        switch (n) {
            case 1: {
                n2 = 1;
                string2 = "constructor";
                break;
            }
            case 2: {
                n2 = 0;
                string2 = "toString";
                break;
            }
            case 3: {
                n2 = 0;
                string2 = "toLocaleString";
                break;
            }
            case 4: {
                n2 = 0;
                string2 = "valueOf";
                break;
            }
            case 5: {
                n2 = 1;
                string2 = "hasOwnProperty";
                break;
            }
            case 6: {
                n2 = 1;
                string2 = "propertyIsEnumerable";
                break;
            }
            case 7: {
                n2 = 1;
                string2 = "isPrototypeOf";
                break;
            }
            case 8: {
                n2 = 0;
                string2 = "toSource";
                break;
            }
            default: {
                throw new IllegalArgumentException(String.valueOf(n));
            }
        }
        this.initPrototypeMethod(OBJECT_TAG, n, string2, n2);
    }

    public Object execIdCall(IdFunctionObject idFunctionObject, Context context, Scriptable scriptable, Scriptable scriptable2, Object[] objectArray) {
        if (!idFunctionObject.hasTag(OBJECT_TAG)) {
            return super.execIdCall(idFunctionObject, context, scriptable, scriptable2, objectArray);
        }
        int n = idFunctionObject.methodId();
        switch (n) {
            case 1: {
                if (scriptable2 != null) {
                    return idFunctionObject.construct(context, scriptable, objectArray);
                }
                if (objectArray.length == 0 || objectArray[0] == null || objectArray[0] == Undefined.instance) {
                    return new NativeObject();
                }
                return ScriptRuntime.toObject(context, scriptable, objectArray[0]);
            }
            case 2: 
            case 3: {
                if (context.hasFeature(4)) {
                    String string2 = ScriptRuntime.defaultObjectToSource(context, scriptable, scriptable2, objectArray);
                    int n2 = string2.length();
                    if (n2 != 0 && string2.charAt(0) == '(' && string2.charAt(n2 - 1) == ')') {
                        string2 = string2.substring(1, n2 - 1);
                    }
                    return string2;
                }
                return ScriptRuntime.defaultObjectToString(scriptable2);
            }
            case 4: {
                return scriptable2;
            }
            case 5: {
                boolean bl;
                if (objectArray.length == 0) {
                    bl = false;
                } else {
                    String string3 = ScriptRuntime.toStringIdOrIndex(context, objectArray[0]);
                    if (string3 == null) {
                        int n3 = ScriptRuntime.lastIndexResult(context);
                        bl = scriptable2.has(n3, scriptable2);
                    } else {
                        bl = scriptable2.has(string3, scriptable2);
                    }
                }
                return ScriptRuntime.wrapBoolean(bl);
            }
            case 6: {
                boolean bl;
                if (objectArray.length == 0) {
                    bl = false;
                } else {
                    String string4 = ScriptRuntime.toStringIdOrIndex(context, objectArray[0]);
                    if (string4 == null) {
                        int n4 = ScriptRuntime.lastIndexResult(context);
                        bl = scriptable2.has(n4, scriptable2);
                        if (bl && scriptable2 instanceof ScriptableObject) {
                            ScriptableObject scriptableObject = (ScriptableObject)scriptable2;
                            int n5 = scriptableObject.getAttributes(n4);
                            bl = (n5 & 2) == 0;
                        }
                    } else {
                        bl = scriptable2.has(string4, scriptable2);
                        if (bl && scriptable2 instanceof ScriptableObject) {
                            ScriptableObject scriptableObject = (ScriptableObject)scriptable2;
                            int n6 = scriptableObject.getAttributes(string4);
                            bl = (n6 & 2) == 0;
                        }
                    }
                }
                return ScriptRuntime.wrapBoolean(bl);
            }
            case 7: {
                boolean bl = false;
                if (objectArray.length != 0 && objectArray[0] instanceof Scriptable) {
                    Scriptable scriptable3 = (Scriptable)objectArray[0];
                    do {
                        if ((scriptable3 = scriptable3.getPrototype()) != scriptable2) continue;
                        bl = true;
                        break;
                    } while (scriptable3 != null);
                }
                return ScriptRuntime.wrapBoolean(bl);
            }
            case 8: {
                return ScriptRuntime.defaultObjectToSource(context, scriptable, scriptable2, objectArray);
            }
        }
        throw new IllegalArgumentException(String.valueOf(n));
    }

    protected int findPrototypeId(String string2) {
        int n = 0;
        String string3 = null;
        switch (string2.length()) {
            case 7: {
                string3 = "valueOf";
                n = 4;
                break;
            }
            case 8: {
                char c = string2.charAt(3);
                if (c == 'o') {
                    string3 = "toSource";
                    n = 8;
                    break;
                }
                if (c != 't') break;
                string3 = "toString";
                n = 2;
                break;
            }
            case 11: {
                string3 = "constructor";
                n = 1;
                break;
            }
            case 13: {
                string3 = "isPrototypeOf";
                n = 7;
                break;
            }
            case 14: {
                char c = string2.charAt(0);
                if (c == 'h') {
                    string3 = "hasOwnProperty";
                    n = 5;
                    break;
                }
                if (c != 't') break;
                string3 = "toLocaleString";
                n = 3;
                break;
            }
            case 20: {
                string3 = "propertyIsEnumerable";
                n = 6;
                break;
            }
        }
        if (string3 != null && string3 != string2 && !string3.equals(string2)) {
            n = 0;
        }
        return n;
    }
}

