/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.annotation_processor;

import foundation.icon.annotation_processor.AnnotatedTypeElement;
import foundation.icon.annotation_processor.Messager;
import foundation.icon.annotation_processor.ProcessorUtil;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

public abstract class AbstractProcessor
extends javax.annotation.processing.AbstractProcessor {
    protected Messager messager;
    protected Elements elementUtil;
    protected Types typeUtil;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = new Messager(processingEnv.getMessager(), this.getClass().getSimpleName());
        this.elementUtil = processingEnv.getElementUtils();
        this.typeUtil = processingEnv.getTypeUtils();
    }

    public TypeMirror getPrimitiveType(Class<?> clazz) {
        return this.typeUtil.getPrimitiveType(TypeKind.valueOf(clazz.getTypeName().toUpperCase()));
    }

    public TypeMirror getBoxedType(TypeMirror type) {
        return this.typeUtil.boxedClass((PrimitiveType)type).asType();
    }

    public TypeMirror getTypeMirror(Class<?> clazz) {
        if (clazz.isArray()) {
            return this.typeUtil.getArrayType(this.getTypeMirror(clazz.getComponentType()));
        }
        if (clazz.isPrimitive()) {
            return this.getPrimitiveType(clazz);
        }
        return this.elementUtil.getTypeElement(clazz.getName()).asType();
    }

    public TypeMirror getTypeMirrorFromAnnotation(Supplier<Class<?>> supplier) {
        try {
            return this.getTypeMirror(supplier.get());
        }
        catch (MirroredTypeException e) {
            return e.getTypeMirror();
        }
    }

    public TypeElement getTypeElement(TypeMirror type) {
        return (TypeElement)this.typeUtil.asElement(type);
    }

    public String findMethod(TypeMirror type, String methodNamePattern, TypeMirror returnType, Modifier[] modifiers, TypeMirror ... parameters) {
        TypeMirror objectType = this.getTypeMirror(Object.class);
        Pattern pattern = Pattern.compile(methodNamePattern);
        TypeElement element = (TypeElement)this.typeUtil.asElement(type);
        for (Element element2 : element.getEnclosedElements()) {
            if (!element2.getKind().equals((Object)ElementKind.METHOD) || !ProcessorUtil.hasModifier(element2, modifiers)) continue;
            ExecutableElement method = (ExecutableElement)element2;
            List<? extends VariableElement> methodParameters = method.getParameters();
            String methodName = method.getSimpleName().toString();
            if (!pattern.matcher(methodName).matches() || returnType != null && !this.typeUtil.isSameType(returnType, method.getReturnType()) || methodParameters.size() != parameters.length) continue;
            boolean isEqual = true;
            for (int i = 0; i < parameters.length; ++i) {
                TypeMirror methodParameter = methodParameters.get(i).asType();
                TypeMirror parameter = parameters[i];
                if (this.typeUtil.isSameType(objectType, parameter) || this.typeUtil.isSameType(methodParameter, parameter)) continue;
                isEqual = false;
                break;
            }
            if (!isEqual) continue;
            this.messager.noteMessage("found pattern:%s '%s %s %s(%s)' in %s", methodNamePattern, Arrays.toString((Object[])modifiers), returnType == null ? "void" : returnType, methodName, Arrays.toString(parameters), type);
            return methodName;
        }
        return null;
    }

    public String findMethod(TypeMirror type, String methodNamePattern, Class<?> returnType, Modifier[] modifiers, Class<?> ... parameters) {
        TypeMirror[] parameterTypes = new TypeMirror[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = this.getTypeMirror(parameters[i]);
        }
        return this.findMethod(type, methodNamePattern, this.getTypeMirror(returnType), modifiers, parameterTypes);
    }

    public <T extends Annotation> AnnotatedTypeElement<T> getAnnotatedTypeElement(TypeMirror type, Class<T> annotationType) {
        T ann;
        TypeElement element;
        if (!type.getKind().isPrimitive() && (element = this.getTypeElement(type)) != null && (ann = element.getAnnotation(annotationType)) != null) {
            return new AnnotatedTypeElement<T>(element, ann);
        }
        return null;
    }

    public boolean containsDeclaredType(Collection<TypeMirror> list, TypeMirror type) {
        if (type.getKind() == TypeKind.DECLARED) {
            TypeElement element = (TypeElement)((DeclaredType)type).asElement();
            TypeMirror varType = element.asType();
            for (TypeMirror e : list) {
                if (!this.typeUtil.isSameType(varType, e)) continue;
                return true;
            }
        }
        return false;
    }

    public <V> V getDeclaredType(Map<TypeMirror, V> map, TypeMirror type) {
        if (type.getKind() == TypeKind.DECLARED) {
            TypeElement element = (TypeElement)((DeclaredType)type).asElement();
            TypeMirror varType = element.asType();
            for (Map.Entry<TypeMirror, V> entry : map.entrySet()) {
                if (!this.typeUtil.isSameType(varType, entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }
}

