/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.io;

import foundation.icon.ee.io.DataReader;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import org.msgpack.core.MessageFormat;
import org.msgpack.core.MessageInsufficientBufferException;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageTypeException;
import org.msgpack.core.MessageUnpacker;
import org.msgpack.value.ValueType;

public class MessagePackDataReader
implements DataReader {
    private MessageUnpacker unpacker;
    private ArrayList<ListFrame> frames = new ArrayList();
    private ListFrame topFrame;

    public MessagePackDataReader(byte[] data) {
        this(MessagePack.newDefaultUnpacker((byte[])data));
    }

    public MessagePackDataReader(MessageUnpacker unpacker) {
        this.unpacker = unpacker;
        this.topFrame = new ListFrame();
        this.frames.add(this.topFrame);
        this.topFrame.length = Integer.MAX_VALUE;
    }

    public RuntimeException convert(Exception e) {
        if (e instanceof MessageTypeException || e instanceof MessageInsufficientBufferException) {
            return new IllegalStateException();
        }
        return new UnsupportedOperationException();
    }

    @Override
    public boolean readBoolean() {
        try {
            boolean res = this.unpacker.unpackBoolean();
            ++this.topFrame.current;
            return res;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public byte readByte() {
        try {
            byte res = this.unpacker.unpackByte();
            ++this.topFrame.current;
            return res;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public short readShort() {
        try {
            short res = this.unpacker.unpackShort();
            ++this.topFrame.current;
            return res;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public char readChar() {
        try {
            char res = (char)this.unpacker.unpackInt();
            ++this.topFrame.current;
            return res;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public int readInt() {
        try {
            int res = this.unpacker.unpackInt();
            ++this.topFrame.current;
            return res;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public float readFloat() {
        try {
            float res = this.unpacker.unpackFloat();
            ++this.topFrame.current;
            return res;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public long readLong() {
        try {
            long res = this.unpacker.unpackLong();
            ++this.topFrame.current;
            return res;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public double readDouble() {
        try {
            double res = this.unpacker.unpackDouble();
            ++this.topFrame.current;
            return res;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public BigInteger readBigInteger() {
        try {
            BigInteger res = this.unpacker.unpackBigInteger();
            ++this.topFrame.current;
            return res;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public String readString() {
        try {
            String res = this.unpacker.unpackString();
            ++this.topFrame.current;
            return res;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public byte[] readByteArray() {
        try {
            MessageFormat fmt = this.unpacker.getNextFormat();
            if (fmt.getValueType() != ValueType.BINARY) {
                throw new IllegalStateException();
            }
            int l = this.unpacker.unpackBinaryHeader();
            byte[] ba = new byte[l];
            this.unpacker.readPayload(ba);
            ++this.topFrame.current;
            return ba;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public boolean readNullity() {
        return this.tryReadNull();
    }

    @Override
    public void skip(int count) {
        try {
            this.unpacker.skipValue(count);
            this.topFrame.current += count;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    private void readContainerHeader(ValueType type) {
        try {
            int l;
            MessageFormat fmt = this.unpacker.getNextFormat();
            ValueType vt = fmt.getValueType();
            if (vt != type) {
                throw new IllegalStateException();
            }
            if (vt == ValueType.ARRAY) {
                l = this.unpacker.unpackArrayHeader();
            } else {
                assert (vt == ValueType.MAP);
                l = this.unpacker.unpackMapHeader();
            }
            this.topFrame = new ListFrame();
            this.topFrame.length = l;
            this.frames.add(this.topFrame);
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public void readListHeader() {
        this.readContainerHeader(ValueType.ARRAY);
    }

    @Override
    public void readMapHeader() {
        this.readContainerHeader(ValueType.MAP);
    }

    @Override
    public boolean hasNext() {
        if (this.frames.size() == 1) {
            try {
                return this.unpacker.hasNext();
            }
            catch (IOException e) {
                throw this.convert(e);
            }
        }
        return this.topFrame.current < this.topFrame.length;
    }

    @Override
    public void readFooter() {
        this.frames.remove(this.frames.size() - 1);
        this.topFrame = this.frames.get(this.frames.size() - 1);
        ++this.topFrame.current;
    }

    private boolean tryReadNull() {
        try {
            MessageFormat fmt = this.unpacker.getNextFormat();
            if (fmt == MessageFormat.NIL) {
                this.unpacker.unpackNil();
                ++this.topFrame.current;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw this.convert(e);
        }
    }

    @Override
    public long getTotalReadBytes() {
        return this.unpacker.getTotalReadBytes();
    }

    private static class ListFrame {
        int current;
        int length;

        private ListFrame() {
        }
    }
}

