/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.io;

import foundation.icon.ee.io.DataReader;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;

public class RLPDataReader
implements DataReader {
    private final ByteBuffer bb;
    private final byte[] arr;
    private final ArrayList<ListFrame> frames = new ArrayList();
    private ListFrame topFrame;
    private int o;
    private int l;

    public RLPDataReader(byte[] data) {
        this(ByteBuffer.wrap(data));
    }

    private RLPDataReader(ByteBuffer bb) {
        this.bb = bb;
        this.arr = bb.array();
        this.topFrame = new ListFrame();
        this.frames.add(this.topFrame);
        this.topFrame.endPos = bb.limit();
    }

    private void readRLPString() {
        int b = this.peek();
        if (b >= 192) {
            throw new IllegalStateException();
        }
        this.peekRLPString(b);
        this.bb.position(this.o + this.l);
    }

    private void peekRLPString(int b) {
        int p = this.bb.arrayOffset() + this.bb.position();
        if (b <= 127) {
            this.o = this.bb.position();
            this.l = 1;
        } else if (b <= 183) {
            this.o = 1 + this.bb.position();
            this.l = b - 128;
        } else if (b == 184) {
            this.o = 2 + this.bb.position();
            this.l = this.arr[p + 1] & 0xFF;
        } else if (b == 185) {
            this.o = 3 + this.bb.position();
            this.l = (this.arr[p + 1] & 0xFF) << 8 | this.arr[p + 2] & 0xFF;
        } else if (b == 186) {
            this.o = 4 + this.bb.position();
            this.l = (this.arr[p + 1] & 0xFF) << 16 | (this.arr[p + 2] & 0xFF) << 8 | this.arr[p + 3] & 0xFF;
        } else if (b == 187) {
            this.o = 5 + this.bb.position();
            this.l = (this.arr[p + 1] & 0xFF) << 24 | (this.arr[p + 2] & 0xFF) << 16 | (this.arr[p + 3] & 0xFF) << 8 | this.arr[p + 4] & 0xFF;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private void peekRLPListHeader(int b) {
        int p = this.bb.arrayOffset() + this.bb.position();
        if (b <= 247) {
            this.o = 1 + this.bb.position();
            this.l = b - 192;
        } else if (b == 248) {
            this.o = 2 + this.bb.position();
            this.l = this.arr[p + 1] & 0xFF;
        } else if (b == 249) {
            this.o = 3 + this.bb.position();
            this.l = (this.arr[p + 1] & 0xFF) << 8 | this.arr[p + 2] & 0xFF;
        } else if (b == 250) {
            this.o = 4 + this.bb.position();
            this.l = (this.arr[p + 1] & 0xFF) << 16 | (this.arr[p + 2] & 0xFF) << 8 | this.arr[p + 3] & 0xFF;
        } else if (b == 251) {
            this.o = 5 + this.bb.position();
            this.l = (this.arr[p + 1] & 0xFF) << 24 | (this.arr[p + 2] & 0xFF) << 16 | (this.arr[p + 3] & 0xFF) << 8 | this.arr[p + 4] & 0xFF;
        } else {
            throw new UnsupportedOperationException();
        }
    }

    private boolean peekRLPNull(int b) {
        if (b != 248) {
            return false;
        }
        int p = this.bb.arrayOffset() + this.bb.position();
        if (this.arr[p + 1] == 0) {
            this.o = 2 + this.bb.position();
            this.l = 0;
            return true;
        }
        return false;
    }

    private int peek() {
        return this.bb.get(this.bb.position()) & 0xFF;
    }

    @Override
    public boolean readBoolean() {
        return this.readBigInteger().signum() != 0;
    }

    @Override
    public byte readByte() {
        return this.readBigInteger().byteValue();
    }

    @Override
    public short readShort() {
        return this.readBigInteger().shortValue();
    }

    @Override
    public char readChar() {
        return (char)this.readBigInteger().intValue();
    }

    @Override
    public int readInt() {
        return this.readBigInteger().intValue();
    }

    @Override
    public float readFloat() {
        this.readRLPString();
        if (this.l != 4) {
            throw new IllegalStateException();
        }
        return this.bb.getFloat(this.o);
    }

    @Override
    public long readLong() {
        return this.readBigInteger().longValue();
    }

    @Override
    public double readDouble() {
        this.readRLPString();
        if (this.l != 8) {
            throw new IllegalStateException();
        }
        return this.bb.getDouble(this.o);
    }

    @Override
    public BigInteger readBigInteger() {
        this.readRLPString();
        int offset = this.bb.arrayOffset() + this.o;
        return new BigInteger(this.arr, offset, this.l);
    }

    @Override
    public String readString() {
        this.readRLPString();
        int offset = this.bb.arrayOffset() + this.o;
        return new String(this.arr, offset, this.l, StandardCharsets.UTF_8);
    }

    @Override
    public byte[] readByteArray() {
        this.readRLPString();
        int offset = this.bb.arrayOffset() + this.o;
        return Arrays.copyOfRange(this.arr, offset, offset + this.l);
    }

    @Override
    public boolean readNullity() {
        return this.tryReadNull();
    }

    @Override
    public void skip(int count) {
        for (int i = 0; i < count; ++i) {
            int b = this.peek();
            if (!this.peekRLPNull(b)) {
                if (b < 192) {
                    this.peekRLPString(b);
                } else {
                    this.peekRLPListHeader(b);
                }
            }
            this.bb.position(this.o + this.l);
        }
    }

    private void _readRLPListHeader() {
        int b = this.peek();
        this.peekRLPListHeader(b);
        this.bb.position(this.o);
        this.topFrame = new ListFrame();
        this.topFrame.endPos = this.bb.position() + this.l;
        this.frames.add(this.topFrame);
    }

    private void _readRLPListFooter() {
        this.frames.remove(this.frames.size() - 1);
        this.topFrame = this.frames.get(this.frames.size() - 1);
    }

    @Override
    public void readListHeader() {
        this._readRLPListHeader();
    }

    @Override
    public void readMapHeader() {
        this.readListHeader();
    }

    @Override
    public boolean hasNext() {
        return this.bb.position() < this.topFrame.endPos;
    }

    @Override
    public void readFooter() {
        this._readRLPListFooter();
    }

    private boolean tryReadNull() {
        int b = this.peek();
        if (!this.peekRLPNull(b)) {
            return false;
        }
        this.bb.position(this.o + this.l);
        return true;
    }

    @Override
    public long getTotalReadBytes() {
        return this.bb.position();
    }

    private static class ListFrame {
        int endPos;

        private ListFrame() {
        }
    }
}

