/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.score;

import foundation.icon.ee.score.Loader;
import foundation.icon.ee.types.Address;
import foundation.icon.ee.types.Result;
import foundation.icon.ee.types.Transaction;
import i.AvmException;
import i.IInstrumentation;
import i.IInstrumentationFactory;
import i.InstrumentationHelpers;
import org.aion.avm.core.AvmConfiguration;
import org.aion.avm.core.DAppCreator;
import org.aion.avm.core.DAppExecutor;
import org.aion.avm.core.IExternalState;
import org.aion.avm.core.ReentrantDAppStack;
import org.aion.avm.core.persistence.LoadedDApp;
import org.aion.parallel.TransactionTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvmExecutor {
    private static final Logger logger = LoggerFactory.getLogger(AvmExecutor.class);
    private final IInstrumentationFactory instrumentationFactory;
    private final AvmConfiguration conf;
    private final Loader loader;
    private IInstrumentation instrumentation;
    private TransactionTask task;

    public AvmExecutor(IInstrumentationFactory factory, AvmConfiguration conf, Loader loader) {
        this.instrumentationFactory = factory;
        this.conf = new AvmConfiguration(conf);
        this.loader = loader;
    }

    public void start() {
        this.instrumentation = this.instrumentationFactory.createInstrumentation();
        InstrumentationHelpers.attachThread(this.instrumentation);
    }

    public Result run(IExternalState kernel, Transaction transaction, Address origin, int eid, int prevEID) {
        if (this.task == null) {
            return this.runExternal(kernel, transaction, origin, eid, prevEID);
        }
        return this.runInternal(kernel, transaction, eid, prevEID);
    }

    private Result runExternal(IExternalState kernel, Transaction transaction, Address origin, int eid, int prevEID) {
        this.task = new TransactionTask(kernel, transaction, origin);
        this.task.startNewTransaction();
        this.task.attachInstrumentationForThread();
        Result result = this.runCommon(this.task.getThisTransactionalKernel(), transaction, eid, prevEID);
        this.task.getReentrantDAppStack().unloadDApps(this.loader);
        this.task.detachInstrumentationForThread();
        logger.trace("{}", (Object)result);
        this.task = null;
        return result;
    }

    private Result runInternal(IExternalState kernel, Transaction transaction, int eid, int prevEID) {
        return this.runCommon(kernel, transaction, eid, prevEID);
    }

    private Result runCommon(IExternalState kernel, Transaction tx, int eid, int prevEID) {
        Address senderAddress = tx.getSender();
        Address recipient = tx.getDestination();
        this.task.setEID(eid);
        this.task.setPrevEID(prevEID);
        if (tx.isCreate()) {
            logger.trace("=== DAppCreator ===");
            return DAppCreator.create(kernel, this.task, senderAddress, recipient, tx, this.conf);
        }
        byte[] cid = kernel.getContractID();
        ReentrantDAppStack.ReentrantState stateToResume = this.task.getReentrantDAppStack().tryShareState(cid);
        LoadedDApp dapp = this.task.getReentrantDAppStack().tryGetLoadedDApp(cid);
        if (dapp == null) {
            try {
                dapp = this.loader.load(kernel, this.conf);
            }
            catch (AvmException e) {
                return new Result(e.getCode(), 0L, (Object)e.getResultMessage());
            }
        }
        return DAppExecutor.call(kernel, dapp, stateToResume, this.task, senderAddress, recipient, tx, this.conf);
    }

    public void shutdown() {
        InstrumentationHelpers.detachThread(this.instrumentation);
        this.instrumentationFactory.destroyInstrumentation(this.instrumentation);
    }
}

