/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.score;

import foundation.icon.ee.Agent;
import foundation.icon.ee.types.IllegalFormatException;
import i.GenericPredefinedException;
import i.RuntimeAssertionError;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipException;
import org.aion.avm.core.AvmConfiguration;
import org.aion.avm.core.ClassHierarchyForest;
import org.aion.avm.core.ClassRenamer;
import org.aion.avm.core.ClassToolchain;
import org.aion.avm.core.ConstantClassBuilder;
import org.aion.avm.core.IExternalState;
import org.aion.avm.core.NodeEnvironment;
import org.aion.avm.core.TypeAwareClassWriter;
import org.aion.avm.core.arraywrapping.ArraysRequiringAnalysisClassVisitor;
import org.aion.avm.core.arraywrapping.ArraysWithKnownTypesClassVisitor;
import org.aion.avm.core.exceptionwrapping.ExceptionWrapping;
import org.aion.avm.core.instrument.ClassMetering;
import org.aion.avm.core.instrument.HeapMemoryCostCalculator;
import org.aion.avm.core.miscvisitors.APIRemapClassVisitor;
import org.aion.avm.core.miscvisitors.ClinitStrippingVisitor;
import org.aion.avm.core.miscvisitors.ConstantVisitor;
import org.aion.avm.core.miscvisitors.InterfaceFieldClassGeneratorVisitor;
import org.aion.avm.core.miscvisitors.InterfaceFieldNameMappingVisitor;
import org.aion.avm.core.miscvisitors.LoopingExceptionStrippingVisitor;
import org.aion.avm.core.miscvisitors.NamespaceMapper;
import org.aion.avm.core.miscvisitors.PreRenameClassAccessRules;
import org.aion.avm.core.miscvisitors.StrictFPVisitor;
import org.aion.avm.core.miscvisitors.UserClassMappingVisitor;
import org.aion.avm.core.persistence.AutomaticGraphVisitor;
import org.aion.avm.core.rejection.InstanceVariableCountManager;
import org.aion.avm.core.rejection.InstanceVariableCountingVisitor;
import org.aion.avm.core.rejection.RejectedClassException;
import org.aion.avm.core.rejection.RejectionClassVisitor;
import org.aion.avm.core.shadowing.ClassShadowing;
import org.aion.avm.core.shadowing.InvokedynamicShadower;
import org.aion.avm.core.stacktracking.StackWatcherClassAdapter;
import org.aion.avm.core.types.ClassHierarchy;
import org.aion.avm.core.types.ClassInfo;
import org.aion.avm.core.types.Forest;
import org.aion.avm.core.types.GeneratedClassConsumer;
import org.aion.avm.core.types.ImmortalDappModule;
import org.aion.avm.core.types.RawDappModule;
import org.aion.avm.core.types.TransformedDappModule;
import org.aion.avm.core.util.DebugNameResolver;
import org.aion.avm.core.verification.Verifier;
import org.aion.avm.utilities.JarBuilder;
import org.aion.avm.utilities.Utilities;
import org.aion.avm.utilities.analyze.ClassFileInfoBuilder;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;

public class Transformer {
    private final IExternalState es;
    private final AvmConfiguration conf;
    private byte[] transformedCodeBytes;
    private byte[] apisBytes;
    private TransformedDappModule bootstrapModule;

    private static Map<String, Integer> computeUserObjectSizes(Forest<String, ClassInfo> classHierarchy) {
        HeapMemoryCostCalculator objectSizeCalculator = new HeapMemoryCostCalculator();
        objectSizeCalculator.calcClassesInstanceSize(classHierarchy);
        return objectSizeCalculator.getClassHeapSizeMap();
    }

    private static Map<String, Integer> computeAllPostRenameObjectSizes(Forest<String, ClassInfo> forest, boolean preserveDebuggability) {
        Map<String, Integer> preRenameUserObjectSizes = Transformer.computeUserObjectSizes(forest);
        HashMap<String, Integer> postRenameObjectSizes = new HashMap<String, Integer>(NodeEnvironment.singleton.postRenameRuntimeObjectSizeMap);
        preRenameUserObjectSizes.forEach((k, v) -> postRenameObjectSizes.put(DebugNameResolver.getUserPackageSlashPrefix(k, preserveDebuggability), (Integer)v));
        return postRenameObjectSizes;
    }

    private static Map<String, byte[]> transformClasses(Map<String, byte[]> inputClasses, Forest<String, ClassInfo> oldPreRenameForest, ClassHierarchy classHierarchy, ClassRenamer classRenamer, boolean preserveDebuggability) {
        byte[] bytecode2;
        Verifier.verifyUntrustedClasses(inputClasses);
        Map<String, byte[]> safeClasses = Transformer.rejectionAndRenameInputClasses(inputClasses, classHierarchy, classRenamer, preserveDebuggability);
        ConstantClassBuilder.ConstantClassInfo constantClass = ConstantClassBuilder.buildConstantClassBytecodeForClasses("C", safeClasses.values());
        HashMap<String, byte[]> processedClasses = new HashMap<String, byte[]>();
        processedClasses.put("C", constantClass.bytecode);
        GeneratedClassConsumer generatedClassesSink = (superClassSlashName, classSlashName, bytecode) -> {
            String classDotName = Utilities.internalNameToFullyQualifiedName(classSlashName);
            processedClasses.put(classDotName, bytecode);
        };
        Map<String, Integer> postRenameObjectSizes = Transformer.computeAllPostRenameObjectSizes(oldPreRenameForest, preserveDebuggability);
        HashMap<String, byte[]> transformedClasses = new HashMap<String, byte[]>();
        int parsingOptions = preserveDebuggability ? 8 : 10;
        for (String name : safeClasses.keySet()) {
            RuntimeAssertionError.assertTrue(!name.contains("/"));
            ClassToolchain.Builder builder = new ClassToolchain.Builder(safeClasses.get(name), parsingOptions);
            Agent agent = Agent.get();
            if (agent == null || agent.isClassMeteringEnabled()) {
                builder.addNextVisitor(new ClassMetering(postRenameObjectSizes));
            }
            bytecode2 = builder.addNextVisitor(new ConstantVisitor("C", constantClass.constantToFieldMap)).addNextVisitor(new InvokedynamicShadower("s/")).addNextVisitor(new ClassShadowing("s/")).addNextVisitor(new StackWatcherClassAdapter()).addNextVisitor(new ExceptionWrapping(generatedClassesSink, classHierarchy)).addNextVisitor(new AutomaticGraphVisitor()).addNextVisitor(new StrictFPVisitor()).addWriter(new TypeAwareClassWriter(3, classHierarchy, classRenamer)).build().runAndGetBytecode();
            bytecode2 = new ClassToolchain.Builder(bytecode2, parsingOptions).addNextVisitor(new ArraysRequiringAnalysisClassVisitor(classHierarchy)).addNextVisitor(new ArraysWithKnownTypesClassVisitor()).addNextVisitor(new APIRemapClassVisitor()).addWriter(new TypeAwareClassWriter(3, classHierarchy, classRenamer)).build().runAndGetBytecode();
            transformedClasses.put(name, bytecode2);
        }
        HashMap<String, String> interfaceFieldClassNames = new HashMap<String, String>();
        String javaLangObjectSlashName = "s/java/lang/Object";
        for (String name : transformedClasses.keySet()) {
            new ClassReader((byte[])transformedClasses.get(name)).accept((ClassVisitor)new InterfaceFieldClassGeneratorVisitor(generatedClassesSink, interfaceFieldClassNames, javaLangObjectSlashName), parsingOptions);
        }
        for (String name : transformedClasses.keySet()) {
            bytecode2 = new ClassToolchain.Builder((byte[])transformedClasses.get(name), parsingOptions).addNextVisitor(new InterfaceFieldNameMappingVisitor(interfaceFieldClassNames)).addWriter(new TypeAwareClassWriter(3, classHierarchy, classRenamer)).build().runAndGetBytecode();
            processedClasses.put(name, bytecode2);
        }
        return processedClasses;
    }

    private static Map<String, byte[]> stripClinitFromClasses(Map<String, byte[]> transformedClasses) {
        HashMap<String, byte[]> immortalClasses = new HashMap<String, byte[]>();
        for (Map.Entry<String, byte[]> elt : transformedClasses.entrySet()) {
            String className = elt.getKey();
            byte[] transformedClass = elt.getValue();
            byte[] immortalClass = new ClassToolchain.Builder(transformedClass, 0).addNextVisitor(new ClinitStrippingVisitor()).addWriter(new ClassWriter(0)).build().runAndGetBytecode();
            immortalClasses.put(className, immortalClass);
        }
        return immortalClasses;
    }

    private static Map<String, byte[]> rejectionAndRenameInputClasses(Map<String, byte[]> inputClasses, ClassHierarchy classHierarchy, ClassRenamer classRenamer, boolean preserveDebuggability) {
        InstanceVariableCountManager manager = new InstanceVariableCountManager();
        HashMap<String, byte[]> safeClasses = new HashMap<String, byte[]>();
        Set<String> preRenameUserClassAndInterfaceSet = classHierarchy.getPreRenameUserDefinedClassesAndInterfaces();
        Set<String> preRenameUserDefinedClasses = classHierarchy.getPreRenameUserDefinedClassesOnly(classRenamer);
        PreRenameClassAccessRules preRenameClassAccessRules = new PreRenameClassAccessRules(preRenameUserDefinedClasses, preRenameUserClassAndInterfaceSet);
        NamespaceMapper namespaceMapper = new NamespaceMapper(preRenameClassAccessRules);
        for (String name : inputClasses.keySet()) {
            RuntimeAssertionError.assertTrue(!name.contains("/"));
            int parsingOptions = preserveDebuggability ? 0 : 2;
            try {
                byte[] classBytecode = inputClasses.get(name);
                ClassFileInfoBuilder.ClassFileInfo classFileInfo = ClassFileInfoBuilder.getDirectClassFileInfo(classBytecode);
                if (classFileInfo.definedMethods.size() > 511) {
                    throw RejectedClassException.maximumMethodCountExceeded(name);
                }
                if (classFileInfo.constantPoolEntryCount > 4095) {
                    throw RejectedClassException.maximumConstantPoolEntriesExceeded(name);
                }
                for (ClassFileInfoBuilder.MethodCode methodCode : classFileInfo.definedMethods) {
                    if (methodCode.codeLength > 4095) {
                        throw RejectedClassException.maximumMethodSizeExceeded(name);
                    }
                    if (methodCode.exceptionTableSize > 15) {
                        throw RejectedClassException.maximumExceptionTableEntriesExceeded(name);
                    }
                    if (methodCode.maxStack > 63) {
                        throw RejectedClassException.maximumOperandStackDepthExceeded(name);
                    }
                    if (methodCode.maxLocals <= 63) continue;
                    throw RejectedClassException.maximumLocalVariableCountExceeded(name);
                }
                InstanceVariableCountingVisitor variableCounter = new InstanceVariableCountingVisitor(manager);
                byte[] bytecode = new ClassToolchain.Builder(classBytecode, parsingOptions).addNextVisitor(new RejectionClassVisitor(preRenameClassAccessRules, namespaceMapper, preserveDebuggability)).addNextVisitor(new LoopingExceptionStrippingVisitor()).addNextVisitor(variableCounter).addNextVisitor(new UserClassMappingVisitor(namespaceMapper, preserveDebuggability)).addWriter(new TypeAwareClassWriter(3, classHierarchy, classRenamer)).build().runAndGetBytecode();
                String mappedName = DebugNameResolver.getUserPackageDotPrefix(name, preserveDebuggability);
                safeClasses.put(mappedName, bytecode);
            }
            catch (Exception e) {
                throw new RejectedClassException(e.getMessage());
            }
        }
        manager.verifyAllCounts();
        return safeClasses;
    }

    public Transformer(IExternalState es, AvmConfiguration conf) {
        this.es = es;
        this.conf = conf;
    }

    public void transform() {
        try {
            this.transformImpl();
        }
        catch (ZipException e) {
            throw new GenericPredefinedException(15, (Throwable)e);
        }
        catch (IOException e) {
            throw new IllegalFormatException(e);
        }
    }

    private void transformImpl() throws IOException {
        byte[] codeBytes = this.es.getCode();
        this.apisBytes = JarBuilder.getAPIsBytesFromJAR(codeBytes);
        if (this.apisBytes == null) {
            throw new IllegalFormatException("bad APIS");
        }
        RawDappModule rawDapp = RawDappModule.readFromJar(codeBytes, this.conf.preserveDebuggability);
        if (!rawDapp.classes.containsKey(rawDapp.mainClass)) {
            throw new IllegalFormatException("no main class");
        }
        ClassHierarchyForest dappClassesForest = rawDapp.classHierarchyForest;
        Map<String, byte[]> transformedClasses = Transformer.transformClasses(rawDapp.classes, dappClassesForest, rawDapp.classHierarchy, rawDapp.classRenamer, this.conf.preserveDebuggability);
        this.bootstrapModule = TransformedDappModule.fromTransformedClasses(transformedClasses, rawDapp.mainClass);
        Map<String, byte[]> immortalClasses = Transformer.stripClinitFromClasses(transformedClasses);
        ImmortalDappModule immortalDapp = ImmortalDappModule.fromImmortalClasses(immortalClasses, this.bootstrapModule.mainClass, this.apisBytes);
        this.transformedCodeBytes = immortalDapp.createJar(this.es.getBlockTimestamp());
    }

    public TransformedDappModule getBootstrapModule() {
        return this.bootstrapModule;
    }

    public byte[] getTransformedCodeBytes() {
        return this.transformedCodeBytes;
    }

    public byte[] getAPIsBytes() {
        return this.apisBytes;
    }
}

