/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.struct;

import foundation.icon.ee.struct.ClassPropertyMemberInfoCollector;
import foundation.icon.ee.struct.PropertyMember;
import foundation.icon.ee.util.ASM;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.objectweb.asm.Type;

public class ClassPropertyMemberInfo {
    private final Type type;
    private final Type superType;
    private final boolean isCreatable;
    private final List<PropertyMember> fields;
    private final List<PropertyMember> getters;
    private final List<PropertyMember> setters;

    public ClassPropertyMemberInfo(Type type, Type superType, boolean isCreatable, List<PropertyMember> fields, List<PropertyMember> getters, List<PropertyMember> setters) {
        this.type = type;
        this.superType = superType;
        this.isCreatable = isCreatable;
        this.fields = fields;
        this.getters = getters;
        this.setters = setters;
    }

    public Type getType() {
        return this.type;
    }

    public Type getSuperType() {
        return this.superType;
    }

    public boolean isCreatable() {
        return this.isCreatable;
    }

    public List<PropertyMember> getFields() {
        return this.fields;
    }

    public List<PropertyMember> getGetters() {
        return this.getters;
    }

    public List<PropertyMember> getSetters() {
        return this.setters;
    }

    public static ClassPropertyMemberInfo fromBytes(byte[] classBytes) {
        return ASM.accept(classBytes, new ClassPropertyMemberInfoCollector()).getClassPropertyInfo();
    }

    public static Map<Type, ClassPropertyMemberInfo> map(Map<String, byte[]> classMap) {
        HashMap<Type, ClassPropertyMemberInfo> cpiMap = new HashMap<Type, ClassPropertyMemberInfo>();
        for (Map.Entry<String, byte[]> e : classMap.entrySet()) {
            ClassPropertyMemberInfo cpi = ClassPropertyMemberInfo.fromBytes(e.getValue());
            cpiMap.put(cpi.getType(), cpi);
        }
        return cpiMap;
    }
}

