/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.struct;

import foundation.icon.ee.struct.FieldProperty;
import foundation.icon.ee.struct.ReadableMethodProperty;
import foundation.icon.ee.struct.ReadableProperty;
import foundation.icon.ee.struct.WritableMethodProperty;
import foundation.icon.ee.struct.WritableProperty;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import s.java.lang.Boolean;

public interface Property {
    public static String decapitalize(String s) {
        if (s.length() > 1 && Character.isUpperCase(s.charAt(0)) && Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        return Character.toLowerCase(s.charAt(0)) + s.substring(1);
    }

    public static String capitalize(String s) {
        if (s.length() > 1 && Character.isLowerCase(s.charAt(0)) && Character.isUpperCase(s.charAt(1))) {
            return s;
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }

    public static WritableProperty getWritableProperty(Class<?> cls, String property) {
        String setter = "avm_set" + Property.capitalize(property);
        while (cls != null && cls.getName().startsWith("u.")) {
            Method[] ma = (Method[])Arrays.stream(cls.getDeclaredMethods()).filter(m -> m.getName().equals(setter) && m.getParameterCount() == 1 && m.getReturnType() == Void.TYPE && !Modifier.isStatic(m.getModifiers()) && Modifier.isPublic(m.getModifiers())).toArray(Method[]::new);
            if (ma.length == 1) {
                return new WritableMethodProperty(ma[0]);
            }
            try {
                Field f = cls.getDeclaredField("avm_" + property);
                if (!Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers())) {
                    return new FieldProperty(f);
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            cls = cls.getSuperclass();
        }
        return null;
    }

    public static boolean isGetter(Method m) {
        if (!Modifier.isPublic(m.getModifiers()) || Modifier.isStatic(m.getModifiers()) || m.getParameterCount() != 0) {
            return false;
        }
        if ((m.getReturnType() == java.lang.Boolean.TYPE || m.getReturnType() == Boolean.class) && m.getName().startsWith("avm_is") && m.getName().length() > 6) {
            return true;
        }
        return m.getReturnType() != Void.TYPE && m.getName().startsWith("avm_get") && m.getName().length() > 7;
    }

    public static List<ReadableProperty> getReadableProperties(Object obj) {
        ArrayList<ReadableProperty> props = new ArrayList<ReadableProperty>();
        for (Class<?> cls = obj.getClass(); cls != null && cls.getName().startsWith("u."); cls = cls.getSuperclass()) {
            Arrays.stream(cls.getDeclaredMethods()).filter(Property::isGetter).map(ReadableMethodProperty::new).forEachOrdered(props::add);
            Arrays.stream(cls.getDeclaredFields()).filter(f -> !Modifier.isStatic(f.getModifiers()) && Modifier.isPublic(f.getModifiers())).filter(f -> {
                for (ReadableProperty p : props) {
                    if (!f.getName().equals(p.getName())) continue;
                    return false;
                }
                return true;
            }).map(FieldProperty::new).forEachOrdered(props::add);
        }
        return props;
    }

    public String getName();

    public Class<?> getType();
}

