/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.types;

import java.math.BigInteger;
import java.util.Map;

public class StepCost {
    public static final String GET = "get";
    public static final String SET = "set";
    public static final String DELETE = "delete";
    public static final String LOG = "log";
    public static final String GET_BASE = "getBase";
    public static final String SET_BASE = "setBase";
    public static final String DELETE_BASE = "deleteBase";
    public static final String LOG_BASE = "logBase";
    private final Map<String, BigInteger> costMap;

    public StepCost(Map<String, BigInteger> costMap) {
        this.costMap = costMap;
    }

    public boolean has(String key) {
        return this.costMap.containsKey(key);
    }

    public int value(String key) {
        return this.costMap.getOrDefault(key, BigInteger.ZERO).intValue();
    }

    public int get() {
        return this.value(GET);
    }

    public int set() {
        return this.value(SET);
    }

    public int delete() {
        return this.value(DELETE);
    }

    public int log() {
        return this.value(LOG);
    }

    public int getBase() {
        return this.value(GET_BASE);
    }

    public int setBase() {
        return this.value(SET_BASE);
    }

    public int deleteBase() {
        return this.value(DELETE_BASE);
    }

    public int logBase() {
        return this.value(LOG_BASE);
    }

    public int replaceBase() {
        return (this.setBase() + this.deleteBase()) / 2;
    }

    public int getStorage(int prevLen) {
        return this.getBase() + prevLen * this.get();
    }

    public int setStorageSet(int newLen) {
        return this.setBase() + newLen * this.set();
    }

    public int setStorageReplace(int prevLen, int newLen) {
        return this.replaceBase() + prevLen * this.delete() + newLen * this.set();
    }

    public int setStorageDelete(int prevLen) {
        return this.deleteBase() + prevLen * this.delete();
    }

    public int eventLog(int len) {
        return this.logBase() + len * this.log();
    }
}

