/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.util;

import java.util.AbstractMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;

public class LinkedHashMultimap<K, V> {
    private final LHSet lru = new LHSet();
    private final HashMap<K, Set<V>> map = new HashMap();

    protected boolean removeEldestEntry(K key, V value) {
        return false;
    }

    private V removeFromMultimap(K k, V v) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            return null;
        }
        boolean res = set.remove(v);
        if (set.isEmpty()) {
            this.map.remove(k);
        }
        return (V)(res ? v : null);
    }

    public int size() {
        return this.lru.size();
    }

    public V remove(K k, V v) {
        if (this.removeFromMultimap(k, v) != null) {
            AbstractMap.SimpleEntry<K, V> w = new AbstractMap.SimpleEntry<K, V>(k, v);
            this.lru.remove(w);
            return v;
        }
        return null;
    }

    public V remove(K k, Function<Set<V>, V> selector) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            return null;
        }
        return this.remove(k, selector.apply(set));
    }

    public void put(K k, V v) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            HashSet<V> newSet = new HashSet<V>();
            newSet.add(v);
            this.map.put(k, newSet);
        } else {
            set.add(v);
        }
        AbstractMap.SimpleEntry<K, V> w = new AbstractMap.SimpleEntry<K, V>(k, v);
        this.lru.put(w, w);
    }

    public boolean contains(K k, V v) {
        Set<V> set = this.map.get(k);
        if (set == null) {
            return false;
        }
        return set.contains(v);
    }

    private class LHSet
    extends LinkedHashMap<AbstractMap.SimpleEntry<K, V>, AbstractMap.SimpleEntry<K, V>> {
        LHSet() {
            super(16, 0.75f, true);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<AbstractMap.SimpleEntry<K, V>, AbstractMap.SimpleEntry<K, V>> eldest) {
            AbstractMap.SimpleEntry e = eldest.getValue();
            boolean res = LinkedHashMultimap.this.removeEldestEntry(e.getKey(), e.getValue());
            if (res) {
                LinkedHashMultimap.this.removeFromMultimap(e.getKey(), e.getValue());
            }
            return res;
        }
    }
}

