/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.util;

import a.ByteArray;
import foundation.icon.ee.io.RLPDataReader;
import foundation.icon.ee.io.RLPDataWriter;
import i.IObject;
import java.nio.charset.StandardCharsets;
import p.score.Address;
import pi.ObjectReaderImpl;
import pi.ObjectWriterImpl;
import s.java.lang.Boolean;
import s.java.lang.Byte;
import s.java.lang.Character;
import s.java.lang.Class;
import s.java.lang.Integer;
import s.java.lang.Long;
import s.java.lang.Short;
import s.java.lang.String;
import s.java.math.BigInteger;

public class ValueCodec {
    public static byte[] encode(IObject o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Byte) {
            return java.math.BigInteger.valueOf(((Byte)o).getUnderlying()).toByteArray();
        }
        if (o instanceof Short) {
            return java.math.BigInteger.valueOf(((Short)o).getUnderlying()).toByteArray();
        }
        if (o instanceof Integer) {
            return java.math.BigInteger.valueOf(((Integer)o).getUnderlying()).toByteArray();
        }
        if (o instanceof Long) {
            return java.math.BigInteger.valueOf(((Long)o).getUnderlying()).toByteArray();
        }
        if (o instanceof BigInteger) {
            return ((BigInteger)o).getUnderlying().toByteArray();
        }
        if (o instanceof Character) {
            return java.math.BigInteger.valueOf(((Character)o).getUnderlying()).toByteArray();
        }
        if (o instanceof Boolean) {
            return java.math.BigInteger.valueOf(((Boolean)o).getUnderlying() ? 1L : 0L).toByteArray();
        }
        if (o instanceof Address) {
            return ((Address)o).toByteArray();
        }
        if (o instanceof String) {
            return ((String)o).getUnderlying().getBytes(StandardCharsets.UTF_8);
        }
        if (o instanceof ByteArray) {
            return (byte[])((ByteArray)o).getUnderlying().clone();
        }
        try (ObjectWriterImpl owi = new ObjectWriterImpl(new RLPDataWriter());){
            owi.avm_write(o);
            byte[] byArray = owi.toByteArray();
            return byArray;
        }
    }

    public static IObject decode(byte[] raw, Class<?> cls) {
        if (raw == null) {
            return null;
        }
        java.lang.Class<?> c = cls.getRealClass();
        if (c == Byte.class) {
            return Byte.avm_valueOf(new java.math.BigInteger(raw).byteValue());
        }
        if (c == Short.class) {
            return Short.avm_valueOf(new java.math.BigInteger(raw).shortValue());
        }
        if (c == Integer.class) {
            return Integer.avm_valueOf(new java.math.BigInteger(raw).intValue());
        }
        if (c == Long.class) {
            return Long.avm_valueOf(new java.math.BigInteger(raw).longValue());
        }
        if (c == BigInteger.class) {
            return BigInteger.newWithCharge(new java.math.BigInteger(raw));
        }
        if (c == Character.class) {
            return Character.avm_valueOf((char)new java.math.BigInteger(raw).intValue());
        }
        if (c == Boolean.class) {
            return Boolean.avm_valueOf(new java.math.BigInteger(raw).intValue() != 0);
        }
        if (c == Address.class) {
            return Address.newWithCharge(raw);
        }
        if (c == String.class) {
            return String.newWithCharge(new java.lang.String(raw, StandardCharsets.UTF_8));
        }
        if (c == ByteArray.class) {
            return ByteArray.newWithCharge((byte[])raw.clone());
        }
        try (ObjectReaderImpl ori = new ObjectReaderImpl(new RLPDataReader(raw));){
            Object obj = ori.avm_read(cls);
            return obj;
        }
    }
}

