/*
 * Decompiled with CFR 0.152.
 */
package foundation.icon.ee.util.xxhash;

import foundation.icon.ee.util.xxhash.Access;
import foundation.icon.ee.util.xxhash.LongHashFunction;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class XxHash {
    private static final long P1 = -7046029288634856825L;
    private static final long P2 = -4417276706812531889L;
    private static final long P3 = 1609587929392839161L;
    private static final long P4 = -8796714831421723037L;
    private static final long P5 = 2870177450012600261L;

    public static byte[] hash128(byte[] msg) {
        ByteBuffer buf = ByteBuffer.allocate(16);
        ByteOrder oder = buf.order();
        buf.order(ByteOrder.LITTLE_ENDIAN);
        buf.asLongBuffer().put(LongHashFunction.xx(0L).hashBytes(msg)).put(LongHashFunction.xx(1L).hashBytes(msg));
        buf.position(buf.position() + 16);
        buf.order(oder);
        return buf.array();
    }

    static <T> long xxHash64(long seed, T input, Access<T> access, long off, long length) {
        long hash;
        long remaining = length;
        if (remaining >= 32L) {
            long v1 = seed + -7046029288634856825L + -4417276706812531889L;
            long v2 = seed + -4417276706812531889L;
            long v3 = seed;
            long v4 = seed - -7046029288634856825L;
            do {
                v1 += access.i64(input, off) * -4417276706812531889L;
                v1 = Long.rotateLeft(v1, 31);
                v1 *= -7046029288634856825L;
                v2 += access.i64(input, off + 8L) * -4417276706812531889L;
                v2 = Long.rotateLeft(v2, 31);
                v2 *= -7046029288634856825L;
                v3 += access.i64(input, off + 16L) * -4417276706812531889L;
                v3 = Long.rotateLeft(v3, 31);
                v4 += access.i64(input, off + 24L) * -4417276706812531889L;
                v4 = Long.rotateLeft(v4, 31);
                v4 *= -7046029288634856825L;
                off += 32L;
            } while ((remaining -= 32L) >= 32L);
            hash = Long.rotateLeft(v1, 1) + Long.rotateLeft(v2, 7) + Long.rotateLeft(v3, 12) + Long.rotateLeft(v4, 18);
            v1 *= -4417276706812531889L;
            v1 = Long.rotateLeft(v1, 31);
            hash ^= (v1 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v2 *= -4417276706812531889L;
            v2 = Long.rotateLeft(v2, 31);
            hash ^= (v2 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v3 *= -4417276706812531889L;
            v3 = Long.rotateLeft(v3, 31);
            hash ^= (v3 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
            v4 *= -4417276706812531889L;
            v4 = Long.rotateLeft(v4, 31);
            hash ^= (v4 *= -7046029288634856825L);
            hash = hash * -7046029288634856825L + -8796714831421723037L;
        } else {
            hash = seed + 2870177450012600261L;
        }
        hash += length;
        while (remaining >= 8L) {
            long k1 = access.i64(input, off);
            k1 *= -4417276706812531889L;
            k1 = Long.rotateLeft(k1, 31);
            hash ^= (k1 *= -7046029288634856825L);
            hash = Long.rotateLeft(hash, 27) * -7046029288634856825L + -8796714831421723037L;
            off += 8L;
            remaining -= 8L;
        }
        if (remaining >= 4L) {
            hash ^= access.u32(input, off) * -7046029288634856825L;
            hash = Long.rotateLeft(hash, 23) * -4417276706812531889L + 1609587929392839161L;
            off += 4L;
            remaining -= 4L;
        }
        while (remaining != 0L) {
            hash ^= (long)access.u8(input, off) * 2870177450012600261L;
            hash = Long.rotateLeft(hash, 11) * -7046029288634856825L;
            --remaining;
            ++off;
        }
        return XxHash.finalize(hash);
    }

    private static long finalize(long hash) {
        hash ^= hash >>> 33;
        hash *= -4417276706812531889L;
        hash ^= hash >>> 29;
        hash *= 1609587929392839161L;
        hash ^= hash >>> 32;
        return hash;
    }

    static LongHashFunction asLongHashFunctionWithSeed(long seed) {
        return new AsLongHashFunctionSeeded(seed);
    }

    private static class AsLongHashFunctionSeeded
    extends AsLongHashFunction {
        private static final long serialVersionUID = 0L;
        private final long seed;

        private AsLongHashFunctionSeeded(long seed) {
            this.seed = seed;
        }

        @Override
        public long seed() {
            return this.seed;
        }
    }

    private static class AsLongHashFunction
    extends LongHashFunction {
        private static final long serialVersionUID = 0L;

        private AsLongHashFunction() {
        }

        public long seed() {
            return 0L;
        }

        @Override
        public <T> long hash(T input, Access<T> access, long off, long len) {
            long seed = this.seed();
            return XxHash.xxHash64(seed, input, access.byteOrder(input, ByteOrder.LITTLE_ENDIAN), off, len);
        }
    }
}

