/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ArrayClassNameMapper {
    private static final Map<String, String> ORIGINAL_TO_CLASS_WRAPPER_MAP = Collections.unmodifiableMap(ArrayClassNameMapper.initializeOriginalNameToClassWrapperMap());
    private static final Map<String, String> CLASS_WRAPPER_TO_ORIGINAL_MAP = Collections.unmodifiableMap(ArrayClassNameMapper.initializeClassWrapperToOriginalMap());
    private static final Map<String, String> INTERFACE_WRAPPER_MAP = Collections.unmodifiableMap(ArrayClassNameMapper.initializeInterfacedWrapperMaps());

    private static HashMap<String, String> initializeClassWrapperToOriginalMap() {
        HashMap<String, String> classWrapperMap = new HashMap<String, String>();
        classWrapperMap.put("a/IntArray", "[I");
        classWrapperMap.put("a/ByteArray", "[B");
        classWrapperMap.put("a/BooleanArray", "[Z");
        classWrapperMap.put("a/CharArray", "[C");
        classWrapperMap.put("a/FloatArray", "[F");
        classWrapperMap.put("a/ShortArray", "[S");
        classWrapperMap.put("a/LongArray", "[J");
        classWrapperMap.put("a/DoubleArray", "[D");
        classWrapperMap.put("a/ObjectArray", "[Ljava/lang/Object");
        return classWrapperMap;
    }

    private static HashMap<String, String> initializeInterfacedWrapperMaps() {
        HashMap<String, String> interfaceWrapperMap = new HashMap<String, String>();
        interfaceWrapperMap.put("[Li/IObject", "i/IObjectArray");
        interfaceWrapperMap.put("La/ObjectArray", "i/IObjectArray");
        interfaceWrapperMap.put("[Ls/java/lang/Object", "i/IObjectArray");
        return interfaceWrapperMap;
    }

    private static HashMap<String, String> initializeOriginalNameToClassWrapperMap() {
        HashMap<String, String> wrapperToOriginalMap = ArrayClassNameMapper.initializeClassWrapperToOriginalMap();
        HashMap<String, String> reverseMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : wrapperToOriginalMap.entrySet()) {
            reverseMap.put(entry.getValue(), entry.getKey());
        }
        reverseMap.put("[Ls/java/lang/Object", "a/ObjectArray");
        reverseMap.put("[Li/IObject", "a/ObjectArray");
        return reverseMap;
    }

    public static String getClassWrapper(String desc) {
        return ORIGINAL_TO_CLASS_WRAPPER_MAP.get(desc);
    }

    public static String getInterfaceWrapper(String desc) {
        return INTERFACE_WRAPPER_MAP.get(desc);
    }

    public static String getOriginalNameFromWrapper(String wrapperClassName) {
        return CLASS_WRAPPER_TO_ORIGINAL_MAP.get(wrapperClassName);
    }
}

