/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import java.util.HashSet;
import java.util.Set;
import org.aion.avm.NameStyle;
import org.aion.avm.core.ClassRenamer;

public final class ClassRenamerBuilder {
    private final boolean preserveDebuggability;
    private final NameStyle style;
    private Set<String> jclExceptions = new HashSet<String>();
    private ClassRenamer.NameCategory jclExceptionsCategory = ClassRenamer.NameCategory.PRE_RENAME;
    private Set<String> userDefinedClasses = new HashSet<String>();
    private ClassRenamer.NameCategory userDefinedClassesCategory = ClassRenamer.NameCategory.PRE_RENAME;
    private Set<ClassRenamer.ClassCategory> prohibitedClasses = new HashSet<ClassRenamer.ClassCategory>();

    public ClassRenamerBuilder(NameStyle style, boolean preserveDebuggability) {
        this.style = style;
        this.preserveDebuggability = preserveDebuggability;
    }

    public ClassRenamerBuilder loadPreRenameJclExceptionClasses(Set<String> jclExceptions) {
        this.jclExceptions = jclExceptions;
        this.jclExceptionsCategory = ClassRenamer.NameCategory.PRE_RENAME;
        return this;
    }

    public ClassRenamerBuilder loadPostRenameJclExceptionClasses(Set<String> jclExceptions) {
        this.jclExceptions = jclExceptions;
        this.jclExceptionsCategory = ClassRenamer.NameCategory.POST_RENAME;
        return this;
    }

    public ClassRenamerBuilder loadPreRenameUserDefinedClasses(Set<String> userDefinedClasses) {
        this.userDefinedClasses = userDefinedClasses;
        this.userDefinedClassesCategory = ClassRenamer.NameCategory.PRE_RENAME;
        return this;
    }

    public ClassRenamerBuilder loadPostRenameUserDefinedClasses(Set<String> userDefinedClasses) {
        this.userDefinedClasses = userDefinedClasses;
        this.userDefinedClassesCategory = ClassRenamer.NameCategory.POST_RENAME;
        return this;
    }

    public ClassRenamerBuilder prohibitJclClasses() {
        this.prohibitedClasses.add(ClassRenamer.ClassCategory.JCL);
        return this;
    }

    public ClassRenamerBuilder prohibitApiClasses() {
        this.prohibitedClasses.add(ClassRenamer.ClassCategory.API);
        return this;
    }

    public ClassRenamerBuilder prohibitExceptionWrappers() {
        this.prohibitedClasses.add(ClassRenamer.ClassCategory.EXCEPTION_WRAPPER);
        return this;
    }

    public ClassRenamerBuilder prohibitPreciseArrayTypes() {
        this.prohibitedClasses.add(ClassRenamer.ClassCategory.PRECISE_ARRAY);
        return this;
    }

    public ClassRenamerBuilder prohibitUnifyingArrayTypes() {
        this.prohibitedClasses.add(ClassRenamer.ClassCategory.UNIFYING_ARRAY);
        return this;
    }

    public ClassRenamerBuilder prohibitUserClasses() {
        this.prohibitedClasses.add(ClassRenamer.ClassCategory.USER);
        return this;
    }

    public ClassRenamer build() {
        return new ClassRenamer(this.preserveDebuggability, this.style, this.jclExceptions, this.jclExceptionsCategory, this.userDefinedClasses, this.userDefinedClassesCategory, this.prohibitedClasses);
    }
}

