/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.aion.avm.core.NodeEnvironment;
import org.aion.avm.core.classloading.AvmClassLoader;
import org.aion.avm.core.persistence.LoadedDApp;
import org.aion.avm.core.types.ImmortalDappModule;
import org.aion.avm.core.types.TransformedDappModule;
import org.aion.avm.core.util.Helpers;
import org.aion.avm.utilities.JarBuilder;

public class DAppLoader {
    public static LoadedDApp loadFromGraph(byte[] immortalDappJar, boolean preserveDebuggability) throws IOException {
        if (immortalDappJar == null || immortalDappJar.length == 0) {
            return null;
        }
        ImmortalDappModule app = ImmortalDappModule.readFromJar(immortalDappJar);
        Map<String, byte[]> allClasses = Helpers.mapIncludingHelperBytecode(app.classes, Helpers.loadDefaultHelperBytecode());
        AvmClassLoader classLoader = NodeEnvironment.singleton.createInvocationClassLoader(allClasses);
        List<Class<?>> aphabeticalContractClasses = Helpers.getAlphabeticalUserTransformedDappClasses(classLoader, app.classes.keySet());
        SplitClasses splitClasses = SplitClasses.splitAllSavedClasses(aphabeticalContractClasses);
        byte[] apis = JarBuilder.getAPIsBytesFromJAR(immortalDappJar);
        if (apis == null) {
            return null;
        }
        return new LoadedDApp(classLoader, splitClasses.sortedUserClasses, splitClasses.constantClass, app.mainClass, apis, preserveDebuggability);
    }

    public static LoadedDApp fromTransformed(TransformedDappModule app, byte[] apis, boolean preserveDebuggability) {
        Map<String, byte[]> allClasses = Helpers.mapIncludingHelperBytecode(app.classes, Helpers.loadDefaultHelperBytecode());
        AvmClassLoader classLoader = NodeEnvironment.singleton.createInvocationClassLoader(allClasses);
        List<Class<?>> aphabeticalContractClasses = Helpers.getAlphabeticalUserTransformedDappClasses(classLoader, app.classes.keySet());
        SplitClasses splitClasses = SplitClasses.splitAllSavedClasses(aphabeticalContractClasses);
        return new LoadedDApp(classLoader, splitClasses.sortedUserClasses, splitClasses.constantClass, app.mainClass, apis, preserveDebuggability);
    }

    private static class SplitClasses {
        public final Class<?>[] sortedUserClasses;
        public final Class<?> constantClass;

        public static SplitClasses splitAllSavedClasses(List<Class<?>> classes) {
            Class[] sortedUserClasses = (Class[])classes.stream().filter(c -> !"C".equals(c.getName())).sorted((f1, f2) -> f1.getName().compareTo(f2.getName())).toArray(Class[]::new);
            Class constantClass = ((Class[])classes.stream().filter(c -> "C".equals(c.getName())).toArray(Class[]::new))[0];
            return new SplitClasses(sortedUserClasses, constantClass);
        }

        private SplitClasses(Class<?>[] sortedUserClasses, Class<?> constantClass) {
            this.sortedUserClasses = sortedUserClasses;
            this.constantClass = constantClass;
        }
    }
}

