/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import foundation.icon.ee.types.Address;
import foundation.icon.ee.types.ObjectGraph;
import foundation.icon.ee.types.Result;
import foundation.icon.ee.types.StepCost;
import java.io.IOException;
import java.math.BigInteger;
import java.util.function.IntConsumer;

public interface IExternalState {
    public static final int OPTION_READ_ONLY = 1;
    public static final int OPTION_TRACE = 2;
    public static final long REVISION_PURGE_ENUM_CACHE = 0x400000L;

    public String getCodeID();

    public byte[] getCode();

    public byte[] getTransformedCode() throws IOException;

    public void setTransformedCode(byte[] var1);

    public byte[] getContractID();

    public void putObjectGraph(ObjectGraph var1);

    public ObjectGraph getObjectGraph();

    public byte[] getObjectGraphHash();

    public int getNextHash();

    public void putStorage(byte[] var1, byte[] var2, IntConsumer var3);

    public boolean waitForCallback();

    public void waitForCallbacks();

    public byte[] getStorage(byte[] var1);

    public BigInteger getBalance(Address var1);

    public long getBlockHeight();

    public long getBlockTimestamp();

    public Address getOwner();

    public void event(byte[][] var1, byte[][] var2);

    public int getFeeSharingProportion();

    public void setFeeSharingProportion(int var1);

    public Result call(Address var1, BigInteger var2, long var3, String var5, Object var6);

    public int getOption();

    default public boolean isReadOnly() {
        return (this.getOption() & 1) != 0;
    }

    default public boolean isTrace() {
        return (this.getOption() & 2) != 0;
    }

    public StepCost getStepCost();

    public long getRevision();

    default public boolean purgeEnumCache() {
        return (this.getRevision() & 0x400000L) != 0L;
    }

    default public boolean forceEnumCache() {
        return !this.purgeEnumCache();
    }
}

