/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core;

import i.RuntimeAssertionError;
import org.aion.avm.ArrayUtil;
import org.aion.avm.NameStyle;
import org.aion.avm.core.ClassRenamer;
import org.aion.avm.core.exceptionwrapping.ExceptionWrapperNameMapper;
import org.aion.avm.core.types.ClassHierarchy;
import org.aion.avm.core.types.CommonType;

public final class PlainTypeSuperResolver {
    private final ClassHierarchy classHierarchy;
    private final ClassRenamer classRenamer;

    public PlainTypeSuperResolver(ClassHierarchy classHierarchy, ClassRenamer classRenamer) {
        if (classHierarchy == null) {
            throw new NullPointerException("Cannot construct PlainTypeSuperResolver with null class hierarchy.");
        }
        if (classRenamer == null) {
            throw new NullPointerException("Cannot construct PlainTypeSuperResolver with null class renamer.");
        }
        this.classHierarchy = classHierarchy;
        this.classRenamer = classRenamer;
    }

    public String getTightestSuperClassIfGivenPlainType(String type1dotName, String type2dotName) {
        RuntimeAssertionError.assertTrue(type1dotName != null);
        RuntimeAssertionError.assertTrue(type2dotName != null);
        boolean type1isPlain = PlainTypeSuperResolver.isPlainType(type1dotName);
        boolean type2isPlain = PlainTypeSuperResolver.isPlainType(type2dotName);
        if (type1isPlain && type2isPlain) {
            return this.findSuperOfTwoPlainTypes(type1dotName, type2dotName);
        }
        if (type1isPlain || type2isPlain) {
            return this.findSuperOfOnePlainTypeOneNonPlainType(type1dotName, type2dotName);
        }
        return null;
    }

    private String findSuperOfTwoPlainTypes(String plain1dotName, String plain2dotName) {
        boolean plain1isPreRename = this.classRenamer.isPreRename(plain1dotName);
        boolean plain2isPreRename = this.classRenamer.isPreRename(plain2dotName);
        if (plain1isPreRename && plain2isPreRename) {
            String plain2renamed;
            String plain1renamed = this.classRenamer.toPostRename(plain1dotName, ClassRenamer.ArrayType.PRECISE_TYPE);
            String postRenameSuper = this.classHierarchy.getTightestCommonSuperClass(plain1renamed, plain2renamed = this.classRenamer.toPostRename(plain2dotName, ClassRenamer.ArrayType.PRECISE_TYPE));
            if (postRenameSuper == null) {
                return CommonType.JAVA_LANG_OBJECT.dotName;
            }
            return this.classRenamer.toPreRename(postRenameSuper);
        }
        if (!plain1isPreRename && !plain2isPreRename) {
            String commonSuper = this.classHierarchy.getTightestCommonSuperClass(plain1dotName, plain2dotName);
            if (commonSuper == null) {
                return CommonType.I_OBJECT.dotName;
            }
            return commonSuper;
        }
        return CommonType.JAVA_LANG_OBJECT.dotName;
    }

    private String findSuperOfOnePlainTypeOneNonPlainType(String plain1dotName, String plain2dotName) {
        String plainDotName = PlainTypeSuperResolver.isPlainType(plain1dotName) ? plain1dotName : plain2dotName;
        String nonPlainDotName = plainDotName.equals(plain1dotName) ? plain2dotName : plain1dotName;
        boolean plainIsPreRename = this.classRenamer.isPreRename(plainDotName);
        boolean nonPlainIsPreRename = this.classRenamer.isPreRename(nonPlainDotName);
        if (plainIsPreRename) {
            boolean nonPlainIsException;
            String plainPostRename = this.classRenamer.toPostRename(plainDotName, ClassRenamer.ArrayType.PRECISE_TYPE);
            boolean plainIsException = this.classHierarchy.isDescendantOfClass(plainPostRename, CommonType.SHADOW_THROWABLE.dotName);
            boolean bl = nonPlainIsException = nonPlainDotName.equals(CommonType.JAVA_LANG_THROWABLE.dotName) || ExceptionWrapperNameMapper.isExceptionWrapperDotName(nonPlainDotName);
            if (plainIsException && nonPlainIsException) {
                return CommonType.JAVA_LANG_THROWABLE.dotName;
            }
            return CommonType.JAVA_LANG_OBJECT.dotName;
        }
        if (nonPlainIsPreRename) {
            return CommonType.JAVA_LANG_OBJECT.dotName;
        }
        boolean plainIsInterface = this.classHierarchy.postRenameTypeIsInterface(plainDotName);
        if (ExceptionWrapperNameMapper.isExceptionWrapperDotName(nonPlainDotName)) {
            return CommonType.JAVA_LANG_OBJECT.dotName;
        }
        if (ArrayUtil.isPostRenameUnifyingTypeObjectArray(NameStyle.DOT_NAME, nonPlainDotName)) {
            return CommonType.I_OBJECT.dotName;
        }
        if (ArrayUtil.isPostRenameConcreteTypeObjectArray(NameStyle.DOT_NAME, nonPlainDotName)) {
            return plainIsInterface ? CommonType.I_OBJECT.dotName : CommonType.SHADOW_OBJECT.dotName;
        }
        if (ArrayUtil.isPostRenamePrimitiveArray(NameStyle.DOT_NAME, nonPlainDotName)) {
            return plainIsInterface ? CommonType.I_OBJECT.dotName : CommonType.SHADOW_OBJECT.dotName;
        }
        throw RuntimeAssertionError.unreachable("Expected an exception wrapper or post-rename array: " + nonPlainDotName);
    }

    private static boolean isPlainType(String dotName) {
        return !ArrayUtil.isArray(NameStyle.DOT_NAME, dotName) && !ExceptionWrapperNameMapper.isExceptionWrapperDotName(dotName);
    }
}

