/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.arraywrapping;

import i.RuntimeAssertionError;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.aion.avm.ArrayClassNameMapper;
import org.aion.avm.ArrayUtil;
import org.aion.avm.NameStyle;
import org.aion.avm.core.rejection.RejectedClassException;
import org.aion.avm.core.util.DescriptorParser;

public class ArrayNameMapper {
    private static Pattern IOBJECT_INTERFACE_FORMAT = Pattern.compile("[_]{2,}Li/IObject");
    private static Set<String> PRIMITIVES = Stream.of("I", "J", "Z", "B", "S", "D", "F", "C").collect(Collectors.toSet());
    private static Pattern OBJECT_INTERFACE_FORMAT = Pattern.compile("[_\\[]{2,}Ls/java/lang/Object");

    static String updateMethodDesc(String desc) {
        return ArrayNameMapper.mapDescriptor(desc);
    }

    public static String getOriginalNameOf(String array) {
        if (ArrayUtil.isPostRenamePrimitiveArray(NameStyle.SLASH_NAME, array)) {
            return ArrayNameMapper.getOriginalNameOfPrimitiveArray(array);
        }
        if (ArrayUtil.isPostRenameObjectArray(NameStyle.SLASH_NAME, array)) {
            return ArrayNameMapper.getOriginalNameOfObjectArray(array);
        }
        throw RuntimeAssertionError.unreachable("Expected post-rename slash-style array: " + array);
    }

    private static String getOriginalNameOfPrimitiveArray(String primitiveArray) {
        if (ArrayUtil.isPostRenameSingleDimensionPrimitiveArray(NameStyle.SLASH_NAME, primitiveArray)) {
            return ArrayNameMapper.getOriginalNameOfPrimitiveArray1D(primitiveArray);
        }
        if (ArrayUtil.isPostRenameMultiDimensionPrimitiveArray(NameStyle.SLASH_NAME, primitiveArray)) {
            return ArrayNameMapper.getOriginalNameOfPrimitiveArrayMD(primitiveArray);
        }
        throw RuntimeAssertionError.unreachable("Expected post-rename slash-style primitive array: " + primitiveArray);
    }

    private static String getOriginalNameOfObjectArray(String objectArray) {
        if (ArrayUtil.isPostRenameConcreteTypeObjectArray(NameStyle.SLASH_NAME, objectArray)) {
            return ArrayNameMapper.getOriginalNameOfPreciseTypeObjectArray(objectArray);
        }
        if (ArrayUtil.isPostRenameUnifyingTypeObjectArray(NameStyle.SLASH_NAME, objectArray)) {
            return ArrayNameMapper.getOriginalNameOfUnifyingTypeObjectArray(objectArray);
        }
        throw RuntimeAssertionError.unreachable("Expected post-rename slash-style object array: " + objectArray);
    }

    private static String getOriginalNameOfPrimitiveArray1D(String primitiveArray1D) {
        String name = ArrayClassNameMapper.getOriginalNameFromWrapper(primitiveArray1D);
        if (name == null) {
            throw RuntimeAssertionError.unreachable("Expected post-rename slash-style 1-dimension primitive array: " + primitiveArray1D);
        }
        return name;
    }

    private static String getOriginalNameOfPrimitiveArrayMD(String primitiveArrayMD) {
        if (primitiveArrayMD.startsWith("a/")) {
            String unwrappedArray = primitiveArrayMD.substring("a/".length());
            return unwrappedArray.replaceAll("\\$", "\\[");
        }
        throw RuntimeAssertionError.unreachable("Expected post-rename slash-style multi-dimension primitive array: " + primitiveArrayMD);
    }

    private static String getOriginalNameOfPreciseTypeObjectArray(String preciseObjectArray) {
        if (preciseObjectArray.startsWith("a/")) {
            String unwrappedArray = preciseObjectArray.substring("a/".length());
            return unwrappedArray.replaceAll("\\$", "\\[");
        }
        throw RuntimeAssertionError.unreachable("Expected post-rename slash-style 'precise type' object array: " + preciseObjectArray);
    }

    private static String getOriginalNameOfUnifyingTypeObjectArray(String unifyingObjectArray) {
        if (unifyingObjectArray.startsWith("w/")) {
            String unwrappedArray = unifyingObjectArray.substring("w/".length());
            return unwrappedArray.replaceAll("_", "\\[");
        }
        throw RuntimeAssertionError.unreachable("Expected post-rename slash-style 'unifying type' object array: " + unifyingObjectArray);
    }

    public static String getPreciseArrayWrapperDescriptor(String desc) {
        return ArrayNameMapper.getClassWrapperDescriptor(desc);
    }

    private static String getClassWrapperDescriptor(String desc) {
        String ret;
        if (desc.endsWith(";")) {
            desc = desc.substring(0, desc.length() - 1);
        }
        if (desc.charAt(0) != '[') {
            ret = desc;
        } else {
            ArrayNameMapper.validateArrayDimension(desc);
            ret = ArrayClassNameMapper.getClassWrapper(desc);
            if (ret == null) {
                ret = ArrayNameMapper.newClassWrapper(desc);
            }
        }
        return ret;
    }

    static String getInterfaceWrapper(String desc) {
        String ret;
        if (desc.endsWith(";")) {
            desc = desc.substring(0, desc.length() - 1);
        }
        if (desc.charAt(0) != '[') {
            ret = desc;
        } else {
            ArrayNameMapper.validateArrayDimension(desc);
            ret = ArrayClassNameMapper.getInterfaceWrapper(desc);
            if (ret == null) {
                ret = ArrayNameMapper.newInterfaceWrapper(desc);
            }
        }
        return ret;
    }

    private static String newClassWrapper(String desc) {
        StringBuilder sb = new StringBuilder();
        sb.append("a/");
        if (desc.charAt(1) != 'L' && desc.charAt(1) != '[') {
            throw RuntimeAssertionError.unreachable("newClassWrapper: " + desc);
        }
        sb.append(desc.replace('[', '$'));
        return sb.toString();
    }

    private static String newInterfaceWrapper(String desc) {
        if (ArrayUtil.isPreRenamePrimitiveArray(desc)) {
            return ArrayNameMapper.wrapperForPrimitiveArrays(desc);
        }
        if (OBJECT_INTERFACE_FORMAT.matcher(desc).matches()) {
            return ArrayNameMapper.getMultiDimensionalObjectArrayDescriptor(desc);
        }
        StringBuilder sb = new StringBuilder();
        sb.append("w/");
        if (desc.charAt(1) != 'L' && desc.charAt(1) != '[') {
            throw RuntimeAssertionError.unreachable("newInterfaceWrapper :" + desc);
        }
        sb.append(desc.replace('[', '_'));
        return sb.toString();
    }

    private static String wrapperForPrimitiveArrays(String desc) {
        int index = desc.lastIndexOf(91);
        index = index == -1 ? desc.lastIndexOf(36) : index;
        int dimension = index + 1;
        if (dimension > 2) {
            return ArrayNameMapper.newClassWrapper(desc);
        }
        switch (desc.substring(dimension)) {
            case "B": {
                return ArrayNameMapper.getByteArrayWrapper(dimension);
            }
            case "Z": {
                return ArrayNameMapper.getBooleanArrayWrapper(dimension);
            }
            case "J": {
                return ArrayNameMapper.getLongArrayWrapper(dimension);
            }
            case "I": {
                return ArrayNameMapper.getIntArrayWrapper(dimension);
            }
            case "S": {
                return ArrayNameMapper.getShortArrayWrapper(dimension);
            }
            case "F": {
                return ArrayNameMapper.getFloatArrayWrapper(dimension);
            }
            case "D": {
                return ArrayNameMapper.getDoubleArrayWrapper(dimension);
            }
            case "C": {
                return ArrayNameMapper.getCharArrayWrapper(dimension);
            }
        }
        return null;
    }

    private static String getMultiDimensionalObjectArrayDescriptor(String descriptor) {
        int dim = descriptor.lastIndexOf(91) + 1;
        String dimPrefix = new String(new char[dim]).replace('\u0000', '_');
        return "w/" + dimPrefix + "Li/IObject";
    }

    private static String getObjectArrayWrapper(String type, int dim) {
        return ArrayNameMapper.getUnifyingArrayWrapperDescriptor(ArrayNameMapper.buildArrayDescriptor(dim, "L" + type + ";"));
    }

    private static String getByteArrayWrapper(int dim) {
        return ArrayNameMapper.getClassWrapperDescriptor(ArrayNameMapper.buildArrayDescriptor(dim, "B"));
    }

    private static String getCharArrayWrapper(int dim) {
        return ArrayNameMapper.getClassWrapperDescriptor(ArrayNameMapper.buildArrayDescriptor(dim, "C"));
    }

    private static String getIntArrayWrapper(int dim) {
        return ArrayNameMapper.getClassWrapperDescriptor(ArrayNameMapper.buildArrayDescriptor(dim, "I"));
    }

    private static String getDoubleArrayWrapper(int dim) {
        return ArrayNameMapper.getClassWrapperDescriptor(ArrayNameMapper.buildArrayDescriptor(dim, "D"));
    }

    private static String getFloatArrayWrapper(int dim) {
        return ArrayNameMapper.getClassWrapperDescriptor(ArrayNameMapper.buildArrayDescriptor(dim, "F"));
    }

    private static String getLongArrayWrapper(int dim) {
        return ArrayNameMapper.getClassWrapperDescriptor(ArrayNameMapper.buildArrayDescriptor(dim, "J"));
    }

    private static String getShortArrayWrapper(int dim) {
        return ArrayNameMapper.getClassWrapperDescriptor(ArrayNameMapper.buildArrayDescriptor(dim, "S"));
    }

    private static String getBooleanArrayWrapper(int dim) {
        return ArrayNameMapper.getClassWrapperDescriptor(ArrayNameMapper.buildArrayDescriptor(dim, "Z"));
    }

    public static String buildArrayDescriptor(int length, String elementDescriptor) {
        return ArrayNameMapper.buildFullString(length, '[') + elementDescriptor;
    }

    private static String buildFullString(int length, char element) {
        return new String(new char[length]).replace('\u0000', element);
    }

    public static String getUnifyingArrayWrapperDescriptor(String desc) {
        boolean isPrimitiveArray = 2 == desc.length() && '[' == desc.charAt(0) && ArrayNameMapper.isPrimitiveElement(desc.substring(1));
        return isPrimitiveArray ? ArrayNameMapper.getClassWrapperDescriptor(desc) : ArrayNameMapper.getInterfaceWrapper(desc);
    }

    public static String getElementInterfaceName(String interfaceClassName) {
        String elementName = interfaceClassName.substring("w.".length());
        int dim = ArrayNameMapper.getPrefixSize(elementName, '_');
        if ((elementName = elementName.substring(dim)).startsWith("L")) {
            elementName = elementName.substring(1);
        }
        return elementName;
    }

    public static String getClassWrapperElementName(String wrapperClassName) {
        String elementName = wrapperClassName.substring("a.".length());
        int dim = ArrayNameMapper.getPrefixSize(elementName, '$');
        if ((elementName = elementName.substring(dim)).startsWith("L")) {
            elementName = elementName.substring(1);
        }
        return elementName;
    }

    static String getElementType(String desc) {
        RuntimeAssertionError.assertTrue(desc.startsWith("["));
        String ret = desc.substring(1);
        if (ret.startsWith("L")) {
            ret = ret.substring(1, ret.length() - 1);
        }
        return ret;
    }

    public static int getPrefixSize(String input, char prefixChar) {
        int d = 0;
        while (input.charAt(d) == prefixChar) {
            ++d;
        }
        return d;
    }

    static String getFactoryDescriptor(String wrapper, int d) {
        Object facDesc = ArrayNameMapper.buildFullString(d, 'I');
        facDesc = "(" + (String)facDesc + ")L" + wrapper + ";";
        return facDesc;
    }

    private static String mapDescriptor(String descriptor) {
        StringBuilder builder = DescriptorParser.parse(descriptor, new DescriptorParser.Callbacks<StringBuilder>(){

            @Override
            public StringBuilder readObject(int arrayDimensions, String type, StringBuilder userData) {
                if (arrayDimensions > 0) {
                    userData.append('L');
                }
                userData.append(ArrayNameMapper.getObjectArrayWrapper(type, arrayDimensions));
                userData.append(';');
                return userData;
            }

            @Override
            public StringBuilder readBoolean(int arrayDimensions, StringBuilder userData) {
                if (arrayDimensions > 0) {
                    userData.append('L');
                    userData.append(ArrayNameMapper.getBooleanArrayWrapper(arrayDimensions));
                    userData.append(';');
                } else {
                    userData.append('Z');
                }
                return userData;
            }

            @Override
            public StringBuilder readShort(int arrayDimensions, StringBuilder userData) {
                if (arrayDimensions > 0) {
                    userData.append('L');
                    userData.append(ArrayNameMapper.getShortArrayWrapper(arrayDimensions));
                    userData.append(';');
                } else {
                    userData.append('S');
                }
                return userData;
            }

            @Override
            public StringBuilder readLong(int arrayDimensions, StringBuilder userData) {
                if (arrayDimensions > 0) {
                    userData.append('L');
                    userData.append(ArrayNameMapper.getLongArrayWrapper(arrayDimensions));
                    userData.append(';');
                } else {
                    userData.append('J');
                }
                return userData;
            }

            @Override
            public StringBuilder readInteger(int arrayDimensions, StringBuilder userData) {
                if (arrayDimensions > 0) {
                    userData.append('L');
                    userData.append(ArrayNameMapper.getIntArrayWrapper(arrayDimensions));
                    userData.append(';');
                } else {
                    userData.append('I');
                }
                return userData;
            }

            @Override
            public StringBuilder readFloat(int arrayDimensions, StringBuilder userData) {
                if (arrayDimensions > 0) {
                    userData.append('L');
                    userData.append(ArrayNameMapper.getFloatArrayWrapper(arrayDimensions));
                    userData.append(';');
                } else {
                    userData.append('F');
                }
                return userData;
            }

            @Override
            public StringBuilder readDouble(int arrayDimensions, StringBuilder userData) {
                if (arrayDimensions > 0) {
                    userData.append('L');
                    userData.append(ArrayNameMapper.getDoubleArrayWrapper(arrayDimensions));
                    userData.append(';');
                } else {
                    userData.append('D');
                }
                return userData;
            }

            @Override
            public StringBuilder readChar(int arrayDimensions, StringBuilder userData) {
                if (arrayDimensions > 0) {
                    userData.append('L');
                    userData.append(ArrayNameMapper.getCharArrayWrapper(arrayDimensions));
                    userData.append(';');
                } else {
                    userData.append('C');
                }
                return userData;
            }

            @Override
            public StringBuilder readByte(int arrayDimensions, StringBuilder userData) {
                if (arrayDimensions > 0) {
                    userData.append('L');
                    userData.append(ArrayNameMapper.getByteArrayWrapper(arrayDimensions));
                    userData.append(';');
                } else {
                    userData.append('B');
                }
                return userData;
            }

            @Override
            public StringBuilder argumentStart(StringBuilder userData) {
                userData.append('(');
                return userData;
            }

            @Override
            public StringBuilder argumentEnd(StringBuilder userData) {
                userData.append(')');
                return userData;
            }

            @Override
            public StringBuilder readVoid(StringBuilder userData) {
                userData.append('V');
                return userData;
            }
        }, new StringBuilder());
        return ArrayNameMapper.unifyArraysInMethodDescriptor(builder.toString());
    }

    private static String unifyArraysInMethodDescriptor(String descriptor) {
        String[] splitDesc = descriptor.substring(1).split("\\)");
        return ArrayNameMapper.arrayParametersToUnifyingTypes(splitDesc[0]) + ArrayNameMapper.arrayReturnTypeToUnifyingType(splitDesc[1]);
    }

    private static String arrayParametersToUnifyingTypes(String parameters) {
        String token;
        StringBuilder builder = new StringBuilder("(");
        int index = 0;
        while ((token = ArrayNameMapper.parameterAtIndex(parameters, index)) != null) {
            if (token.length() == 1) {
                builder.append(token);
            } else {
                builder.append(ArrayNameMapper.unifyArrayDescriptor(token));
            }
            index += token.length();
        }
        return builder.append(")").toString();
    }

    private static String arrayReturnTypeToUnifyingType(String methodType) {
        return methodType.length() == 1 ? methodType : ArrayNameMapper.unifyArrayDescriptor(methodType);
    }

    private static String parameterAtIndex(String parameters, int startIndex) {
        if (startIndex >= parameters.length()) {
            return null;
        }
        int n = startIndex = parameters.charAt(startIndex) == ';' ? startIndex + 1 : startIndex;
        if (PRIMITIVES.contains(String.valueOf(parameters.charAt(startIndex)))) {
            return String.valueOf(parameters.charAt(startIndex));
        }
        return parameters.substring(startIndex, parameters.indexOf(59, startIndex) + 1);
    }

    private static String unifyArrayDescriptor(String descriptor) {
        String objectArrayPrefix = "La/$";
        if (descriptor.startsWith(objectArrayPrefix)) {
            int len = descriptor.length() - 1;
            String desc = descriptor.endsWith(";") ? descriptor.substring(0, len) : descriptor;
            String array = desc.substring(objectArrayPrefix.length());
            if (ArrayUtil.isPreRenamePrimitiveArray(array)) {
                return objectArrayPrefix + array + ";";
            }
            String preparedArray = "[" + ArrayNameMapper.prepareObjectArrayForUnification(array);
            String unifiedArray = ArrayNameMapper.getUnifyingArrayWrapperDescriptor(preparedArray);
            return "L" + unifiedArray + ";";
        }
        String starting = descriptor.startsWith("L") ? "" : "L";
        String ending = descriptor.endsWith(";") ? "" : ";";
        return starting + descriptor + ending;
    }

    private static String prepareObjectArrayForUnification(String descriptor) {
        int numLeadingTokens = 0;
        for (char c : descriptor.toCharArray()) {
            if (c != '$') break;
            ++numLeadingTokens;
        }
        String transformedTokens = new String(new char[numLeadingTokens]).replace("\u0000", "[");
        String remainder = descriptor.substring(numLeadingTokens);
        return transformedTokens + remainder;
    }

    public static boolean isIObjectInterfaceFormat(String elementInterfaceSlashName) {
        return IOBJECT_INTERFACE_FORMAT.matcher(elementInterfaceSlashName).matches();
    }

    public static boolean isObjectInterfaceFormat(String elementInterfaceSlashName) {
        return OBJECT_INTERFACE_FORMAT.matcher(elementInterfaceSlashName).matches();
    }

    public static boolean isPrimitiveElement(String desc) {
        return PRIMITIVES.contains(desc);
    }

    private static void validateArrayDimension(String desc) {
        int dim = ArrayNameMapper.getPrefixSize(desc, '[');
        if (dim > 3) {
            RejectedClassException.arrayDimensionTooBig(desc);
        }
    }
}

