/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.arraywrapping;

import org.aion.avm.core.types.ClassHierarchy;
import org.aion.avm.core.types.CommonType;
import org.aion.avm.utilities.Utilities;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.analysis.AnalyzerException;
import org.objectweb.asm.tree.analysis.BasicInterpreter;
import org.objectweb.asm.tree.analysis.BasicValue;

public class ArrayWrappingInterpreter
extends BasicInterpreter {
    private final ClassHierarchy hierarchy;

    ArrayWrappingInterpreter(ClassHierarchy hierarchy) {
        super(458752);
        this.hierarchy = hierarchy;
    }

    public BasicValue newValue(Type type) {
        if (type == null) {
            return BasicValue.UNINITIALIZED_VALUE;
        }
        switch (type.getSort()) {
            case 0: {
                return null;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return new BasicValue(type);
            }
        }
        throw new AssertionError();
    }

    public BasicValue binaryOperation(AbstractInsnNode insn, BasicValue value1, BasicValue value2) throws AnalyzerException {
        switch (insn.getOpcode()) {
            case 46: 
            case 51: 
            case 52: 
            case 53: 
            case 96: 
            case 100: 
            case 104: 
            case 108: 
            case 112: 
            case 120: 
            case 122: 
            case 124: 
            case 126: 
            case 128: 
            case 130: {
                return BasicValue.INT_VALUE;
            }
            case 48: 
            case 98: 
            case 102: 
            case 106: 
            case 110: 
            case 114: {
                return BasicValue.FLOAT_VALUE;
            }
            case 47: 
            case 97: 
            case 101: 
            case 105: 
            case 109: 
            case 113: 
            case 121: 
            case 123: 
            case 125: 
            case 127: 
            case 129: 
            case 131: {
                return BasicValue.LONG_VALUE;
            }
            case 49: 
            case 99: 
            case 103: 
            case 107: 
            case 111: 
            case 115: {
                return BasicValue.DOUBLE_VALUE;
            }
            case 50: {
                return this.newValue(Type.getType((String)value1.toString().substring(1)));
            }
            case 148: 
            case 149: 
            case 150: 
            case 151: 
            case 152: {
                return BasicValue.INT_VALUE;
            }
            case 159: 
            case 160: 
            case 161: 
            case 162: 
            case 163: 
            case 164: 
            case 165: 
            case 166: 
            case 181: {
                return null;
            }
        }
        throw new AssertionError();
    }

    public BasicValue merge(BasicValue value1, BasicValue value2) {
        BasicValue b = super.merge(value1, value2);
        if (b.equals((Object)BasicValue.UNINITIALIZED_VALUE)) {
            if (value1.equals((Object)BasicValue.UNINITIALIZED_VALUE) && value2.equals((Object)BasicValue.UNINITIALIZED_VALUE)) {
                return b;
            }
            String cleanDescriptor1 = value1.toString();
            String cleanDescriptor2 = value2.toString();
            int dimension1 = this.getArrayDimension(cleanDescriptor1);
            int dimension2 = this.getArrayDimension(cleanDescriptor2);
            if (dimension1 == 0 || dimension2 == 0) {
                return new BasicValue(Type.getType((String)("[L" + Utilities.fullyQualifiedNameToInternalName(CommonType.SHADOW_OBJECT.dotName) + ";")));
            }
            if (dimension1 != dimension2) {
                return new BasicValue(Type.getType((String)("[L" + Utilities.fullyQualifiedNameToInternalName(CommonType.I_OBJECT_ARRAY.dotName) + ";")));
            }
            cleanDescriptor1 = cleanDescriptor1.substring(dimension1);
            cleanDescriptor2 = cleanDescriptor2.substring(dimension2);
            boolean descriptor1isObject = cleanDescriptor1.startsWith("L");
            boolean descriptor2isObject = cleanDescriptor2.startsWith("L");
            if (!descriptor1isObject && !descriptor2isObject) {
                return new BasicValue(Type.getType((String)("[L" + Utilities.fullyQualifiedNameToInternalName(CommonType.I_OBJECT_ARRAY.dotName) + ";")));
            }
            if (descriptor1isObject && !descriptor2isObject || !descriptor1isObject && descriptor2isObject) {
                return new BasicValue(Type.getType((String)("[L" + Utilities.fullyQualifiedNameToInternalName(CommonType.SHADOW_OBJECT.dotName) + ";")));
            }
            cleanDescriptor1 = cleanDescriptor1.substring(1);
            cleanDescriptor2 = cleanDescriptor2.substring(1);
            cleanDescriptor1 = cleanDescriptor1.substring(0, cleanDescriptor1.length() - 1);
            cleanDescriptor2 = cleanDescriptor2.substring(0, cleanDescriptor2.length() - 1);
            String commonSuper = this.hierarchy.getTightestCommonSuperClass(cleanDescriptor1 = Utilities.internalNameToFullyQualifiedName(cleanDescriptor1), cleanDescriptor2 = Utilities.internalNameToFullyQualifiedName(cleanDescriptor2));
            commonSuper = commonSuper == null ? Utilities.fullyQualifiedNameToInternalName(CommonType.I_OBJECT.dotName) : Utilities.fullyQualifiedNameToInternalName(commonSuper);
            return new BasicValue(Type.getType((String)(this.getArrayDimensionPrefix(dimension1) + "L" + commonSuper + ";")));
        }
        return b;
    }

    private int getArrayDimension(String descriptor) {
        int length = descriptor.length();
        int dimension = 0;
        for (int i = 0; i < length; ++i) {
            if (descriptor.charAt(i) != '[') {
                return dimension;
            }
            ++dimension;
        }
        return dimension;
    }

    private String getArrayDimensionPrefix(int dimension) {
        return new String(new char[dimension]).replaceAll("\u0000", "[");
    }
}

