/*
 * Decompiled with CFR 0.152.
 */
package org.aion.avm.core.classloading;

import i.RuntimeAssertionError;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import org.aion.avm.core.arraywrapping.ArrayNameMapper;
import org.aion.avm.core.arraywrapping.ArrayWrappingClassGenerator;
import org.aion.avm.core.classloading.AvmSharedClassLoader;
import org.aion.avm.core.util.DebugNameResolver;

public class AvmClassLoader
extends ClassLoader {
    private static final int CLASS_IS_ENUM = 16384;
    private Map<String, byte[]> bytecodeMap;
    private ArrayList<Function<String, byte[]>> handlers;
    private final Map<String, Class<?>> cache;

    public AvmClassLoader(AvmSharedClassLoader parent, Map<String, byte[]> bytecodeMap, ArrayList<Function<String, byte[]>> handlers) {
        super(parent);
        this.bytecodeMap = bytecodeMap;
        this.handlers = handlers;
        this.cache = new HashMap();
        this.registerHandlers();
    }

    public AvmClassLoader(AvmSharedClassLoader parent, Map<String, byte[]> bytecodeMap) {
        this(parent, bytecodeMap, new ArrayList<Function<String, byte[]>>());
    }

    private void registerHandlers() {
        Function<String, byte[]> wrapperGenerator = cName -> ArrayWrappingClassGenerator.arrayWrappingFactory(cName, this);
        this.handlers.add(wrapperGenerator);
    }

    @Override
    public Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> result = null;
        boolean shouldResolve = resolve;
        if (this.cache.containsKey(name)) {
            result = this.cache.get(name);
            shouldResolve = false;
        } else if (this.bytecodeMap.containsKey(name)) {
            byte[] injected = this.bytecodeMap.get(name);
            result = this.defineClass(name, injected, 0, injected.length);
            RuntimeAssertionError.assertTrue(0 == (0x4000 & result.getModifiers()));
            this.cache.put(name, result);
        } else if (this.isUserArrayWrapper(name)) {
            for (Function<String, byte[]> handler : this.handlers) {
                byte[] code = handler.apply(name);
                if (code == null) continue;
                result = this.defineClass(name, code, 0, code.length);
                this.cache.put(name, result);
                break;
            }
        } else {
            result = this.getParent().loadClass(name);
            shouldResolve = false;
        }
        if (null != result && shouldResolve) {
            this.resolveClass(result);
        }
        if (null == result) {
            throw new ClassNotFoundException(name);
        }
        return result;
    }

    private boolean isUserArrayWrapper(String className) {
        if (className.startsWith("w.")) {
            return this.bytecodeMap.containsKey(ArrayNameMapper.getElementInterfaceName(className));
        }
        if (className.startsWith("a.$")) {
            return this.bytecodeMap.containsKey(ArrayNameMapper.getClassWrapperElementName(className));
        }
        return false;
    }

    public Class<?> loadUserClassByOriginalName(String originalClassName, boolean preserveDebuggability) throws ClassNotFoundException {
        String renamedClass = DebugNameResolver.getUserPackageDotPrefix(originalClassName, preserveDebuggability);
        Class<?> clazz = this.loadClass(renamedClass);
        RuntimeAssertionError.assertTrue(this == clazz.getClassLoader());
        return clazz;
    }

    public byte[] getUserClassBytecodeByOriginalName(String className, boolean preserveDebuggability) {
        return this.bytecodeMap.get(DebugNameResolver.getUserPackageDotPrefix(className, preserveDebuggability));
    }

    public byte[] getUserClassBytecode(String className) {
        return this.bytecodeMap.get(className);
    }
}

